/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugTMWithAliases;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.FileLoaderHelper;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.TextFile;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.dialogs.AcceptEnvVariableDialog;
import com.iscobol.debugger.dialogs.AcceptVariableDialog;
import com.iscobol.debugger.dialogs.BreakpointDialog;
import com.iscobol.debugger.dialogs.BreakpointsSettingsDialog;
import com.iscobol.debugger.dialogs.ConnectDialog;
import com.iscobol.debugger.dialogs.ConsoleSettingsDialog;
import com.iscobol.debugger.dialogs.CustomizeCommandsDialog;
import com.iscobol.debugger.dialogs.CustomizeShortcutsDialog;
import com.iscobol.debugger.dialogs.DataSettingsDialog;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.DisplayVariableDialog;
import com.iscobol.debugger.dialogs.FindDialog;
import com.iscobol.debugger.dialogs.GotoDialog;
import com.iscobol.debugger.dialogs.HelpDialog;
import com.iscobol.debugger.dialogs.InputDialog;
import com.iscobol.debugger.dialogs.JumpToDialog;
import com.iscobol.debugger.dialogs.MonitorDialog;
import com.iscobol.debugger.dialogs.QuickWatchDialog;
import com.iscobol.debugger.dialogs.SessionSettingsDialog;
import com.iscobol.debugger.dialogs.SettingsDialog;
import com.iscobol.debugger.dialogs.TraceDialog;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class GraphDebugger
implements FileLoaderHelper {
    static final String TITLE = "isCOBOL Graphic Debugger";
    public static final String eol = System.getProperty("line.separator", "\n");
    public static final int COMMAND_HISTORY_LIMIT = 50;
    public static final int ANSI_FORMAT = 1;
    public static final int TERMINAL_FORMAT = 2;
    public static final int FREE_FORMAT = 3;
    public static final int VARIABLE_FORMAT = 4;
    public static final int LONG_FORMAT = 5;
    private static final int ATTEMPT_NUMBER = 10;
    private static final String START_AUTOSTEP_LBL = "Start autostep [ston]";
    private static final String STOP_AUTOSTEP_LBL = "Stop autostep [stoff]";
    private static final String START_AUTOSTEP_ACTION = "start";
    private static final String STOP_AUTOSTEP_ACTION = "stop";
    private static final int START_AUTOSTEP_MNEMONIC = 65;
    private static final int STOP_AUTOSTEP_MNEMONIC = 85;
    private static String mainClassName;
    private static String[] dbgArgv;
    private static String hostname;
    private static int port;
    private static String chainingString;
    private JFrame jframe;
    private FindDialog findDialog;
    private GotoDialog gotoDialog;
    private QuickWatchDialog quickWatchDialog;
    private Rectangle breakpointSettingsDialogBds;
    private Rectangle dataSettingsDialogBds;
    private Rectangle customizeCommandsDialogBds;
    private Rectangle customizeShortcutsDialogBds;
    private Rectangle sessionSettingsDialogBds;
    private HelpDialog helpDialog;
    private Rectangle acceptEnvVariableDialogBds;
    private Rectangle acceptVariableDialogBds;
    private Rectangle breakpointDialogBds;
    private Rectangle connectDialogBds;
    private Rectangle consoleSettingsDialogBds;
    private Rectangle displayVariableDialogBds;
    private Rectangle displayEnvVariableDialogBds;
    private Rectangle setParametersDialogBds;
    private Rectangle displayOffsetDialogBds;
    private Rectangle displayLengthDialogBds;
    private Rectangle stepToDialogBds;
    private Rectangle jumpToDialogBds;
    private Rectangle monitorDialogBds;
    private Rectangle settingsDialogBds;
    private Rectangle traceDialogBds;
    private DebugPanel preview;
    private String lparam;
    private List previousCommands = new Vector();
    private int previousCommandIndex = Integer.MIN_VALUE;
    private int lastCommandCode = -1;
    private DebugTM tm;
    private boolean remote;
    private boolean remoteThinClient;
    private boolean quitCmdExecuted = true;
    private volatile boolean processing;
    boolean stopImmediately = true;
    private boolean running;
    private boolean exitDebug;
    private String[] watchedVariableCommands;
    private int maxHexDumpLength;
    private int hexDumpStartOffset;
    private int maxArrayLength;
    private int arrayStartOffset;
    private int maxTextValueLength;
    private int maxTextValueLengthOutput;
    boolean dataSettingsChanged = true;
    private Timer autoStepTimer;
    private boolean isASActive;
    private JFileChooser fileChooser;
    private JMenu runMenu;
    private JMenu dataMenu;
    private JMenu bpMenu;
    private JMenuItem tronItem;
    private JMenuItem troffItem;
    private JMenuItem loadItem;
    private JMenuItem unloadItem;
    private JMenuItem saveDebugItem;
    private JMenuItem loadDebugItem;
    private JMenuItem exitItem;
    private JMenuItem setParametersItem;
    private JMenuItem displayEnvVarItem;
    private JMenuItem acceptEnvVarItem;
    private JMenuItem displayVersionItem;
    private JMenuItem startItem;
    private JMenuItem quitItem;
    private JMenuItem continueItem;
    private JMenuItem suspendItem;
    private JMenuItem stepIntoItem;
    private JMenuItem stepOverItem;
    private JMenuItem continueToLineItem;
    private JMenuItem runToSelLineItem;
    private JMenuItem runToNextProgItem;
    private JMenuItem stepOutParItem;
    private JMenuItem stepOutProgItem;
    private JMenuItem autostepItem;
    private JMenuItem firstItem;
    private JMenuItem firstExecItem;
    private JMenuItem lastItem;
    private JMenuItem currentLineItem;
    private JMenuItem findItem;
    private JMenuItem gotoItem;
    private JMenuItem gotoDeclItem;
    private JMenuItem backItem;
    private JMenuItem forwardItem;
    private JMenuItem findForwardItem;
    private JMenuItem findBackwardItem;
    private JMenuItem findFromTopItem;
    private JMenuItem expandAllCopyItem;
    private JMenuItem collapseAllCopyItem;
    private JMenuItem repeatFindItem;
    private JMenuItem clearoutItem;
    private JMenuItem lastCmdItem;
    private JMenuItem prevCmdItem;
    private JMenuItem nextCmdItem;
    private JMenuItem displayItem;
    private JMenuItem displayOnLineItem;
    private JMenuItem offsetItem;
    private JMenuItem lengthItem;
    private JMenuItem acceptItem;
    private JMenuItem setMonitorItem;
    private JMenuItem clearAllMonitorsItem;
    private JMenuItem setBreakpointItem;
    private JMenuItem toggleBreakpointItem;
    private JMenuItem clearAllBreakpointsItem;
    private JMenuItem commandsItem;
    private JMenuItem aboutItem;
    private JMenuItem incrFontSizeItem;
    private JMenuItem decrFontSizeItem;
    private JMenuItem jumpToItem;
    private JMenuItem jumpToSelLineItem;
    private JMenuItem jumpOutParItem;
    private JMenuItem jumpOutProgItem;
    private JMenuItem jumpNextItem;
    private JMenuItem fontsAndColorsItem;
    private JMenuItem shortcutsItem;
    private JMenuItem custCommandsItem;
    private JMenuItem consoleItem;
    private JMenuItem quickWatchItem;
    private JMenuItem refreshItem;
    private JMenuItem f10Item;
    private JCheckBoxMenuItem expandCopiesOnLoadItem;
    private JRadioButtonMenuItem[] threadItems = new JRadioButtonMenuItem[0];
    private JRadioButtonMenuItem[] fontSizeItems = new JRadioButtonMenuItem[12];
    private JRadioButtonMenuItem autoItem;
    private JRadioButtonMenuItem ansiItem;
    private JRadioButtonMenuItem termItem;
    private JRadioButtonMenuItem freeItem;
    private JRadioButtonMenuItem variableItem;
    private JRadioButtonMenuItem longItem;
    private JMenuItem dataItem;
    private JMenuItem breakpointsItem;
    private JMenuItem sessionItem;
    private ButtonGroup sfGroup;
    private Map commandEnablingTable = new HashMap();
    private MyDebuggerInvoker invoker;

    private GraphDebugger(MyDebuggerInvoker myDebuggerInvoker, LocalDebugInfo localDebugInfo, String string, boolean bl, boolean bl2) throws IOException {
        this.invoker = myDebuggerInvoker;
        this.invoker.gd = this;
        this.remote = bl;
        DebuggerInvoker.setDefaultMonitorEnabledState(Settings.getDefaultMonitorEnabledState());
        DebuggerInvoker.setDefaultBreakpointEnabledState(Settings.getDefaultBreakpointEnabledState());
        this.jframe = new JFrame();
        this.jframe.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (GraphDebugger.this.preview != null) {
                    GraphDebugger.this.preview.hideTipPopup();
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }
        });
        this.jframe.setDefaultCloseOperation(0);
        this.jframe.setTitle(string);
        this.remoteThinClient = bl2;
        this.preview = new DebugPanel(this, localDebugInfo, true);
        this.createAndShow(bl2);
    }

    private void createAndShow(boolean bl) {
        this.autoStepTimer = new Timer(1000, actionEvent -> this.setTextCommand("step"));
        this.autoStepTimer.setRepeats(false);
        this.findDialog = new FindDialog(this.jframe, "Find", false, this.preview);
        this.findDialog.setMatchCaseSelected(Settings.isFindMatchCase());
        this.findDialog.setMatchMinusUnderscoreSelected(Settings.isFindMatchMinusUnderscore());
        this.findDialog.setSearchFromTopSelected(Settings.isFindTopSearch());
        this.findDialog.setWholeWordsSelected(Settings.isFindWholeWord());
        this.findDialog.setWrapSearchSelected(Settings.isFindWrapSearch());
        this.findDialog.setBackwardSearchSelected(Settings.isFindBackwardSearch());
        this.gotoDialog = new GotoDialog(this.jframe, "Go To", false, this.preview);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir", ".")));
        this.fileChooser.addActionListener(actionEvent -> {
            String string = this.lparam = this.fileChooser.getSelectedFile() != null ? this.fileChooser.getSelectedFile().getAbsolutePath() : null;
            if (this.lparam != null) {
                this.lparam = this.lparam.replace('\\', '/');
                String string2 = DebugUtilities.getIscobolClassName(this.lparam);
                LocalDebugInfo localDebugInfo = this.getInvoker().getInfo(string2, this.processing, true);
                if (localDebugInfo != null) {
                    if (localDebugInfo.getErrorString() == null) {
                        this.preview.loadFile(localDebugInfo, new Filename(localDebugInfo.getSourcefile()), localDebugInfo.getTimestamp(), true);
                    } else {
                        this.preview.loadFile(null, new Filename(this.lparam), localDebugInfo.getTimestamp(), false);
                    }
                } else {
                    this.preview.loadFile(null, new Filename(this.lparam), 0L, false);
                }
            }
        });
        Rectangle rectangle = Settings.getWindowBounds();
        if (rectangle.x <= 0 || rectangle.y <= 0) {
            this.jframe.setSize(rectangle.getSize());
            this.jframe.setLocationRelativeTo(null);
        } else {
            this.jframe.setBounds(Settings.getWindowBounds());
        }
        this.buildMenuBar();
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("favicon.gif"));
        this.jframe.getContentPane().setLayout(new GridLayout(1, 0));
        this.jframe.setIconImage(image);
        this.jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (GraphDebugger.this.showConfirmExitDialog()) {
                    GraphDebugger.close(GraphDebugger.this, GraphDebugger.this.getInvoker());
                }
            }
        });
        this.jframe.getContentPane().add(this.preview);
        this.preview.setInitFocus();
        this.jframe.setVisible(true);
        this.preview.setVisible(true);
        int n2 = Settings.getWindowState();
        if (n2 != 0) {
            this.jframe.setExtendedState(n2);
        }
        if (bl) {
            System.out.println("Ready");
            System.out.flush();
            if (Settings.isConsoleAttached()) {
                new Thread(() -> {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            System.out.println(string);
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }).start();
            }
        }
        if (Settings.isConsoleAttached()) {
            this.preview.overwriteSysOut();
            this.preview.overwriteSysErr();
        } else {
            GraphUtilities.setOut(GraphUtilities.systemOut);
            GraphUtilities.setErr(GraphUtilities.systemErr);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEvent -> {
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 0 && this.f10Item != null) {
                this.f10Item.doClick(20);
                keyEvent.consume();
                return true;
            }
            return false;
        });
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.jframe.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.tronItem = new JMenuItem("Trace On... [tron]", 78);
        jMenu.add(this.tronItem).addActionListener(actionEvent -> this.showTraceDialog());
        this.troffItem = new JMenuItem("Trace Off [troff]", 70);
        jMenu.add(this.troffItem).addActionListener(actionEvent -> this.setTextCommand("troff"));
        jMenu.addSeparator();
        this.loadItem = new JMenuItem("Load file...", 76);
        jMenu.add(this.loadItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            this.fileChooser.showDialog(this.jframe, "Load");
        });
        this.unloadItem = new JMenuItem("Unload current file", 85);
        jMenu.add(this.unloadItem).addActionListener(actionEvent -> this.preview.unload());
        jMenu.addSeparator();
        this.loadDebugItem = new JMenuItem("Load debugger session... [readsession]", 68);
        jMenu.add(this.loadDebugItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            JFileChooser jFileChooser = this.getIsdFileChooser("Load debugger session", null);
            int n2 = jFileChooser.showDialog(this.jframe, "Load info");
            if (n2 == 0) {
                this.setTextCommand("readsession " + jFileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.saveDebugItem = new JMenuItem("Save debugger session... [writesession]", 69);
        jMenu.add(this.saveDebugItem).addActionListener(actionEvent -> {
            JFileChooser jFileChooser;
            int n2;
            this.preview.hideTipPopup();
            String string = Settings.getSessionOutputFileName();
            if (string.length() == 0) {
                string = mainClassName + ".isd";
            }
            if ((n2 = (jFileChooser = this.getIsdFileChooser("Save debugger session", string)).showDialog(this.jframe, "Save info")) == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                if (string2.lastIndexOf(46) < 0) {
                    string2 = string2 + ".isd";
                }
                this.setTextCommand("writesession " + string2);
            }
        });
        jMenu.addSeparator();
        this.exitItem = new JMenuItem("Exit", 88);
        jMenu.add(this.exitItem).addActionListener(actionEvent -> {
            if (this.showConfirmExitDialog()) {
                GraphDebugger.close(this, this.getInvoker());
            }
        });
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        String string = this.remote ? "Connect to" : "Set command line parameters";
        this.setParametersItem = new JMenuItem(string + "...", 83);
        this.runMenu.add(this.setParametersItem).addActionListener(actionEvent -> {
            if (this.remote) {
                this.preview.hideTipPopup();
                ConnectDialog connectDialog = new ConnectDialog(this.jframe, string, hostname, "" + port);
                this.connectDialogBds = connectDialog.openDialog(this.connectDialogBds);
                if (connectDialog.isOk()) {
                    hostname = connectDialog.getHost();
                    port = connectDialog.getPort();
                }
            } else {
                this.preview.hideTipPopup();
                InputDialog inputDialog = new InputDialog(this.jframe, string, "Arguments:", "this change will take effect at the next run", chainingString, 20, false);
                this.setParametersDialogBds = inputDialog.openDialog(this.setParametersDialogBds);
                String string2 = inputDialog.getValue();
                if (string2 != null) {
                    chainingString = string2;
                }
            }
        });
        this.runMenu.addSeparator();
        this.displayVersionItem = new JMenuItem("Display class info [" + "display".substring(0, 3) + " " + "-classinfo" + "]", 76);
        this.runMenu.add(this.displayVersionItem).addActionListener(actionEvent -> this.setTextCommand("display -classinfo"));
        this.runMenu.addSeparator();
        String string2 = this.remote ? "Connect" : "Start session";
        String string3 = this.remote ? "connect.gif" : "rundebug.gif";
        this.startItem = new JMenuItem(string2 + " [" + "run" + "]", new ImageIcon(GraphUtilities.getImage(string3)));
        this.startItem.setMnemonic(69);
        this.runMenu.add(this.startItem).addActionListener(actionEvent -> this.setTextCommand("run " + chainingString));
        String string4 = this.remote ? "Disconnect" : "Finish session";
        string3 = this.remote ? "disconnect.gif" : "stop.gif";
        this.quitItem = new JMenuItem(string4 + " [" + "quit" + "]", new ImageIcon(GraphUtilities.getImage(string3)));
        this.quitItem.setMnemonic(78);
        this.runMenu.add(this.quitItem).addActionListener(actionEvent -> {
            if (this.processing) {
                if (this.showConfirmQuitDialog()) {
                    this.quitCmdExecuted = true;
                    this.getInvoker().exitDebug(this.isRemote() && Settings.getForceStopRun());
                }
            } else {
                this.setTextCommand("quit");
            }
        });
        this.runMenu.addSeparator();
        this.continueItem = new JMenuItem("Continue [" + "continue".substring(0, 2) + "]", new ImageIcon(GraphUtilities.getImage("continue.gif")));
        this.continueItem.setMnemonic(67);
        this.runMenu.add(this.continueItem).addActionListener(actionEvent -> this.setTextCommand("continue"));
        this.suspendItem = new JMenuItem("Pause [" + "pause".substring(0, 2) + "]", new ImageIcon(GraphUtilities.getImage("suspend.gif")));
        this.runMenu.add(this.suspendItem).addActionListener(actionEvent -> this.setTextCommand("pause"));
        this.stepIntoItem = new JMenuItem("Step into [step]", new ImageIcon(GraphUtilities.getImage("stepinto.gif")));
        this.stepIntoItem.setMnemonic(73);
        this.runMenu.add(this.stepIntoItem).addActionListener(actionEvent -> this.setTextCommand("step"));
        this.stepOverItem = new JMenuItem("Step over [next]", new ImageIcon(GraphUtilities.getImage("stepover.gif")));
        this.stepOverItem.setMnemonic(79);
        this.runMenu.add(this.stepOverItem).addActionListener(actionEvent -> this.setTextCommand("next"));
        this.stepOutParItem = new JMenuItem("Step out paragraph [outpar]", new ImageIcon(GraphUtilities.getImage("stepout.gif")));
        this.stepOutParItem.setMnemonic(80);
        this.runMenu.add(this.stepOutParItem).addActionListener(actionEvent -> this.setTextCommand("outpar"));
        this.stepOutProgItem = new JMenuItem("Step out program [outprog]", new ImageIcon(GraphUtilities.getImage("stepoutprog.gif")));
        this.stepOutProgItem.setMnemonic(82);
        this.runMenu.add(this.stepOutProgItem).addActionListener(actionEvent -> this.setTextCommand("outprog"));
        this.runMenu.addSeparator();
        this.continueToLineItem = new JMenuItem("Continue to line number [to]", 77);
        this.runMenu.add(this.continueToLineItem).addActionListener(actionEvent -> this.showStepToDialog());
        this.runToSelLineItem = new JMenuItem("Run to selected line", new ImageIcon(GraphUtilities.getImage("runtilcurs.gif")));
        this.runToSelLineItem.setMnemonic(84);
        this.runMenu.add(this.runToSelLineItem).addActionListener(actionEvent -> this.runToSelectedLine(this.preview.getSelectedLine(), this.preview.getFile()));
        this.runToNextProgItem = new JMenuItem("Run to next program [prog]", new ImageIcon(GraphUtilities.getImage("runtilpgm.gif")));
        this.runToNextProgItem.setMnemonic(71);
        this.runMenu.add(this.runToNextProgItem).addActionListener(actionEvent -> this.setTextCommand("prog"));
        this.runMenu.addSeparator();
        this.autostepItem = new JMenuItem(START_AUTOSTEP_LBL, new ImageIcon(GraphUtilities.getImage("autostep.gif")));
        this.autostepItem.setActionCommand(START_AUTOSTEP_ACTION);
        this.autostepItem.setMnemonic(65);
        this.runMenu.add(this.autostepItem).addActionListener(actionEvent -> this.preview.setAutostepState(this.autostepItem.getActionCommand().equals(START_AUTOSTEP_ACTION)));
        this.runMenu.addSeparator();
        this.jumpNextItem = new JMenuItem("Jump next statement [j -next]", new ImageIcon(GraphUtilities.getImage("jumpover.gif")));
        this.jumpNextItem.setEnabled(false);
        this.runMenu.add(this.jumpNextItem).addActionListener(actionEvent -> this.setTextCommand("jump -next"));
        this.jumpOutParItem = new JMenuItem("Jump out paragraph [j -outpar]", new ImageIcon(GraphUtilities.getImage("jumpout.gif")));
        this.jumpOutParItem.setEnabled(false);
        this.setCommandEnabled(29, false);
        this.runMenu.add(this.jumpOutParItem).addActionListener(actionEvent -> this.setTextCommand("jump -outpar"));
        this.jumpOutProgItem = new JMenuItem("Jump out program [j -outprog]", new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif")));
        this.jumpOutProgItem.setEnabled(false);
        this.runMenu.add(this.jumpOutProgItem).addActionListener(actionEvent -> this.setTextCommand("jump -outprog"));
        this.jumpToItem = new JMenuItem("Jump to [j]");
        this.jumpToItem.setMnemonic(74);
        this.jumpToItem.setEnabled(false);
        this.runMenu.add(this.jumpToItem).addActionListener(actionEvent -> this.showJumpToDialog());
        this.jumpToSelLineItem = new JMenuItem("Jump to selected line", new ImageIcon(GraphUtilities.getImage("jump.gif")));
        this.jumpToSelLineItem.setEnabled(false);
        this.runMenu.add(this.jumpToSelLineItem).addActionListener(actionEvent -> {
            int n2 = this.preview.getSelectedLine();
            if (n2 >= 0) {
                CobolRef cobolRef = this.preview.getFile().getBPArgs(this.preview.getListingline(n2));
                this.setTextCommand("jump " + cobolRef.lineNo() + " " + cobolRef.filename() + " " + "-fi" + " " + cobolRef.getFileIndex());
            }
        });
        this.runMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        this.firstItem = new JMenuItem("First line [wt]", 70);
        jMenu2.add(this.firstItem).addActionListener(actionEvent -> this.preview.select(0, 0));
        this.firstExecItem = new JMenuItem("First executable line [w0]", 88);
        jMenu2.add(this.firstExecItem).addActionListener(actionEvent -> {
            DebugParagraph[] debugParagraphArray = this.preview.getFile().getDebugParagraphs();
            if (debugParagraphArray != null && debugParagraphArray.length > 0) {
                this.preview.goTo(debugParagraphArray[0].getLineNumber(), debugParagraphArray[0].getParagraphName(), debugParagraphArray[0].getFileIndex());
            }
        });
        this.lastItem = new JMenuItem("Last line [wb]", 76);
        jMenu2.add(this.lastItem).addActionListener(actionEvent -> this.preview.selectLast());
        this.currentLineItem = new JMenuItem("Current line [w@]", new ImageIcon(GraphUtilities.getImage("gotocurrline.gif")));
        this.currentLineItem.setMnemonic(67);
        jMenu2.add(this.currentLineItem).addActionListener(actionEvent -> this.preview.selectCurrentLine());
        jMenu2.addSeparator();
        this.findItem = new JMenuItem("Find...", new ImageIcon(GraphUtilities.getImage("find.gif")));
        this.findItem.setMnemonic(73);
        this.findItem.addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            String string = this.preview.getHighlightedVariable(true);
            if (string == null) {
                string = this.preview.getHighlightedWord();
            }
            this.findDialog.setVisible(string);
        });
        jMenu2.add(this.findItem);
        this.repeatFindItem = new JMenuItem("Repeat find [f]", new ImageIcon(GraphUtilities.getImage("find_repeat.gif")));
        this.repeatFindItem.setMnemonic(82);
        jMenu2.add(this.repeatFindItem).addActionListener(actionEvent -> this.preview.repeatFind());
        this.findForwardItem = new JMenuItem("Find forwards... [ff]", 78);
        jMenu2.add(this.findForwardItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            this.findDialog.setBackwardSearchSelected(false);
            this.findDialog.setSearchFromTopSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        this.findBackwardItem = new JMenuItem("Find backwards... [fb]", 83);
        jMenu2.add(this.findBackwardItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            this.findDialog.setBackwardSearchSelected(true);
            this.findDialog.setSearchFromTopSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        this.findFromTopItem = new JMenuItem("Find from top... [ft]", 84);
        jMenu2.add(this.findFromTopItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            this.findDialog.setSearchFromTopSelected(true);
            this.findDialog.setBackwardSearchSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        jMenu2.addSeparator();
        this.expandAllCopyItem = new JMenuItem("Expand all copy books");
        jMenu2.add(this.expandAllCopyItem).addActionListener(actionEvent -> this.preview.expandAllCopies());
        this.collapseAllCopyItem = new JMenuItem("Collapse all copy books");
        jMenu2.add(this.collapseAllCopyItem).addActionListener(actionEvent -> this.preview.collapseAllCopies());
        jMenu2.addSeparator();
        this.gotoItem = new JMenuItem("Go to...", 71);
        jMenu2.add(this.gotoItem).addActionListener(actionEvent -> this.showGotoDialog());
        this.gotoDeclItem = new JMenuItem("Go to declaration", 68);
        jMenu2.add(this.gotoDeclItem).addActionListener(actionEvent -> {
            DebugPanel.MyVarName myVarName = this.preview.getVarName();
            if (myVarName != null) {
                int n2 = this.preview.previewArea.locationToIndex(this.preview.quickWatchPoint);
                int n3 = this.preview.getListingline(n2);
                CobolRef cobolRef = this.preview.getFile().toCobolLine(n3);
                this.preview.goTo(cobolRef.lineNo(), myVarName.varName, cobolRef.getFileIndex());
            }
        });
        this.backItem = new JMenuItem("Back");
        this.backItem.setMnemonic(75);
        jMenu2.add(this.backItem).addActionListener(actionEvent -> this.preview.back());
        this.backItem.setEnabled(false);
        this.forwardItem = new JMenuItem("Forward");
        this.forwardItem.setMnemonic(87);
        jMenu2.add(this.forwardItem).addActionListener(actionEvent -> this.preview.forward());
        this.forwardItem.setEnabled(false);
        jMenu2.addSeparator();
        this.clearoutItem = new JMenuItem("Clear output", 79);
        jMenu2.add(this.clearoutItem).addActionListener(actionEvent -> this.preview.clearOutput());
        jMenu2.addSeparator();
        this.prevCmdItem = new JMenuItem("Previous command", 80);
        jMenu2.add(this.prevCmdItem).addActionListener(actionEvent -> {
            String string = this.getPreviousCommand();
            if (string != null) {
                this.preview.setLineCommandText(string);
            }
        });
        this.nextCmdItem = new JMenuItem("Next command", 69);
        jMenu2.add(this.nextCmdItem).addActionListener(actionEvent -> {
            String string = this.getNextCommand();
            if (string != null) {
                this.preview.setLineCommandText(string);
            }
        });
        this.lastCmdItem = new JMenuItem("Last command", 65);
        jMenu2.add(this.lastCmdItem).addActionListener(actionEvent -> {
            this.previousCommandIndex = Integer.MIN_VALUE;
            String string = this.getPreviousCommand();
            if (string != null) {
                this.preview.setLineCommandText(string);
            }
        });
        this.dataMenu = new JMenu("Data");
        this.dataMenu.setMnemonic(68);
        this.displayEnvVarItem = new JMenuItem("Display environment variable... [" + "display".substring(0, 3) + " " + "-env" + "]", 68);
        this.dataMenu.add(this.displayEnvVarItem).addActionListener(actionEvent -> this.showEnvDialog());
        this.acceptEnvVarItem = new JMenuItem("Accept environment variable... [let -env]", 65);
        this.dataMenu.add(this.acceptEnvVarItem).addActionListener(actionEvent -> this.showAcceptEnvVarDialog());
        this.dataMenu.addSeparator();
        this.displayItem = new JMenuItem("Display... [" + "display".substring(0, 3) + "]", 68);
        this.dataMenu.add(this.displayItem).addActionListener(actionEvent -> this.showDisplayVariableDialog());
        this.displayOnLineItem = new JMenuItem("Display variables on selected line", 89);
        this.dataMenu.add(this.displayOnLineItem).addActionListener(actionEvent -> this.preview.displayVarsOnSelLine());
        this.offsetItem = new JMenuItem("Offset... [of]", 79);
        this.dataMenu.add(this.offsetItem).addActionListener(actionEvent -> this.showOffsetVariableDialog());
        this.lengthItem = new JMenuItem("Length... [len]", 76);
        this.dataMenu.add(this.lengthItem).addActionListener(actionEvent -> this.showLengthVariableDialog());
        this.quickWatchItem = new JMenuItem("Quick watch", 81);
        this.quickWatchItem.addActionListener(actionEvent -> {
            DebugPanel.MyVarName myVarName = this.preview.getVarName();
            String string = myVarName != null ? myVarName.varName : this.preview.getHighlightedVariable();
            this.showQuickWatchDialog(string, this.preview.getSelectedModule());
        });
        this.dataMenu.add(this.quickWatchItem);
        this.quickWatchItem.setEnabled(false);
        this.refreshItem = new JMenuItem("Refresh Variables Area");
        this.refreshItem.addActionListener(actionEvent -> this.preview.refreshVariables());
        this.dataMenu.add(this.refreshItem);
        this.refreshItem.setEnabled(false);
        this.dataMenu.addSeparator();
        this.acceptItem = new JMenuItem("Accept... [let]", 65);
        this.dataMenu.add(this.acceptItem).addActionListener(actionEvent -> this.showAcceptVariableDialog());
        this.dataMenu.addSeparator();
        this.setMonitorItem = new JMenuItem("Set monitor... [" + "monitor".substring(0, 3) + "]", 83);
        this.dataMenu.add(this.setMonitorItem).addActionListener(actionEvent -> this.showMonitorDialog());
        this.clearAllMonitorsItem = new JMenuItem("Clear all monitors [" + "unmonitor".substring(0, 5) + " " + "-a" + "]", 69);
        this.dataMenu.add(this.clearAllMonitorsItem).addActionListener(actionEvent -> this.setTextCommand("unmonitor -a"));
        this.bpMenu = new JMenu("Breakpoint");
        this.bpMenu.setMnemonic(66);
        this.setBreakpointItem = new JMenuItem("Set... [break]", 115);
        this.bpMenu.add(this.setBreakpointItem).addActionListener(actionEvent -> this.showBreakpointDialog(null));
        this.toggleBreakpointItem = new JMenuItem("Toggle breakpoint at current line", 99);
        this.bpMenu.add(this.toggleBreakpointItem).addActionListener(actionEvent -> this.toggleBreakpoint(this.preview.getSelectedLine(), this.preview.getFile(), this.preview.getBreakpoint(this.preview.getSelectedLine())));
        this.clearAllBreakpointsItem = new JMenuItem("Clear all [clear -a]", 97);
        this.bpMenu.add(this.clearAllBreakpointsItem).addActionListener(actionEvent -> this.setTextCommand("clear -a"));
        JMenu jMenu3 = new JMenu("Settings");
        jMenu3.setMnemonic(83);
        this.dataItem = new JMenuItem("Data", 68);
        this.dataItem.addActionListener(actionEvent -> this.showDataSettingsDialog());
        jMenu3.add(this.dataItem);
        this.breakpointsItem = new JMenuItem("Breakpoint", 66);
        this.breakpointsItem.addActionListener(actionEvent -> this.showBreakpointsSettingsDialog());
        jMenu3.add(this.breakpointsItem);
        JMenu jMenu4 = new JMenu("Source");
        jMenu4.setMnemonic(82);
        jMenu3.add(jMenu4);
        JMenu jMenu5 = new JMenu("Format");
        jMenu5.setMnemonic(70);
        jMenu4.add(jMenu5);
        ActionListener actionListener = actionEvent -> {
            Settings.setSourceFormat(Integer.parseInt(this.sfGroup.getSelection().getActionCommand()));
            this.preview.repaintSource();
        };
        this.sfGroup = new ButtonGroup();
        this.autoItem = new JRadioButtonMenuItem("Auto");
        this.autoItem.setActionCommand("0");
        this.autoItem.setMnemonic(65);
        this.autoItem.addActionListener(actionListener);
        jMenu5.add(this.autoItem);
        this.sfGroup.add(this.autoItem);
        this.ansiItem = new JRadioButtonMenuItem("Ansi");
        this.ansiItem.setActionCommand("1");
        this.ansiItem.setMnemonic(78);
        this.ansiItem.addActionListener(actionListener);
        jMenu5.add(this.ansiItem);
        this.sfGroup.add(this.ansiItem);
        this.termItem = new JRadioButtonMenuItem("Terminal");
        this.termItem.setActionCommand("2");
        this.termItem.setMnemonic(84);
        this.termItem.addActionListener(actionListener);
        jMenu5.add(this.termItem);
        this.sfGroup.add(this.termItem);
        this.freeItem = new JRadioButtonMenuItem("Free");
        this.freeItem.setActionCommand("3");
        this.freeItem.setMnemonic(70);
        this.freeItem.addActionListener(actionListener);
        jMenu5.add(this.freeItem);
        this.sfGroup.add(this.freeItem);
        this.variableItem = new JRadioButtonMenuItem("Variable");
        this.variableItem.setActionCommand("4");
        this.variableItem.setMnemonic(86);
        this.variableItem.addActionListener(actionListener);
        jMenu5.add(this.variableItem);
        this.sfGroup.add(this.variableItem);
        this.longItem = new JRadioButtonMenuItem("Long Line");
        this.longItem.setActionCommand("5");
        this.longItem.setMnemonic(76);
        this.longItem.addActionListener(actionListener);
        jMenu5.add(this.longItem);
        this.sfGroup.add(this.longItem);
        int n2 = Settings.getSourceFormat();
        this.setSourceFormat(n2);
        this.expandCopiesOnLoadItem = new JCheckBoxMenuItem("Expand copy books when loading source");
        this.expandCopiesOnLoadItem.setMnemonic(69);
        jMenu4.add(this.expandCopiesOnLoadItem);
        this.expandCopiesOnLoadItem.setSelected(Settings.isExpandCopiesOnLoad());
        this.expandCopiesOnLoadItem.addActionListener(actionEvent -> Settings.setExpandCopiesOnLoad(this.expandCopiesOnLoadItem.isSelected()));
        JMenu jMenu6 = new JMenu("Font size");
        jMenu6.setMnemonic(70);
        jMenu3.add(jMenu6);
        this.incrFontSizeItem = new JMenuItem("Increment font size", 73);
        jMenu6.add(this.incrFontSizeItem).addActionListener(actionEvent -> {
            this.preview.setSourceFontSize(this.preview.getSourceFontSize() + 1);
            this.fontSizeItems[this.preview.getSourceFontSize() - 9].setSelected(true);
        });
        this.decrFontSizeItem = new JMenuItem("Decrement font size", 68);
        jMenu6.add(this.decrFontSizeItem).addActionListener(actionEvent -> {
            this.preview.setSourceFontSize(this.preview.getSourceFontSize() - 1);
            this.fontSizeItems[this.preview.getSourceFontSize() - 9].setSelected(true);
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        int n3 = 0;
        int n4 = 9;
        while (n4 <= 20) {
            this.fontSizeItems[n3] = new JRadioButtonMenuItem("" + n4, n4 == this.preview.getSourceFontSize());
            int n5 = n4++;
            jMenu6.add(this.fontSizeItems[n3]).addActionListener(actionEvent -> this.preview.setSourceFontSize(n5));
            buttonGroup.add(this.fontSizeItems[n3]);
            ++n3;
        }
        JMenu jMenu7 = new JMenu("Customize");
        jMenu3.add(jMenu7);
        jMenu7.setMnemonic('c');
        this.custCommandsItem = new JMenuItem("Commands", 99);
        jMenu7.add(this.custCommandsItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            CustomizeCommandsDialog customizeCommandsDialog = new CustomizeCommandsDialog(this.jframe, "Commands");
            this.customizeCommandsDialogBds = customizeCommandsDialog.openDialog(this.customizeCommandsDialogBds);
        });
        this.shortcutsItem = new JMenuItem("Shortcuts", 115);
        jMenu7.add(this.shortcutsItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            CustomizeShortcutsDialog customizeShortcutsDialog = new CustomizeShortcutsDialog(this.jframe, "Shortcuts", this);
            this.customizeShortcutsDialogBds = customizeShortcutsDialog.openDialog(this.customizeShortcutsDialogBds);
        });
        this.fontsAndColorsItem = new JMenuItem("Fonts And Colors", 102);
        jMenu7.add(this.fontsAndColorsItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            SettingsDialog settingsDialog = new SettingsDialog(this.jframe, "Fonts and Colors", true, this.preview);
            this.settingsDialogBds = settingsDialog.openDialog(this.settingsDialogBds);
        });
        this.sessionItem = new JMenuItem("Session", 83);
        this.sessionItem.addActionListener(actionEvent -> this.showSessionSettingsDialog());
        jMenu3.add(this.sessionItem);
        this.consoleItem = new JMenuItem("Console", 79);
        this.consoleItem.addActionListener(actionEvent -> this.showConsoleSettingsDialog());
        jMenu3.add(this.consoleItem);
        JMenu jMenu8 = new JMenu("Help");
        jMenu8.setMnemonic(72);
        this.commandsItem = new JMenuItem("Commands... [help]", 67);
        jMenu8.add(this.commandsItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            this.showHelpDialog(null);
        });
        this.aboutItem = new JMenuItem("About...", 65);
        jMenu8.add(this.aboutItem).addActionListener(actionEvent -> {
            this.preview.hideTipPopup();
            JOptionPane.showMessageDialog(this.jframe, GraphDebugger.version(), TITLE, 1);
        });
        this.setAccelerators();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.runMenu);
        jMenuBar.add(this.dataMenu);
        jMenuBar.add(this.bpMenu);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu8);
        this.unloadItem.setEnabled(false);
        this.quitItem.setEnabled(false);
        this.setCommandEnabled(21, false);
        this.continueItem.setEnabled(false);
        this.setCommandEnabled(1, false);
        this.suspendItem.setEnabled(false);
        this.setCommandEnabled(28, false);
        this.stepIntoItem.setEnabled(false);
        this.setCommandEnabled(3, false);
        this.stepOverItem.setEnabled(false);
        this.setCommandEnabled(4, false);
        this.continueToLineItem.setEnabled(false);
        this.setCommandEnabled(12, false);
        this.runToSelLineItem.setEnabled(false);
        this.setCommandEnabled(56, false);
        this.runToNextProgItem.setEnabled(false);
        this.jumpToItem.setEnabled(false);
        this.setCommandEnabled(29, false);
        this.jumpToSelLineItem.setEnabled(false);
        this.jumpOutParItem.setEnabled(false);
        this.jumpOutProgItem.setEnabled(false);
        this.jumpNextItem.setEnabled(false);
        this.stepOutParItem.setEnabled(false);
        this.setCommandEnabled(10, false);
        this.stepOutProgItem.setEnabled(false);
        this.setCommandEnabled(11, false);
        this.displayItem.setEnabled(false);
        this.offsetItem.setEnabled(false);
        this.lengthItem.setEnabled(false);
        this.setCommandEnabled(5, false);
        this.displayOnLineItem.setEnabled(false);
        this.quickWatchItem.setEnabled(false);
        if (this.displayVersionItem != null) {
            this.displayVersionItem.setEnabled(false);
        }
        this.acceptItem.setEnabled(false);
        this.setCommandEnabled(6, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (!this.exitDebug) {
            GraphDebugger graphDebugger = this;
            synchronized (graphDebugger) {
                boolean bl = this.quitCmdExecuted;
                this.quitCmdExecuted = false;
                if (!this.getInvoker().isRunning() && !bl && this.remote && Settings.getAutoConnect()) {
                    this.lastCommandCode = 2;
                    this.process(true);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!this.exitDebug) {
                    this.process(false);
                }
            }
        }
    }

    boolean canJump(DebugResponse debugResponse) {
        return this.preview.getFile().isSupportingJumpCommand();
    }

    private static GraphDebugger start(MyDebuggerInvoker myDebuggerInvoker, DebugResponse debugResponse, LocalDebugInfo localDebugInfo, boolean bl, boolean bl2) throws IOException {
        String string = TITLE;
        if (bl2) {
            string = string + " [Remote execution]";
        }
        GraphDebugger graphDebugger = new GraphDebugger(myDebuggerInvoker, localDebugInfo, string, bl2, bl);
        myDebuggerInvoker.setFileLoaderHelper(graphDebugger);
        if (bl2) {
            graphDebugger.setRunCommandsButtonsEnabled(true, graphDebugger.canJump(null));
            graphDebugger.processing = true;
            graphDebugger.setEnabledAll(false, false);
            graphDebugger.handleResponse(debugResponse, true);
            boolean bl3 = graphDebugger.stopImmediately = debugResponse.getFirstBlockMode() != 1;
            if (!graphDebugger.stopImmediately) {
                graphDebugger.running = true;
                graphDebugger.setEnabledAll(false, false);
                if (myDebuggerInvoker.isRunning()) {
                    myDebuggerInvoker.processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
                    graphDebugger.loadDebugSession();
                }
                GraphDebugger.getAsynchronousResponse(() -> {
                    DebugResponse debugResponse = myDebuggerInvoker.getResponse(1);
                    graphDebugger.handleResponse(debugResponse, true);
                    graphDebugger.processing = false;
                    graphDebugger.setEnabledAll(true, graphDebugger.canJump(debugResponse));
                });
            } else {
                debugResponse = myDebuggerInvoker.getResponse();
                graphDebugger.handleResponse(debugResponse, true);
                if (myDebuggerInvoker.isRunning()) {
                    myDebuggerInvoker.processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
                    graphDebugger.loadDebugSession();
                }
                graphDebugger.processing = false;
                graphDebugger.setEnabledAll(true, graphDebugger.canJump(debugResponse));
            }
        } else {
            graphDebugger.setRunCommandsButtonsEnabled(false, graphDebugger.canJump(null));
            if (myDebuggerInvoker.isRunning()) {
                graphDebugger.loadDebugSession();
            }
            graphDebugger.processing = false;
        }
        graphDebugger.run();
        return graphDebugger;
    }

    public String getLastCommand() {
        if (!this.previousCommands.isEmpty()) {
            return (String)this.previousCommands.get(this.previousCommands.size() - 1);
        }
        return null;
    }

    public void setLastCommand(String string) {
        String string2 = this.getLastCommand();
        if (string2 == null || !string2.equals(string)) {
            if (this.previousCommands.size() == 50) {
                this.previousCommands.remove(0);
            }
            this.previousCommands.add(string);
            this.preview.setLastCommand(string);
        }
        this.previousCommandIndex = Integer.MIN_VALUE;
    }

    public String getPreviousCommand() {
        if (this.previousCommandIndex == Integer.MIN_VALUE) {
            if (!this.previousCommands.isEmpty()) {
                this.previousCommandIndex = this.previousCommands.size() - 1;
            }
        } else if (this.previousCommandIndex == this.previousCommands.size() - 1 && this.previousCommands.size() > 1) {
            --this.previousCommandIndex;
        }
        if (this.previousCommandIndex >= 0 && !this.previousCommands.isEmpty()) {
            String string = (String)this.previousCommands.get(this.previousCommandIndex);
            if (this.previousCommandIndex > 0) {
                --this.previousCommandIndex;
            }
            return string;
        }
        return null;
    }

    public String getNextCommand() {
        if (this.previousCommandIndex == Integer.MIN_VALUE) {
            return null;
        }
        if (this.previousCommandIndex == 0 && this.previousCommands.size() > 1) {
            ++this.previousCommandIndex;
        }
        if (this.previousCommandIndex < this.previousCommands.size()) {
            String string = (String)this.previousCommands.get(this.previousCommandIndex);
            if (this.previousCommandIndex < this.previousCommands.size() - 1) {
                ++this.previousCommandIndex;
            }
            return string;
        }
        return null;
    }

    public String[] setTextCommand(String string) {
        block61: {
            block62: {
                if (string == null) break block61;
                string = string.trim();
                String string2 = this.getLastCommand();
                if (string.length() == 0 && string2 != null) {
                    string = string2;
                }
                if (string.length() <= 0) break block62;
                String string3 = new StringTokenizer(string).nextToken();
                String string4 = Settings.getCommandAlias("debugger.commands.alias." + string3);
                if (string4 != null) {
                    string = new StringBuffer(string).replace(0, string3.length(), string4).toString();
                }
                string2 = string;
                this.setLastCommand(string2);
                this.tm = new DebugTMWithAliases(string2, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                int n2 = -1;
                try {
                    n2 = this.tm.getCommand(this.tm.getToken());
                    if (!this.isCommandEnabled(n2)) {
                        this.preview.outputResult("- command not allowed" + eol);
                        return null;
                    }
                }
                catch (DebuggerException debuggerException) {
                    this.preview.outputResult(debuggerException.getMessage() + eol);
                    return null;
                }
                switch (n2) {
                    case 21: {
                        if (this.processing) {
                            this.preview.outputResult("- debugger running" + eol);
                            break;
                        }
                        this.setCommand(n2);
                        break;
                    }
                    case 28: {
                        if (!this.processing) {
                            this.preview.outputResult("- the debugger is already paused" + eol);
                            break;
                        }
                        this.getInvoker().suspend();
                        break;
                    }
                    case 2: {
                        String string5;
                        if (this.processing) {
                            this.preview.outputResult("- debugger running" + eol);
                            break;
                        }
                        if (this.tm.countTokens() == 0 && (string5 = GraphDebugger.getChainingString()).length() > 0) {
                            string2 = "run " + string5;
                            this.setLastCommand(string2);
                            this.tm = new DebugTMWithAliases(string2, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                            this.tm.getToken();
                        }
                        this.setCommand(n2);
                        break;
                    }
                    case 27: {
                        if (this.showConfirmExitDialog()) {
                            GraphDebugger.close(this, this.getInvoker());
                            break;
                        }
                        break block61;
                    }
                    case 17: {
                        if (this.tm.countTokens() == 0) {
                            this.showTraceDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 26: {
                        if (this.tm.countTokens() == 0) {
                            this.showEnvDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 20: {
                        this.preview.hideTipPopup();
                        this.showHelpDialog(this.tm.getToken());
                        break;
                    }
                    case 31: {
                        this.preview.doFind(string2, false, false);
                        break;
                    }
                    case 32: {
                        this.preview.doFind(string2, true, false);
                        break;
                    }
                    case 33: {
                        this.preview.doFind(string2, false, true);
                        break;
                    }
                    case 34: {
                        this.preview.repeatFind();
                        break;
                    }
                    case 35: {
                        this.preview.select(0, 0);
                        break;
                    }
                    case 36: {
                        this.preview.selectLast();
                        break;
                    }
                    case 37: {
                        this.preview.selectCurrentLine();
                        break;
                    }
                    case 38: {
                        DebugParagraph[] debugParagraphArray = this.preview.getFile().getDebugParagraphs();
                        if (debugParagraphArray != null && debugParagraphArray.length > 0) {
                            this.preview.goTo(debugParagraphArray[0].getLineNumber(), debugParagraphArray[0].getParagraphName(), debugParagraphArray[0].getFileIndex());
                            break;
                        }
                        break block61;
                    }
                    case 39: {
                        try {
                            AutoOnCommand autoOnCommand = (AutoOnCommand)this.getInvoker().parseCommand(n2, this.tm);
                            if (autoOnCommand.isGet()) {
                                this.preview.outputResult("Autostep Delay: " + this.preview.getAutostepDelay());
                                break;
                            }
                            if (autoOnCommand.isSet()) {
                                this.preview.setAutostepDelay(autoOnCommand.getDelay());
                                this.preview.outputResult("Autostep Delay: " + this.preview.getAutostepDelay());
                                break;
                            }
                            this.preview.setAutostepState(true);
                        }
                        catch (DebuggerException debuggerException) {
                            this.preview.outputResult(debuggerException.getMessage() + eol);
                        }
                        break;
                    }
                    case 40: {
                        this.preview.setAutostepState(false);
                        break;
                    }
                    case 5: {
                        if (this.tm.countTokens() == 0) {
                            this.showDisplayVariableDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 54: {
                        if (this.tm.countTokens() == 0) {
                            this.showLengthVariableDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 55: {
                        if (this.tm.countTokens() == 0) {
                            this.showOffsetVariableDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 6: {
                        if (this.tm.countTokens() == 0) {
                            this.showAcceptVariableDialog();
                            break;
                        }
                        try {
                            DebugTM.Marker marker = this.tm.setMarker();
                            LetCommand letCommand = (LetCommand)this.getInvoker().parseCommand(n2, this.tm);
                            if (letCommand.getNewValue() != null) {
                                this.tm.rewindToMarker(marker);
                                this.caseDefault(n2);
                                break;
                            }
                            if (this.processing) {
                                this.preview.outputResult(LetCommand.USAGE + eol);
                                break;
                            }
                            String string6 = "display" + string.substring(string.indexOf(32));
                            DebugResponse debugResponse = this.getInvoker().processCommand(string6);
                            if (debugResponse != null && debugResponse.getReturnCode() == 0) {
                                return new String[]{string + "=" + debugResponse.getVarValue(), Integer.toString(string.length() + 1)};
                            }
                            this.tm.rewindToMarker(marker);
                            this.caseDefault(n2);
                        }
                        catch (DebuggerException debuggerException) {
                            this.preview.outputResult(debuggerException.getMessage() + eol);
                        }
                        break;
                    }
                    case 12: {
                        if (this.tm.countTokens() == 0) {
                            this.showStepToDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 29: {
                        if (this.preview.getFile().isSupportingJumpCommand()) {
                            if (this.tm.countTokens() == 0) {
                                this.showJumpToDialog();
                                break;
                            }
                            this.caseDefault(n2);
                            break;
                        }
                        this.preview.outputResult("- JUMP command not supported for this program. Please recompile with -dx option" + eol);
                        break;
                    }
                    case 13: {
                        if (this.tm.countTokens() == 0) {
                            this.showMonitorDialog();
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 0: {
                        if (this.tm.countTokens() == 0) {
                            this.showBreakpointDialog(null);
                            break;
                        }
                        this.caseDefault(n2);
                        break;
                    }
                    case 16: {
                        this.caseDefault(n2);
                        break;
                    }
                    default: {
                        this.caseDefault(n2);
                    }
                }
                break block61;
            }
            if (this.processing) {
                this.preview.outputResult("- debugger running" + eol);
            } else {
                this.setCommand(this.lastCommandCode);
            }
        }
        return null;
    }

    private void caseDefault(int n2) {
        if (this.processing && !this.isCommandAllowedInProcessing(n2)) {
            this.preview.outputResult("- debugger running" + eol);
        } else {
            this.setCommand(n2);
        }
    }

    private synchronized void setCommand(int n2) {
        this.lastCommandCode = n2;
        this.notify();
    }

    protected synchronized void setAllBreakpointsEnabledCommand(boolean bl) {
        this.lastCommandCode = bl ? 48 : 49;
        this.notify();
    }

    protected synchronized void setAllMonitorsEnabledCommand(boolean bl) {
        this.lastCommandCode = bl ? 50 : 51;
        this.notify();
    }

    private boolean startRemoteSession(DebugResponse debugResponse) {
        boolean bl = this.stopImmediately = !this.remote || debugResponse.getFirstBlockMode() != 1;
        if (this.remote) {
            this.preview.outputResult("+ Connected at host '" + hostname + "' on port " + port + eol);
            this.handleResponse(debugResponse, true);
            this.processing = true;
            this.quitItem.setEnabled(true);
            this.setCommandEnabled(21, true);
            this.preview.setQuitEnabled(true);
            if (this.stopImmediately) {
                debugResponse = this.getInvoker().getResponse();
            } else {
                this.setEnabledAll(false, false);
                GraphDebugger.getAsynchronousResponse(() -> {
                    DebugResponse debugResponse = this.getInvoker().getResponse(1);
                    this.handleResponse(debugResponse, true);
                    this.processing = false;
                    this.setEnabledAll(true, this.canJump(debugResponse));
                    this.reloadSession(this.preview.getBreakpoints(), this.preview.getMonitors(), this.watchedVariableCommands);
                });
            }
        }
        if (this.stopImmediately) {
            boolean bl2 = this.handleResponse(debugResponse, true);
            this.processing = false;
            return bl2;
        }
        return false;
    }

    private String connectionRefusedMsg() {
        return GraphDebugger.connectionRefusedMsg(hostname, port);
    }

    private static String connectionRefusedMsg(String string, int n2) {
        return "- Connection refused: host = '" + string + "', port = " + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void process(boolean bl) {
        boolean bl2;
        block25: {
            boolean bl3;
            block24: {
                block26: {
                    bl3 = false;
                    if (this.getInvoker().isRunning()) break block25;
                    this.setRunEnabled(false);
                    this.preview.outputResult("Restarting debugger..." + eol);
                    this.preview.resetIdxs();
                    bl2 = false;
                    if (!this.remote) break block26;
                    int n2 = 106;
                    DebugResponse debugResponse = null;
                    if (!bl) {
                        debugResponse = this.getInvoker().invokeRemote(hostname, port, 1, true);
                        n2 = debugResponse.getReturnCode();
                    }
                    boolean bl4 = bl2 = !DebugResponse.isErrorCode(n2);
                    if (bl2) {
                        bl3 = this.startRemoteSession(debugResponse);
                        break block24;
                    } else {
                        if (!Settings.getAutoConnect()) {
                            System.out.println(this.connectionRefusedMsg());
                            this.setRunEnabled(true);
                            return;
                        }
                        debugResponse = GraphDebugger.showAutoConnectDialog(this.invoker, this.jframe);
                        boolean bl5 = bl2 = debugResponse != null && !DebugResponse.isErrorCode(n2 = debugResponse.getReturnCode());
                        if (bl2) {
                            bl3 = this.startRemoteSession(debugResponse);
                            break block24;
                        } else {
                            if (debugResponse == null) {
                                this.quitCmdExecuted = true;
                            }
                            System.out.println(this.connectionRefusedMsg());
                            this.setRunEnabled(true);
                            return;
                        }
                    }
                }
                int n3 = this.getInvoker().launchIsCobolProgram(dbgArgv);
                boolean bl6 = bl2 = n3 > 0;
                if (!bl2) {
                    this.setRunEnabled(true);
                    return;
                }
                DebugResponse debugResponse = this.getInvoker().invokeRemote("localhost", n3, 10, true);
                int n4 = debugResponse.getReturnCode();
                if (!DebugResponse.isErrorCode(n4)) {
                    bl3 = this.startRemoteSession(debugResponse);
                }
            }
            if (bl3) {
                return;
            }
            if (this.remote && !this.remoteThinClient) {
                this.getInvoker().processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
            }
            this.reloadSession(this.preview.getBreakpoints(), this.stopImmediately ? this.preview.getMonitors() : null, this.stopImmediately ? this.watchedVariableCommands : null);
        }
        if (!(bl2 = this.processing)) {
            this.processing = true;
            this.setEnabledAll(false, false);
        }
        switch (this.lastCommandCode) {
            case -1: {
                break;
            }
            case 2: {
                this.setRunQuitEnabled(true);
                if (this.remote) break;
                this.genericCommand();
                break;
            }
            case 48: {
                this.handleResponse(this.setAllBreakpointsEnabled(this.preview.getBreakpoints(), true), false);
                break;
            }
            case 49: {
                this.handleResponse(this.setAllBreakpointsEnabled(this.preview.getBreakpoints(), false), false);
                break;
            }
            case 50: {
                this.handleResponse(this.setAllMonitorsEnabled(this.preview.getMonitors(), true), false);
                break;
            }
            case 51: {
                this.handleResponse(this.setAllMonitorsEnabled(this.preview.getMonitors(), false), false);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                this.genericCommand();
                break;
            }
            case 21: {
                if (!this.showConfirmQuitDialog()) break;
                this.quitCmdExecuted = true;
                this.stopSession();
                break;
            }
            default: {
                if (this.getLastCommand() == null) break;
                this.genericCommand();
            }
        }
        if (!bl2) {
            this.setEnabledAll(true, this.canJump(null));
            if (!this.running) {
                this.setRunEnabled(true);
            }
            this.processing = false;
        }
    }

    private void reloadSession(Breakpoint[] breakpointArray, Watch[] watchArray, String[] stringArray) {
        Vector<DebugCommand> vector = new Vector<DebugCommand>();
        vector.addElement(new ClearBreakpointCommand(true));
        if (watchArray != null) {
            vector.addElement(new ClearMonitorCommand(true));
        }
        DebugResponse debugResponse = null;
        if (breakpointArray != null) {
            for (Breakpoint breakpoint : breakpointArray) {
                try {
                    vector.addElement(this.getInvoker().parseCommand(breakpoint.getDebugCommand()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (watchArray != null) {
            for (Watch watch : watchArray) {
                try {
                    vector.addElement(this.getInvoker().parseCommand(watch.getDebugCommand()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (stringArray != null) {
            for (String string : stringArray) {
                try {
                    DisplayCommand displayCommand = (DisplayCommand)this.getInvoker().parseCommand(string);
                    displayCommand.setDeferredIfNotRunning(true);
                    vector.addElement(displayCommand);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!vector.isEmpty()) {
            CompositeCommand compositeCommand = new CompositeCommand(vector);
            debugResponse = this.getInvoker().processCommand(compositeCommand);
        }
        if (debugResponse != null) {
            breakpointArray = debugResponse.getBreakpoints();
            if (breakpointArray != null) {
                this.preview.setBreakpoints(breakpointArray);
            }
            this.preview.setMonitors(debugResponse.getMonitors());
        }
    }

    private DebugResponse setAllMonitorsEnabled(Watch[] watchArray, boolean bl) {
        DebugResponse debugResponse = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (watchArray.length > 0) {
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                watchArray[i2].setEnabled(bl);
                debugResponse = this.getInvoker().processCommand(watchArray[i2].getDebugCommand());
                if (debugResponse == null) continue;
                stringBuffer.append(debugResponse.getMessage());
            }
        }
        if (debugResponse != null) {
            debugResponse.setMessage(stringBuffer.toString());
        }
        return debugResponse;
    }

    private DebugResponse setAllBreakpointsEnabled(Breakpoint[] breakpointArray, boolean bl) {
        DebugResponse debugResponse = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (breakpointArray.length > 0) {
            for (int i2 = 0; i2 < breakpointArray.length; ++i2) {
                breakpointArray[i2].setEnabled(bl);
                debugResponse = this.getInvoker().processCommand(breakpointArray[i2].getDebugCommand());
                if (debugResponse == null) continue;
                stringBuffer.append(debugResponse.getMessage());
            }
        }
        if (debugResponse != null) {
            debugResponse.setMessage(stringBuffer.toString());
        }
        return debugResponse;
    }

    void setUnloadEnabled(boolean bl) {
        if (this.unloadItem != null) {
            this.unloadItem.setEnabled(bl);
        }
    }

    void stopSession() {
        this.getInvoker().exitDebug(this.isRemote() && Settings.getForceStopRun());
        this.running = false;
        this.preview.setAutostepState(false);
        this.setRunCommandsButtonsEnabled(false, false);
        this.preview.setParStack(null);
        this.preview.setMemory(0L, 0L);
        this.preview.deactivateMonitors();
        this.watchedVariableCommands = this.preview.getWatchedVariableCommands();
        this.preview.clearTrees();
        this.maxHexDumpLength = 0;
        this.hexDumpStartOffset = 0;
        this.maxArrayLength = 0;
        this.arrayStartOffset = 0;
        this.maxTextValueLength = 0;
        this.maxTextValueLengthOutput = 0;
        this.dataSettingsChanged = true;
        this.setThreads(null, null);
        this.preview.outputResult("- Program finished" + eol);
    }

    private void setEnabledAll(boolean bl, boolean bl2) {
        this.setRunMenuEnabled(bl && this.running, bl2);
        this.preview.setEnabledAll(bl && this.running, bl2);
    }

    private void setRunMenuEnabled(boolean bl, boolean bl2) {
        this.dataMenu.setEnabled(bl);
        if (this.stopImmediately) {
            this.bpMenu.setEnabled(this.running ? bl : true);
        }
        this.stepIntoItem.setEnabled(bl);
        this.setCommandEnabled(3, bl);
        this.stepOverItem.setEnabled(bl);
        this.setCommandEnabled(4, bl);
        this.continueItem.setEnabled(bl);
        this.setCommandEnabled(1, bl);
        this.suspendItem.setEnabled(!bl && this.running);
        this.setCommandEnabled(28, !bl && this.running);
        this.continueToLineItem.setEnabled(bl);
        this.runToSelLineItem.setEnabled(bl);
        this.setCommandEnabled(12, bl);
        this.runToNextProgItem.setEnabled(bl);
        this.setCommandEnabled(56, bl);
        this.jumpToSelLineItem.setEnabled(bl && bl2);
        this.jumpToItem.setEnabled(bl && bl2);
        this.jumpOutParItem.setEnabled(bl && bl2);
        this.jumpOutProgItem.setEnabled(bl && bl2);
        this.jumpNextItem.setEnabled(bl && bl2);
        this.setCommandEnabled(29, bl && bl2);
        this.acceptItem.setEnabled(bl);
        this.setCommandEnabled(6, bl);
        this.stepOutParItem.setEnabled(bl);
        this.setCommandEnabled(10, bl);
        this.stepOutProgItem.setEnabled(bl);
        this.setCommandEnabled(11, bl);
        this.autostepItem.setEnabled(bl);
        this.displayItem.setEnabled(bl);
        this.offsetItem.setEnabled(bl);
        this.lengthItem.setEnabled(bl);
        this.setCommandEnabled(5, bl);
        this.quickWatchItem.setEnabled(bl);
        this.refreshItem.setEnabled(bl);
        this.displayOnLineItem.setEnabled(bl);
        boolean bl3 = bl || !this.running;
        this.tronItem.setEnabled(bl3);
        this.troffItem.setEnabled(bl3);
        this.loadDebugItem.setEnabled(bl3);
        this.saveDebugItem.setEnabled(bl3);
        if (this.displayVersionItem != null) {
            this.displayVersionItem.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genericCommand() {
        String string;
        DebugTM debugTM;
        int n2;
        DebugResponse debugResponse = null;
        GraphDebugger graphDebugger = this;
        synchronized (graphDebugger) {
            n2 = this.lastCommandCode;
            debugTM = this.tm;
            string = this.getLastCommand();
        }
        try {
            debugResponse = this.getInvoker().processCommand(n2, debugTM);
        }
        catch (DebuggerException debuggerException) {
            debugResponse = new DebugResponse(1, debuggerException.getMessage() + eol);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debugResponse = new DebugResponse(1, "Internal error: " + string + eol);
        }
        this.handleResponse(debugResponse, false);
    }

    static int getClassNameIndex(String[] stringArray) {
        int n2;
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
        }
        return n2;
    }

    static boolean isIsCobolClass(String string) throws ClassNotFoundException {
        try {
            return GraphDebugger.isIsCobolClass(DebugUtilities.classForNameNoInitialize(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (GraphDebugger.isIsCobolClass(Config.a("iscobol.code_prefix", ""), string)) {
                return true;
            }
            throw classNotFoundException;
        }
    }

    static boolean isIsCobolClass(String string, String string2) throws ClassNotFoundException {
        CallLoader callLoader = CallLoader.getInstance(string);
        if (callLoader != null) {
            return GraphDebugger.isIsCobolClass(callLoader.loadClass(string2));
        }
        return false;
    }

    static boolean isIsCobolClass(Class clazz) {
        try {
            Class<?> clazz2 = Class.forName("com.iscobol.rts.IscobolClass", false, GraphDebugger.class.getClassLoader());
            return clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    boolean isQuickWatchActive() {
        return this.quickWatchDialog != null && this.quickWatchDialog.isActive();
    }

    private boolean handleResponse(DebugResponse debugResponse, boolean bl) {
        boolean bl2;
        boolean bl3;
        if (this.exitDebug) {
            return true;
        }
        boolean bl4 = false;
        if (!this.isASActive) {
            this.jframe.toFront();
            this.preview.setInitFocus();
        }
        boolean bl5 = bl3 = (bl2 = this.isQuickWatchActive()) && !this.quickWatchDialog.isExecutingDisplayCommand();
        if (debugResponse != null) {
            boolean bl6 = bl4 = debugResponse.getReturnCode() == 103 || debugResponse.getReturnCode() == 104;
            if (bl2) {
                if (!this.quickWatchDialog.commandExecuted(debugResponse)) {
                    this.preview.outputResult(debugResponse.getMessage());
                }
            } else {
                this.preview.outputResult(debugResponse.getMessage());
            }
            if (Settings.getExitAfterTermination() && debugResponse.getReturnCode() == 103) {
                GraphDebugger.close(this, null);
            }
        } else {
            bl4 = true;
        }
        if (bl4) {
            String string = "- The program is finished. Type ";
            if (!this.remote) {
                string = string + "'run' to restart session or ";
            }
            string = string + "'exit' to exit debug";
            this.getInvoker().exitDebug();
            this.setRunCommandsButtonsEnabled(false, false);
            this.running = false;
            this.preview.outputResult(string + eol);
            if (this.isASActive) {
                this.preview.setAutostepState(false);
            }
            if (debugResponse.getReturnCode() == 104) {
                this.setCurrentLine(debugResponse, debugResponse.getInfo());
            }
            this.preview.setParStack(null);
            this.preview.setMemory(0L, 0L);
            this.setThreads(null, null);
            this.preview.deactivateMonitors();
            this.watchedVariableCommands = this.preview.getWatchedVariableCommands();
            this.preview.clearTrees();
            this.maxHexDumpLength = 0;
            this.hexDumpStartOffset = 0;
            this.maxArrayLength = 0;
            this.arrayStartOffset = 0;
            this.maxTextValueLength = 0;
            this.maxTextValueLengthOutput = 0;
            this.dataSettingsChanged = true;
        } else {
            this.update(debugResponse, bl, bl3);
            if (this.isASActive) {
                this.autoStepTimer.restart();
            }
        }
        return bl4;
    }

    private void setCurrentLine(DebugResponse debugResponse, DebugResponse.DebugInfo debugInfo) {
        int n2;
        if ("".equals(debugResponse.getLastProgram())) {
            return;
        }
        int n3 = debugResponse.getLine();
        int n4 = debugResponse.getLastFileIndex();
        Filename filename = new Filename(debugResponse.getLastProgram());
        Filename filename2 = new Filename(debugResponse.getLastFile());
        long l2 = debugResponse.getLastProgramTimestamp();
        TextFile textFile = this.preview.getFile();
        long l3 = textFile.getTimestamp();
        if (!filename.equals(new Filename(textFile.getFilename())) || l3 > 0L && l2 != l3) {
            ParagraphObject[] paragraphObjectArray;
            DebugResponse.DebugInfo debugInfo2 = null;
            if (debugResponse.getCurrentThread() != null && (debugResponse.getInfo() == null || debugResponse.getInfo().getErrorString() == null) && (paragraphObjectArray = debugResponse.getCurrentThread().getParStack()) != null && paragraphObjectArray.length > 0) {
                ParagraphObject paragraphObject = paragraphObjectArray[paragraphObjectArray.length - 1];
                String string = paragraphObject.getProgName();
                if (mainClassName == null || mainClassName.equals("$Dummy$")) {
                    mainClassName = string;
                }
                if (paragraphObject.getProgClassLocation() != null) {
                    string = paragraphObject.getProgClassLocation() + "/" + string;
                }
                debugInfo2 = this.getInvoker().getInfo(string, false, true);
            }
            if ((debugInfo2 == null || debugInfo2.getErrorString() != null) && debugInfo != null && debugInfo.getErrorString() == null) {
                debugInfo2 = new LocalDebugInfo(this.getInvoker(), debugInfo);
                this.getInvoker().putLocalDebugInfo(debugInfo2.getClassName(), 991, (LocalDebugInfo)debugInfo2, true);
            }
            if (debugInfo2 != null && debugInfo2.getErrorString() == null) {
                textFile = this.preview.loadFile((LocalDebugInfo)debugInfo2, filename, l2, true);
                boolean bl = debugInfo2.isJumpCommandSupported();
                this.jumpToItem.setEnabled(bl);
                this.jumpToSelLineItem.setEnabled(bl);
                this.jumpOutParItem.setEnabled(bl);
                this.jumpOutProgItem.setEnabled(bl);
                this.jumpNextItem.setEnabled(bl);
                this.setCommandEnabled(29, bl);
                this.preview.setJumpCommandEnabled(bl);
            } else {
                textFile = this.preview.loadFile(null, new Filename(""), 0L, true);
            }
        }
        int n5 = n3;
        n3 = textFile.toListingLine(n3, filename2, n4);
        textFile.setTimestamp(l2);
        if (n3 == -1 && n5 > 0) {
            for (int i2 = n5 - 1; n3 == -1 && i2 >= 0; --i2) {
                n3 = textFile.toListingLine(i2, filename2, n4);
            }
        }
        if ((n2 = this.preview.getLineIndex(n3, true)) >= 0) {
            this.preview.setCurrentLine(n2);
        }
    }

    private static void getAsynchronousResponse(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("AsynchronousGetResponse");
        thread.start();
    }

    private void updateTabs(DebugResponse debugResponse, boolean bl) {
        this.preview.setParStack(debugResponse.getParStack());
        if (!bl) {
            int n2;
            int n3;
            if (debugResponse.getLastProgram().equals(debugResponse.getOldProgram())) {
                n3 = debugResponse.getOldLine();
                n2 = debugResponse.getOldFileIndex();
            } else {
                n3 = -1;
                n2 = -1;
            }
            if (this.preview.isAutoRefreshEnabled()) {
                this.preview.refreshCurrentVariables(debugResponse.getLine(), debugResponse.getLastFileIndex(), n3, n2);
                this.preview.refreshVariables(1);
            }
            this.preview.setMonitors(debugResponse.getMonitors());
        }
        this.preview.setMemory(debugResponse.getTotalMemory(), debugResponse.getFreeMemory());
        this.setThreads(debugResponse.getThreads(), debugResponse.getCurrentThread());
    }

    private void update(DebugResponse debugResponse, boolean bl, boolean bl2) {
        int n2 = debugResponse.getReturnCode();
        if (n2 == 101 || n2 == 102 || debugResponse.getLastCmd() == 28) {
            this.running = true;
            this.setCurrentLine(debugResponse, null);
            this.updateTabs(debugResponse, bl);
            return;
        }
        if (n2 != 0) {
            return;
        }
        int n3 = debugResponse.getLastCmd();
        Breakpoint[] breakpointArray = debugResponse.getBreakpoints();
        Watch[] watchArray = debugResponse.getMonitors();
        Tree[] treeArray = debugResponse.getTrees();
        switch (n3) {
            case 16: {
                this.preview.selectThreadsTab();
                this.setCurrentLine(debugResponse, null);
                this.updateTabs(debugResponse, bl);
                break;
            }
            case 2: {
                this.running = true;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 56: {
                this.setCurrentLine(debugResponse, null);
                this.updateTabs(debugResponse, bl);
                break;
            }
            case 0: 
            case 9: 
            case 19: 
            case 48: 
            case 49: 
            case 52: {
                this.preview.selectBreakpointsTab();
                this.preview.setBreakpoints(breakpointArray);
                break;
            }
            case 22: {
                if (breakpointArray != null) {
                    this.preview.setBreakpoints(breakpointArray);
                }
                if (watchArray == null) break;
                this.preview.setMonitors(watchArray);
                break;
            }
            case 13: 
            case 14: 
            case 50: 
            case 51: {
                this.preview.selectMonitorsTab();
                this.preview.setMonitors(debugResponse.getMonitors());
                break;
            }
            case 15: {
                this.preview.selectPerformStackTab();
                break;
            }
            case 24: 
            case 25: {
                this.preview.setMemory(debugResponse.getTotalMemory(), debugResponse.getFreeMemory());
            }
        }
        if (treeArray != null && !bl2) {
            for (int i2 = 0; i2 < treeArray.length; ++i2) {
                this.preview.setTree(treeArray[i2], i2 == treeArray.length - 1);
            }
        }
    }

    private void setThreads(ThreadObject[] threadObjectArray, ThreadObject threadObject) {
        new IsguiWorker(false, () -> {
            for (int i2 = 0; i2 < this.threadItems.length; ++i2) {
                this.runMenu.remove(this.threadItems[i2]);
            }
            if (threadObjectArray != null) {
                int n2;
                Arrays.sort(threadObjectArray);
                ButtonGroup buttonGroup = new ButtonGroup();
                this.threadItems = new JRadioButtonMenuItem[threadObjectArray.length];
                Font font = this.runMenu.getFont();
                for (n2 = 0; n2 < threadObjectArray.length; ++n2) {
                    this.threadItems[n2] = new JRadioButtonMenuItem(threadObjectArray[n2].toString());
                    this.threadItems[n2].setName(threadObjectArray[n2].getName());
                    buttonGroup.add(this.threadItems[n2]);
                    this.runMenu.add(this.threadItems[n2]);
                    this.threadItems[n2].setFont(font);
                    this.threadItems[n2].addActionListener(this.preview.getThreadActionListener());
                }
                for (n2 = 0; n2 < threadObjectArray.length; ++n2) {
                    if (!threadObjectArray[n2].equals(threadObject)) continue;
                    this.threadItems[n2].setSelected(true);
                    break;
                }
            } else {
                this.threadItems = new JRadioButtonMenuItem[0];
            }
            this.preview.setThreads(threadObjectArray, threadObject);
        }).start();
    }

    void startAutostep() {
        if (!this.isASActive) {
            new IsguiWorker(false, () -> {
                if (this.startItem.isEnabled()) {
                    this.setTextCommand("run " + chainingString);
                } else {
                    this.autoStepTimer.restart();
                }
                this.isASActive = true;
                this.autostepItem.setText(STOP_AUTOSTEP_LBL);
                this.autostepItem.setActionCommand(STOP_AUTOSTEP_ACTION);
                this.autostepItem.setMnemonic(85);
                this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, "graphdebugger.shortcut.stoff"));
            }).start();
        }
    }

    void stopAutostep() {
        if (this.isASActive) {
            new IsguiWorker(false, () -> {
                this.autoStepTimer.stop();
                this.isASActive = false;
                this.autostepItem.setText(START_AUTOSTEP_LBL);
                this.autostepItem.setActionCommand(START_AUTOSTEP_ACTION);
                this.autostepItem.setMnemonic(65);
                this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, "graphdebugger.shortcut.ston"));
            }).start();
        }
    }

    private void setRunQuitEnabled(boolean bl) {
        this.startItem.setEnabled(!bl);
        this.setCommandEnabled(2, !bl);
        this.quitItem.setEnabled(bl);
        this.setCommandEnabled(21, bl);
        this.preview.setRunQuitEnabled(bl);
    }

    private void setRunEnabled(boolean bl) {
        this.startItem.setEnabled(bl);
        this.setCommandEnabled(2, bl);
        this.preview.setRunEnabled(bl);
    }

    private void setRunCommandsButtonsEnabled(boolean bl, boolean bl2) {
        this.startItem.setEnabled(!bl);
        this.setCommandEnabled(2, !bl);
        this.quitItem.setEnabled(bl);
        this.setCommandEnabled(21, bl);
        this.setRunMenuEnabled(bl, bl2);
        this.preview.setRunCommandsButtonsEnabled(bl, bl2);
    }

    public void setSourceFormat(int n2) {
        switch (n2) {
            case 1: {
                this.ansiItem.setSelected(true);
                break;
            }
            case 2: {
                this.termItem.setSelected(true);
                break;
            }
            case 3: {
                this.freeItem.setSelected(true);
                break;
            }
            case 4: {
                this.variableItem.setSelected(true);
                break;
            }
            case 5: {
                this.longItem.setSelected(true);
                break;
            }
            default: {
                this.autoItem.setSelected(true);
            }
        }
    }

    private JFileChooser getIsdFileChooser(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".isd");
            }

            @Override
            public String getDescription() {
                return "*.isd";
            }
        });
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir", ".")));
        if (string2 != null) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        return jFileChooser;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Config.c();
        Locale.setDefault(Locale.ENGLISH);
        String string = "Usage: java GraphDebugger [-opt1 ... -optN] java-class [arg1 ... argN]" + eol + "Usage: java GraphDebugger -r [hostname [port]]";
        if (stringArray.length == 0) {
            GraphDebugger.exit(string, -1);
        }
        if (stringArray.length == 1 && stringArray[0].equals("-v")) {
            SwingErrorBox.message(RuntimeProperties.getFullVersionNumber(), GraphDebugger.version(), TITLE, "Inform.gif");
            System.exit(0);
        }
        boolean bl = stringArray[0].equalsIgnoreCase("-r");
        boolean bl2 = stringArray[0].startsWith("-r_notifyclient");
        if (bl || bl2) {
            try {
                object4 = Class.forName("com.iscobol.gui.client.Client");
                object3 = ((Class)object4).getDeclaredField("a");
                ((Field)object3).setAccessible(true);
                object2 = (byte[])((Field)object3).get(null);
                Field field = ((Class)object4).getDeclaredField("b");
                field.setAccessible(true);
                byte[] byArray = (byte[])field.get(null);
                object = new Properties();
                ((Properties)object).setProperty(RtsUtil.newUTFString((byte[])object2), RtsUtil.newUTFString(byArray));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ((Properties)object).store(byteArrayOutputStream, "GraphDebugger Static Configurations");
                byteArrayOutputStream.close();
                Config.a(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        object3 = new MyDebuggerInvoker();
        object2 = new ArrayList<String>();
        object2.addAll(Factory.getJVMArguments());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object2.add(stringArray[i2]);
        }
        String[] stringArray2 = new String[object2.size()];
        object2.toArray(stringArray2);
        if (bl) {
            object4 = GraphDebugger.doRemoteDebugging((MyDebuggerInvoker)object3, stringArray, false, true);
        } else if (bl2) {
            object4 = GraphDebugger.doRemoteDebugging((MyDebuggerInvoker)object3, stringArray, true, true);
        } else {
            boolean bl3;
            int n2;
            block27: {
                int n3 = GraphDebugger.getClassNameIndex(stringArray);
                object = null;
                if (n3 >= stringArray.length) {
                    GraphDebugger.exit(string, -1);
                } else {
                    object = stringArray[n3];
                }
                n2 = 0;
                bl3 = false;
                try {
                    if (GraphDebugger.isIsCobolClass((String)object)) {
                        n2 = ((DebuggerInvoker)object3).launchIsCobolProgram(stringArray2);
                        bl3 = true;
                    } else {
                        GraphDebugger.exit("Invalid class '" + (String)object + "'", -1);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string2 = "-Discobol.code_prefix=";
                    String string3 = "-Discobol.conf=";
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        Object object5;
                        if (stringArray[i3].startsWith("-Discobol.code_prefix=")) {
                            object5 = stringArray[i3].substring("-Discobol.code_prefix=".length());
                            try {
                                if (!GraphDebugger.isIsCobolClass((String)object5, (String)object)) break;
                                n2 = ((DebuggerInvoker)object3).launchIsCobolProgram(stringArray2);
                                bl3 = true;
                            }
                            catch (ClassNotFoundException classNotFoundException2) {}
                            break;
                        }
                        if (!stringArray[i3].startsWith("-Discobol.conf=")) continue;
                        object5 = new Properties();
                        RtsUtil.loadPropertiesWithImport((Properties)object5, stringArray[i3].substring("-Discobol.conf=".length()));
                        String string4 = ((Properties)object5).getProperty("iscobol.code_prefix");
                        if (string4 == null) continue;
                        try {
                            if (!GraphDebugger.isIsCobolClass(string4, (String)object)) break;
                            n2 = ((DebuggerInvoker)object3).launchIsCobolProgram(stringArray2);
                            bl3 = true;
                        }
                        catch (ClassNotFoundException classNotFoundException3) {}
                        break;
                    }
                    if (bl3) break block27;
                    GraphDebugger.exit("Cannot load class '" + (String)object + "'", -1);
                }
            }
            if (n2 > 0) {
                dbgArgv = stringArray2;
                mainClassName = object;
                chainingString = "";
                for (int i4 = n3 + 1; i4 < stringArray.length; ++i4) {
                    boolean bl4 = stringArray[i4].indexOf(32) >= 0;
                    if (bl4) {
                        chainingString = chainingString + "\"";
                    }
                    chainingString = chainingString + stringArray[i4];
                    if (bl4) {
                        chainingString = chainingString + "\"";
                    }
                    if (i4 >= stringArray.length - 1) continue;
                    chainingString = chainingString + " ";
                }
            } else {
                GraphDebugger.exit("Cannot load class '" + (String)object + "'", -1);
            }
            object4 = bl3 ? GraphDebugger.doRemoteDebugging((MyDebuggerInvoker)object3, new String[]{"-r", "localhost", Integer.toString(n2)}, false, false) : null;
        }
        GraphDebugger.close((GraphDebugger)object4, (DebuggerInvoker)object3);
    }

    private static void close(GraphDebugger graphDebugger, DebuggerInvoker debuggerInvoker) {
        if (graphDebugger != null) {
            graphDebugger.saveDebugSession();
            graphDebugger.saveWindowLayout();
            Settings.setFindFlags(graphDebugger.findDialog.isMatchCaseSelected(), graphDebugger.findDialog.isBackwardSearchSelected(), graphDebugger.findDialog.isWrapSearchSelected(), graphDebugger.findDialog.isWholeWordsSelected(), graphDebugger.findDialog.isSearchFromTopSelected(), graphDebugger.findDialog.isMatchMinusUnderscoreSelected());
            Settings.saveSettings();
        }
        if (debuggerInvoker != null) {
            debuggerInvoker.exitDebug(graphDebugger != null && graphDebugger.isRemote() && Settings.getForceStopRun());
        }
        System.exit(0);
    }

    private void saveDebugSession() {
        if (Settings.getAutosave()) {
            String string = Settings.getSessionOutputFileName();
            if (string.length() == 0) {
                string = mainClassName + ".isd";
            }
            DebuggerInvoker.save(string, this.preview.getBreakpoints(), this.preview.getMonitors(), this.preview.getWatchedVariableCommands(), chainingString);
        }
    }

    private void loadDebugSession() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        String string = Settings.getSessionOutputFileName();
        if (string.length() == 0) {
            string = mainClassName + ".isd";
        }
        String[] stringArray = new String[1];
        CompositeCommand compositeCommand = this.getInvoker().load(string, vector, vector2, vector3, stringArray);
        if (compositeCommand != null) {
            int n2;
            Watch[] watchArray;
            if (stringArray[0] != null && (chainingString == null || chainingString.trim().length() == 0)) {
                chainingString = stringArray[0];
            }
            if (vector2.size() > 0) {
                watchArray = new Watch[vector2.size()];
                vector2.toArray(watchArray);
                this.preview.setMonitors(watchArray);
            }
            if (vector.size() > 0) {
                watchArray = new Breakpoint[vector.size()];
                vector.toArray(watchArray);
                this.preview.setBreakpoints((Breakpoint[])watchArray);
            }
            watchArray = compositeCommand.getCommandList();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (n2 = 0; n2 < watchArray.size(); ++n2) {
                if (!(watchArray.get(n2) instanceof DisplayCommand)) continue;
                DisplayCommand displayCommand = (DisplayCommand)watchArray.get(n2);
                arrayList.add(new String[]{displayCommand.getVarName().getFullName(), displayCommand.getClassName()});
            }
            this.preview.setWatchedVariableNames(arrayList);
            if (vector3.size() > 0) {
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    this.preview.setTree((Tree)vector3.elementAt(n2), n2 == vector3.size() - 1);
                }
            }
        }
    }

    private static GraphDebugger doRemoteDebugging(MyDebuggerInvoker myDebuggerInvoker, String[] stringArray, boolean bl, boolean bl2) throws IOException {
        DebugResponse debugResponse;
        int n2;
        GraphDebugger graphDebugger = null;
        hostname = stringArray.length > 1 ? stringArray[1] : Config.a("iscobol.hostname", "localhost");
        if (stringArray.length > 2) {
            try {
                port = Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                port = Config.a("iscobol.debug.port", 9999);
            }
        } else {
            port = Config.a("iscobol.debug.port", 9999);
        }
        if (!DebugResponse.isErrorCode(n2 = (debugResponse = myDebuggerInvoker.invokeRemote(hostname, port, bl2 ? 1 : 10, true)).getReturnCode())) {
            mainClassName = debugResponse.getInfo().getClassName();
            LocalDebugInfo localDebugInfo = myDebuggerInvoker.getInfo(mainClassName, true, false);
            if (localDebugInfo == null) {
                localDebugInfo = myDebuggerInvoker.createLocalDebugInfo(debugResponse);
            }
            graphDebugger = GraphDebugger.start(myDebuggerInvoker, debugResponse, localDebugInfo, bl, bl2);
        } else if (bl2) {
            debugResponse = GraphDebugger.showAutoConnectDialog(myDebuggerInvoker, null);
            if (debugResponse != null && !DebugResponse.isErrorCode(n2 = debugResponse.getReturnCode())) {
                mainClassName = debugResponse.getInfo().getClassName();
                LocalDebugInfo localDebugInfo = myDebuggerInvoker.getInfo(mainClassName, true, false);
                if (localDebugInfo == null) {
                    localDebugInfo = myDebuggerInvoker.createLocalDebugInfo(debugResponse);
                }
                graphDebugger = GraphDebugger.start(myDebuggerInvoker, debugResponse, localDebugInfo, bl, bl2);
            } else {
                GraphDebugger.exit(GraphDebugger.connectionRefusedMsg(hostname, port), -2);
            }
        } else {
            GraphDebugger.exit(debugResponse.getMessage(), -2);
        }
        return graphDebugger;
    }

    public void runToSelectedLine(int n2, TextFile textFile) {
        CobolRef cobolRef = textFile.toCobolLine(this.preview.getListingline(n2));
        String string = "to ";
        string = string + cobolRef.lineNo() + " \"" + cobolRef.filename() + "\"";
        if (cobolRef.getFileIndex() >= 0) {
            string = string + " -fi " + cobolRef.getFileIndex();
        }
        this.setTextCommand(string);
    }

    public void toggleBreakpoint(int n2, TextFile textFile, Breakpoint breakpoint) {
        if (!this.processing && n2 >= 0) {
            CobolRef cobolRef = textFile.getBPArgs(this.preview.getListingline(n2));
            if (breakpoint != null) {
                String string = "clear ";
                string = breakpoint.getParagraph() != null ? string + breakpoint.getParagraph() : string + cobolRef.lineNo();
                string = string + " \"" + cobolRef.filename() + "\"";
                if (cobolRef.getFileIndex() >= 0) {
                    string = string + " -fi " + cobolRef.getFileIndex();
                }
                if (cobolRef.progname() != null) {
                    string = string + " " + cobolRef.progname();
                }
                this.setTextCommand(string);
            } else {
                String string = "break " + cobolRef.lineNo() + " \"" + cobolRef.filename() + "\"";
                if (cobolRef.getFileIndex() >= 0) {
                    string = string + " -fi " + cobolRef.getFileIndex();
                }
                if (cobolRef.progname() != null) {
                    string = string + " " + cobolRef.progname();
                }
                this.setTextCommand(string);
            }
        }
    }

    private void showAcceptVariableDialog() {
        String string;
        Object object;
        this.preview.hideTipPopup();
        String string2 = this.preview.getHighlightedVariable();
        String string3 = string2 != null ? string2 : "";
        String string4 = null;
        if (string3.length() > 0 && (object = this.invoker.processCommand("display " + string3)) != null && ((DebugResponse)object).getReturnCode() == 0) {
            string4 = ((DebugResponse)object).getVarValue();
        }
        if ((string = this.showAcceptVariableDialog(string3, (String)(object = this.preview.getSelectedModule()), string4, string4, this.exitDebug)) != null) {
            this.setTextCommand(string);
        }
    }

    public String showAcceptVariableDialog(String string, String string2, String string3, String string4, boolean bl) {
        AcceptVariableDialog acceptVariableDialog = new AcceptVariableDialog(this.jframe, "Modify variable", string, string2, string3, null, Settings.getHexOption());
        this.acceptVariableDialogBds = acceptVariableDialog.openDialog(this.acceptVariableDialogBds);
        return acceptVariableDialog.getCommandString();
    }

    private void showDataSettingsDialog() {
        this.preview.hideTipPopup();
        DataSettingsDialog dataSettingsDialog = new DataSettingsDialog(this.jframe, "Data Settings", this.preview);
        this.dataSettingsDialogBds = dataSettingsDialog.openDialog(this.dataSettingsDialogBds);
    }

    private void showBreakpointsSettingsDialog() {
        this.preview.hideTipPopup();
        BreakpointsSettingsDialog breakpointsSettingsDialog = new BreakpointsSettingsDialog(this.jframe, "Breakpoint Settings");
        this.breakpointSettingsDialogBds = breakpointsSettingsDialog.openDialog(this.breakpointSettingsDialogBds);
    }

    private void showHelpDialog(String string) {
        if (this.helpDialog == null) {
            this.helpDialog = new HelpDialog(this.jframe, "Debug commands");
        }
        if (this.helpDialog.isVisible()) {
            this.helpDialog.toFront();
        } else {
            this.helpDialog.openDialog(this.helpDialog.getLastBounds());
        }
        if (string != null) {
            this.helpDialog.selectCommand(string);
        }
    }

    private void showSessionSettingsDialog() {
        this.preview.hideTipPopup();
        SessionSettingsDialog sessionSettingsDialog = new SessionSettingsDialog(this.jframe, "Session Settings", true);
        this.sessionSettingsDialogBds = sessionSettingsDialog.openDialog(this.sessionSettingsDialogBds);
    }

    private void showConsoleSettingsDialog() {
        this.preview.hideTipPopup();
        ConsoleSettingsDialog consoleSettingsDialog = new ConsoleSettingsDialog(this.jframe, this.preview);
        this.consoleSettingsDialogBds = consoleSettingsDialog.openDialog(this.consoleSettingsDialogBds);
    }

    private void showDisplayVariableDialog() {
        String string = this.preview.getHighlightedVariable();
        String string2 = string != null ? string : "";
        String string3 = this.preview.getSelectedModule();
        this.showDisplayVariableDialog(string2, string3, false);
    }

    void showDisplayVariableDialog(String string, String string2, boolean bl) {
        this.preview.hideTipPopup();
        DisplayVariableDialog displayVariableDialog = new DisplayVariableDialog(this.jframe, "Display variable", string, string2, bl);
        this.displayVariableDialogBds = displayVariableDialog.openDialog(this.displayVariableDialogBds);
        String string3 = displayVariableDialog.getCommandString();
        if (string3 != null) {
            this.setTextCommand(string3);
        }
    }

    private void showOffsetVariableDialog() {
        this.preview.hideTipPopup();
        String string = this.preview.getHighlightedVariable();
        String string2 = this.preview.getSelectedModule();
        InputDialog inputDialog = new InputDialog(this.jframe, "Display offset of variable", new String[]{"Name:", "Method/Program:"}, null, new String[]{string, string2}, new int[]{20, 20}, false);
        this.displayOffsetDialogBds = inputDialog.openDialog(this.displayOffsetDialogBds);
        String[] stringArray = inputDialog.getValues();
        if (stringArray != null && stringArray[0].length() > 0) {
            String string3 = "offset";
            if (stringArray[1].length() > 0) {
                string3 = string3 + " ";
                string3 = string3 + "-c";
                string3 = string3 + " ";
                string3 = string3 + stringArray[1];
            }
            string3 = string3 + " ";
            string3 = string3 + stringArray[0];
            this.setTextCommand(string3);
        }
    }

    private void showLengthVariableDialog() {
        String string = this.preview.getHighlightedVariable();
        String string2 = this.preview.getSelectedModule();
        InputDialog inputDialog = new InputDialog(this.jframe, "Display length of variable", new String[]{"Name:", "Method/Program:"}, null, new String[]{string, string2}, new int[]{20, 20}, false);
        this.displayLengthDialogBds = inputDialog.openDialog(this.displayLengthDialogBds);
        String[] stringArray = inputDialog.getValues();
        if (stringArray != null && stringArray[0].length() > 0) {
            String string3 = "length";
            if (stringArray[1].length() > 0) {
                string3 = string3 + " ";
                string3 = string3 + "-c";
                string3 = string3 + " ";
                string3 = string3 + stringArray[1];
            }
            string3 = string3 + " ";
            string3 = string3 + stringArray[0];
            this.setTextCommand(string3);
        }
    }

    private void showStepToDialog() {
        InputDialog inputDialog = new InputDialog(this.jframe, "Continue to line number", "TO line-number [filename]:", null, null, 20, false);
        this.stepToDialogBds = inputDialog.openDialog(this.stepToDialogBds);
        String string = inputDialog.getValue();
        if (string != null && string.length() > 0) {
            this.setTextCommand("to " + string);
        }
    }

    private void showJumpToDialog() {
        this.preview.hideTipPopup();
        JumpToDialog jumpToDialog = new JumpToDialog(this.jframe, "Jump to", this.preview);
        this.jumpToDialogBds = jumpToDialog.openDialog(this.jumpToDialogBds);
        if (jumpToDialog.getSelectedLineNumber() > 0) {
            this.setTextCommand("jump " + jumpToDialog.getSelectedLineNumber() + " " + jumpToDialog.getSelectedFileName());
        } else if (jumpToDialog.getSelectedParagraphName() != null) {
            this.setTextCommand("jump " + jumpToDialog.getSelectedParagraphName());
        }
    }

    void showMonitorDialog() {
        String string = this.preview.getHighlightedVariable();
        String string2 = string != null ? string : "";
        this.showMonitorDialog(string2, this.preview.getSelectedModule(), null, this.running, Settings.getHexOption());
    }

    public String showMonitorDialog(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.preview.hideTipPopup();
        MonitorDialog monitorDialog = new MonitorDialog(this.jframe, "Set monitor", string, string2, string3, bl, bl2, Settings.getDefaultMonitorEnabledState());
        this.monitorDialogBds = monitorDialog.openDialog(this.monitorDialogBds);
        String string4 = monitorDialog.getCommandString();
        if (string4 != null) {
            this.setTextCommand(string4);
        }
        return string4;
    }

    void showModifyMonitorDialog(Watch watch) {
        this.preview.hideTipPopup();
        MonitorDialog monitorDialog = new MonitorDialog(this.jframe, "Modify monitor", watch, this.running, Settings.getHexOption(), Settings.getDefaultMonitorEnabledState());
        this.monitorDialogBds = monitorDialog.openDialog(this.monitorDialogBds);
        String string = monitorDialog.getCommandString();
        if (string != null) {
            this.setTextCommand(string);
        }
    }

    private void showAcceptEnvVarDialog() {
        this.preview.hideTipPopup();
        AcceptEnvVariableDialog acceptEnvVariableDialog = new AcceptEnvVariableDialog(this.jframe, "Accept environment variable");
        this.acceptEnvVariableDialogBds = acceptEnvVariableDialog.openDialog(this.acceptEnvVariableDialogBds);
        String string = acceptEnvVariableDialog.getCommandString();
        if (string != null) {
            this.setTextCommand(string);
        }
    }

    void showBreakpointDialog(Breakpoint breakpoint) {
        this.preview.hideTipPopup();
        BreakpointDialog breakpointDialog = new BreakpointDialog(this.jframe, "Set breakpoint", breakpoint, this.running);
        this.breakpointDialogBds = breakpointDialog.openDialog(this.breakpointDialogBds);
        String string = breakpointDialog.getCommandString();
        if (string != null) {
            this.setTextCommand(string);
        }
    }

    private void showTraceDialog() {
        this.preview.hideTipPopup();
        TraceDialog traceDialog = new TraceDialog(this.jframe, "Start tracing", true);
        this.traceDialogBds = traceDialog.openDialog(this.traceDialogBds);
        String string = traceDialog.getCommandString();
        if (string != null) {
            this.setTextCommand(string);
        }
    }

    public void showGotoDialog() {
        this.preview.hideTipPopup();
        this.gotoDialog.openDialog(this.gotoDialog.getLastBounds());
    }

    private void showEnvDialog() {
        this.preview.hideTipPopup();
        InputDialog inputDialog = new InputDialog(this.jframe, "Display environment variable", "Name:", null, null, 20, true);
        this.displayEnvVariableDialogBds = inputDialog.openDialog(this.displayEnvVariableDialogBds);
        String string = inputDialog.getValue();
        boolean bl = inputDialog.isHexadecimal();
        if (string != null && string.length() > 0) {
            String string2 = "display";
            if (bl) {
                string2 = string2 + " -x";
            }
            string2 = string2 + " -env " + string;
            this.setTextCommand(string2);
        }
    }

    void showQuickWatchDialog(String string, String string2) {
        this.preview.hideTipPopup();
        if (this.quickWatchDialog == null) {
            this.quickWatchDialog = new QuickWatchDialog(this, this.jframe, "Quick Watch");
        }
        this.quickWatchDialog.setVariableName(string);
        this.quickWatchDialog.setModuleName(string2);
        this.quickWatchDialog.openDialog(this.quickWatchDialog.getLastBounds());
    }

    boolean showConfirmQuitDialog() {
        this.preview.hideTipPopup();
        if (!Settings.getAskConfirmWhenQuit()) {
            return true;
        }
        boolean[] blArray = this.showConfirmDialog("Quit session?", "Always quit without prompt");
        Settings.setAskConfirmWhenQuit(!blArray[1]);
        return blArray[0];
    }

    boolean showConfirmExitDialog() {
        this.preview.hideTipPopup();
        if (!Settings.getAskConfirmWhenExit()) {
            return true;
        }
        boolean[] blArray = this.showConfirmDialog("Exit debug?", "Always exit without prompt");
        Settings.setAskConfirmWhenExit(!blArray[1]);
        return blArray[0];
    }

    private boolean[] showConfirmDialog(String string, String string2) {
        JCheckBox jCheckBox = new JCheckBox(string2);
        jCheckBox.setFont(jCheckBox.getFont().deriveFont(8));
        return new boolean[]{JOptionPane.showOptionDialog(null, string, "Question", 0, 3, null, new Object[]{jCheckBox, "OK", "No"}, "OK") == 1, jCheckBox.isSelected()};
    }

    private static DebugResponse showAutoConnectDialog(DebuggerInvoker debuggerInvoker, JFrame jFrame) {
        class AutoConnectTimer
        extends Timer {
            private static final long serialVersionUID = 1L;
            int times;

            AutoConnectTimer(int n2) {
                super(1000, null);
                this.times = n2;
            }
        }
        AutoConnectTimer autoConnectTimer = new AutoConnectTimer(Settings.getAutoConnectDelay() - 1);
        DebugDialog debugDialog = new DebugDialog(jFrame, "Connect", true);
        DebugResponse[] debugResponseArray = new DebugResponse[1];
        debugDialog.setLocationRelativeTo(jFrame);
        debugDialog.setDefaultCloseOperation(0);
        debugDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 30));
        int n2 = Settings.getAutoConnectDelay();
        JLabel jLabel = new JLabel("Connection refused.");
        jLabel.setForeground(Color.red);
        JButton jButton = new JButton("Reconnect " + n2 + ".");
        jButton.addActionListener(actionEvent -> {
            autoConnectTimer.stop();
            jButton.setEnabled(false);
            debugResponseArray[0] = debuggerInvoker.invokeRemote(hostname, port, 1, true);
            int n2 = debugResponseArray[0].getReturnCode();
            if (DebugResponse.isErrorCode(n2)) {
                jLabel.setVisible(true);
                autoConnectTimer.times = Settings.getAutoConnectDelay();
                autoConnectTimer.start();
            } else {
                debugDialog.closeDialog();
            }
        });
        jButton.setToolTipText("hostname: " + hostname + ", port: " + port);
        jButton.setPreferredSize(new Dimension(200, 25));
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.addActionListener(actionEvent -> {
            autoConnectTimer.stop();
            debugResponseArray[0] = null;
            debugDialog.dispose();
        });
        jButton2.setPreferredSize(new Dimension(80, 25));
        jPanel.add(jButton2);
        autoConnectTimer.addActionListener(actionEvent -> {
            jButton.setEnabled(true);
            jLabel.setVisible(false);
            jButton.setText("Reconnect " + autoConnectTimer.times + ".");
            if (autoConnectTimer.times == 0) {
                jButton.setEnabled(false);
                debugResponseArray[0] = debuggerInvoker.invokeRemote(hostname, port, 1, true);
                int n2 = debugResponseArray[0].getReturnCode();
                if (DebugResponse.isErrorCode(n2)) {
                    jLabel.setVisible(true);
                    autoConnectTimer.times = Settings.getAutoConnectDelay();
                    autoConnectTimer.start();
                } else {
                    debugDialog.dispose();
                }
            } else {
                --autoConnectTimer.times;
                autoConnectTimer.start();
            }
        });
        autoConnectTimer.setRepeats(false);
        debugDialog.getContentPane().add((Component)jPanel, "Center");
        debugDialog.getContentPane().add((Component)jLabel, "South");
        jLabel.setVisible(false);
        debugDialog.setResizable(false);
        debugDialog.pack();
        autoConnectTimer.start();
        debugDialog.setVisible(true);
        return debugResponseArray[0];
    }

    void updateGotoActions(boolean bl, boolean bl2) {
        this.backItem.setEnabled(bl);
        this.forwardItem.setEnabled(bl2);
    }

    public String getDebugPanelInfoRow(int n2) {
        return this.preview.menuBPintoCMD(n2);
    }

    private KeyStroke getKeyStroke(JMenuItem jMenuItem, String string) {
        String string2 = Settings.getShortcut(string);
        int[] nArray = Settings.getShortcutParams(string2);
        if (nArray[1] == 121 && nArray[0] == 0) {
            this.f10Item = jMenuItem;
        }
        return KeyStroke.getKeyStroke(nArray[1], nArray[0]);
    }

    public void setAccelerators() {
        this.f10Item = null;
        this.tronItem.setAccelerator(this.getKeyStroke(this.tronItem, "graphdebugger.shortcut.tron"));
        this.troffItem.setAccelerator(this.getKeyStroke(this.troffItem, "graphdebugger.shortcut.troff"));
        this.loadItem.setAccelerator(this.getKeyStroke(this.loadItem, "graphdebugger.shortcut.loadfile"));
        this.unloadItem.setAccelerator(this.getKeyStroke(this.unloadItem, "graphdebugger.shortcut.unloadfile"));
        this.exitItem.setAccelerator(this.getKeyStroke(this.exitItem, "graphdebugger.shortcut.exit"));
        this.startItem.setAccelerator(this.getKeyStroke(this.startItem, "graphdebugger.shortcut.run"));
        this.quitItem.setAccelerator(this.getKeyStroke(this.quitItem, "graphdebugger.shortcut.quit"));
        this.continueItem.setAccelerator(this.getKeyStroke(this.continueItem, "graphdebugger.shortcut.continue"));
        this.stepIntoItem.setAccelerator(this.getKeyStroke(this.stepIntoItem, "graphdebugger.shortcut.step"));
        this.stepOverItem.setAccelerator(this.getKeyStroke(this.stepOverItem, "graphdebugger.shortcut.next"));
        this.stepOutParItem.setAccelerator(this.getKeyStroke(this.stepOutParItem, "graphdebugger.shortcut.outpar"));
        this.stepOutProgItem.setAccelerator(this.getKeyStroke(this.stepOutProgItem, "graphdebugger.shortcut.outprog"));
        this.continueToLineItem.setAccelerator(this.getKeyStroke(this.continueToLineItem, "graphdebugger.shortcut.to"));
        this.runToSelLineItem.setAccelerator(this.getKeyStroke(this.runToSelLineItem, "graphdebugger.shortcut.toline"));
        this.runToNextProgItem.setAccelerator(this.getKeyStroke(this.runToNextProgItem, "graphdebugger.shortcut.prog"));
        this.jumpNextItem.setAccelerator(this.getKeyStroke(this.jumpNextItem, "graphdebugger.shortcut.jumpnext"));
        this.jumpToItem.setAccelerator(this.getKeyStroke(this.jumpToItem, "graphdebugger.shortcut.jump"));
        this.jumpOutParItem.setAccelerator(this.getKeyStroke(this.jumpOutParItem, "graphdebugger.shortcut.jumpoutpar"));
        this.jumpOutProgItem.setAccelerator(this.getKeyStroke(this.jumpOutProgItem, "graphdebugger.shortcut.jumpoutprog"));
        this.jumpToSelLineItem.setAccelerator(this.getKeyStroke(this.jumpToSelLineItem, "graphdebugger.shortcut.jumptoline"));
        this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, this.autostepItem.getActionCommand().equals(START_AUTOSTEP_ACTION) ? "graphdebugger.shortcut.ston" : "graphdebugger.shortcut.stoff"));
        this.findItem.setAccelerator(this.getKeyStroke(this.findItem, "graphdebugger.shortcut.find"));
        this.gotoItem.setAccelerator(this.getKeyStroke(this.gotoItem, "graphdebugger.shortcut.goto"));
        this.gotoDeclItem.setAccelerator(this.getKeyStroke(this.gotoDeclItem, "graphdebugger.shortcut.gotodecl"));
        this.backItem.setAccelerator(this.getKeyStroke(this.backItem, "graphdebugger.shortcut.gotoback"));
        this.forwardItem.setAccelerator(this.getKeyStroke(this.forwardItem, "graphdebugger.shortcut.gotoforw"));
        this.clearoutItem.setAccelerator(this.getKeyStroke(this.clearoutItem, "graphdebugger.shortcut.clearout"));
        this.lastCmdItem.setAccelerator(this.getKeyStroke(this.lastCmdItem, "graphdebugger.shortcut.lastcmd"));
        this.prevCmdItem.setAccelerator(this.getKeyStroke(this.prevCmdItem, "graphdebugger.shortcut.prevcmd"));
        this.nextCmdItem.setAccelerator(this.getKeyStroke(this.nextCmdItem, "graphdebugger.shortcut.nextcmd"));
        this.findBackwardItem.setAccelerator(this.getKeyStroke(this.findBackwardItem, "graphdebugger.shortcut.fb"));
        this.findForwardItem.setAccelerator(this.getKeyStroke(this.findForwardItem, "graphdebugger.shortcut.ff"));
        this.findFromTopItem.setAccelerator(this.getKeyStroke(this.findFromTopItem, "graphdebugger.shortcut.ft"));
        this.repeatFindItem.setAccelerator(this.getKeyStroke(this.repeatFindItem, "graphdebugger.shortcut.repfind"));
        this.displayItem.setAccelerator(this.getKeyStroke(this.displayItem, "graphdebugger.shortcut.display"));
        this.quickWatchItem.setAccelerator(this.getKeyStroke(this.quickWatchItem, "graphdebugger.shortcut.quickwatch"));
        this.refreshItem.setAccelerator(this.getKeyStroke(this.refreshItem, "graphdebugger.shortcut.refreshvararea"));
        this.displayOnLineItem.setAccelerator(this.getKeyStroke(this.displayOnLineItem, "graphdebugger.shortcut.displayonselline"));
        this.acceptItem.setAccelerator(this.getKeyStroke(this.acceptItem, "graphdebugger.shortcut.let"));
        this.setMonitorItem.setAccelerator(this.getKeyStroke(this.setMonitorItem, "graphdebugger.shortcut.monitor"));
        this.setBreakpointItem.setAccelerator(this.getKeyStroke(this.setBreakpointItem, "graphdebugger.shortcut.break"));
        this.toggleBreakpointItem.setAccelerator(this.getKeyStroke(this.toggleBreakpointItem, "graphdebugger.shortcut.togglebreak"));
        this.incrFontSizeItem.setAccelerator(this.getKeyStroke(this.incrFontSizeItem, "graphdebugger.shortcut.incfont"));
        this.decrFontSizeItem.setAccelerator(this.getKeyStroke(this.decrFontSizeItem, "graphdebugger.shortcut.decfont"));
        this.commandsItem.setAccelerator(this.getKeyStroke(this.commandsItem, "graphdebugger.shortcut.help"));
        this.firstItem.setAccelerator(this.getKeyStroke(this.firstItem, "graphdebugger.shortcut.first_line"));
        this.firstExecItem.setAccelerator(this.getKeyStroke(this.firstExecItem, "graphdebugger.shortcut.first_exec_line"));
        this.lastItem.setAccelerator(this.getKeyStroke(this.lastItem, "graphdebugger.shortcut.last_line"));
        this.currentLineItem.setAccelerator(this.getKeyStroke(this.currentLineItem, "graphdebugger.shortcut.curr_line"));
        this.preview.setAccelerators();
    }

    public static String version() {
        String string = Config.a(".licinfo", "Missing license!");
        String string2 = string.substring(string.length() - 8).equals("99991231") ? "None" : string.substring(string.length() - 8);
        String[] stringArray = string.substring(0, string.length() - 8).split("(##)");
        String string3 = stringArray.length > 1 ? stringArray[1] : "Missing";
        String string4 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String string5 = RuntimeProperties.getFullVersionNumber();
        String string6 = RuntimeProperties.getProductCopyright();
        return string5 + eol + "Company:         " + stringArray[0] + eol + "License ID:      " + string3 + eol + "Expiration Date: " + string2 + eol + string6 + eol + eol + "Java version:    " + string4 + eol + "                 " + System.getProperty("java.home");
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public JFrame getFrame() {
        return this.jframe;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isRemoteThinClient() {
        return this.remoteThinClient;
    }

    public static String getChainingString() {
        return chainingString;
    }

    public void setAutostepDelay(int n2) {
        this.autoStepTimer.setInitialDelay(n2);
    }

    public void setQuitCommandExecuted(boolean bl) {
        this.quitCmdExecuted = bl;
    }

    public FindDialog getFindDialog() {
        return this.findDialog;
    }

    private void saveWindowLayout() {
        Settings.setWindowBounds(this.jframe.getBounds());
        Settings.setWindowState(this.jframe.getExtendedState());
        this.preview.saveWindowLayout();
    }

    private void setCommandEnabled(int n2, boolean bl) {
        this.commandEnablingTable.put(new Integer(n2), new Boolean(bl));
    }

    private boolean isCommandEnabled(int n2) {
        Boolean bl = (Boolean)this.commandEnablingTable.get(new Integer(n2));
        return bl == null || bl != false;
    }

    protected void clearCommandHistory() {
        this.previousCommands.clear();
        this.previousCommandIndex = Integer.MIN_VALUE;
    }

    protected void executeCommand(String string) {
        if (this.isProcessing() && this.isRunning() && !this.isCommandAllowedInProcessing(string)) {
            this.getInvoker().putInput(string);
        } else {
            this.setTextCommand(string);
        }
    }

    @Override
    public String getLine(int n2, String string, int n3) {
        if (this.preview != null) {
            TextFile textFile = this.preview.getFile();
            int n4 = textFile.toListingLine(n2, new Filename(string), n3);
            return textFile.getLine(n4, false, false);
        }
        return null;
    }

    public DebuggerInvoker getInvoker() {
        return this.invoker;
    }

    private static void exit(final String string, int n2) {
        String string2 = string.indexOf(eol) >= 0 ? "<html>" + string.replace(eol, "<br>") + "</html>" : string;
        ErrorBox.showDirect(new Exception(string2){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }

            @Override
            public String toString() {
                return string;
            }
        });
        System.exit(n2);
    }

    private void addLetEnvPropCommands(Vector vector) {
        if (Settings.getMaxHexDumpLength() != this.maxHexDumpLength) {
            this.maxHexDumpLength = Settings.getMaxHexDumpLength();
            vector.addElement(new LetCommand("debug.internal.max_hex_dump_length", Integer.toString(this.maxHexDumpLength)));
        }
        if (Settings.getHexDumpStartOffset() != this.hexDumpStartOffset) {
            this.hexDumpStartOffset = Settings.getHexDumpStartOffset();
            vector.addElement(new LetCommand("debug.internal.hex_dump_start", Integer.toString(this.hexDumpStartOffset)));
        }
        if (Settings.getMaxArrayLength() != this.maxArrayLength) {
            this.maxArrayLength = Settings.getMaxArrayLength();
            vector.addElement(new LetCommand("debug.internal.max_array_length", Integer.toString(this.maxArrayLength)));
        }
        if (Settings.getArrayStartOffset() != this.arrayStartOffset) {
            this.arrayStartOffset = Settings.getArrayStartOffset();
            vector.addElement(new LetCommand("debug.internal.array_start", Integer.toString(this.arrayStartOffset)));
        }
        if (Settings.getMaxTextValueLength() != this.maxTextValueLength) {
            this.maxTextValueLength = Settings.getMaxTextValueLength();
            vector.addElement(new LetCommand("debug.internal.max_text_length", Integer.toString(this.maxTextValueLength)));
        }
        if (Settings.getMaxTextValueLengthOutput() != this.maxTextValueLengthOutput) {
            this.maxTextValueLengthOutput = Settings.getMaxTextValueLengthOutput();
            vector.addElement(new LetCommand("debug.internal.max_text_length_out", Integer.toString(this.maxTextValueLengthOutput)));
        }
    }

    boolean isCommandAllowedInProcessing(String string) {
        return (string = string.toLowerCase().trim()).startsWith("pause".substring(0, 1)) || !this.stopImmediately && (string.startsWith("break".substring(0, 1)) || string.startsWith("clear".substring(0, 1)) || string.startsWith("b0".substring(0, 1)) || string.startsWith("m0".substring(0, 1)));
    }

    boolean isCommandAllowedInProcessing(int n2) {
        switch (n2) {
            case 28: {
                return true;
            }
            case 0: 
            case 9: 
            case 19: 
            case 52: {
                return !this.stopImmediately;
            }
        }
        return false;
    }

    void outputResult(String string) {
        this.preview.outputResult0(string);
    }

    static {
        hostname = "localhost";
        port = 9999;
        chainingString = "";
    }

    static class MyDebuggerInvoker
    extends DebuggerInvoker {
        GraphDebugger gd;

        MyDebuggerInvoker() {
        }

        @Override
        protected DebugCommand parseLet(DebugTM debugTM) throws DebuggerException {
            return super.parseLet(debugTM, true);
        }

        @Override
        protected DebugCommand parseDisplay(DebugTM debugTM) throws DebuggerException {
            DisplayCommand displayCommand = (DisplayCommand)super.parseDisplay(debugTM);
            if (displayCommand.displayAsTree()) {
                displayCommand.setDisplayAsHex(true);
                displayCommand.setDisplayAsText(true);
                displayCommand.setShowChildren(this.gd.isQuickWatchActive() ? (short)2 : 0);
            }
            return displayCommand;
        }

        @Override
        public DebugResponse processCommand(DebugCommand debugCommand) {
            if (debugCommand instanceof CompositeCommand) {
                Vector<DebugCommand> vector = ((CompositeCommand)debugCommand).getCommandList();
                if (this.gd.dataSettingsChanged) {
                    Vector vector2 = new Vector();
                    this.gd.addLetEnvPropCommands(vector2);
                    if (vector2.size() > 0) {
                        vector.addAll(0, vector2);
                    }
                    this.gd.dataSettingsChanged = false;
                }
            } else if (this.gd.dataSettingsChanged) {
                Vector<DebugCommand> vector = new Vector<DebugCommand>();
                this.gd.addLetEnvPropCommands(vector);
                if (vector.size() > 0) {
                    vector.addElement(debugCommand);
                    debugCommand = new CompositeCommand(vector);
                }
                this.gd.dataSettingsChanged = false;
            }
            return super.processCommand(debugCommand);
        }

        @Override
        protected String getChainingString() {
            return chainingString;
        }

        @Override
        protected void setChainingString(String string) {
            chainingString = string;
        }

        @Override
        protected DebugResponse save(DebugTM debugTM) {
            if (this.gd != null) {
                SaveCommand saveCommand = (SaveCommand)this.parseSave(debugTM);
                boolean bl = MyDebuggerInvoker.save(saveCommand.getFilename(), this.gd.preview.getBreakpoints(), this.gd.preview.getMonitors(), this.gd.preview.getWatchedVariableCommands(), chainingString);
                if (bl) {
                    return new DebugResponse(0, "+ saved information in '" + saveCommand.getFilename() + "'" + eol, 23);
                }
                return new DebugResponse(1, "");
            }
            return super.save(debugTM);
        }
    }
}

