/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class GraphUtilities {
    public static final String CONNECT_IMAGE = "connect.gif";
    public static final String RUN_IMAGE = "rundebug.gif";
    public static final String CONTINUE_IMAGE = "continue.gif";
    public static final String SUSPEND_IMAGE = "suspend.gif";
    public static final String STEP_OVER_IMAGE = "stepover.gif";
    public static final String STEP_INTO_IMAGE = "stepinto.gif";
    public static final String STEP_OUT_IMAGE = "stepout.gif";
    public static final String STEP_OUT_PROG_IMAGE = "stepoutprog.gif";
    public static final String STEP_TO_IMAGE = "runtilcurs.gif";
    public static final String STEP_TO_PROGRAM_IMAGE = "runtilpgm.gif";
    public static final String JUMP_IMAGE = "jump.gif";
    public static final String JUMP_OUT_IMAGE = "jumpout.gif";
    public static final String JUMP_OUT_PROG_IMAGE = "jumpoutprog.gif";
    public static final String JUMP_OVER_IMAGE = "jumpover.gif";
    public static final String DISCONNECT_IMAGE = "disconnect.gif";
    public static final String QUIT_IMAGE = "stop.gif";
    public static final String FIND_IMAGE = "find.gif";
    public static final String REPEAT_FIND_IMAGE = "find_repeat.gif";
    public static final String AUTOSTEP_IMAGE = "autostep.gif";
    public static final String BREAKPOINT_IMAGE = "breakpoint.gif";
    public static final String CURR_LINE_IMAGE = "currline.gif";
    public static final String GO_TO_CURR_LINE_IMAGE = "gotocurrline.gif";
    public static final String CHANGE_VALUE_IMAGE = "changevalue.gif";
    public static final String EXPAND_ALL_IMAGE = "expandall.gif";
    public static final String COLLAPSE_ALL_IMAGE = "collapseall.gif";
    public static final String EXPAND_IMAGE = "expand.gif";
    public static final String COLLAPSE_IMAGE = "collapse.gif";
    public static final String CHECKALL_IMAGE = "checkall.gif";
    public static final String UNCHECKALL_IMAGE = "uncheckall.gif";
    public static final String REFRESH_IMAGE = "refresh.gif";
    public static final String HEX_IMAGE = "hex.gif";
    public static final String NEWMONITOR_IMAGE = "newmonitor.gif";
    public static final String EDIT_IMAGE = "edit.gif";
    public static final String REMOVE_IMAGE = "remove.gif";
    public static final String REMOVE_ALL_IMAGE = "removeall.gif";
    public static final String BACK_IMAGE = "back.gif";
    public static final String FORWARD_IMAGE = "forward.gif";
    public static final String EXECUTE_IMAGE = "execute.gif";
    public static final String ADD_ITEM_IMAGE = "add_item.gif";
    public static final String ATTACHED_IMAGE = "attached.gif";
    public static final String CLEAR_CONSOLE_IMAGE = "clearconsole.png";
    public static final String SHOW_CONSOLE_IMAGE = "showconsole.png";
    private static final Map IMAGES = new HashMap();
    public static final PrintStream systemOut = System.out;
    public static final PrintStream systemErr = System.err;
    private static final OutputStreamManager osm = new OutputStreamManager();

    public static void setOut(PrintStream printStream) {
        osm.setOut(printStream);
    }

    public static void setErr(PrintStream printStream) {
        osm.setErr(printStream);
    }

    public static void enableOutputStream() {
        osm.enableOutputStream();
    }

    public static void disableOutputStream() {
        osm.disableOutputStream();
    }

    public static void enableErrorStream() {
        osm.enableErrorStream();
    }

    public static void disableErrorStream() {
        osm.disableErrorStream();
    }

    public static Image getImage(String string) {
        Image image = (Image)IMAGES.get(string);
        if (image == null) {
            image = Toolkit.getDefaultToolkit().getImage(GraphUtilities.class.getResource(string));
            IMAGES.put(string, image);
        }
        return image;
    }

    public static Font createFont(String string, int n2, float f2) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.SIZE, new Float((double)(f2 * (float)Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0));
        hashMap.put(TextAttribute.FAMILY, string);
        if ((n2 & 1) != 0) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((n2 & 2) != 0) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return new Font(hashMap);
    }

    public static int pixelsToOffset(FontMetrics fontMetrics, String string, int n2) {
        int n3;
        int n4 = string.length();
        for (n3 = 0; n3 < n4 && (n2 < fontMetrics.stringWidth(string.substring(0, n3)) || n2 > fontMetrics.stringWidth(string.substring(0, n3 + 1))); ++n3) {
        }
        return n3;
    }

    public static VariableNode buildVariableNode(Tree tree) {
        VariableNode variableNode = new VariableNode(tree.getRoot().getVarName(), tree.getClassName(), "", null);
        TreeNode[] treeNodeArray = tree.getRoot().getChildren();
        if (treeNodeArray.length > 0) {
            for (int i2 = 0; i2 < treeNodeArray.length; ++i2) {
                GraphUtilities.buildVariableNode(treeNodeArray[i2], tree.getClassName(), variableNode, tree.isHex());
            }
        } else {
            GraphUtilities.buildVariableNode(tree.getRoot(), tree.getClassName(), variableNode, tree.isHex());
        }
        variableNode.setHasChildren(tree.getRoot().hasChildren());
        return variableNode;
    }

    public static VariableNode buildVariableNode(TreeNode treeNode, String string, VariableNode variableNode, boolean bl) {
        VariableNode variableNode2;
        if (bl) {
            variableNode2 = new VariableNode(treeNode.getVarName(), string, treeNode.getVarValue(), treeNode.getVarOffset(), treeNode.getVarLength(), variableNode);
        } else {
            variableNode2 = new VariableNode(treeNode.getVarName(), string, "", treeNode.getVarOffset(), treeNode.getVarLength(), variableNode);
            variableNode2.setTextValue(treeNode.getVarValue());
        }
        variableNode2.setHasChildren(treeNode.hasChildren());
        TreeNode[] treeNodeArray = treeNode.getChildren();
        for (int i2 = 0; i2 < treeNodeArray.length; ++i2) {
            GraphUtilities.buildVariableNode(treeNodeArray[i2], string, variableNode2, bl);
        }
        return variableNode2;
    }

    public static String nodeToVarname(VariableNode variableNode) {
        String string = variableNode.getName();
        int n2 = string.indexOf(40);
        String string2 = null;
        if (n2 >= 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2).trim();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if ((variableNode = (VariableNode)variableNode.getParent()) != null) {
            while (variableNode.getParent() != null) {
                string = variableNode.getName();
                n2 = string.indexOf(40);
                if (n2 >= 0) {
                    string = string.substring(0, n2).trim();
                }
                stringBuffer.append(" of " + string);
                variableNode = (VariableNode)variableNode.getParent();
            }
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().trim();
    }

    public static void expandNode(JTree jTree, VariableNode variableNode) {
        jTree.expandPath(new TreePath(variableNode.getPath()));
        int n2 = variableNode.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            GraphUtilities.expandNode(jTree, (VariableNode)variableNode.getChildAt(i2));
        }
    }

    public static void collapseNode(JTree jTree, VariableNode variableNode) {
        int n2 = variableNode.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            GraphUtilities.collapseNode(jTree, (VariableNode)variableNode.getChildAt(i2));
        }
        if (variableNode.getParent() != null) {
            jTree.collapsePath(new TreePath(variableNode.getPath()));
        }
    }

    public static DefaultCellEditor getValueEditor(JComponent jComponent) {
        return new ValueEditor(jComponent);
    }

    public static void setFirstFocusedComponent(final JComponent jComponent) {
        jComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                jComponent.requestFocusInWindow();
                jComponent.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private static class OutputStreamManager {
        final PrintStream dummyOutputStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
            }
        });
        PrintStream out = System.out;
        PrintStream err = System.err;
        int outputStreamDisableCount;
        int errorStreamDisableCount;

        private OutputStreamManager() {
        }

        synchronized void enableOutputStream() {
            if (this.outputStreamDisableCount > 0) {
                --this.outputStreamDisableCount;
                if (this.outputStreamDisableCount == 0) {
                    System.setOut(this.out);
                }
            }
        }

        synchronized void enableErrorStream() {
            if (this.errorStreamDisableCount > 0) {
                --this.errorStreamDisableCount;
                if (this.errorStreamDisableCount == 0) {
                    System.setErr(this.err);
                }
            }
        }

        synchronized void disableOutputStream() {
            if (this.outputStreamDisableCount == 0) {
                System.setOut(this.dummyOutputStream);
            }
            ++this.outputStreamDisableCount;
        }

        synchronized void disableErrorStream() {
            if (this.errorStreamDisableCount == 0) {
                System.setErr(this.dummyOutputStream);
            }
            ++this.errorStreamDisableCount;
        }

        synchronized void setOut(PrintStream printStream) {
            this.out = printStream;
            if (this.outputStreamDisableCount == 0) {
                System.setOut(this.out);
            }
        }

        synchronized void setErr(PrintStream printStream) {
            this.err = printStream;
            if (this.errorStreamDisableCount == 0) {
                System.setErr(this.err);
            }
        }
    }

    public static class TextFieldDefaultPopup
    extends PopupMouseListener {
        protected JTextComponent textComponent;
        protected JPopupMenu popup;
        protected JMenuItem cutItem;
        protected JMenuItem copyItem;
        protected JMenuItem pasteItem;
        protected JMenuItem selectAllItem;

        public TextFieldDefaultPopup(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
            this.popup = new JPopupMenu();
            this.fillPopup();
        }

        protected void fillPopup() {
            if (this.textComponent.isEditable()) {
                this.cutItem = new JMenuItem("Cut");
                this.cutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        textComponent.cut();
                    }
                });
                this.popup.add(this.cutItem);
            }
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    textComponent.copy();
                }
            });
            this.popup.add(this.copyItem);
            if (this.textComponent.isEditable()) {
                this.pasteItem = new JMenuItem("Paste");
                this.pasteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        textComponent.paste();
                    }
                });
                this.popup.add(this.pasteItem);
            }
            this.selectAllItem = new JMenuItem("Select All");
            this.selectAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    textComponent.requestFocus();
                    textComponent.selectAll();
                }
            });
            this.popup.add(this.selectAllItem);
        }

        @Override
        public void showPopup(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = this.textComponent.getSelectedText() != null && this.textComponent.getSelectedText().length() > 0;
            if (this.cutItem != null) {
                this.cutItem.setEnabled(this.textComponent.isEditable() && bl);
            }
            if (this.copyItem != null) {
                this.copyItem.setEnabled(bl);
            }
            if (this.pasteItem != null) {
                this.pasteItem.setEnabled(this.textComponent.isEditable());
            }
            this.popup.show(this.textComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static abstract class PopupMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Component && ((Component)mouseEvent.getSource()).isEnabled() && mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }

    private static class ValueEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private JTextField tf;
        private JComponent parent;

        private ValueEditor(JComponent jComponent) {
            super(new JTextField());
            this.parent = jComponent;
            this.tf = (JTextField)this.editorComponent;
            this.tf.setEditable(false);
            this.tf.setBackground(this.parent.getBackground());
            this.tf.setForeground(this.parent.getForeground());
            this.tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Caret caret = tf.getCaret();
                    if (caret != null) {
                        caret.setVisible(true);
                        caret.setSelectionVisible(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        this.stopCellEditing();
                    }
                }
            });
            this.tf.addMouseListener(new TextFieldDefaultPopup(this.tf));
            this.parent.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("background".equals(propertyChangeEvent.getPropertyName())) {
                        tf.setBackground(parent.getBackground());
                    } else if ("foreground".equals(propertyChangeEvent.getPropertyName())) {
                        tf.setForeground(parent.getForeground());
                    }
                }
            });
        }
    }
}

