/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Level88
implements Handle,
Serializable {
    private static final long serialVersionUID = 1000006L;
    private String name;
    private ICobolVar parent;
    private Vector trueIntervals = new Vector();
    private ICobolVar falseValue;

    public Level88(String string, CobolVar cobolVar) {
        this(string, (ICobolVar)cobolVar);
    }

    public Level88(String string, ICobolVar iCobolVar) {
        this.name = string;
        this.parent = iCobolVar;
    }

    private Level88(String string, ICobolVar iCobolVar, Vector vector, ICobolVar iCobolVar2) {
        this(string, iCobolVar);
        this.trueIntervals = vector;
        this.falseValue = iCobolVar2;
    }

    public ICobolVar getParent() {
        return this.parent;
    }

    private int CompareTo(ICobolVar iCobolVar) {
        if (this.parent instanceof INumericVar && iCobolVar instanceof INumericVar) {
            return ((INumericVar)this.parent).num().compareTo(((INumericVar)iCobolVar).num());
        }
        return this.parent.compare(iCobolVar);
    }

    private void moveFrom(ICobolVar iCobolVar) {
        this.parent.setValue(iCobolVar);
    }

    public boolean getValue() {
        try {
            return this.intGetValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean intGetValue() throws Exception {
        Enumeration enumeration = this.trueIntervals.elements();
        while (enumeration.hasMoreElements()) {
            Interval interval = (Interval)enumeration.nextElement();
            if (!(interval.to == null ? this.CompareTo(interval.from) == 0 : this.CompareTo(interval.from) >= 0 && this.CompareTo(interval.to) <= 0)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getDimCount() {
        int[] nArray = DebugUtilities.getDimensions(this.parent);
        return nArray != null ? nArray.length : 0;
    }

    public Level88 intAt(int[] nArray) {
        return new Level88(this.name, this.parent.intIAt(nArray), this.trueIntervals, this.falseValue);
    }

    public void setValue(boolean bl) {
        if (bl) {
            this.moveFrom(((Interval)this.trueIntervals.elementAt((int)0)).from);
        } else if (this.falseValue != null) {
            this.moveFrom(this.falseValue);
        }
    }

    public Level88 addInterval(CobolVar cobolVar, CobolVar cobolVar2) {
        return this.addInterval((ICobolVar)cobolVar, (ICobolVar)cobolVar2);
    }

    public Level88 addInterval(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.trueIntervals.addElement(new Interval(iCobolVar, iCobolVar2));
        return this;
    }

    public Level88 setFalseValue(CobolVar cobolVar) {
        return this.setFalseValue((ICobolVar)cobolVar);
    }

    public Level88 setFalseValue(ICobolVar iCobolVar) {
        this.falseValue = iCobolVar;
        return this;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n2) {
        boolean bl = false;
        String string = DebuggerConstants.NULL_VALUE;
        try {
            bl = this.intGetValue();
            string = DebugUtilities.toString(this.parent, n2);
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            if (iscobolRuntimeException.getErrNum() == 31) {
                string = DebuggerConstants.NON_NUMERIC_VALUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + bl + " [" + string + "]";
    }

    @Override
    public int type() {
        return 8;
    }

    private static class Interval {
        ICobolVar from;
        ICobolVar to;

        Interval(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
            this.from = iCobolVar;
            this.to = iCobolVar2;
        }
    }
}

