/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.ListingException;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IFilename;
import com.iscobol.interfaces.debugger.IListing;
import com.iscobol.types.CobolVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class Listing
implements IListing {
    private Vector fileList = new Vector();
    private String longestLine = "";
    private boolean freeFormat;
    private LineObj[] allLines;
    Vector fileNotFoundList = new Vector();
    private Hashtable includeCopyBooks = new Hashtable();
    private IFileLoader fileLoader;
    private String encoding;
    private PreProcessorReaderProvider isrProvider;

    public Listing(IFileLoader iFileLoader, DebugCopyFile[] debugCopyFileArray, Filename filename, final String string, Set<String> set) throws ListingException {
        this.fileLoader = iFileLoader;
        this.setEncoding(string);
        this.isrProvider = new PreProcessorReaderProvider(){

            @Override
            public Reader getReader(String string2) {
                try {
                    try {
                        return new InputStreamReader((InputStream)new FileInputStream(string2), string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return new FileReader(string2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }

            @Override
            public Hashtable getIncludeCopyBooks() {
                return null;
            }
        };
        this.listingCopyReplacing(debugCopyFileArray, filename, set);
    }

    public Listing(byte[] byArray, int n2, DebugCopyFile[] debugCopyFileArray, Filename filename, String string, Set<String> set) throws IOException {
        ListingInfo listingInfo = new ListingInfo(byArray, n2);
        this.fileLoader = listingInfo.getFileLoader();
        this.setEncoding(string);
        this.isrProvider = listingInfo.getReaderProvider();
        this.listingCopyReplacing(debugCopyFileArray, filename, set);
    }

    private void setEncoding(String string) {
        this.encoding = string;
        if (this.encoding == null) {
            this.encoding = CobolVar.encoding;
        }
    }

    private void checkFilesNotFound(DebugCopyFile[] debugCopyFileArray) {
        for (int i2 = 0; i2 < debugCopyFileArray.length; ++i2) {
            Filename filename = new Filename(debugCopyFileArray[i2].getCopyFileName());
            String string = this.fileLoader.getAbsolutePath(filename.getOrigName());
            if (string != null) continue;
            this.fileNotFoundList.addElement(filename.getBaseName());
        }
    }

    void listingCopyReplacing(DebugCopyFile[] debugCopyFileArray, Filename filename, Set<String> set) {
        byte by;
        Object object;
        Object object2;
        if (debugCopyFileArray == null) {
            debugCopyFileArray = new DebugCopyFile[]{};
        }
        String string = this.fileLoader.getAbsolutePath(filename.getOrigName());
        final Hashtable<String, File> hashtable = new Hashtable<String, File>();
        for (int i2 = 0; i2 < debugCopyFileArray.length; ++i2) {
            object2 = debugCopyFileArray[i2].getCopyFileName();
            File file = new File((String)object2);
            object = new CopyBookDesc(file.getName(), new File(debugCopyFileArray[i2].getParentFileName()).getName(), debugCopyFileArray[i2].getCopyStatementLineNumber(), i2 + 1);
            this.includeCopyBooks.put(object, object);
            hashtable.put(((String)object2).toLowerCase(), file);
            hashtable.put(file.getName().toLowerCase(), file);
        }
        if (string == null) {
            this.allLines = new LineObj[0];
            String string2 = filename.getBaseName();
            this.fileNotFoundList.addElement(string2);
            this.checkFilesNotFound(debugCopyFileArray);
            return;
        }
        this.checkFilesNotFound(debugCopyFileArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-lf");
        arrayList.addAll(set);
        arrayList.add(filename.getOrigName());
        object2 = new OptionList(arrayList.toArray(new String[arrayList.size()]));
        int n2 = 0;
        if (set.contains("-st")) {
            n2 = 2;
        } else if (set.contains("-sa")) {
            n2 = 1;
        } else if (set.contains("-sf")) {
            n2 = 3;
        } else if (set.contains("-sv")) {
            n2 = 4;
        } else if (set.contains("-sl")) {
            n2 = 5;
        }
        object = new FileFinder(){

            @Override
            public File findFile(String string) {
                String string2;
                File file = (File)hashtable.get(string.toLowerCase());
                if (file != null) {
                    if (file.exists()) {
                        return file;
                    }
                    string = file.getPath();
                }
                if ((string2 = Listing.this.fileLoader.getAbsolutePath(string)) == null) {
                    return null;
                }
                return new File(string2);
            }
        };
        GraphUtilities.disableErrorStream();
        PreProcessor preProcessor = null;
        StringWriter stringWriter = null;
        for (by = 2; by >= 1; by = (byte)((byte)(by - 1))) {
            try {
                preProcessor = new PreProcessor(filename.getOrigName(), null, (OptionList)object2, new Errors(), (FileFinder)object, this.isrProvider);
                preProcessor.setFormat(n2);
                stringWriter = new StringWriter();
                preProcessor.start(null, stringWriter, by, this.includeCopyBooks, false);
                while (preProcessor.getLine(null) >= 0) {
                }
                break;
            }
            catch (Exception exception) {
                if (by != 2) continue;
                preProcessor.closeSource();
                continue;
            }
        }
        if (by == 1) {
            this.freeFormat = true;
        }
        GraphUtilities.enableErrorStream();
        ArrayList<LineObj> arrayList2 = new ArrayList<LineObj>();
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(stringWriter.toString()));
        try {
            this.loadLines(preProcessor, lineNumberReader, arrayList2, (byte)0);
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setLinesFields(arrayList2);
        preProcessor.closeSource();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setLinesFields(ArrayList<LineObj> arrayList) {
        this.allLines = new LineObj[arrayList.size()];
        if (this.allLines.length > 0) {
            this.allLines[0] = arrayList.get(0);
            int n2 = this.allLines[0].text.length();
            int n3 = 0;
            for (int i2 = 1; i2 < this.allLines.length; ++i2) {
                this.allLines[i2] = arrayList.get(i2);
                if (this.allLines[i2].text.length() <= n2) continue;
                n2 = this.allLines[i2].text.length();
                n3 = i2;
            }
            this.longestLine = this.allLines[n3].text;
        }
    }

    private void loadLines(PreProcessor preProcessor, LineNumberReader lineNumberReader, ArrayList arrayList, byte by) throws IOException {
        int n2;
        PreProcessor preProcessor2;
        Object object;
        int n3 = 0;
        if (by > 0) {
            object = new CopyBookDesc(new File(preProcessor.getOrigFilename()).getName(), new File(preProcessor.getParent().getOrigFilename()).getName(), preProcessor.getCopyLineNumber());
            CopyBookDesc copyBookDesc = (CopyBookDesc)this.includeCopyBooks.get(object);
            n3 = copyBookDesc != null ? (int)((short)copyBookDesc.getIndex()) : -1;
        }
        if (!arrayList.isEmpty()) {
            ((LineObj)arrayList.get((int)(arrayList.size() - 1))).copyFileIndex = n3;
        }
        object = preProcessor.getChildren();
        int n4 = 0;
        int n5 = preProcessor.getLineCount();
        if (n4 < ((Vector)object).size()) {
            preProcessor2 = (PreProcessor)((Vector)object).elementAt(n4++);
            n2 = preProcessor2.getCopyLineNumber();
        } else {
            preProcessor2 = null;
            n2 = n5;
        }
        this.fileList.addElement(new Filename(preProcessor.getOrigFilename()));
        int n6 = 1;
        while (true) {
            if (n6 <= n2) {
                String string = lineNumberReader.readLine();
                if (string == null) break;
                LineObj lineObj = new LineObj(string);
                lineObj.lineNumber = n6++;
                lineObj.filename = new Filename(preProcessor.getFileName().replace('\\', '/'));
                lineObj.fileIndex = (short)n3;
                lineObj.copyDeep = by;
                arrayList.add(lineObj);
                continue;
            }
            if (preProcessor2 == null) break;
            this.loadLines(preProcessor2, lineNumberReader, arrayList, (byte)(by + 1));
            if (n4 < ((Vector)object).size()) {
                preProcessor2 = (PreProcessor)((Vector)object).elementAt(n4++);
                n2 = preProcessor2.getCopyLineNumber();
                continue;
            }
            preProcessor2 = null;
            n2 = n5;
        }
    }

    @Override
    public String[] getLines() {
        if (this.allLines == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.allLines.length];
        for (int i2 = 0; i2 < this.allLines.length; ++i2) {
            stringArray[i2] = this.allLines[i2].text;
        }
        return stringArray;
    }

    @Override
    public int toListingLine(int n2, IFilename iFilename, int n3) {
        if (iFilename != null && !(iFilename instanceof Filename)) {
            throw new IllegalArgumentException(iFilename.toString());
        }
        return this.toListingLine(n2, (Filename)iFilename, n3);
    }

    public int toListingLine(int n2, Filename filename, int n3) {
        if (this.allLines != null) {
            for (int i2 = 0; i2 < this.allLines.length; ++i2) {
                if (!this.allLines[i2].filename.equals(filename) || this.allLines[i2].lineNumber != n2 || n3 >= 0 && this.allLines[i2].fileIndex >= 0 && n3 != this.allLines[i2].fileIndex) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int toListingLine(int n2, int n3) {
        if (this.allLines != null) {
            for (int i2 = 0; i2 < this.allLines.length; ++i2) {
                if (this.allLines[i2].lineNumber != n2 || n3 != this.allLines[i2].fileIndex) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public CobolRef toCobolLine(int n2) {
        if (n2 < 0 || n2 >= this.allLines.length || this.allLines[n2] == null || this.allLines[n2].filename == null) {
            return null;
        }
        CobolRef cobolRef = new CobolRef(this.allLines[n2].lineNumber, this.allLines[n2].filename.getOrigName(), this.allLines[n2].fileIndex, this.allLines[n2].copyFileIndex, null);
        cobolRef.setCopyDeep(this.allLines[n2].copyDeep);
        return cobolRef;
    }

    @Override
    public boolean isCopyStatement(int n2) {
        if (n2 < 0 || n2 >= this.allLines.length || this.allLines[n2] == null || this.allLines[n2].filename == null) {
            return false;
        }
        return this.allLines[n2].copyFileIndex > 0;
    }

    @Override
    public int getLength() {
        if (this.allLines == null) {
            return 0;
        }
        return this.allLines.length;
    }

    @Override
    public String getLongestLine() {
        return this.longestLine;
    }

    @Override
    public Vector getFiles() {
        return this.fileList;
    }

    public boolean isFreeFormat() {
        return this.freeFormat;
    }

    private static class LineObj {
        String text;
        int lineNumber;
        Filename filename;
        short fileIndex;
        byte copyDeep;
        short copyFileIndex;

        LineObj(String string) {
            this.text = string;
        }

        public String toString() {
            return "line=" + this.lineNumber + ", file=" + this.filename + ", index=" + this.fileIndex;
        }
    }
}

