/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IListingInfoExtension;
import com.iscobol.interfaces.debugger.InputStreamProvider;
import com.iscobol.rts.Config;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ListingInfo
implements IListingInfoExtension {
    private static byte[] unscramble = new byte[]{9, 36, 92, 106, 73, -76, -20, -53, 37, -92, -39, 66, -62, 47, 23, -64, 20, -73, 55, 26, -85, 120, -94, -33, 114, -19, 93, 24, -9, -27, -67, -120, 116, -55, -112, 53, 107, 28, 82, 97, 17, 89, 81, -26, 4, -25, 6, 15, -44, 127, 25, 3, 105, -29, 95, 52, 31, -125, -93, 48, 57, 103, 2, 90, 16, -116, 41, -87, -127, 65, 111, 87, 74, 122, -32, 0, -110, -54, -31, -49, 83, 5, 46, -100, 27, -10, 63, 50, -41, 112, 44, 21, -38, 59, 42, 61, 64, -42, -47, -1, -36, 72, 125, -4, -21, 40, 14, -37, -114, -59, -95, 84, 86, 119, 8, -78, -51, 126, 113, -43, -7, 109, -80, 100, -126, 79, -99, -11, -70, -8, 70, 78, 108, 7, -22, -63, -104, 30, -61, 11, 69, 110, -124, 77, -79, -123, -108, 102, 43, 104, -40, -3, -68, 80, -82, -57, -90, 29, 115, 45, 101, -46, -60, -2, 49, -128, -75, 62, 1, -72, 18, 39, -66, 98, -71, 13, 54, 118, -105, -15, 67, -77, 85, -91, -84, -48, -45, -111, -17, 58, -106, -97, -50, -30, -115, -16, 33, 51, 38, 76, 10, -88, -119, 99, -23, 117, 123, -117, -101, -107, -102, -89, -69, 19, 96, 121, -122, -18, -28, -74, -96, 88, -118, -6, -52, 34, 60, -12, 68, -35, 75, -98, 71, 32, -81, -113, -34, -56, 22, 56, 12, -86, 91, -121, -14, -65, -58, -83, 94, -5, -13, 35, 124, -24, -103, -109};
    private final IFileLoader fileLoader;
    private final PreProcessorReaderProvider readerProvider;
    private final InputStreamProvider inputStreamProvider;
    private String charset;
    private final HashMap<File, List<byte[]>> fileMap = new HashMap();

    public ListingInfo(byte[] byArray, int n2) throws IOException {
        this(byArray, null, n2);
    }

    public ListingInfo(byte[] byArray, DebugCopyFile[] debugCopyFileArray, int n2) throws IOException {
        IFileLoader iFileLoader = null;
        PreProcessorReaderProvider preProcessorReaderProvider = null;
        InputStreamProvider inputStreamProvider = null;
        DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        while (true) {
            try {
                Hashtable<CopyBookDesc, CopyBookDesc> hashtable;
                Object object;
                int n3;
                this.charset = dataInputStream.readUTF();
                if (n2 < 4) {
                    int n4 = dataInputStream.readInt();
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.readFile(dataInputStream, dataInputStream.readUTF());
                    }
                    n3 = dataInputStream.readInt();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        object = dataInputStream.readUTF();
                        int n5 = ((String)object).indexOf(61);
                        if (n5 < 0) continue;
                        Config.b(((String)object).substring(0, n5), ((String)object).substring(n5 + 1));
                    }
                } else {
                    String string = dataInputStream.readUTF();
                    while (string.length() > 0) {
                        this.readFile(dataInputStream, string);
                        string = dataInputStream.readUTF();
                    }
                }
                if (debugCopyFileArray != null) {
                    hashtable = new Hashtable<CopyBookDesc, CopyBookDesc>();
                    for (n3 = 0; n3 < debugCopyFileArray.length; ++n3) {
                        String string = debugCopyFileArray[n3].getCopyFileName();
                        object = new File(string);
                        CopyBookDesc copyBookDesc = new CopyBookDesc(((File)object).getName(), new File(debugCopyFileArray[n3].getParentFileName()).getName(), debugCopyFileArray[n3].getCopyStatementLineNumber(), n3 + 1);
                        hashtable.put(copyBookDesc, copyBookDesc);
                    }
                } else {
                    hashtable = null;
                }
                iFileLoader = new IFileLoader(){

                    private Integer[] getIndexes(File file, File[] fileArray) {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (int i2 = 0; i2 < fileArray.length; ++i2) {
                            if (!file.getName().equalsIgnoreCase(fileArray[i2].getName())) continue;
                            arrayList.add(i2);
                        }
                        return arrayList.toArray(new Integer[arrayList.size()]);
                    }

                    @Override
                    public String getAbsolutePath(String string) {
                        File[] fileArray;
                        File[] fileArray2 = fileArray = ListingInfo.this.fileMap.keySet().toArray(new File[ListingInfo.this.fileMap.size()]);
                        File file = new File(string);
                        Integer[] integerArray;
                        while ((integerArray = this.getIndexes(file, fileArray2)).length != 0) {
                            if (integerArray.length == 1) {
                                return fileArray[integerArray[0]].getPath();
                            }
                            if ((file = file.getParentFile()) == null) {
                                file = new File(".");
                            }
                            File[] fileArray3 = new File[integerArray.length];
                            File[] fileArray4 = new File[integerArray.length];
                            for (int i2 = 0; i2 < integerArray.length; ++i2) {
                                fileArray3[i2] = fileArray2[integerArray[i2]].getParentFile();
                                if (fileArray3[i2] == null) {
                                    fileArray3[i2] = new File(".");
                                }
                                fileArray4[i2] = fileArray[integerArray[i2]];
                            }
                            fileArray2 = fileArray3;
                            fileArray = fileArray4;
                        }
                        return null;
                    }
                };
                final InputStreamProvider inputStreamProvider2 = inputStreamProvider = new InputStreamProvider(){

                    @Override
                    public InputStream getInputStream(String string) {
                        File file = new File(string);
                        List list = (List)ListingInfo.this.fileMap.get(file);
                        if (list != null) {
                            byte[] byArray = list.size() > 1 ? (byte[])list.remove(0) : (byte[])list.get(0);
                            return new ByteArrayInputStream(byArray);
                        }
                        return null;
                    }
                };
                preProcessorReaderProvider = new PreProcessorReaderProvider(){

                    @Override
                    public Reader getReader(String string) {
                        InputStream inputStream = inputStreamProvider2.getInputStream(string);
                        if (inputStream != null) {
                            try {
                                return new InputStreamReader(inputStream, ListingInfo.this.charset);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                return new InputStreamReader(inputStream);
                            }
                        }
                        return null;
                    }

                    @Override
                    public Hashtable getIncludeCopyBooks() {
                        return hashtable;
                    }
                };
            }
            catch (ZipException zipException) {
                dataInputStream.close();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                continue;
            }
            break;
        }
        this.fileLoader = iFileLoader;
        this.readerProvider = preProcessorReaderProvider;
        this.inputStreamProvider = inputStreamProvider;
    }

    private void readFile(DataInputStream dataInputStream, String string) throws IOException {
        File file = new File(string);
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = unscramble[byArray[i2] & 0xFF];
        }
        List<byte[]> list = this.fileMap.get(file);
        if (list == null) {
            list = new ArrayList<byte[]>();
            this.fileMap.put(file, list);
        }
        list.add(byArray);
    }

    @Override
    public IFileLoader getFileLoader() {
        return this.fileLoader;
    }

    public PreProcessorReaderProvider getReaderProvider() {
        return this.readerProvider;
    }

    @Override
    public InputStreamProvider getInputStreamProvider() {
        return this.inputStreamProvider;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

