/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.OptionListForCodeAnalyzer;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.debugger.TextFile;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalDebugInfo
extends DebugResponse.DebugInfo {
    private static final long serialVersionUID = 1L;
    private static final int NOT_LOADED = 0;
    private static final int LOADING = 1;
    private static final int LOADED = 2;
    private static final int ERROR = 3;
    private int metadataLoadState = 0;
    private Map metadata = new HashMap();
    private int format;
    private static final Set COMPILER_OPTIONS;
    private DebuggerInvoker invoker;
    private boolean usedAll;

    public LocalDebugInfo(DebuggerInvoker debuggerInvoker, DebugResponse.DebugInfo debugInfo) {
        super(debugInfo.getClassName(), debugInfo.getFilenames(), debugInfo.getLines(), debugInfo.getParagraphs(), debugInfo.getCopyfiles(), debugInfo.getSourcefile(), debugInfo.getCopyPath(), debugInfo.getTimestamp(), debugInfo.isJumpCommandSupported(), debugInfo.getCompilerOptions(), debugInfo.fileSeparators, debugInfo.getCompilerProps(), debugInfo.getListingInfos(), debugInfo.getInfoFormat());
        this.invoker = debuggerInvoker;
    }

    public LocalDebugInfo(String string) {
        super(string);
    }

    public void loadMetadata(boolean bl) {
        if (bl) {
            new Thread(){

                @Override
                public void run() {
                    Config.c();
                    LocalDebugInfo.this.loadMetadata();
                }
            }.start();
        } else {
            this.loadMetadata();
        }
    }

    public synchronized boolean isReady() {
        return this.metadataLoadState != 1;
    }

    public synchronized void waitUntilIsReady() {
        if (this.metadataLoadState == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void setMetadataLoadState(int n2) {
        this.metadataLoadState = n2;
    }

    public String normalizeVarName(String string, int n2, TextFile textFile) {
        String string2;
        Location location;
        int n3 = string.indexOf(40);
        String string3 = "";
        if (n3 >= 0) {
            string3 = " " + string.substring(n3);
            string = string.substring(0, n3).trim();
        }
        if ((location = this.getMemberLocation(string, n2, textFile)) != null) {
            if (location.element instanceof VariableDeclaration) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)location.element;
                if (this.usedAll || variableDeclaration.getLevel() == 78 || variableDeclaration.isUsed()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(variableDeclaration.getName());
                    if (!location.capacityVar && location.hasDuplicates) {
                        for (variableDeclaration = variableDeclaration.getParent(); variableDeclaration != null; variableDeclaration = variableDeclaration.getParent()) {
                            if (!this.usedAll && !variableDeclaration.isUsed()) continue;
                            stringBuilder.append(" OF ");
                            stringBuilder.append(variableDeclaration.getName());
                        }
                    }
                    stringBuilder.append(string3);
                    string2 = stringBuilder.toString();
                } else {
                    string2 = null;
                }
            } else {
                string2 = location.element instanceof FileDescriptor ? ((FileDescriptor)location.element).getNameToken().getOriginalWord() : null;
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    public Location getMemberLocation(String string, int n2, TextFile textFile) {
        String string2;
        int n3;
        int n4 = (string = string.toUpperCase().replace(this.getHyphenReplacingChar(), '-')).indexOf(40);
        if (n4 >= 0) {
            string = string.substring(0, n4).trim();
        }
        if ((n3 = (string2 = string).lastIndexOf(46)) >= 0 && n3 < string2.length() - 1) {
            string2 = string2.substring(n3 + 1).trim();
        } else {
            n4 = string2.indexOf(32);
            if (n4 >= 0) {
                string2 = string2.substring(0, n4).trim();
            }
        }
        Object v2 = this.metadata.get(string2);
        if (v2 instanceof List) {
            Token token;
            CobolToken cobolToken;
            String[] stringArray = string.split("(\\s+(OF|IN)\\s+)|(\\.)");
            if (n3 >= 0) {
                int n5 = 0;
                for (int i2 = stringArray.length - 1; n5 < i2; ++n5, --i2) {
                    Iterator iterator = stringArray[n5];
                    stringArray[n5] = stringArray[i2];
                    stringArray[i2] = iterator;
                }
            }
            List list = (List)v2;
            ArrayList<Location> arrayList = new ArrayList<Location>();
            for (Location location : list) {
                Token token2;
                cobolToken = location.element instanceof VariableDeclaration ? ((VariableDeclaration)location.element).getPcc() : (location.element instanceof FileDescriptor ? ((FileDescriptor)location.element).getPcc() : ((Paragraph)location.element).getPcc());
                if (cobolToken instanceof CobolClass) {
                    token = ((CobolClass)cobolToken).getFirstToken();
                    token2 = ((CobolClass)cobolToken).getLastToken();
                } else if (cobolToken instanceof CobolMethod) {
                    token = ((CobolMethod)cobolToken).getFirstToken();
                    token2 = ((CobolMethod)cobolToken).getLastToken();
                } else {
                    token = null;
                    token2 = null;
                }
                if (token != null && token2 != null) {
                    int n6 = textFile.toListingLine(token.getFLN(), token.getFileIndex());
                    int n7 = textFile.toListingLine(token2.getFLN(), token2.getFileIndex());
                    if (n2 >= 0 && (n2 < n6 || n2 > n7)) continue;
                }
                if (location.element instanceof VariableDeclaration) {
                    int n8;
                    VariableDeclaration variableDeclaration;
                    VariableDeclaration variableDeclaration2 = variableDeclaration = (VariableDeclaration)location.element;
                    for (n8 = 1; n8 < stringArray.length; ++n8) {
                        boolean bl = false;
                        for (VariableDeclaration variableDeclaration3 = variableDeclaration2.getParent(); variableDeclaration3 != null; variableDeclaration3 = variableDeclaration3.getParent()) {
                            if (!variableDeclaration3.getName().equals(stringArray[n8])) continue;
                            variableDeclaration2 = variableDeclaration3;
                            bl = true;
                            break;
                        }
                        if (!bl) break;
                    }
                    if (n8 != stringArray.length) continue;
                    arrayList.add(location);
                    continue;
                }
                if (location.element instanceof Paragraph) {
                    Paragraph paragraph = (Paragraph)location.element;
                    if (stringArray.length <= 1 || paragraph.getSection() == null || !paragraph.getSection().getName().equals(stringArray[1])) continue;
                    arrayList.add(location);
                    break;
                }
                arrayList.add(location);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() == 1) {
                return new Location((Location)arrayList.get(0));
            }
            for (Location location : arrayList) {
                if (!(location.element instanceof VariableDeclaration) || n2 != textFile.toListingLine((token = ((VariableDeclaration)(cobolToken = (VariableDeclaration)location.element)).getNameToken()).getFLN(), token.getFileIndex())) continue;
                return new Location(location);
            }
            return new Location((Location)arrayList.get(0));
        }
        return (Location)v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        if (this.getErrorString() != null) {
            this.setMetadataLoadState(3);
        } else {
            boolean bl;
            this.setMetadataLoadState(1);
            try {
                bl = this.analyzeSource();
            }
            catch (Throwable throwable) {
                if (this.invoker instanceof GraphDebugger.MyDebuggerInvoker) {
                    GraphDebugger graphDebugger = ((GraphDebugger.MyDebuggerInvoker)this.invoker).gd;
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.close();
                    graphDebugger.outputResult(stringWriter.toString());
                } else {
                    throwable.printStackTrace();
                }
                bl = false;
            }
            if (bl) {
                this.setMetadataLoadState(2);
            } else {
                this.setMetadataLoadState(3);
            }
        }
        LocalDebugInfo localDebugInfo = this;
        synchronized (localDebugInfo) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean analyzeSource() {
        String[] stringArray;
        FileFinder fileFinder;
        PreProcessorReaderProvider preProcessorReaderProvider;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getCompilerOptions();
        DebugUtilities.setCompilerConsts(this.getCompilerProps(), false);
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.invoker.getFileLoader().getAbsolutePath(this.getSourcefile());
        if (string == null) {
            return false;
        }
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 == null) {
            string2 = ".";
        }
        if (!hashSet.contains(string2)) {
            hashSet.add(string2);
        }
        arrayList.add(file.getName());
        String string3 = null;
        DebugCopyFile[] debugCopyFileArray = this.getCopyfiles();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string4 = stringArray2[i2];
            int n2 = string4.indexOf(61);
            if (n2 >= 0 && "-ce=".equals(string4 = string4.substring(0, n2 + 1))) {
                string3 = TextFile.canonicalizePathList(stringArray2[i2].substring(n2 + 1), this.getPathSeparator());
                stringArray2[i2] = string4 + string3;
            }
            if (COMPILER_OPTIONS.contains(string4)) {
                arrayList.add(stringArray2[i2]);
                continue;
            }
            if (!"-dx".equals(string4)) continue;
            this.usedAll = true;
        }
        ListingInfo listingInfo = null;
        if (this.getListingInfos() != null) {
            try {
                listingInfo = new ListingInfo(this.getListingInfos(), this.getCopyfiles(), this.getInfoFormat());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (listingInfo != null) {
            final IFileLoader iFileLoader = listingInfo.getFileLoader();
            preProcessorReaderProvider = listingInfo.getReaderProvider();
            fileFinder = new FileFinder(){

                @Override
                public File findFile(String string) {
                    String string2 = iFileLoader.getAbsolutePath(string);
                    return string2 != null ? new File(string2) : null;
                }
            };
        } else {
            void var15_22;
            stringArray = new HashMap();
            if (debugCopyFileArray != null) {
                for (DebugCopyFile debugCopyFile : debugCopyFileArray) {
                    String string4 = debugCopyFile.getCopyFileName();
                    File file2 = new File(string4);
                    stringArray.put(string4.toLowerCase(), file2);
                    stringArray.put(file2.getName().toLowerCase(), file2);
                }
            }
            if (string3 != null) {
                String[] stringArray3 = RtsUtil.getPathList(string3);
            } else {
                Object var15_21 = null;
            }
            FileLoader fileLoader = this.invoker.getFileLoader();
            preProcessorReaderProvider = null;
            fileFinder = new FileFinder((HashMap)stringArray, fileLoader, (String[])var15_22){
                final /* synthetic */ HashMap val$copyFilesTable;
                final /* synthetic */ IFileLoader val$fileLoader;
                final /* synthetic */ String[] val$extList;
                {
                    this.val$copyFilesTable = hashMap;
                    this.val$fileLoader = iFileLoader;
                    this.val$extList = stringArray;
                }

                @Override
                public File findFile(String string) {
                    String string2;
                    File file = (File)this.val$copyFilesTable.get(string.toLowerCase());
                    if (file != null) {
                        if (file.exists()) {
                            return file;
                        }
                        string = file.getPath();
                    }
                    if ((string2 = this.val$fileLoader.getAbsolutePath(string)) == null) {
                        if (this.val$extList != null) {
                            for (String string3 : this.val$extList) {
                                string2 = this.val$fileLoader.getAbsolutePath(string + "." + string3);
                                if (string2 != null) break;
                            }
                        }
                        if (string2 == null) {
                            return null;
                        }
                    }
                    return new File(string2);
                }
            };
        }
        arrayList.add("-jj");
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        OptionListForCodeAnalyzer optionListForCodeAnalyzer = OptionListForCodeAnalyzer.newInstance(stringArray);
        GraphUtilities.disableErrorStream();
        GraphUtilities.disableOutputStream();
        Pcc pcc = null;
        try {
            pcc = Pcc.analyze(string, optionListForCodeAnalyzer, new Errors(), null, fileFinder, preProcessorReaderProvider);
            this.format = ((PreProcessor)pcc.getTokenManager().getAllPreProcessors().get(0)).getFormat();
        }
        catch (Throwable throwable) {
        }
        finally {
            GraphUtilities.enableErrorStream();
            GraphUtilities.enableOutputStream();
        }
        if (pcc != null) {
            Repository repository = pcc.getRepository();
            if (repository != null) {
                this.loadVariablesInfo(repository.getAllClasses());
            }
            if (pcc.getCobolProgram() != null) {
                this.loadPccInfo(pcc.getCobolProgram());
            } else {
                if (pcc.getFactoryPart() != null) {
                    this.loadCobolClassInfo(pcc.getFactoryPart());
                }
                if (pcc.getObjectPart() != null) {
                    this.loadCobolClassInfo(pcc.getObjectPart());
                }
            }
            return true;
        }
        return false;
    }

    private void loadCobolClassInfo(CobolClass cobolClass) {
        CobolMethod[] cobolMethodArray = cobolClass.getAllMethods();
        if (cobolClass.getDataDivision() != null) {
            this.loadDataDivisionInfo(cobolClass.getDataDivision());
        }
        for (int i2 = 0; i2 < cobolMethodArray.length; ++i2) {
            this.loadPccInfo(cobolMethodArray[i2]);
        }
    }

    private void loadPccInfo(Pcc pcc) {
        if (pcc.getDataDivision() != null) {
            this.loadDataDivisionInfo(pcc.getDataDivision());
        }
        if (pcc.getProcedureDivision() != null) {
            this.loadProcedureDivisionInfo(pcc.getProcedureDivision());
        }
    }

    private void loadProcedureDivisionInfo(ProcedureDivision procedureDivision) {
        Paragraph[] paragraphArray = procedureDivision.getParagraphs();
        for (int i2 = 0; i2 < paragraphArray.length; ++i2) {
            Token token = paragraphArray[i2].getNameToken();
            this.putMemberLocation(paragraphArray[i2].getName(), new Location(token.getFLN(), new Filename(token.getFileName()), token.getFileIndex(), paragraphArray[i2], false));
        }
    }

    private void putMemberLocation(String string, Location location) {
        Object v2 = this.metadata.get(string);
        if (v2 != null) {
            if (v2 instanceof Location) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(v2);
                arrayList.add(location);
                this.metadata.put(string, arrayList);
            } else {
                ((List)v2).add(location);
            }
        } else {
            this.metadata.put(string, location);
        }
    }

    private void loadDataDivisionInfo(DataDivision dataDivision) {
        if (dataDivision.getFileSection() != null) {
            FileDescriptorList fileDescriptorList = dataDivision.getFileSection().getFileDescriptorList();
            FileDescriptor fileDescriptor = fileDescriptorList.getFirst();
            while (fileDescriptor != null) {
                Token token = fileDescriptor.getNameToken();
                this.putMemberLocation(token.getWord(), new Location(token.getFLN(), new Filename(token.getFileName()), token.getFileIndex(), fileDescriptor, false));
                this.loadVariablesInfo(fileDescriptor.getRecordDescription());
                fileDescriptor = fileDescriptorList.getNext();
            }
        }
        if (dataDivision.getWorkingStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getWorkingStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getLocalStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getLocalStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getThreadLocalStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getThreadLocalStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getLinkageSection() != null) {
            this.loadVariablesInfo(dataDivision.getLinkageSection().getVariableDeclarationList());
        }
        if (dataDivision.getScreenSection() != null) {
            this.loadVariablesInfo(dataDivision.getScreenSection().getVariableDeclarationList());
        }
    }

    private void loadVariablesInfo(VariableDeclarationList variableDeclarationList) {
        VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            if (!variableDeclaration.isFiller()) {
                Token token = variableDeclaration.getNameToken();
                this.putMemberLocation(variableDeclaration.getName(), new Location(token.getFLN(), new Filename(token.getFileName()), token.getFileIndex(), variableDeclaration, false));
                VariableName variableName = variableDeclaration.getCapacity();
                if (variableName != null) {
                    token = variableName.getNameToken();
                    Location location = new Location(token.getFLN(), new Filename(token.getFileName()), token.getFileIndex(), variableName.getVarDecl(), true);
                    this.putMemberLocation(variableName.getName(), location);
                }
            }
            this.loadVariablesInfo(variableDeclaration.getChildren());
            variableDeclaration = variableDeclarationList.getNext();
        }
    }

    public int getFormat() {
        return this.format;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet = new HashSet();
        hashSet.add("-ca");
        hashSet.add("-cdlz");
        hashSet.add("-ce=");
        hashSet.add("-cghv");
        hashSet.add("-cm");
        hashSet.add("-cms");
        hashSet.add("-cp");
        hashSet.add("-csl");
        hashSet.add("-cv");
        hashSet.add("-d");
        hashSet.add("-ds");
        hashSet.add("-exec=");
        hashSet.add("-flsu");
        hashSet.add("-noexec");
        hashSet.add("-rc=");
        hashSet.add("-rm=");
        hashSet.add("-rw=");
        hashSet.add("-s78c");
        hashSet.add("-sa");
        hashSet.add("-scnl");
        hashSet.add("-scnu");
        hashSet.add("-sf");
        hashSet.add("-sl");
        hashSet.add("-smat");
        hashSet.add("-smfu");
        hashSet.add("-st");
        hashSet.add("-sv");
        hashSet.add("-xms");
        hashSet.add("-xoldsmat");
        COMPILER_OPTIONS = Collections.unmodifiableSet(hashSet);
    }

    public static class Location {
        public final int line;
        public final Filename file;
        public final int fileIndex;
        public final Object element;
        public final boolean capacityVar;
        public final boolean hasDuplicates;

        public Location(int n2, Filename filename, int n3, Object object, boolean bl) {
            this(n2, filename, n3, object, bl, false);
        }

        public Location(Location location) {
            this(location.line, location.file, location.fileIndex, location.element, location.capacityVar, true);
        }

        private Location(int n2, Filename filename, int n3, Object object, boolean bl, boolean bl2) {
            this.line = n2;
            this.file = filename;
            this.fileIndex = n3;
            this.element = object;
            this.capacityVar = bl;
            this.hasDuplicates = bl2;
        }
    }
}

