/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Child;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.ErrorResponse;
import com.iscobol.debugger.RawTextResponse;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;

public class OutputChild
extends Child
implements Runnable {
    private PrintStream out;
    private DataInput in;
    private Vector<DebugResponse> responseQueue = new Vector();
    private boolean alive;
    private String remoteEncoding;

    public OutputChild(InputStream inputStream, PrintStream printStream) {
        this.in = new DataInputStream(inputStream);
        this.out = printStream;
        this.alive = true;
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    private PrintStream getOut() {
        return this.out != null ? this.out : System.out;
    }

    @Override
    public void run() {
        Config.c();
        try {
            int n2 = this.in.readInt();
            if ((long)n2 != 1000006L) {
                throw new RuntimeException("Debugger protocol incompatibility: local = 1000006, remote = " + n2);
            }
            this.remoteEncoding = RtsUtil.readUTFOptmz(this.in);
            block7: while (!this.isStopped()) {
                int n3 = this.in.readInt();
                switch (n3) {
                    case 1: {
                        DebugResponse debugResponse = new DebugResponse();
                        debugResponse.readExternal(this.in);
                        this.setResponse(debugResponse);
                        continue block7;
                    }
                    case 2: {
                        ErrorResponse errorResponse = new ErrorResponse();
                        errorResponse.readExternal(this.in);
                        System.err.println(errorResponse.getErrorMessage());
                        continue block7;
                    }
                    case 3: {
                        RawTextResponse rawTextResponse = new RawTextResponse();
                        rawTextResponse.readExternal(this.in);
                        this.getOut().println(rawTextResponse.getRawText());
                        continue block7;
                    }
                }
                throw new RuntimeException("Invalid response");
            }
        }
        catch (IOException iOException) {
            this.setResponse(new DebugResponse(103, ""));
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.responseQueue.addElement(new DebugResponse(103, ""));
        this.notifyAll();
    }

    private synchronized void setResponse(DebugResponse debugResponse) {
        this.responseQueue.addElement(debugResponse);
        this.notifyAll();
    }

    public synchronized DebugResponse getResponse(int n2) {
        if (this.responseQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        while (true) {
            int n3 = this.responseQueue.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                DebugResponse debugResponse = this.responseQueue.elementAt(i2);
                if (debugResponse.getFirstBlockMode() != n2 && n2 >= 0) continue;
                this.responseQueue.removeElementAt(i2);
                return debugResponse;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    String getRemoteEncoding() {
        return this.remoteEncoding;
    }
}

