/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IParagraphObjectExtension2;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ParagraphObject
implements DataExternalizable,
IParagraphObjectExtension2 {
    private static final long serialVersionUID = 1000006L;
    private String filename;
    private String parName;
    private String progName;
    private String methName;
    private String entryPointName;
    private int lineNumber;
    private int fileIndex;
    private boolean isLastPar;
    private boolean declaratives;
    private String progClassLocation;
    private int paragraphNumber;
    private transient int progStackSize;
    private transient int methStackSize;
    private transient Object method;
    private transient Object prog;
    private transient Class progClass;
    private transient String parentSection;

    public ParagraphObject() {
    }

    public ParagraphObject(String string, int n2, String string2, boolean bl, Class clazz, Object object, String string3, Object object2, String string4, int n3, int n4, int n5, boolean bl2, int n6) {
        this.filename = string;
        this.fileIndex = n2;
        this.parName = string2;
        this.prog = object;
        this.isLastPar = bl;
        this.progClass = clazz;
        this.progName = clazz.getName();
        this.progClassLocation = string3;
        this.method = object2;
        this.lineNumber = n5;
        this.methName = string4;
        this.progStackSize = n3;
        this.methStackSize = n4;
        this.declaratives = bl2;
        this.paragraphNumber = n6;
    }

    @Override
    public int getParagraphNumber() {
        return this.paragraphNumber;
    }

    @Override
    public boolean isDeclaratives() {
        return this.declaratives;
    }

    public int getProgStackSize() {
        return this.progStackSize;
    }

    public int getMethStackSize() {
        return this.methStackSize;
    }

    @Override
    public boolean isLastPar() {
        return this.isLastPar;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int n2) {
        this.fileIndex = n2;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    public void setLine(int n2) {
        this.lineNumber = n2;
    }

    @Override
    public String getName() {
        return this.parName;
    }

    @Override
    public String getFile() {
        return this.filename;
    }

    public void setFile(String string) {
        this.filename = string;
    }

    @Override
    public String getProgName() {
        return this.progName;
    }

    @Override
    public String getMethodName() {
        return this.methName;
    }

    public Object getMethod() {
        return this.method;
    }

    public Object getProgram() {
        return this.prog;
    }

    public Class getProgClass() {
        return this.progClass;
    }

    public String getProgClassLocation() {
        return this.progClassLocation;
    }

    public String getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(String string) {
        this.parentSection = string;
    }

    @Override
    public String getEntryPointName() {
        return this.entryPointName;
    }

    public void setEntryPointName(String string) {
        this.entryPointName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.entryPointName != null) {
            stringBuffer.append(this.entryPointName);
        } else {
            stringBuffer.append(this.parName);
            if (this.parentSection != null) {
                stringBuffer.append(" of ");
                stringBuffer.append(this.parentSection);
            }
        }
        stringBuffer.append("(");
        stringBuffer.append(this.lineNumber);
        stringBuffer.append(")");
        stringBuffer.append(" [");
        stringBuffer.append(this.progName);
        if (this.methName != null) {
            stringBuffer.append(":>");
            stringBuffer.append(this.methName);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.parName, dataOutput);
        RtsUtil.writeUTFOptmz(this.filename, dataOutput);
        RtsUtil.writeUTFOptmz(this.progName, dataOutput);
        RtsUtil.writeUTFOptmz(this.methName, dataOutput);
        dataOutput.writeInt(this.lineNumber);
        dataOutput.writeInt(this.fileIndex);
        dataOutput.writeBoolean(this.declaratives);
        dataOutput.writeBoolean(this.isLastPar);
        dataOutput.writeInt(this.paragraphNumber);
        RtsUtil.writeUTFOptmz(this.progClassLocation, dataOutput);
        RtsUtil.writeUTFOptmz(this.entryPointName, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.parName = RtsUtil.readUTFOptmz(dataInput);
        this.filename = RtsUtil.readUTFOptmz(dataInput);
        this.progName = RtsUtil.readUTFOptmz(dataInput);
        this.methName = RtsUtil.readUTFOptmz(dataInput);
        this.lineNumber = dataInput.readInt();
        this.fileIndex = dataInput.readInt();
        this.declaratives = dataInput.readBoolean();
        this.isLastPar = dataInput.readBoolean();
        this.paragraphNumber = dataInput.readInt();
        this.progClassLocation = RtsUtil.readUTFOptmz(dataInput);
        this.entryPointName = RtsUtil.readUTFOptmz(dataInput);
    }
}

