/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public abstract class Settings {
    public static final String IS_DEBUGGER_PROPERTIES;
    public static final String COPY_SOURCE_COLOR_PATTERN_PREFIX = "Level ";
    public static final String BREAKPOINT_COLUMN = "Breakpoint column";
    public static final String BREAKPOINT_LINE = "Breakpoint line";
    public static final String BREAKPOINT_LIST = "Breakpoint list";
    public static final String BREAKPOINT_LIST_SELECTED = "Breakpoint list (selected)";
    public static final String COMMENTS = "Comments";
    public static final String COPY_SOURCE = "Copy source";
    public static final String CURRENT_LINE = "Current line";
    public static final String DISPLAY_TREE = "Display tree area";
    public static final String DISPLAY_TREE_SELECTED = "Display tree area (selected)";
    public static final String DISPLAY_VARIABLE_TOOLTIP = "Variable hint";
    public static final String FIGURATIVE_CONSTS = "Figurative constants";
    public static final String HIGHLIGHTED_BY_SEARCH = "Highlighted by search";
    public static final String KEYWORDS = "Keywords";
    public static final String LEV_NUMS = "Level numbers";
    public static final String LINE_COMMAND = "Line command";
    public static final String LINE_COMMAND_SELECTED = "Line command (selected)";
    public static final String LINE_NUMBER_COLUMN = "Line number column";
    public static final String MONITOR_LIST = "Monitor list";
    public static final String MONITOR_LIST_SELECTED = "Monitor list (selected)";
    public static final String CMD_HISTORY = "Command history";
    public static final String CMD_HISTORY_SELECTED = "Command history (selected)";
    public static final String CONSOLE = "Console";
    public static final String CONSOLE_SELECTED = "Console (selected)";
    public static final String CONSOLE_STDERR = "Console StdErr";
    public static final String NUMBERS = "Numeric literals";
    public static final String OUTPUT_AREA = "Output area";
    public static final String OUTPUT_AREA_SELECTED = "Output area (selected)";
    public static final String PERFORM_STACK = "Perform stack";
    public static final String PERFORM_STACK_SELECTED = "Perform stack (selected)";
    public static final String SOURCE_CODE = "Source code";
    public static final String SOURCE_CODE_SELECTED = "Source code (selected)";
    public static final String STATEMENTS = "Statements";
    public static final String STRINGS = "String literals";
    public static final String THREAD_LIST = "Thread list";
    public static final String COMMAND_ALIAS_PREFIX = "debugger.commands.alias.";
    private static final String SHORTCUT_PREFIX = "graphdebugger.shortcut.";
    public static final String BACK_SHORTCUT = "graphdebugger.shortcut.gotoback";
    public static final String CLEAR_OUTPUT_SHORTCUT = "graphdebugger.shortcut.clearout";
    public static final String CONTINUE_SHORTCUT = "graphdebugger.shortcut.continue";
    public static final String CURRENT_LINE_SHORTCUT = "graphdebugger.shortcut.curr_line";
    public static final String DECREMENT_FONT_SHORTCUT = "graphdebugger.shortcut.decfont";
    public static final String DISPLAY_SEL_LINE_VARS_SHORTCUT = "graphdebugger.shortcut.displayonselline";
    public static final String DISPLAY_SHORTCUT = "graphdebugger.shortcut.display";
    public static final String EXIT_SHORTCUT = "graphdebugger.shortcut.exit";
    public static final String FIND_BACKWARD_SHORTCUT = "graphdebugger.shortcut.fb";
    public static final String FIND_FORWARD_SHORTCUT = "graphdebugger.shortcut.ff";
    public static final String FIND_FROM_TOP_SHORTCUT = "graphdebugger.shortcut.ft";
    public static final String FIND_SHORTCUT = "graphdebugger.shortcut.find";
    public static final String FIRST_EXEC_LINE_SHORTCUT = "graphdebugger.shortcut.first_exec_line";
    public static final String FIRST_LINE_SHORTCUT = "graphdebugger.shortcut.first_line";
    public static final String FORWARD_SHORTCUT = "graphdebugger.shortcut.gotoforw";
    public static final String GOTO_DECL_SHORTCUT = "graphdebugger.shortcut.gotodecl";
    public static final String GOTO_SHORTCUT = "graphdebugger.shortcut.goto";
    public static final String HELP_SHORTCUT = "graphdebugger.shortcut.help";
    public static final String INCREMENT_FONT_SHORTCUT = "graphdebugger.shortcut.incfont";
    public static final String JUMP_OUT_PAR_SHORTCUT = "graphdebugger.shortcut.jumpoutpar";
    public static final String JUMP_OUT_PROG_SHORTCUT = "graphdebugger.shortcut.jumpoutprog";
    public static final String JUMP_OVER_SHORTCUT = "graphdebugger.shortcut.jumpnext";
    public static final String JUMP_SHORTCUT = "graphdebugger.shortcut.jump";
    public static final String JUMP_TO_SEL_LINE_SHORTCUT = "graphdebugger.shortcut.jumptoline";
    public static final String LAST_COMMAND_SHORTCUT = "graphdebugger.shortcut.lastcmd";
    public static final String LAST_LINE_SHORTCUT = "graphdebugger.shortcut.last_line";
    public static final String LET_SHORTCUT = "graphdebugger.shortcut.let";
    public static final String LOAD_FILE_SHORTCUT = "graphdebugger.shortcut.loadfile";
    public static final String NEXT_COMMAND_SHORTCUT = "graphdebugger.shortcut.nextcmd";
    public static final String PREV_COMMAND_SHORTCUT = "graphdebugger.shortcut.prevcmd";
    public static final String QUICK_WATCH_SHORTCUT = "graphdebugger.shortcut.quickwatch";
    public static final String QUIT_SHORTCUT = "graphdebugger.shortcut.quit";
    public static final String REFRESH_VARIABLES_AREA_SHORTCUT = "graphdebugger.shortcut.refreshvararea";
    public static final String REPEAT_FIND_SHORTCUT = "graphdebugger.shortcut.repfind";
    public static final String RUN_SHORTCUT = "graphdebugger.shortcut.run";
    public static final String SET_BREAKPOINT_SHORTCUT = "graphdebugger.shortcut.break";
    public static final String SET_MONITOR_SHORTCUT = "graphdebugger.shortcut.monitor";
    public static final String START_AUTOSTEP_SHORTCUT = "graphdebugger.shortcut.ston";
    public static final String START_TRACING_SHORTCUT = "graphdebugger.shortcut.tron";
    public static final String STEP_INTO_SHORTCUT = "graphdebugger.shortcut.step";
    public static final String STEP_OUT_PAR_SHORTCUT = "graphdebugger.shortcut.outpar";
    public static final String STEP_OUT_PROG_SHORTCUT = "graphdebugger.shortcut.outprog";
    public static final String STEP_OVER_SHORTCUT = "graphdebugger.shortcut.next";
    public static final String STEP_TO_PROGRAM_SHORTCUT = "graphdebugger.shortcut.prog";
    public static final String STEP_TO_SEL_LINE_SHORTCUT = "graphdebugger.shortcut.toline";
    public static final String STEP_TO_SHORTCUT = "graphdebugger.shortcut.to";
    public static final String STOP_AUTOSTEP_SHORTCUT = "graphdebugger.shortcut.stoff";
    public static final String STOP_TRACING_SHORTCUT = "graphdebugger.shortcut.troff";
    public static final String TOGGLE_BREAKPOINT_SHORTCUT = "graphdebugger.shortcut.togglebreak";
    public static final String UNLOAD_FILE_SHORTCUT = "graphdebugger.shortcut.unloadfile";
    private static final String ARRAY_START_PROP = "graphdebugger.displaytree.arraystart";
    private static final String ASK_EXIT_CONFIRM_PROP = "graphdebugger.askconfirmwhenexit";
    private static final String ASK_QUIT_CONFIRM_PROP = "graphdebugger.askconfirmwhenquit";
    private static final String AUTOCONNECT_DELAY_PROP = "graphdebugger.autoconnect.delay";
    private static final String AUTOCONNECT_PROP = "graphdebugger.autoconnect";
    private static final String AUTOSAVE_PROP = "graphdebugger.autosave";
    private static final String BREAKPOINT_COLUMN_PROP = "graphdebugger.breakpointcolumn";
    private static final String BREAKPOINT_DEFAULT_EN_STATE_PROP = "graphdebugger.breakpoint.enstate";
    private static final String BREAKPOINT_LINE_PROP = "graphdebugger.breakpointline";
    private static final String BREAKPOINT_LIST_PROP = "graphdebugger.breakpointlist";
    private static final String BREAKPOINT_LIST_SELECTED_PROP = "graphdebugger.breakpointlistselected";
    private static final String CMD_HISTORY_PROP = "graphdebugger.cmdhistory";
    private static final String CMD_HISTORY_SELECTED_PROP = "graphdebugger.cmdhistoryselected";
    private static final String COMMENTS_PROP = "graphdebugger.comments";
    private static final String CONSOLE_ATTACHED_PROP = "graphdebugger.consoleattached";
    private static final String CONSOLE_PROP = "graphdebugger.console";
    private static final String CONSOLE_SELECTED_PROP = "graphdebugger.consoleselected";
    private static final String CONSOLE_STDERR_PROP = "graphdebugger.consolestderr";
    private static final String COPY_SOURCE_PATTERN_PROP = "graphdebugger.copysource.pattern";
    private static final String CURRENT_LINE_PROP = "graphdebugger.currentline";
    private static final String DISPLAY_TREE_PROP = "graphdebugger.displaytree";
    private static final String DISPLAY_TREE_SELECTED_PROP = "graphdebugger.displaytreeselected";
    private static final String DISPLAY_VAR_TOOLTIP_DELAY_PROP = "graphdebugger.display.delay";
    private static final String DISPLAY_VAR_TOOLTIP_ENABLED_PROP = "graphdebugger.display.enabled";
    private static final String DISPLAY_VAR_TOOLTIP_PROP = "graphdebugger.variabletooltip";
    private static final String EXIT_AFTER_TERMINATION_PROP = "graphdebugger.exitaftertermination";
    private static final String EXPAND_COPY_ON_LOAD_PROP = "graphdebugger.expandcopyonload";
    private static final String FIGURATIVE_CONSTS_PROP = "graphdebugger.figurativeconsts";
    private static final String FIND_BACKWARD_SEARCH_PROP = "graphdebugger.finddialog.bkw";
    private static final String FIND_MATCH_CASE_PROP = "graphdebugger.finddialog.matchcase";
    private static final String FIND_MATCH_MIN_UND_PROP = "graphdebugger.finddialog.matchminund";
    private static final String FIND_TOP_SEARCH_PROP = "graphdebugger.finddialog.top";
    private static final String FIND_WHOLE_WORD_PROP = "graphdebugger.finddialog.wholeword";
    private static final String FIND_WRAP_PROP = "graphdebugger.finddialog.wrap";
    private static final String FORCE_STOP_RUN_PROP = "graphdebugger.forcestoprun";
    private static final String HEX_DUMP_START_PROP = "graphdebugger.displaytree.hexdumpstart";
    private static final String HEX_PROP = "graphdebugger.displayhex";
    private static final String HIGHLIGHT_BY_SEARCH_PROP = "graphdebugger.highlightedbysearch";
    private static final String KEYWORDS_PROP = "graphdebugger.keywords";
    private static final String LEVEL_NUMBER_PROP = "graphdebugger.levelnumbers";
    private static final String LINE_COMMAND_PROP = "graphdebugger.linecommand";
    private static final String LINE_COMMAND_SELECTED_PROP = "graphdebugger.linecommandselected";
    private static final String LINE_NUMBER_COLUMN_PROP = "graphdebugger.linenumbercolumn";
    private static final String MAIN_SPLITPANE_DIV_LOC_PROP = "graphdebugger.mainsplipane.divloc";
    private static final String MAX_ARRAY_LENGTH_PROP = "graphdebugger.displaytree.maxarraylen";
    private static final String MAX_HEX_DUMP_LENGTH_PROP = "graphdebugger.displaytree.maxhexdumplen";
    private static final String MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP = "graphdebugger.displaytree.maxtextlenout";
    private static final String MAX_TEXT_VALUE_LENGTH_PROP = "graphdebugger.displaytree.maxtextlen";
    private static final String MONITOR_DEFAULT_EN_STATE_PROP = "graphdebugger.monitor.enstate";
    private static final String MONITOR_LIST_COL_NAME_WIDTH_PROP = "graphdebugger.monitorlist.name.width";
    private static final String MONITOR_LIST_COL_VALUE_WIDTH_PROP = "graphdebugger.monitorlist.value.width";
    private static final String MONITOR_LIST_PROP = "graphdebugger.monitorlist";
    private static final String MONITOR_LIST_SELECTED_PROP = "graphdebugger.monitorlistselected";
    private static final String NUMBERS_PROP = "graphdebugger.numbers";
    private static final String OUTPUT_AREA_PROP = "graphdebugger.outputarea";
    private static final String OUTPUT_AREA_SELECTED_PROP = "graphdebugger.outputareaselected";
    private static final String OUTPUT_SPLITPANE_DIV_LOC_PROP = "graphdebugger.outsplipane.divloc";
    private static final String PERFORM_STACK_COL_LOC_WIDTH_PROP = "graphdebugger.performstack.location.width";
    private static final String PERFORM_STACK_COL_PAR_WIDTH_PROP = "graphdebugger.performstack.paragraph.width";
    private static final String PERFORM_STACK_COL_PROG_WIDTH_PROP = "graphdebugger.performstack.program.width";
    private static final String PERFORM_STACK_PROP = "graphdebugger.performstack";
    private static final String PERFORM_STACK_SELECTED_PROP = "graphdebugger.performstackselected";
    private static final String SESSION_FILENAME_PROP = "graphdebugger.session.filename";
    private static final String SHOW_CONSOLE_PROP = "graphdebugger.showconsole";
    private static final String SOURCE_CODE_PROP = "graphdebugger.sourcecode";
    private static final String SOURCE_CODE_SELECTED_PROP = "graphdebugger.selectedsource";
    private static final String SOURCE_FORMAT_PROP = "graphdebugger.sourceformat";
    private static final String SRC_SPLITPANE_DIV_LOC_PROP = "graphdebugger.srcsplipane.divloc";
    private static final String STATEMENTS_PROP = "graphdebugger.statements";
    private static final String STRINGS_PROP = "graphdebugger.strings";
    private static final String THREAD_LIST_COL_NAME_WIDTH_PROP = "graphdebugger.threadlist.name.width";
    private static final String THREAD_LIST_COL_PAR_WIDTH_PROP = "graphdebugger.threadlist.paragraph.width";
    private static final String THREAD_LIST_COL_PROG_WIDTH_PROP = "graphdebugger.threadlist.program.width";
    private static final String THREAD_LIST_PROP = "graphdebugger.threadlist";
    private static final String VAR_HAND_MOUSE_DELAY_PROP = "graphdebugger.handmouse.delay";
    private static final String VAR_HAND_MOUSE_ENABLED_PROP = "graphdebugger.handmouse.enabled";
    private static final String VAR_SPLITPANE_DIV_LOC_PROP = "graphdebugger.varsplipane.divloc";
    private static final String WINDOW_HEIGHT_PROP = "graphdebugger.window.height";
    private static final String WINDOW_STATE_PROP = "graphdebugger.window.state";
    private static final String WINDOW_WIDTH_PROP = "graphdebugger.window.width";
    private static final String WINDOW_X_PROP = "graphdebugger.window.x";
    private static final String WINDOW_Y_PROP = "graphdebugger.window.y";
    private static final String FONT_NAME_SFX = ".font.name";
    private static final String FONT_STYLE_SFX = ".font.style";
    private static final String FONT_SIZE_SFX = ".font.size";
    private static final String FOREGROUND_SFX = ".foreground.rgb";
    private static final String BACKGROUND_SFX = ".background.rgb";
    private static final String DEF_LAF_SFX = ".def_laf";
    private static FontAndColors[] settings;
    private static String copySourcePattern;
    private static boolean defaultBreakpointEnabledState;
    private static boolean defaultMonitorEnabledState;
    private static boolean hexOption;
    private static boolean autoSave;
    private static boolean showConsole;
    private static boolean consoleAttached;
    private static String sessionOutputFileName;
    private static boolean askConfirmWhenQuit;
    private static boolean askConfirmWhenExit;
    private static boolean exitAfterTermination;
    private static boolean autoConnect;
    private static boolean forceStopRun;
    private static boolean findMatchCase;
    private static boolean findWholeWord;
    private static boolean findBackwardSearch;
    private static boolean findTopSearch;
    private static boolean findWrapSearch;
    private static boolean findMatchMinusUnderscore;
    private static boolean expandCopiesOnLoad;
    private static int autoConnectDelay;
    private static int mainSplitPaneDividerLocation;
    private static int outputSplitPaneDividerLocation;
    private static int sourceSplitPaneDividerLocation;
    private static int variableSplitPaneDividerLocation;
    private static int maxHexDumpLength;
    private static int hexDumpStartOffset;
    private static int maxArrayLength;
    private static int arrayStartOffset;
    private static int maxTextValueLength;
    private static int maxTextValueLengthOutput;
    private static int monitorTableNameColumnWidth;
    private static int monitorTableValueColumnWidth;
    private static int callStackTableParagraphColumnWidth;
    private static int callStackTableLocationColumnWidth;
    private static int callStackTableProgramColumnWidth;
    private static int threadTableNameColumnWidth;
    private static int threadTableParagraphColumnWidth;
    private static int threadTableProgramColumnWidth;
    private static final Map<String, FontAndColors> htSettings;
    private static int windowState;
    private static Rectangle windowBounds;
    private static int sourceFormat;
    private static int variableHintDelay;
    private static int variableHandMouseDelay;
    private static boolean variableHintEnabled;
    private static boolean variableHandMouseEnabled;
    private static Properties commandAliasis;
    private static Properties shortcuts;
    private static final boolean isNimbus;
    private static final String[] styles;
    private static final int[] stylesValues;
    private static final String[] fonts;
    public static final int MINIMUM_FONT_SIZE = 9;
    public static final int MAXIMUM_FONT_SIZE = 20;

    private static int getPropInt(Properties properties, String string, int n2) {
        try {
            return Integer.parseInt(properties.getProperty(string));
        }
        catch (Exception exception) {
            return n2;
        }
    }

    private static Color getPropColor(Properties properties, String string, Color color) {
        try {
            return new Color(Integer.parseInt(properties.getProperty(string)));
        }
        catch (Exception exception) {
            return color;
        }
    }

    private static boolean getPropInheritFromLaf(Properties properties, String string) {
        return !"false".equals(properties.getProperty(string + DEF_LAF_SFX));
    }

    public static String getCommandAlias(String string) {
        return commandAliasis.getProperty(string);
    }

    public static void setCommandAlias(String string, String string2) {
        commandAliasis.setProperty(string, string2);
    }

    public static String getShortcut(String string) {
        return shortcuts.getProperty(string);
    }

    public static void setShortcut(String string, String string2) {
        shortcuts.setProperty(string, string2);
    }

    public static void setVariableHintDelay(int n2) {
        variableHintDelay = n2;
    }

    public static int getVariableHandMouseDelay() {
        return variableHandMouseDelay;
    }

    public static void setVariableHandMouseDelay(int n2) {
        variableHandMouseDelay = n2;
    }

    public static boolean isVariableHintEnabled() {
        return variableHintEnabled;
    }

    public static boolean isVariableHandMouseEnabled() {
        return variableHandMouseEnabled;
    }

    public static void setVariableHintEnabled(boolean bl) {
        variableHintEnabled = bl;
    }

    public static void setVariableHandMouseEnabled(boolean bl) {
        variableHandMouseEnabled = bl;
    }

    public static boolean getDefaultMonitorEnabledState() {
        return defaultMonitorEnabledState;
    }

    public static void setDefaultMonitorEnabledState(boolean bl) {
        defaultMonitorEnabledState = bl;
    }

    public static boolean getDefaultBreakpointEnabledState() {
        return defaultBreakpointEnabledState;
    }

    public static void setDefaultBreakpointEnabledState(boolean bl) {
        defaultBreakpointEnabledState = bl;
    }

    public static void setThreadTableColumnsWidths(int n2, int n3, int n4) {
        threadTableParagraphColumnWidth = n3;
        threadTableNameColumnWidth = n2;
        threadTableProgramColumnWidth = n4;
    }

    public static int getThreadTableNameColumnWidth() {
        return threadTableNameColumnWidth;
    }

    public static int getThreadTableParagraphColumnWidth() {
        return threadTableParagraphColumnWidth;
    }

    public static int getThreadTableProgramColumnWidth() {
        return threadTableProgramColumnWidth;
    }

    public static void setCallStackTableColumnsWidths(int n2, int n3, int n4) {
        callStackTableParagraphColumnWidth = n2;
        callStackTableLocationColumnWidth = n3;
        callStackTableProgramColumnWidth = n4;
    }

    public static int getCallStackTableParagraphColumnWidth() {
        return callStackTableParagraphColumnWidth;
    }

    public static int getCallStackTableLocationColumnWidth() {
        return callStackTableLocationColumnWidth;
    }

    public static int getCallStackTableProgramColumnWidth() {
        return callStackTableProgramColumnWidth;
    }

    public static int getVariableHintDelay() {
        return variableHintDelay;
    }

    public static void setCopySourcePattern(String string) {
        copySourcePattern = string;
    }

    public static String getCopySourcePattern() {
        return copySourcePattern;
    }

    public static void setHexOption(boolean bl) {
        hexOption = bl;
    }

    public static boolean getHexOption() {
        return hexOption;
    }

    public static void setAutosave(boolean bl) {
        autoSave = bl;
    }

    public static boolean getAutosave() {
        return autoSave;
    }

    public static void setSessionOutputFileName(String string) {
        sessionOutputFileName = string;
    }

    public static String getSessionOutputFileName() {
        return sessionOutputFileName;
    }

    public static void setAskConfirmWhenExit(boolean bl) {
        askConfirmWhenExit = bl;
    }

    public static boolean getAskConfirmWhenExit() {
        return askConfirmWhenExit;
    }

    public static void setAskConfirmWhenQuit(boolean bl) {
        askConfirmWhenQuit = bl;
    }

    public static boolean getAskConfirmWhenQuit() {
        return askConfirmWhenQuit;
    }

    public static void setAutoConnect(boolean bl) {
        autoConnect = bl;
    }

    public static int getMainSplitPaneDividerLocation() {
        return mainSplitPaneDividerLocation;
    }

    public static void setMainSplitPaneDividerLocation(int n2) {
        mainSplitPaneDividerLocation = n2;
    }

    public static int getOutputSplitPaneDividerLocation() {
        return outputSplitPaneDividerLocation;
    }

    public static void setOutputSplitPaneDividerLocation(int n2) {
        outputSplitPaneDividerLocation = n2;
    }

    public static int getSourceSplitPaneDividerLocation() {
        return sourceSplitPaneDividerLocation;
    }

    public static void setSourceSplitPaneDividerLocation(int n2) {
        sourceSplitPaneDividerLocation = n2;
    }

    public static int getVariableSplitPaneDividerLocation() {
        return variableSplitPaneDividerLocation;
    }

    public static void setVariableSplitPaneDividerLocation(int n2) {
        variableSplitPaneDividerLocation = n2;
    }

    public static void setMonitorTableColumnsWidths(int n2, int n3) {
        monitorTableNameColumnWidth = n2;
        monitorTableValueColumnWidth = n3;
    }

    public static int getMonitorTableNameColumnWidth() {
        return monitorTableNameColumnWidth;
    }

    public static int getMonitorTableValueColumnWidth() {
        return monitorTableValueColumnWidth;
    }

    public static boolean getAutoConnect() {
        return autoConnect;
    }

    public static void setAutoConnectDelay(int n2) {
        autoConnectDelay = n2;
    }

    public static boolean getForceStopRun() {
        return forceStopRun;
    }

    public static void setForceStopRun(boolean bl) {
        forceStopRun = bl;
    }

    public static int getAutoConnectDelay() {
        return autoConnectDelay;
    }

    public static int getWindowState() {
        return windowState;
    }

    public static void setWindowState(int n2) {
        windowState = n2;
    }

    public static Rectangle getWindowBounds() {
        return windowBounds;
    }

    public static void setWindowBounds(Rectangle rectangle) {
        windowBounds = rectangle;
    }

    public static boolean isExpandCopiesOnLoad() {
        return expandCopiesOnLoad;
    }

    public static void setExpandCopiesOnLoad(boolean bl) {
        expandCopiesOnLoad = bl;
    }

    public static int getMaxHexDumpLength() {
        return maxHexDumpLength;
    }

    public static void setMaxHexDumpLength(int n2) {
        maxHexDumpLength = n2;
    }

    public static int getHexDumpStartOffset() {
        return hexDumpStartOffset;
    }

    public static void setHexDumpStartOffset(int n2) {
        hexDumpStartOffset = n2;
    }

    public static int getMaxArrayLength() {
        return maxArrayLength;
    }

    public static void setMaxArrayLength(int n2) {
        maxArrayLength = n2;
    }

    public static int getArrayStartOffset() {
        return arrayStartOffset;
    }

    public static void setArrayStartOffset(int n2) {
        arrayStartOffset = n2;
    }

    public static int getMaxTextValueLength() {
        return maxTextValueLength;
    }

    public static void setMaxTextValueLength(int n2) {
        maxTextValueLength = n2;
    }

    public static int getMaxTextValueLengthOutput() {
        return maxTextValueLengthOutput;
    }

    public static void setMaxTextValueLengthOutput(int n2) {
        maxTextValueLengthOutput = n2;
    }

    public static void setFindFlags(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        findMatchCase = bl;
        findBackwardSearch = bl2;
        findWrapSearch = bl3;
        findWholeWord = bl4;
        findTopSearch = bl5;
        findMatchMinusUnderscore = bl6;
    }

    public static boolean isFindMatchCase() {
        return findMatchCase;
    }

    public static boolean isFindWholeWord() {
        return findWholeWord;
    }

    public static boolean isFindBackwardSearch() {
        return findBackwardSearch;
    }

    public static boolean isFindTopSearch() {
        return findTopSearch;
    }

    public static boolean isFindWrapSearch() {
        return findWrapSearch;
    }

    public static boolean isFindMatchMinusUnderscore() {
        return findMatchMinusUnderscore;
    }

    public static int getSourceFormat() {
        return sourceFormat;
    }

    public static void setSourceFormat(int n2) {
        sourceFormat = n2;
    }

    public static boolean isInheritFromLaf(String string) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            return fontAndColors.isInheritFromLaf();
        }
        return false;
    }

    public static Font getFont(String string) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            return fontAndColors.getFont();
        }
        return null;
    }

    public static void setFont(String string, Font font) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            fontAndColors.setFont(font);
        }
    }

    public static Color getBackground(String string) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            return fontAndColors.getBackground();
        }
        return null;
    }

    public static void setBackground(String string, Color color) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            fontAndColors.setBackground(color);
        }
    }

    public static Color getForeground(String string) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            return fontAndColors.getForeground();
        }
        return null;
    }

    public static void setForeground(String string, Color color) {
        FontAndColors fontAndColors = htSettings.get(string);
        if (fontAndColors != null) {
            fontAndColors.setForeground(color);
        }
    }

    public static String[] getFonts() {
        return fonts;
    }

    public static String[] getStylesNames() {
        return styles;
    }

    public static int[] getStylesValues() {
        return stylesValues;
    }

    public static FontAndColors[] getSettings() {
        return settings;
    }

    public static void setSettings(FontAndColors[] fontAndColorsArray) {
        settings = fontAndColorsArray;
        htSettings.clear();
        for (FontAndColors fontAndColors : settings) {
            htSettings.put(fontAndColors.getName(), fontAndColors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        SortedProperties sortedProperties = new SortedProperties();
        sortedProperties.setProperty(MAX_HEX_DUMP_LENGTH_PROP, Integer.toString(maxHexDumpLength));
        sortedProperties.setProperty(HEX_DUMP_START_PROP, Integer.toString(hexDumpStartOffset));
        sortedProperties.setProperty(MAX_ARRAY_LENGTH_PROP, Integer.toString(maxArrayLength));
        sortedProperties.setProperty(ARRAY_START_PROP, Integer.toString(arrayStartOffset));
        sortedProperties.setProperty(MAX_TEXT_VALUE_LENGTH_PROP, Integer.toString(maxTextValueLength));
        sortedProperties.setProperty(MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP, Integer.toString(maxTextValueLengthOutput));
        sortedProperties.setProperty(AUTOSAVE_PROP, Integer.toString(autoSave ? 1 : 0));
        sortedProperties.setProperty(CONSOLE_ATTACHED_PROP, Integer.toString(consoleAttached ? 1 : 0));
        sortedProperties.setProperty(SHOW_CONSOLE_PROP, Integer.toString(showConsole ? 1 : 0));
        sortedProperties.setProperty(SESSION_FILENAME_PROP, sessionOutputFileName);
        sortedProperties.setProperty(HEX_PROP, Integer.toString(hexOption ? 1 : 0));
        sortedProperties.setProperty(EXPAND_COPY_ON_LOAD_PROP, String.valueOf(expandCopiesOnLoad ? 1 : 0));
        sortedProperties.setProperty(FIND_BACKWARD_SEARCH_PROP, Integer.toString(findBackwardSearch ? 1 : 0));
        sortedProperties.setProperty(FIND_WHOLE_WORD_PROP, Integer.toString(findWholeWord ? 1 : 0));
        sortedProperties.setProperty(FIND_WRAP_PROP, Integer.toString(findWrapSearch ? 1 : 0));
        sortedProperties.setProperty(FIND_MATCH_CASE_PROP, Integer.toString(findMatchCase ? 1 : 0));
        sortedProperties.setProperty(FIND_MATCH_MIN_UND_PROP, Integer.toString(findMatchMinusUnderscore ? 1 : 0));
        sortedProperties.setProperty(FIND_TOP_SEARCH_PROP, Integer.toString(findTopSearch ? 1 : 0));
        sortedProperties.setProperty(DISPLAY_VAR_TOOLTIP_DELAY_PROP, Integer.toString(variableHintDelay));
        sortedProperties.setProperty(VAR_HAND_MOUSE_DELAY_PROP, Integer.toString(variableHandMouseDelay));
        sortedProperties.setProperty(DISPLAY_VAR_TOOLTIP_ENABLED_PROP, Integer.toString(variableHintEnabled ? 1 : 0));
        sortedProperties.setProperty(VAR_HAND_MOUSE_ENABLED_PROP, Integer.toString(variableHandMouseEnabled ? 1 : 0));
        sortedProperties.setProperty(BREAKPOINT_DEFAULT_EN_STATE_PROP, Integer.toString(defaultBreakpointEnabledState ? 1 : 0));
        sortedProperties.setProperty(MONITOR_DEFAULT_EN_STATE_PROP, Integer.toString(defaultMonitorEnabledState ? 1 : 0));
        sortedProperties.setProperty(ASK_QUIT_CONFIRM_PROP, Integer.toString(askConfirmWhenQuit ? 1 : 0));
        sortedProperties.setProperty(ASK_EXIT_CONFIRM_PROP, Integer.toString(askConfirmWhenExit ? 1 : 0));
        sortedProperties.setProperty(EXIT_AFTER_TERMINATION_PROP, Integer.toString(exitAfterTermination ? 1 : 0));
        sortedProperties.setProperty(AUTOCONNECT_PROP, Integer.toString(autoConnect ? 1 : 0));
        sortedProperties.setProperty(AUTOCONNECT_DELAY_PROP, Integer.toString(autoConnectDelay));
        sortedProperties.setProperty(FORCE_STOP_RUN_PROP, Integer.toString(forceStopRun ? 1 : 0));
        sortedProperties.setProperty(MAIN_SPLITPANE_DIV_LOC_PROP, Integer.toString(mainSplitPaneDividerLocation));
        sortedProperties.setProperty(OUTPUT_SPLITPANE_DIV_LOC_PROP, Integer.toString(outputSplitPaneDividerLocation));
        sortedProperties.setProperty(SRC_SPLITPANE_DIV_LOC_PROP, Integer.toString(sourceSplitPaneDividerLocation));
        sortedProperties.setProperty(VAR_SPLITPANE_DIV_LOC_PROP, Integer.toString(variableSplitPaneDividerLocation));
        sortedProperties.setProperty(MONITOR_LIST_COL_NAME_WIDTH_PROP, Integer.toString(monitorTableNameColumnWidth));
        sortedProperties.setProperty(MONITOR_LIST_COL_VALUE_WIDTH_PROP, Integer.toString(monitorTableValueColumnWidth));
        sortedProperties.setProperty(PERFORM_STACK_COL_PAR_WIDTH_PROP, Integer.toString(callStackTableParagraphColumnWidth));
        sortedProperties.setProperty(PERFORM_STACK_COL_LOC_WIDTH_PROP, Integer.toString(callStackTableLocationColumnWidth));
        sortedProperties.setProperty(PERFORM_STACK_COL_PROG_WIDTH_PROP, Integer.toString(callStackTableProgramColumnWidth));
        sortedProperties.setProperty(THREAD_LIST_COL_NAME_WIDTH_PROP, Integer.toString(threadTableNameColumnWidth));
        sortedProperties.setProperty(THREAD_LIST_COL_PAR_WIDTH_PROP, Integer.toString(threadTableParagraphColumnWidth));
        sortedProperties.setProperty(THREAD_LIST_COL_PROG_WIDTH_PROP, Integer.toString(threadTableProgramColumnWidth));
        sortedProperties.setProperty(WINDOW_STATE_PROP, "" + windowState);
        sortedProperties.setProperty(WINDOW_X_PROP, "" + Settings.windowBounds.x);
        sortedProperties.setProperty(WINDOW_Y_PROP, "" + Settings.windowBounds.y);
        sortedProperties.setProperty(WINDOW_WIDTH_PROP, "" + Settings.windowBounds.width);
        sortedProperties.setProperty(WINDOW_HEIGHT_PROP, "" + Settings.windowBounds.height);
        sortedProperties.setProperty(SOURCE_FORMAT_PROP, "" + sourceFormat);
        sortedProperties.setProperty("graphdebugger.sourcecode.font.name", Settings.getFont(SOURCE_CODE).getName());
        sortedProperties.setProperty("graphdebugger.sourcecode.font.style", "" + Settings.getFont(SOURCE_CODE).getStyle());
        sortedProperties.setProperty("graphdebugger.sourcecode.font.size", "" + Settings.getFont(SOURCE_CODE).getSize());
        sortedProperties.setProperty("graphdebugger.sourcecode.background.rgb", "" + Settings.getBackground(SOURCE_CODE).getRGB());
        sortedProperties.setProperty("graphdebugger.sourcecode.foreground.rgb", "" + Settings.getForeground(SOURCE_CODE).getRGB());
        sortedProperties.setProperty("graphdebugger.selectedsource.background.rgb", "" + Settings.getBackground(SOURCE_CODE_SELECTED).getRGB());
        sortedProperties.setProperty("graphdebugger.comments.foreground.rgb", "" + Settings.getForeground(COMMENTS).getRGB());
        sortedProperties.setProperty("graphdebugger.keywords.foreground.rgb", "" + Settings.getForeground(KEYWORDS).getRGB());
        sortedProperties.setProperty("graphdebugger.strings.foreground.rgb", "" + Settings.getForeground(STRINGS).getRGB());
        sortedProperties.setProperty("graphdebugger.numbers.foreground.rgb", "" + Settings.getForeground(NUMBERS).getRGB());
        sortedProperties.setProperty("graphdebugger.statements.foreground.rgb", "" + Settings.getForeground(STATEMENTS).getRGB());
        sortedProperties.setProperty("graphdebugger.levelnumbers.foreground.rgb", "" + Settings.getForeground(LEV_NUMS).getRGB());
        sortedProperties.setProperty("graphdebugger.figurativeconsts.foreground.rgb", "" + Settings.getForeground(FIGURATIVE_CONSTS).getRGB());
        sortedProperties.setProperty("graphdebugger.breakpointline.background.rgb", "" + Settings.getBackground(BREAKPOINT_LINE).getRGB());
        sortedProperties.setProperty("graphdebugger.currentline.background.rgb", "" + Settings.getBackground(CURRENT_LINE).getRGB());
        sortedProperties.setProperty("graphdebugger.currentline.foreground.rgb", "" + Settings.getForeground(CURRENT_LINE).getRGB());
        sortedProperties.setProperty("graphdebugger.highlightedbysearch.background.rgb", "" + Settings.getBackground(HIGHLIGHTED_BY_SEARCH).getRGB());
        sortedProperties.setProperty("graphdebugger.highlightedbysearch.foreground.rgb", "" + Settings.getForeground(HIGHLIGHTED_BY_SEARCH).getRGB());
        sortedProperties.setProperty("graphdebugger.linenumbercolumn.background.rgb", "" + Settings.getBackground(LINE_NUMBER_COLUMN).getRGB());
        sortedProperties.setProperty("graphdebugger.linenumbercolumn.foreground.rgb", "" + Settings.getForeground(LINE_NUMBER_COLUMN).getRGB());
        sortedProperties.setProperty("graphdebugger.breakpointcolumn.background.rgb", "" + Settings.getBackground(BREAKPOINT_COLUMN).getRGB());
        sortedProperties.setProperty("graphdebugger.outputarea.font.name", Settings.getFont(OUTPUT_AREA).getName());
        sortedProperties.setProperty("graphdebugger.outputarea.font.style", "" + Settings.getFont(OUTPUT_AREA).getStyle());
        sortedProperties.setProperty("graphdebugger.outputarea.font.size", "" + Settings.getFont(OUTPUT_AREA).getSize());
        boolean bl = Settings.isInheritFromLaf(OUTPUT_AREA);
        sortedProperties.setProperty("graphdebugger.outputarea.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.outputarea.background.rgb", "" + Settings.getBackground(OUTPUT_AREA).getRGB());
            sortedProperties.setProperty("graphdebugger.outputarea.foreground.rgb", "" + Settings.getForeground(OUTPUT_AREA).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.console.font.name", Settings.getFont(CONSOLE).getName());
        sortedProperties.setProperty("graphdebugger.console.font.style", "" + Settings.getFont(CONSOLE).getStyle());
        sortedProperties.setProperty("graphdebugger.console.font.size", "" + Settings.getFont(CONSOLE).getSize());
        bl = Settings.isInheritFromLaf(CONSOLE);
        sortedProperties.setProperty("graphdebugger.console.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.console.background.rgb", "" + Settings.getBackground(CONSOLE).getRGB());
            sortedProperties.setProperty("graphdebugger.console.foreground.rgb", "" + Settings.getForeground(CONSOLE).getRGB());
        }
        bl = Settings.isInheritFromLaf(CONSOLE_SELECTED);
        sortedProperties.setProperty("graphdebugger.consoleselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.consoleselected.background.rgb", "" + Settings.getBackground(CONSOLE_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.consoleselected.foreground.rgb", "" + Settings.getForeground(CONSOLE_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.consolestderr.foreground.rgb", "" + Settings.getForeground(CONSOLE_STDERR).getRGB());
        sortedProperties.setProperty("graphdebugger.linecommand.font.name", Settings.getFont(LINE_COMMAND).getName());
        sortedProperties.setProperty("graphdebugger.linecommand.font.style", "" + Settings.getFont(LINE_COMMAND).getStyle());
        sortedProperties.setProperty("graphdebugger.linecommand.font.size", "" + Settings.getFont(LINE_COMMAND).getSize());
        bl = Settings.isInheritFromLaf(LINE_COMMAND);
        sortedProperties.setProperty("graphdebugger.linecommand.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.linecommand.background.rgb", "" + Settings.getBackground(LINE_COMMAND).getRGB());
            sortedProperties.setProperty("graphdebugger.linecommand.foreground.rgb", "" + Settings.getForeground(LINE_COMMAND).getRGB());
        }
        bl = Settings.isInheritFromLaf(LINE_COMMAND_SELECTED);
        sortedProperties.setProperty("graphdebugger.linecommandselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.linecommandselected.background.rgb", "" + Settings.getBackground(LINE_COMMAND_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.linecommandselected.foreground.rgb", "" + Settings.getForeground(LINE_COMMAND_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.variabletooltip.font.name", Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getName());
        sortedProperties.setProperty("graphdebugger.variabletooltip.font.style", "" + Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getStyle());
        sortedProperties.setProperty("graphdebugger.variabletooltip.font.size", "" + Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getSize());
        bl = Settings.isInheritFromLaf(DISPLAY_VARIABLE_TOOLTIP);
        sortedProperties.setProperty("graphdebugger.variabletooltip.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.variabletooltip.background.rgb", "" + Settings.getBackground(DISPLAY_VARIABLE_TOOLTIP).getRGB());
            sortedProperties.setProperty("graphdebugger.variabletooltip.foreground.rgb", "" + Settings.getForeground(DISPLAY_VARIABLE_TOOLTIP).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.performstack.font.name", Settings.getFont(PERFORM_STACK).getName());
        sortedProperties.setProperty("graphdebugger.performstack.font.style", "" + Settings.getFont(PERFORM_STACK).getStyle());
        sortedProperties.setProperty("graphdebugger.performstack.font.size", "" + Settings.getFont(PERFORM_STACK).getSize());
        bl = Settings.isInheritFromLaf(PERFORM_STACK);
        sortedProperties.setProperty("graphdebugger.performstack.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.performstack.background.rgb", "" + Settings.getBackground(PERFORM_STACK).getRGB());
            sortedProperties.setProperty("graphdebugger.performstack.foreground.rgb", "" + Settings.getForeground(PERFORM_STACK).getRGB());
        }
        bl = Settings.isInheritFromLaf(PERFORM_STACK_SELECTED);
        sortedProperties.setProperty("graphdebugger.performstackselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.performstackselected.background.rgb", "" + Settings.getBackground(PERFORM_STACK_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.performstackselected.foreground.rgb", "" + Settings.getForeground(PERFORM_STACK_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.breakpointlist.font.name", Settings.getFont(BREAKPOINT_LIST).getName());
        sortedProperties.setProperty("graphdebugger.breakpointlist.font.style", "" + Settings.getFont(BREAKPOINT_LIST).getStyle());
        sortedProperties.setProperty("graphdebugger.breakpointlist.font.size", "" + Settings.getFont(BREAKPOINT_LIST).getSize());
        bl = Settings.isInheritFromLaf(BREAKPOINT_LIST);
        sortedProperties.setProperty("graphdebugger.breakpointlist.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.breakpointlist.background.rgb", "" + Settings.getBackground(BREAKPOINT_LIST).getRGB());
            sortedProperties.setProperty("graphdebugger.breakpointlist.foreground.rgb", "" + Settings.getForeground(BREAKPOINT_LIST).getRGB());
        }
        bl = Settings.isInheritFromLaf(BREAKPOINT_LIST_SELECTED);
        sortedProperties.setProperty("graphdebugger.breakpointlistselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.breakpointlistselected.background.rgb", "" + Settings.getBackground(BREAKPOINT_LIST_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.breakpointlistselected.foreground.rgb", "" + Settings.getForeground(BREAKPOINT_LIST_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.threadlist.font.name", Settings.getFont(THREAD_LIST).getName());
        sortedProperties.setProperty("graphdebugger.threadlist.font.style", "" + Settings.getFont(THREAD_LIST).getStyle());
        sortedProperties.setProperty("graphdebugger.threadlist.font.size", "" + Settings.getFont(THREAD_LIST).getSize());
        bl = Settings.isInheritFromLaf(THREAD_LIST);
        sortedProperties.setProperty("graphdebugger.threadlist.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.threadlist.background.rgb", "" + Settings.getBackground(THREAD_LIST).getRGB());
            sortedProperties.setProperty("graphdebugger.threadlist.foreground.rgb", "" + Settings.getForeground(THREAD_LIST).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.monitorlist.font.name", Settings.getFont(MONITOR_LIST).getName());
        sortedProperties.setProperty("graphdebugger.monitorlist.font.style", "" + Settings.getFont(MONITOR_LIST).getStyle());
        sortedProperties.setProperty("graphdebugger.monitorlist.font.size", "" + Settings.getFont(MONITOR_LIST).getSize());
        bl = Settings.isInheritFromLaf(MONITOR_LIST);
        sortedProperties.setProperty("graphdebugger.monitorlist.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.monitorlist.background.rgb", "" + Settings.getBackground(MONITOR_LIST).getRGB());
            sortedProperties.setProperty("graphdebugger.monitorlist.foreground.rgb", "" + Settings.getForeground(MONITOR_LIST).getRGB());
        }
        bl = Settings.isInheritFromLaf(MONITOR_LIST_SELECTED);
        sortedProperties.setProperty("graphdebugger.monitorlistselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.monitorlistselected.background.rgb", "" + Settings.getBackground(MONITOR_LIST_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.monitorlistselected.foreground.rgb", "" + Settings.getForeground(MONITOR_LIST_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.cmdhistory.font.name", Settings.getFont(CMD_HISTORY).getName());
        sortedProperties.setProperty("graphdebugger.cmdhistory.font.style", "" + Settings.getFont(CMD_HISTORY).getStyle());
        sortedProperties.setProperty("graphdebugger.cmdhistory.font.size", "" + Settings.getFont(CMD_HISTORY).getSize());
        bl = Settings.isInheritFromLaf(CMD_HISTORY);
        sortedProperties.setProperty("graphdebugger.cmdhistory.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.cmdhistory.background.rgb", "" + Settings.getBackground(CMD_HISTORY).getRGB());
            sortedProperties.setProperty("graphdebugger.cmdhistory.foreground.rgb", "" + Settings.getForeground(CMD_HISTORY).getRGB());
        }
        bl = Settings.isInheritFromLaf(CMD_HISTORY_SELECTED);
        sortedProperties.setProperty("graphdebugger.cmdhistoryselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.cmdhistoryselected.background.rgb", "" + Settings.getBackground(CMD_HISTORY_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.cmdhistoryselected.foreground.rgb", "" + Settings.getForeground(CMD_HISTORY_SELECTED).getRGB());
        }
        sortedProperties.setProperty("graphdebugger.displaytree.font.name", Settings.getFont(DISPLAY_TREE).getName());
        sortedProperties.setProperty("graphdebugger.displaytree.font.style", "" + Settings.getFont(DISPLAY_TREE).getStyle());
        sortedProperties.setProperty("graphdebugger.displaytree.font.size", "" + Settings.getFont(DISPLAY_TREE).getSize());
        bl = Settings.isInheritFromLaf(DISPLAY_TREE);
        sortedProperties.setProperty("graphdebugger.displaytree.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.displaytree.background.rgb", "" + Settings.getBackground(DISPLAY_TREE).getRGB());
            sortedProperties.setProperty("graphdebugger.displaytree.foreground.rgb", "" + Settings.getForeground(DISPLAY_TREE).getRGB());
        }
        bl = Settings.isInheritFromLaf(DISPLAY_TREE_SELECTED);
        sortedProperties.setProperty("graphdebugger.displaytreeselected.def_laf", "" + bl);
        if (!bl) {
            sortedProperties.setProperty("graphdebugger.displaytreeselected.background.rgb", "" + Settings.getBackground(DISPLAY_TREE_SELECTED).getRGB());
            sortedProperties.setProperty("graphdebugger.displaytreeselected.foreground.rgb", "" + Settings.getForeground(DISPLAY_TREE_SELECTED).getRGB());
        }
        sortedProperties.setProperty(COPY_SOURCE_PATTERN_PROP, copySourcePattern);
        sortedProperties.putAll((Map<?, ?>)commandAliasis);
        sortedProperties.putAll((Map<?, ?>)shortcuts);
        try (PrintStream printStream = null;){
            printStream = new PrintStream(new FileOutputStream(IS_DEBUGGER_PROPERTIES));
            sortedProperties.store(printStream, "Debugger settings");
        }
    }

    public static int[] getShortcutParams(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(32);
        if (n4 >= 0 && n4 < string.length() - 1) {
            try {
                n2 = Integer.parseInt(string.substring(0, n4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n3 = Integer.parseInt(string.substring(n4 + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{n2, n3};
    }

    public static boolean isShowConsole() {
        return showConsole;
    }

    public static void setShowConsole(boolean bl) {
        showConsole = bl;
    }

    public static boolean isConsoleAttached() {
        return consoleAttached;
    }

    public static void setConsoleAttached(boolean bl) {
        consoleAttached = bl;
    }

    public static boolean getExitAfterTermination() {
        return exitAfterTermination;
    }

    public static void setExitAfterTermination(boolean bl) {
        exitAfterTermination = bl;
    }

    static {
        htSettings = new HashMap<String, FontAndColors>();
        commandAliasis = new Properties();
        shortcuts = new Properties();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        isNimbus = lookAndFeel != null ? "Nimbus".equals(lookAndFeel.getName()) : false;
        String string = Thread.currentThread().getName();
        Config.c();
        IS_DEBUGGER_PROPERTIES = Config.a("iscobol.debug.propfile", System.getProperty("user.home") + File.separator + "isdebugger.properties");
        Thread.currentThread().setName(string);
        Properties properties = new Properties();
        try {
            RtsUtil.loadProperties(properties, IS_DEBUGGER_PROPERTIES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        commandAliasis.setProperty("debugger.commands.alias.f", properties.getProperty("debugger.commands.alias.f", "f"));
        commandAliasis.setProperty("debugger.commands.alias.fb", properties.getProperty("debugger.commands.alias.fb", "fb"));
        commandAliasis.setProperty("debugger.commands.alias.ff", properties.getProperty("debugger.commands.alias.ff", "ff"));
        commandAliasis.setProperty("debugger.commands.alias.ft", properties.getProperty("debugger.commands.alias.ft", "ft"));
        commandAliasis.setProperty("debugger.commands.alias.stoff", properties.getProperty("debugger.commands.alias.stoff", "stoff"));
        commandAliasis.setProperty("debugger.commands.alias.ston", properties.getProperty("debugger.commands.alias.ston", "ston"));
        commandAliasis.setProperty("debugger.commands.alias.w0", properties.getProperty("debugger.commands.alias.w0", "w0"));
        commandAliasis.setProperty("debugger.commands.alias.wb", properties.getProperty("debugger.commands.alias.wb", "wb"));
        commandAliasis.setProperty("debugger.commands.alias.wt", properties.getProperty("debugger.commands.alias.wt", "wt"));
        commandAliasis.setProperty("debugger.commands.alias.w@", properties.getProperty("debugger.commands.alias.w@", "w@"));
        commandAliasis.setProperty("debugger.commands.alias.b0", properties.getProperty("debugger.commands.alias.b0", "b0"));
        commandAliasis.setProperty("debugger.commands.alias.break", properties.getProperty("debugger.commands.alias.break", "break"));
        commandAliasis.setProperty("debugger.commands.alias.clear", properties.getProperty("debugger.commands.alias.clear", "clear"));
        commandAliasis.setProperty("debugger.commands.alias.continue", properties.getProperty("debugger.commands.alias.continue", "continue"));
        commandAliasis.setProperty("debugger.commands.alias.display", properties.getProperty("debugger.commands.alias.display", "display"));
        commandAliasis.setProperty("debugger.commands.alias.down", properties.getProperty("debugger.commands.alias.down", "down"));
        commandAliasis.setProperty("debugger.commands.alias.env", properties.getProperty("debugger.commands.alias.env", "env"));
        commandAliasis.setProperty("debugger.commands.alias.exit", properties.getProperty("debugger.commands.alias.exit", "exit"));
        commandAliasis.setProperty("debugger.commands.alias.gc", properties.getProperty("debugger.commands.alias.gc", "gc"));
        commandAliasis.setProperty("debugger.commands.alias.help", properties.getProperty("debugger.commands.alias.help", "help"));
        commandAliasis.setProperty("debugger.commands.alias.infostack", properties.getProperty("debugger.commands.alias.infostack", "infostack"));
        commandAliasis.setProperty("debugger.commands.alias.jump", properties.getProperty("debugger.commands.alias.jump", "jump"));
        commandAliasis.setProperty("debugger.commands.alias.let", properties.getProperty("debugger.commands.alias.let", "let"));
        commandAliasis.setProperty("debugger.commands.alias.line", properties.getProperty("debugger.commands.alias.line", "line"));
        commandAliasis.setProperty("debugger.commands.alias.list", properties.getProperty("debugger.commands.alias.list", "list"));
        commandAliasis.setProperty("debugger.commands.alias.m0", properties.getProperty("debugger.commands.alias.m0", "m0"));
        commandAliasis.setProperty("debugger.commands.alias.memory", properties.getProperty("debugger.commands.alias.memory", "memory"));
        commandAliasis.setProperty("debugger.commands.alias.monitor", properties.getProperty("debugger.commands.alias.monitor", "monitor"));
        commandAliasis.setProperty("debugger.commands.alias.next", properties.getProperty("debugger.commands.alias.next", "next"));
        commandAliasis.setProperty("debugger.commands.alias.outpar", properties.getProperty("debugger.commands.alias.outpar", "outpar"));
        commandAliasis.setProperty("debugger.commands.alias.outprog", properties.getProperty("debugger.commands.alias.outprog", "outprog"));
        commandAliasis.setProperty("debugger.commands.alias.pause", properties.getProperty("debugger.commands.alias.pause", "pause"));
        commandAliasis.setProperty("debugger.commands.alias.prog", properties.getProperty("debugger.commands.alias.prog", "prog"));
        commandAliasis.setProperty("debugger.commands.alias.quit", properties.getProperty("debugger.commands.alias.quit", "quit"));
        commandAliasis.setProperty("debugger.commands.alias.readsession", properties.getProperty("debugger.commands.alias.readsession", "readsession"));
        commandAliasis.setProperty("debugger.commands.alias.run", properties.getProperty("debugger.commands.alias.run", "run"));
        commandAliasis.setProperty("debugger.commands.alias.step", properties.getProperty("debugger.commands.alias.step", "step"));
        commandAliasis.setProperty("debugger.commands.alias.thread", properties.getProperty("debugger.commands.alias.thread", "thread"));
        commandAliasis.setProperty("debugger.commands.alias.to", properties.getProperty("debugger.commands.alias.to", "to"));
        commandAliasis.setProperty("debugger.commands.alias.troff", properties.getProperty("debugger.commands.alias.troff", "troff"));
        commandAliasis.setProperty("debugger.commands.alias.tron", properties.getProperty("debugger.commands.alias.tron", "tron"));
        commandAliasis.setProperty("debugger.commands.alias.unmonitor", properties.getProperty("debugger.commands.alias.unmonitor", "unmonitor"));
        commandAliasis.setProperty("debugger.commands.alias.up", properties.getProperty("debugger.commands.alias.up", "up"));
        commandAliasis.setProperty("debugger.commands.alias.writesession", properties.getProperty("debugger.commands.alias.writesession", "writesession"));
        commandAliasis.setProperty("debugger.commands.alias.length", properties.getProperty("debugger.commands.alias.length", "length"));
        commandAliasis.setProperty("debugger.commands.alias.offset", properties.getProperty("debugger.commands.alias.offset", "offset"));
        shortcuts.setProperty(SET_BREAKPOINT_SHORTCUT, properties.getProperty(SET_BREAKPOINT_SHORTCUT, "2 66"));
        shortcuts.setProperty(CONTINUE_SHORTCUT, properties.getProperty(CONTINUE_SHORTCUT, "2 116"));
        shortcuts.setProperty(CLEAR_OUTPUT_SHORTCUT, properties.getProperty(CLEAR_OUTPUT_SHORTCUT, "8 114"));
        shortcuts.setProperty(CURRENT_LINE_SHORTCUT, properties.getProperty(CURRENT_LINE_SHORTCUT, "3 67"));
        shortcuts.setProperty(DECREMENT_FONT_SHORTCUT, properties.getProperty(DECREMENT_FONT_SHORTCUT, "2 45"));
        shortcuts.setProperty(DISPLAY_SHORTCUT, properties.getProperty(DISPLAY_SHORTCUT, "2 68"));
        shortcuts.setProperty(DISPLAY_SEL_LINE_VARS_SHORTCUT, properties.getProperty(DISPLAY_SEL_LINE_VARS_SHORTCUT, "113"));
        shortcuts.setProperty(EXIT_SHORTCUT, properties.getProperty(EXIT_SHORTCUT, "8 115"));
        shortcuts.setProperty(FIND_BACKWARD_SHORTCUT, properties.getProperty(FIND_BACKWARD_SHORTCUT, "3 75"));
        shortcuts.setProperty(FIND_FORWARD_SHORTCUT, properties.getProperty(FIND_FORWARD_SHORTCUT, "2 75"));
        shortcuts.setProperty(FIND_FROM_TOP_SHORTCUT, properties.getProperty(FIND_FROM_TOP_SHORTCUT, "2 84"));
        shortcuts.setProperty(FIND_SHORTCUT, properties.getProperty(FIND_SHORTCUT, "2 70"));
        shortcuts.setProperty(FIRST_EXEC_LINE_SHORTCUT, properties.getProperty(FIRST_EXEC_LINE_SHORTCUT, "3 69"));
        shortcuts.setProperty(FIRST_LINE_SHORTCUT, properties.getProperty(FIRST_LINE_SHORTCUT, "3 70"));
        shortcuts.setProperty(GOTO_SHORTCUT, properties.getProperty(GOTO_SHORTCUT, "2 71"));
        shortcuts.setProperty(GOTO_DECL_SHORTCUT, properties.getProperty(GOTO_DECL_SHORTCUT, "123"));
        shortcuts.setProperty(BACK_SHORTCUT, properties.getProperty(BACK_SHORTCUT, "8 37"));
        shortcuts.setProperty(FORWARD_SHORTCUT, properties.getProperty(FORWARD_SHORTCUT, "8 39"));
        shortcuts.setProperty(HELP_SHORTCUT, properties.getProperty(HELP_SHORTCUT, "112"));
        shortcuts.setProperty(INCREMENT_FONT_SHORTCUT, properties.getProperty(INCREMENT_FONT_SHORTCUT, "2 521"));
        shortcuts.setProperty(JUMP_SHORTCUT, properties.getProperty(JUMP_SHORTCUT, "2 74"));
        shortcuts.setProperty(JUMP_OVER_SHORTCUT, properties.getProperty(JUMP_OVER_SHORTCUT, "1 121"));
        shortcuts.setProperty(JUMP_OUT_PAR_SHORTCUT, properties.getProperty(JUMP_OUT_PAR_SHORTCUT, "9 121"));
        shortcuts.setProperty(JUMP_OUT_PROG_SHORTCUT, properties.getProperty(JUMP_OUT_PROG_SHORTCUT, "9 122"));
        shortcuts.setProperty(JUMP_TO_SEL_LINE_SHORTCUT, properties.getProperty(JUMP_TO_SEL_LINE_SHORTCUT, "1 122"));
        shortcuts.setProperty(LAST_COMMAND_SHORTCUT, properties.getProperty(LAST_COMMAND_SHORTCUT, "2 119"));
        shortcuts.setProperty(LAST_LINE_SHORTCUT, properties.getProperty(LAST_LINE_SHORTCUT, "3 76"));
        shortcuts.setProperty(PREV_COMMAND_SHORTCUT, properties.getProperty(PREV_COMMAND_SHORTCUT, "2 38"));
        shortcuts.setProperty(NEXT_COMMAND_SHORTCUT, properties.getProperty(NEXT_COMMAND_SHORTCUT, "2 40"));
        shortcuts.setProperty(LET_SHORTCUT, properties.getProperty(LET_SHORTCUT, "3 65"));
        shortcuts.setProperty(LOAD_FILE_SHORTCUT, properties.getProperty(LOAD_FILE_SHORTCUT, "2 76"));
        shortcuts.setProperty(REPEAT_FIND_SHORTCUT, properties.getProperty(REPEAT_FIND_SHORTCUT, "114"));
        shortcuts.setProperty(SET_MONITOR_SHORTCUT, properties.getProperty(SET_MONITOR_SHORTCUT, "2 77"));
        shortcuts.setProperty(STEP_OVER_SHORTCUT, properties.getProperty(STEP_OVER_SHORTCUT, "1 118"));
        shortcuts.setProperty(STEP_OUT_PAR_SHORTCUT, properties.getProperty(STEP_OUT_PAR_SHORTCUT, "9 118"));
        shortcuts.setProperty(STEP_OUT_PROG_SHORTCUT, properties.getProperty(STEP_OUT_PROG_SHORTCUT, "9 119"));
        shortcuts.setProperty(QUICK_WATCH_SHORTCUT, properties.getProperty(QUICK_WATCH_SHORTCUT, "2 81"));
        shortcuts.setProperty(REFRESH_VARIABLES_AREA_SHORTCUT, properties.getProperty(REFRESH_VARIABLES_AREA_SHORTCUT, "0 116"));
        shortcuts.setProperty(QUIT_SHORTCUT, properties.getProperty(QUIT_SHORTCUT, "1 116"));
        shortcuts.setProperty(RUN_SHORTCUT, properties.getProperty(RUN_SHORTCUT, "2 117"));
        shortcuts.setProperty(STEP_INTO_SHORTCUT, properties.getProperty(STEP_INTO_SHORTCUT, "118"));
        shortcuts.setProperty(STOP_AUTOSTEP_SHORTCUT, properties.getProperty(STOP_AUTOSTEP_SHORTCUT, "2 115"));
        shortcuts.setProperty(START_AUTOSTEP_SHORTCUT, properties.getProperty(START_AUTOSTEP_SHORTCUT, "2 114"));
        shortcuts.setProperty(STEP_TO_SHORTCUT, properties.getProperty(STEP_TO_SHORTCUT, "2 120"));
        shortcuts.setProperty(TOGGLE_BREAKPOINT_SHORTCUT, properties.getProperty(TOGGLE_BREAKPOINT_SHORTCUT, "115"));
        shortcuts.setProperty(STEP_TO_SEL_LINE_SHORTCUT, properties.getProperty(STEP_TO_SEL_LINE_SHORTCUT, "120"));
        shortcuts.setProperty(STEP_TO_PROGRAM_SHORTCUT, properties.getProperty(STEP_TO_PROGRAM_SHORTCUT, "8 120"));
        shortcuts.setProperty(STOP_TRACING_SHORTCUT, properties.getProperty(STOP_TRACING_SHORTCUT, "1 115"));
        shortcuts.setProperty(START_TRACING_SHORTCUT, properties.getProperty(START_TRACING_SHORTCUT, "1 114"));
        shortcuts.setProperty(UNLOAD_FILE_SHORTCUT, properties.getProperty(UNLOAD_FILE_SHORTCUT, "2 85"));
        copySourcePattern = properties.getProperty(COPY_SOURCE_PATTERN_PROP, Integer.toString(new Color(235, 235, 235).getRGB()) + ";" + Integer.toString(new Color(225, 225, 225).getRGB()) + ";" + Integer.toString(new Color(215, 215, 215).getRGB()));
        maxHexDumpLength = Settings.getPropInt(properties, MAX_HEX_DUMP_LENGTH_PROP, 256);
        hexDumpStartOffset = Settings.getPropInt(properties, HEX_DUMP_START_PROP, 1);
        maxArrayLength = Settings.getPropInt(properties, MAX_ARRAY_LENGTH_PROP, 25);
        arrayStartOffset = Settings.getPropInt(properties, ARRAY_START_PROP, 1);
        maxTextValueLength = Settings.getPropInt(properties, MAX_TEXT_VALUE_LENGTH_PROP, 512);
        maxTextValueLengthOutput = Settings.getPropInt(properties, MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP, 1024);
        hexOption = Settings.getPropInt(properties, HEX_PROP, 0) == 1;
        autoSave = Settings.getPropInt(properties, AUTOSAVE_PROP, 0) == 1;
        consoleAttached = Settings.getPropInt(properties, CONSOLE_ATTACHED_PROP, 1) == 1;
        showConsole = Settings.getPropInt(properties, SHOW_CONSOLE_PROP, 0) == 1;
        sessionOutputFileName = properties.getProperty(SESSION_FILENAME_PROP, "");
        askConfirmWhenQuit = Settings.getPropInt(properties, ASK_QUIT_CONFIRM_PROP, 0) == 1;
        askConfirmWhenExit = Settings.getPropInt(properties, ASK_EXIT_CONFIRM_PROP, 0) == 1;
        exitAfterTermination = Settings.getPropInt(properties, EXIT_AFTER_TERMINATION_PROP, 0) == 1;
        autoConnect = Settings.getPropInt(properties, AUTOCONNECT_PROP, 0) == 1;
        autoConnectDelay = Settings.getPropInt(properties, AUTOCONNECT_DELAY_PROP, 3);
        forceStopRun = Settings.getPropInt(properties, FORCE_STOP_RUN_PROP, 0) == 1;
        mainSplitPaneDividerLocation = Settings.getPropInt(properties, MAIN_SPLITPANE_DIV_LOC_PROP, -1);
        outputSplitPaneDividerLocation = Settings.getPropInt(properties, OUTPUT_SPLITPANE_DIV_LOC_PROP, -1);
        sourceSplitPaneDividerLocation = Settings.getPropInt(properties, SRC_SPLITPANE_DIV_LOC_PROP, -1);
        variableSplitPaneDividerLocation = Settings.getPropInt(properties, VAR_SPLITPANE_DIV_LOC_PROP, -1);
        monitorTableNameColumnWidth = Settings.getPropInt(properties, MONITOR_LIST_COL_NAME_WIDTH_PROP, -1);
        monitorTableValueColumnWidth = Settings.getPropInt(properties, MONITOR_LIST_COL_VALUE_WIDTH_PROP, -1);
        callStackTableParagraphColumnWidth = Settings.getPropInt(properties, PERFORM_STACK_COL_PAR_WIDTH_PROP, -1);
        callStackTableLocationColumnWidth = Settings.getPropInt(properties, PERFORM_STACK_COL_LOC_WIDTH_PROP, -1);
        callStackTableProgramColumnWidth = Settings.getPropInt(properties, PERFORM_STACK_COL_PROG_WIDTH_PROP, -1);
        threadTableNameColumnWidth = Settings.getPropInt(properties, THREAD_LIST_COL_NAME_WIDTH_PROP, -1);
        threadTableParagraphColumnWidth = Settings.getPropInt(properties, THREAD_LIST_COL_PAR_WIDTH_PROP, -1);
        threadTableProgramColumnWidth = Settings.getPropInt(properties, THREAD_LIST_COL_PROG_WIDTH_PROP, -1);
        variableHintDelay = Settings.getPropInt(properties, DISPLAY_VAR_TOOLTIP_DELAY_PROP, 800);
        variableHandMouseDelay = Settings.getPropInt(properties, VAR_HAND_MOUSE_DELAY_PROP, 800);
        variableHintEnabled = Settings.getPropInt(properties, DISPLAY_VAR_TOOLTIP_ENABLED_PROP, 1) == 1;
        variableHandMouseEnabled = Settings.getPropInt(properties, VAR_HAND_MOUSE_ENABLED_PROP, 1) == 1;
        windowState = Settings.getPropInt(properties, WINDOW_STATE_PROP, 0);
        defaultBreakpointEnabledState = Settings.getPropInt(properties, BREAKPOINT_DEFAULT_EN_STATE_PROP, 1) == 1;
        defaultMonitorEnabledState = Settings.getPropInt(properties, MONITOR_DEFAULT_EN_STATE_PROP, 0) == 1;
        windowBounds = new Rectangle();
        Settings.windowBounds.x = Settings.getPropInt(properties, WINDOW_X_PROP, -1);
        Settings.windowBounds.y = Settings.getPropInt(properties, WINDOW_Y_PROP, -1);
        Settings.windowBounds.width = Settings.getPropInt(properties, WINDOW_WIDTH_PROP, 900);
        Settings.windowBounds.height = Settings.getPropInt(properties, WINDOW_HEIGHT_PROP, 800);
        sourceFormat = Settings.getPropInt(properties, SOURCE_FORMAT_PROP, 0);
        findMatchCase = Settings.getPropInt(properties, FIND_MATCH_CASE_PROP, 0) == 1;
        findWholeWord = Settings.getPropInt(properties, FIND_WHOLE_WORD_PROP, 0) == 1;
        findMatchMinusUnderscore = Settings.getPropInt(properties, FIND_MATCH_MIN_UND_PROP, 0) == 1;
        findBackwardSearch = Settings.getPropInt(properties, FIND_BACKWARD_SEARCH_PROP, 0) == 1;
        findWrapSearch = Settings.getPropInt(properties, FIND_WRAP_PROP, 0) == 1;
        findTopSearch = Settings.getPropInt(properties, FIND_TOP_SEARCH_PROP, 0) == 1;
        expandCopiesOnLoad = Settings.getPropInt(properties, EXPAND_COPY_ON_LOAD_PROP, 0) == 1;
        ArrayList<FontAndColors> arrayList = new ArrayList<FontAndColors>();
        FontAndColors fontAndColors = new FontAndColors(null, SOURCE_CODE, new Font(properties.getProperty("graphdebugger.sourcecode.font.name", "monospaced"), Settings.getPropInt(properties, "graphdebugger.sourcecode.font.style", 0), Settings.getPropInt(properties, "graphdebugger.sourcecode.font.size", 12)), Settings.getPropColor(properties, "graphdebugger.sourcecode.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.sourcecode.foreground.rgb", Color.black));
        arrayList.add(new FontAndColors(fontAndColors, BREAKPOINT_COLUMN, null, Settings.getPropColor(properties, "graphdebugger.breakpointcolumn.background.rgb", new Color(153, 186, 243)), null));
        arrayList.add(new FontAndColors(fontAndColors, BREAKPOINT_LINE, null, Settings.getPropColor(properties, "graphdebugger.breakpointline.background.rgb", new Color(255, 227, 189)), null));
        FontAndColors fontAndColors2 = new FontAndColors(null, BREAKPOINT_LIST, new Font(properties.getProperty("graphdebugger.breakpointlist.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.breakpointlist.font.style", 0), Settings.getPropInt(properties, "graphdebugger.breakpointlist.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.breakpointlist.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.breakpointlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, BREAKPOINT_LIST_PROP), ControlType.LIST);
        arrayList.add(fontAndColors2);
        arrayList.add(new FontAndColors(fontAndColors2, BREAKPOINT_LIST_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.breakpointlistselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.breakpointlistselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, BREAKPOINT_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        FontAndColors fontAndColors3 = new FontAndColors(null, CMD_HISTORY, new Font(properties.getProperty("graphdebugger.cmdhistory.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.cmdhistory.font.style", 0), Settings.getPropInt(properties, "graphdebugger.cmdhistory.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.cmdhistory.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.cmdhistory.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, CMD_HISTORY_PROP), ControlType.LIST);
        arrayList.add(fontAndColors3);
        arrayList.add(new FontAndColors(fontAndColors3, CMD_HISTORY_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.cmdhistoryselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.cmdhistoryselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, CMD_HISTORY_SELECTED_PROP), ControlType.LIST_SELECTED));
        arrayList.add(new FontAndColors(fontAndColors, COMMENTS, null, null, Settings.getPropColor(properties, "graphdebugger.comments.foreground.rgb", new Color(128, 128, 0))));
        FontAndColors fontAndColors4 = new FontAndColors(null, CONSOLE, new Font(properties.getProperty("graphdebugger.console.font.name", "monospaced"), Settings.getPropInt(properties, "graphdebugger.console.font.style", 0), Settings.getPropInt(properties, "graphdebugger.console.font.size", 12)), Settings.getPropColor(properties, "graphdebugger.console.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.console.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, CONSOLE_PROP), ControlType.TEXT_AREA);
        arrayList.add(fontAndColors4);
        arrayList.add(new FontAndColors(fontAndColors4, CONSOLE_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.consoleselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.consoleselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, CONSOLE_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        arrayList.add(new FontAndColors(fontAndColors4, CONSOLE_STDERR, null, null, Settings.getPropColor(properties, "graphdebugger.consolestderr.foreground.rgb", Color.red)));
        FontAndColors fontAndColors5 = new FontAndColors(fontAndColors, COPY_SOURCE, null, null, null);
        arrayList.add(fontAndColors5);
        StringTokenizer stringTokenizer = new StringTokenizer(copySourcePattern, ";");
        FontAndColors[] fontAndColorsArray = new FontAndColors[stringTokenizer.countTokens()];
        int n2 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            fontAndColorsArray[n2 - 1] = new FontAndColors(fontAndColors, COPY_SOURCE_COLOR_PATTERN_PREFIX + n2++, null, new Color(Integer.parseInt(stringTokenizer.nextToken())), null);
        }
        fontAndColors5.setChildren(fontAndColorsArray);
        arrayList.add(new FontAndColors(fontAndColors, CURRENT_LINE, null, Settings.getPropColor(properties, "graphdebugger.currentline.background.rgb", Color.yellow), Settings.getPropColor(properties, "graphdebugger.currentline.foreground.rgb", Color.black)));
        FontAndColors fontAndColors6 = new FontAndColors(null, DISPLAY_TREE, new Font(properties.getProperty("graphdebugger.displaytree.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.displaytree.font.style", 0), Settings.getPropInt(properties, "graphdebugger.displaytree.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.displaytree.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.displaytree.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, DISPLAY_TREE_PROP), ControlType.LIST);
        arrayList.add(fontAndColors6);
        arrayList.add(new FontAndColors(fontAndColors6, DISPLAY_TREE_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.displaytreeselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.displaytreeselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, DISPLAY_TREE_SELECTED_PROP), ControlType.LIST_SELECTED));
        arrayList.add(new FontAndColors(fontAndColors, FIGURATIVE_CONSTS, null, null, Settings.getPropColor(properties, "graphdebugger.figurativeconsts.foreground.rgb", new Color(204, 102, 0))));
        arrayList.add(new FontAndColors(fontAndColors, HIGHLIGHTED_BY_SEARCH, null, Settings.getPropColor(properties, "graphdebugger.highlightedbysearch.background.rgb", new Color(49, 106, 197)), Settings.getPropColor(properties, "graphdebugger.highlightedbysearch.foreground.rgb", Color.white)));
        arrayList.add(new FontAndColors(fontAndColors, KEYWORDS, null, null, Settings.getPropColor(properties, "graphdebugger.keywords.foreground.rgb", new Color(0, 0, 255))));
        arrayList.add(new FontAndColors(fontAndColors, LEV_NUMS, null, null, Settings.getPropColor(properties, "graphdebugger.levelnumbers.foreground.rgb", new Color(204, 0, 204))));
        FontAndColors fontAndColors7 = new FontAndColors(null, LINE_COMMAND, new Font(properties.getProperty("graphdebugger.linecommand.font.name", "monospaced"), Settings.getPropInt(properties, "graphdebugger.linecommand.font.style", 0), Settings.getPropInt(properties, "graphdebugger.linecommand.font.size", 12)), Settings.getPropColor(properties, "graphdebugger.linecommand.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.linecommand.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, LINE_COMMAND_PROP), ControlType.TEXT_AREA);
        arrayList.add(fontAndColors7);
        arrayList.add(new FontAndColors(fontAndColors7, LINE_COMMAND_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.linecommandselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.linecommandselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, LINE_COMMAND_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        arrayList.add(new FontAndColors(fontAndColors, LINE_NUMBER_COLUMN, null, Settings.getPropColor(properties, "graphdebugger.linenumbercolumn.background.rgb", new Color(236, 233, 216)), Settings.getPropColor(properties, "graphdebugger.linenumbercolumn.foreground.rgb", new Color(120, 120, 120))));
        FontAndColors fontAndColors8 = new FontAndColors(null, MONITOR_LIST, new Font(properties.getProperty("graphdebugger.monitorlist.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.monitorlist.font.style", 0), Settings.getPropInt(properties, "graphdebugger.monitorlist.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.monitorlist.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.monitorlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, MONITOR_LIST_PROP), ControlType.LIST);
        arrayList.add(fontAndColors8);
        arrayList.add(new FontAndColors(fontAndColors8, MONITOR_LIST_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.monitorlistselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.monitorlistselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, MONITOR_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        arrayList.add(new FontAndColors(fontAndColors, NUMBERS, null, null, Settings.getPropColor(properties, "graphdebugger.numbers.foreground.rgb", new Color(204, 0, 0))));
        FontAndColors fontAndColors9 = new FontAndColors(null, OUTPUT_AREA, new Font(properties.getProperty("graphdebugger.outputarea.font.name", "monospaced"), Settings.getPropInt(properties, "graphdebugger.outputarea.font.style", 0), Settings.getPropInt(properties, "graphdebugger.outputarea.font.size", 12)), Settings.getPropColor(properties, "graphdebugger.outputarea.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.outputarea.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, OUTPUT_AREA_PROP), ControlType.TEXT_AREA);
        arrayList.add(fontAndColors9);
        arrayList.add(new FontAndColors(fontAndColors9, OUTPUT_AREA_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.outputareaselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.outputareaselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, OUTPUT_AREA_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        FontAndColors fontAndColors10 = new FontAndColors(null, PERFORM_STACK, new Font(properties.getProperty("graphdebugger.performstack.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.performstack.font.style", 0), Settings.getPropInt(properties, "graphdebugger.performstack.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.performstack.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.performstack.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, PERFORM_STACK_PROP), ControlType.LIST);
        arrayList.add(fontAndColors10);
        arrayList.add(new FontAndColors(fontAndColors10, PERFORM_STACK_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.performstackselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(properties, "graphdebugger.performstackselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, PERFORM_STACK_SELECTED_PROP), ControlType.LIST_SELECTED));
        arrayList.add(fontAndColors);
        arrayList.add(new FontAndColors(fontAndColors, SOURCE_CODE_SELECTED, null, Settings.getPropColor(properties, "graphdebugger.selectedsource.background.rgb", new Color(232, 242, 254)), null));
        arrayList.add(new FontAndColors(fontAndColors, STATEMENTS, null, null, Settings.getPropColor(properties, "graphdebugger.statements.foreground.rgb", new Color(255, 0, 153))));
        arrayList.add(new FontAndColors(fontAndColors, STRINGS, null, null, Settings.getPropColor(properties, "graphdebugger.strings.foreground.rgb", new Color(0, 128, 0))));
        arrayList.add(new FontAndColors(null, THREAD_LIST, new Font(properties.getProperty("graphdebugger.threadlist.font.name", "dialog"), Settings.getPropInt(properties, "graphdebugger.threadlist.font.style", 0), Settings.getPropInt(properties, "graphdebugger.threadlist.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.threadlist.background.rgb", Color.white), Settings.getPropColor(properties, "graphdebugger.threadlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, THREAD_LIST_PROP), ControlType.LIST));
        arrayList.add(new FontAndColors(null, DISPLAY_VARIABLE_TOOLTIP, new Font(properties.getProperty("graphdebugger.variabletooltip.font.name", "sansserif"), Settings.getPropInt(properties, "graphdebugger.variabletooltip.font.style", 0), Settings.getPropInt(properties, "graphdebugger.variabletooltip.font.size", 10)), Settings.getPropColor(properties, "graphdebugger.variabletooltip.background.rgb", new Color(255, 255, 153)), Settings.getPropColor(properties, "graphdebugger.variabletooltip.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(properties, DISPLAY_VAR_TOOLTIP_PROP), ControlType.TOOLTIP));
        FontAndColors[] fontAndColorsArray2 = new FontAndColors[arrayList.size()];
        arrayList.toArray(fontAndColorsArray2);
        Settings.setSettings(fontAndColorsArray2);
        styles = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        stylesValues = new int[]{0, 2, 1, 3};
        fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static class FontAndColors {
        private FontAndColors superType;
        private String name;
        private Font font;
        private Color background;
        private Color foreground;
        private FontAndColors[] children;
        private final ControlType type;
        private boolean inheritFromLaf;
        private boolean modified;

        public FontAndColors(FontAndColors fontAndColors, String string, Font font, Color color, Color color2) {
            this(fontAndColors, string, font, color, color2, false, null);
        }

        public FontAndColors(FontAndColors fontAndColors, String string, Font font, Color color, Color color2, boolean bl, ControlType controlType) {
            this.superType = fontAndColors;
            this.name = string;
            this.font = font;
            this.background = color;
            this.foreground = color2;
            this.inheritFromLaf = bl;
            this.type = controlType;
        }

        public FontAndColors Clone() {
            FontAndColors fontAndColors = new FontAndColors(null, this.name, this.font, this.background, this.foreground, this.inheritFromLaf, this.type);
            return fontAndColors;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isModified() {
            return this.modified;
        }

        public void setModified(boolean bl) {
            this.modified = bl;
        }

        public void setFont(Font font) {
            if (!this.isFontInherited()) {
                this.font = font;
            }
        }

        public FontAndColors getSuper() {
            return this.superType;
        }

        public void setSuper(FontAndColors fontAndColors) {
            this.superType = fontAndColors;
        }

        public FontAndColors[] getChildren() {
            return this.children;
        }

        public void setChildren(FontAndColors[] fontAndColorsArray) {
            this.children = fontAndColorsArray;
        }

        public Font getFont() {
            if (this.font != null) {
                return this.font;
            }
            return this.superType.getFont();
        }

        public void setBackground(Color color) {
            if (!this.isBackgroundInherited()) {
                this.background = color;
            }
        }

        public Color getBackground() {
            if (this.inheritFromLaf && this.type != null) {
                return this.type.getBackground();
            }
            if (this.background != null) {
                return this.background;
            }
            return this.superType.getBackground();
        }

        public void setForeground(Color color) {
            if (!this.isForegroundInherited()) {
                this.foreground = color;
            }
        }

        public Color getForeground() {
            if (this.inheritFromLaf && this.type != null) {
                return this.type.getForeground();
            }
            if (this.foreground != null) {
                return this.foreground;
            }
            return this.superType.getForeground();
        }

        public void setInheritFromLaf(boolean bl) {
            this.inheritFromLaf = bl;
        }

        public boolean isInheritFromLaf() {
            return this.inheritFromLaf;
        }

        public boolean isFontInherited() {
            return this.font == null;
        }

        public boolean isBackgroundInherited() {
            return this.background == null;
        }

        public boolean isForegroundInherited() {
            return this.foreground == null;
        }
    }

    private static enum ControlType {
        LIST,
        LIST_SELECTED,
        TEXT_AREA,
        TEXT_AREA_SELECTED,
        TOOLTIP;


        public Color getBackground() {
            Color color;
            switch (this) {
                default: {
                    color = Color.white;
                    break;
                }
                case LIST: {
                    color = UIManager.getColor("List.background");
                    if (color != null) break;
                    color = Color.white;
                    break;
                }
                case LIST_SELECTED: {
                    color = UIManager.getColor(isNimbus ? "List[Selected].textBackground" : "List.selectionBackground");
                    if (color != null) break;
                    color = new Color(204, 204, 255);
                    break;
                }
                case TEXT_AREA: {
                    color = UIManager.getColor("TextArea.background");
                    if (color != null) break;
                    color = Color.white;
                    break;
                }
                case TEXT_AREA_SELECTED: {
                    color = UIManager.getColor(isNimbus ? "TextArea[Selected].backgroundPainter" : "TextArea.selectionBackground");
                    if (color != null) break;
                    color = new Color(204, 204, 255);
                    break;
                }
                case TOOLTIP: {
                    color = UIManager.getColor("ToolTip.background");
                    if (color != null) break;
                    color = new Color(255, 255, 153);
                }
            }
            return color;
        }

        public Color getForeground() {
            Color color;
            switch (this) {
                default: {
                    color = null;
                    break;
                }
                case LIST: {
                    color = UIManager.getColor("List.foreground");
                    break;
                }
                case LIST_SELECTED: {
                    color = UIManager.getColor(isNimbus ? "List[Selected].textForeground" : "List.selectionForeground");
                    break;
                }
                case TEXT_AREA: {
                    color = UIManager.getColor("TextArea.foreground");
                    break;
                }
                case TEXT_AREA_SELECTED: {
                    color = UIManager.getColor(isNimbus ? "TextArea[Selected].textForeground" : "TextArea.selectionForeground");
                    break;
                }
                case TOOLTIP: {
                    color = UIManager.getColor("ToolTip.foreground");
                }
            }
            if (color == null) {
                color = Color.black;
            }
            return color;
        }
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> enumeration = super.keys();
            Vector<Object> vector = new Vector<Object>();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            Collections.sort(vector);
            return vector.elements();
        }
    }
}

