/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.Listing;
import com.iscobol.debugger.ListingException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextFile {
    private String[] lines;
    private int numLines;
    private int maxLineWidth;
    private String longestLine = "";
    private Filename filename;
    private long timestamp;
    private int currLine;
    private Listing listing;
    private String className;
    private DebugParagraph[] debugParagraphs;
    private DebugLine[] debugLines;
    private String[] filenames;
    private String fileNotFound;
    private boolean supportingJumpCommand;
    private char hyphenRepl = (char)95;

    public TextFile(String string) {
        this.filename = new Filename("");
        String string2 = string != null ? string : "                                                    ";
        this.lines = new String[]{string2};
        this.longestLine = string2;
        this.numLines = this.lines.length;
        this.maxLineWidth = this.longestLine.length();
    }

    public TextFile(FileLoader fileLoader, DebugResponse.DebugInfo debugInfo, Filename filename, long l2, boolean bl) {
        this.filename = filename;
        this.timestamp = l2;
        boolean bl2 = this.supportingJumpCommand = debugInfo != null ? debugInfo.isJumpCommandSupported() : false;
        if (bl && debugInfo != null) {
            String[] stringArray;
            this.debugParagraphs = debugInfo.getParagraphs();
            this.debugLines = debugInfo.getLines();
            this.filenames = debugInfo.getFilenames();
            this.className = debugInfo.getClassName();
            this.hyphenRepl = debugInfo.getHyphenReplacingChar();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : stringArray = debugInfo.getCompilerOptions()) {
                String string2 = string.toLowerCase();
                if (string2.equals("-st") || string2.equals("-sa") || string2.equals("-sf") || string2.equals("-sv") || string2.equals("-sl") || string2.equals("-smat") || string2.equals("-xoldsmat")) {
                    hashSet.add(string);
                    continue;
                }
                if (!string2.startsWith("-ce=")) continue;
                string = TextFile.canonicalizePathList(string, debugInfo.getPathSeparator());
                hashSet.add(string);
            }
            if (debugInfo.getListingInfos() != null) {
                try {
                    DebugUtilities.setCompilerConsts(debugInfo.getCompilerProps(), false);
                    this.listing = new Listing(debugInfo.getListingInfos(), debugInfo.getInfoFormat(), debugInfo.getCopyfiles(), this.filename, fileLoader.getRemoteEncoding(), hashSet);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                try {
                    this.listing = new Listing(fileLoader, debugInfo.getCopyfiles(), this.filename, fileLoader.getRemoteEncoding(), hashSet);
                }
                catch (ListingException listingException) {
                    // empty catch block
                }
            }
        }
        if (this.listing != null) {
            this.lines = this.listing.getLines();
            this.longestLine = this.listing.getLongestLine();
        } else {
            try {
                this.lines = fileLoader.getLines(this.filename.getOrigName(), true);
                this.longestLine = fileLoader.getLongestLine(this.filename.getOrigName(), false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lines = new String[0];
                this.longestLine = "";
                this.fileNotFound = this.filename.getBaseName();
            }
        }
        this.numLines = this.lines.length;
        this.maxLineWidth = this.longestLine.length();
    }

    public boolean isSupportingJumpCommand() {
        return this.supportingJumpCommand;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public String[] getFilesNotFound() {
        String[] stringArray;
        if (this.listing != null) {
            stringArray = new String[this.listing.fileNotFoundList.size()];
            this.listing.fileNotFoundList.toArray(stringArray);
        } else {
            stringArray = this.fileNotFound != null ? new String[]{this.fileNotFound} : new String[]{};
        }
        return stringArray;
    }

    public String getLine(int n2, boolean bl) {
        return this.getLine(n2, bl, true);
    }

    public String getLine(int n2, boolean bl, boolean bl2) {
        String string = "";
        if (n2 >= 0 && n2 < this.numLines) {
            string = bl ? this.lines[n2].toUpperCase() : this.lines[n2];
            if (!bl2) {
                string = string.replaceAll("_", "-");
            }
            string = string.replaceAll("\t", "        ");
        } else {
            string = "";
        }
        return string;
    }

    public int toListingLine(int n2, Filename filename, int n3) {
        if (this.listing != null) {
            return this.listing.toListingLine(n2, filename, n3);
        }
        return n2 - 1;
    }

    public int toListingLine(int n2, int n3) {
        if (this.listing != null) {
            return this.listing.toListingLine(n2, n3);
        }
        return n2 - 1;
    }

    public CobolRef toCobolLine(int n2) {
        if (this.listing != null) {
            return this.listing.toCobolLine(n2);
        }
        return new CobolRef(n2 + 1, this.filename.getOrigName(), -1, -1, null);
    }

    public boolean isCopyStatement(int n2) {
        if (this.listing != null) {
            return this.listing.isCopyStatement(n2);
        }
        return false;
    }

    public String getLongestLine() {
        return this.longestLine;
    }

    public String getFilename() {
        return this.filename.getOrigName();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l2) {
        this.timestamp = l2;
    }

    public String getClassName() {
        return this.className;
    }

    public Filename[] getFilenames() {
        if (this.listing != null) {
            Vector vector = this.listing.getFiles();
            Filename[] filenameArray = new Filename[vector.size()];
            vector.toArray(filenameArray);
            return filenameArray;
        }
        return new Filename[]{this.filename};
    }

    public void setCurrLine(int n2) {
        this.currLine = n2;
    }

    public int getCurrLine() {
        return this.currLine;
    }

    public DebugParagraph[] getDebugParagraphs() {
        return this.debugParagraphs;
    }

    public DebugLine[] getDebugLines() {
        return this.debugLines;
    }

    public String[] getParagraphs() {
        if (this.debugParagraphs == null) {
            return null;
        }
        String[] stringArray = new String[this.debugParagraphs.length];
        for (int i2 = 0; i2 < this.debugParagraphs.length; ++i2) {
            stringArray[i2] = this.debugParagraphs[i2].getParagraphName();
        }
        return stringArray;
    }

    public void getParagraphsNames(Set<String> set) {
        if (this.debugParagraphs == null) {
            return;
        }
        for (int i2 = 0; i2 < this.debugParagraphs.length; ++i2) {
            set.add(this.debugParagraphs[i2].getParagraphName());
        }
    }

    public CobolRef paragraphToLine(String string) {
        if (this.filenames == null) {
            return null;
        }
        try {
            for (int i2 = 0; i2 < this.debugParagraphs.length; ++i2) {
                if (!this.debugParagraphs[i2].getParagraphName().equalsIgnoreCase(string.replace(this.hyphenRepl, '-'))) continue;
                return new CobolRef(this.debugParagraphs[i2].getLineNumber(), this.filenames[this.debugParagraphs[i2].getFileIndex()], (short)this.debugParagraphs[i2].getFileIndex(), -1, null);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasListing() {
        return this.listing != null;
    }

    protected CobolRef getBPArgs(int n2) {
        CobolRef cobolRef = this.toCobolLine(n2);
        if (cobolRef != null && this.hasListing()) {
            cobolRef.setProgname(this.className);
        }
        return cobolRef;
    }

    static String canonicalizePathList(String string, String string2) {
        if (string2.equals(";")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public boolean isFreeFormat() {
        return this.listing != null && this.listing.isFreeFormat();
    }
}

