/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.interfaces.debugger.IThreadObject;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ThreadObject
implements DataExternalizable,
IThreadObject {
    private static final long serialVersionUID = 1000006L;
    private static int threadProg = 1;
    private static int javaThreadProg = 100001;
    private String name;
    private String description;
    private int id;
    private ParagraphObject[] parStack;
    private transient Thread thread;

    public ThreadObject() {
    }

    private ThreadObject(Thread thread, int n2) {
        this.thread = thread;
        this.name = thread != null ? thread.getName() : Thread.currentThread().getName();
        this.id = n2;
    }

    public String toString() {
        return this.name + (this.description != null ? ": " + this.description : "");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ThreadObject)) {
            return false;
        }
        return ((ThreadObject)object).id == this.id;
    }

    public int compareTo(Object object) {
        if (!(object instanceof ThreadObject)) {
            throw new ClassCastException();
        }
        ThreadObject threadObject = (ThreadObject)object;
        return this.id - threadObject.id;
    }

    public static ThreadObject getJavaThreadObject(Thread thread) {
        return new ThreadObject(thread, javaThreadProg++);
    }

    public static ThreadObject getIscobolThreadObject(Thread thread) {
        return new ThreadObject(thread, threadProg++);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setThread() {
        this.thread = Thread.currentThread();
        this.name = this.thread.getName();
    }

    @Override
    public boolean isAlive() {
        return this.thread == null || this.thread.isAlive();
    }

    public void setParStack(ParagraphObject[] paragraphObjectArray) {
        this.parStack = paragraphObjectArray;
    }

    public ParagraphObject[] getParStack() {
        return this.parStack;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.name, dataOutput);
        RtsUtil.writeUTFOptmz(this.description, dataOutput);
        dataOutput.writeInt(this.id);
        if (this.parStack != null) {
            dataOutput.writeInt(this.parStack.length);
            for (ParagraphObject paragraphObject : this.parStack) {
                paragraphObject.writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.name = RtsUtil.readUTFOptmz(dataInput);
        this.description = RtsUtil.readUTFOptmz(dataInput);
        this.id = dataInput.readInt();
        this.parStack = new ParagraphObject[dataInput.readInt()];
        for (int i2 = 0; i2 < this.parStack.length; ++i2) {
            this.parStack[i2] = new ParagraphObject();
            this.parStack[i2].readExternal(dataInput);
        }
    }
}

