/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.interfaces.debugger.IVarNameExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class VarName
implements DataExternalizable,
IVarNameExtension {
    private static final long serialVersionUID = 1000006L;
    private Vector<String> of = new Vector();
    private Vector<Expression> subscript = new Vector();
    private String name;
    private String fullName;
    private Expression leftPos;
    private Expression subLen;
    private transient int type;
    private transient int offset;
    private transient int length;
    private transient String value;

    public VarName() {
    }

    public VarName(String string, String string2) {
        this.name = string;
        this.fullName = string;
        this.value = string2;
    }

    public VarName(DebugTM debugTM) throws DebuggerException {
        DebugTM.Marker marker = debugTM.setMarker();
        this.analyze(debugTM);
        debugTM.ungetToken();
        DebugTM.Marker marker2 = debugTM.setMarker();
        debugTM.getToken();
        this.fullName = debugTM.toString(marker, marker2);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n2) {
        this.offset = n2;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int n2) {
        this.length = n2;
    }

    public void clearSubscripts() {
        this.subscript.clear();
    }

    @Override
    public boolean hasSubvalue() {
        return this.leftPos != null;
    }

    @Override
    public boolean hasAncestor() {
        return this.of.size() > 0;
    }

    @Override
    public Enumeration getAncestors() {
        return this.of.elements();
    }

    @Override
    public int getNAncestors() {
        return this.of.size();
    }

    @Override
    public int getNSubscripts() {
        return this.subscript.size();
    }

    @Override
    public String getAncestor(int n2) {
        try {
            return this.of.elementAt(n2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public Enumeration getSubscripts() {
        return this.subscript.elements();
    }

    @Override
    public Expression getSubscript(int n2) {
        try {
            return this.subscript.elementAt(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasSubscript() {
        return this.subscript.size() > 0;
    }

    @Override
    public Expression getLeftPos() {
        return this.leftPos;
    }

    @Override
    public Expression getSubLen() {
        return this.subLen;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    @Override
    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName.toUpperCase();
        }
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof VarName)) {
            return false;
        }
        VarName varName = (VarName)object;
        return this.getFullName().equals(varName.getFullName());
    }

    private void analyze(DebugTM debugTM) throws DebuggerException {
        String string;
        Object object;
        this.name = debugTM.getToken();
        if (this.name == null) {
            throw new DebuggerException(5);
        }
        if (this.name.equals(":")) {
            this.name = debugTM.getToken();
            if (this.name == null) {
                throw new DebuggerException(5);
            }
        }
        if (this.name.indexOf(46) >= 0) {
            object = this.name.split("\\.");
            this.name = object[((String[])object).length - 1];
            for (int i2 = 0; i2 < ((String[])object).length - 1; ++i2) {
                this.of.add(0, object[i2]);
            }
            string = debugTM.getToken();
        } else {
            while ((string = debugTM.getToken()) != null && (string.equalsIgnoreCase("OF") || string.equalsIgnoreCase("IN"))) {
                string = debugTM.getToken();
                if (string != null) {
                    this.of.addElement(string);
                    continue;
                }
                throw new DebuggerException(5);
            }
        }
        if (string != null) {
            if (!string.equals("(")) {
                debugTM.ungetToken();
                return;
            }
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(5);
            }
            debugTM.ungetToken();
            object = new Expression(debugTM);
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(5);
            }
            if (string.equals(":")) {
                this.leftPos = object;
                string = debugTM.getToken();
                if (string == null) {
                    throw new DebuggerException(5);
                }
                if (!string.equals(")")) {
                    debugTM.ungetToken();
                    this.subLen = new Expression(debugTM);
                    string = debugTM.getToken();
                    if (string == null || !string.equals(")")) {
                        throw new DebuggerException(5);
                    }
                }
            } else {
                this.subscript.addElement((Expression)object);
                debugTM.ungetToken();
                while ((string = debugTM.getToken()) != null && !string.equals(")")) {
                    debugTM.ungetToken();
                    this.subscript.addElement(new Expression(debugTM));
                }
                if (string == null) {
                    throw new DebuggerException(5);
                }
                string = debugTM.getToken();
                if (string != null) {
                    if (string.equals("(")) {
                        string = debugTM.getToken();
                        if (string == null) {
                            throw new DebuggerException(5);
                        }
                        debugTM.ungetToken();
                        this.leftPos = new Expression(debugTM);
                        string = debugTM.getToken();
                        if (string == null || !string.equals(":")) {
                            throw new DebuggerException(5);
                        }
                        string = debugTM.getToken();
                        if (string == null) {
                            throw new DebuggerException(5);
                        }
                        if (!string.equals(")")) {
                            debugTM.ungetToken();
                            this.subLen = new Expression(debugTM);
                            string = debugTM.getToken();
                            if (string == null || !string.equals(")")) {
                                throw new DebuggerException(5);
                            }
                        }
                    } else {
                        debugTM.ungetToken();
                    }
                }
            }
        }
    }

    @Override
    public boolean containsVariables() {
        if (!this.hasSubscript() && !this.hasSubvalue()) {
            return false;
        }
        if (this.hasSubscript()) {
            Enumeration<Expression> enumeration = this.subscript.elements();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().containsVariables()) continue;
                return true;
            }
            return false;
        }
        return this.leftPos != null && this.leftPos.containsVariables() || this.subLen != null && this.subLen.containsVariables();
    }

    public String toString() {
        return this.fullName;
    }

    public Object clone() {
        VarName varName = new VarName();
        varName.of = new Vector();
        varName.of.addAll(this.of);
        varName.subscript = new Vector();
        varName.subscript.addAll(this.subscript);
        varName.fullName = this.fullName;
        varName.leftPos = this.leftPos;
        varName.name = this.name;
        varName.subLen = this.subLen;
        varName.value = this.value;
        return varName;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.fullName, dataOutput);
        RtsUtil.writeUTFOptmz(this.name, dataOutput);
        dataOutput.writeInt(this.of.size());
        for (String object : this.of) {
            RtsUtil.writeUTFOptmz(object, dataOutput);
        }
        dataOutput.writeInt(this.subscript.size());
        for (Expression expression : this.subscript) {
            expression.writeExternal(dataOutput);
        }
        dataOutput.writeBoolean(this.leftPos != null);
        if (this.leftPos != null) {
            this.leftPos.writeExternal(dataOutput);
            dataOutput.writeBoolean(this.subLen != null);
            if (this.subLen != null) {
                this.subLen.writeExternal(dataOutput);
            }
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        int n2;
        this.fullName = RtsUtil.readUTFOptmz(dataInput);
        this.name = RtsUtil.readUTFOptmz(dataInput);
        int n3 = dataInput.readInt();
        this.of = new Vector();
        for (n2 = 0; n2 < n3; ++n2) {
            this.of.addElement(RtsUtil.readUTFOptmz(dataInput));
        }
        n3 = dataInput.readInt();
        this.subscript = new Vector();
        for (n2 = 0; n2 < n3; ++n2) {
            Expression expression = new Expression();
            expression.readExternal(dataInput);
            this.subscript.addElement(expression);
        }
        if (dataInput.readBoolean()) {
            this.leftPos = new Expression();
            this.leftPos.readExternal(dataInput);
            if (dataInput.readBoolean()) {
                this.subLen = new Expression();
                this.subLen.readExternal(dataInput);
            } else {
                this.subLen = null;
            }
        } else {
            this.leftPos = null;
            this.subLen = null;
        }
    }
}

