/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.VarName;
import com.iscobol.interfaces.debugger.IWatch;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Watch
implements DataExternalizable,
IWatch {
    private static final long serialVersionUID = 1000006L;
    private String fullName;
    private String className;
    private String propName;
    private String value;
    private String envProperty;
    private boolean activated;
    private boolean enabled = true;
    private boolean hexadecimal;
    private boolean _88val;
    private Condition cond;
    private transient INumericVar handleVar;
    private transient VarName varname;
    private transient Debugger.IscobolField isField;

    public Watch() {
    }

    public Watch(VarName varName, Debugger.IscobolField iscobolField, Condition condition, String string, String string2, boolean bl, boolean bl2) {
        this.varname = varName;
        this.fullName = varName.getFullName();
        this.cond = condition;
        this.className = string;
        this.activated = false;
        this.propName = string2;
        this.isField = iscobolField;
        this.hexadecimal = bl;
        this.enabled = bl2;
    }

    public Watch(VarName varName, Debugger.IscobolField iscobolField, Object object, String string, Condition condition, String string2, boolean bl, boolean bl2) {
        this.varname = varName;
        this.isField = iscobolField;
        this.fullName = varName.getFullName();
        this.className = string2;
        if (object instanceof ICobolVar) {
            this.cond = condition;
        } else if (object instanceof Level88) {
            this.cond = condition;
            this._88val = ((Level88)object).getValue();
        }
        this.activated = true;
        this.hexadecimal = bl;
        try {
            this.value = bl && object instanceof ICobolVar ? DebugUtilities.toHexString((ICobolVar)object) : object.toString();
        }
        catch (Exception exception) {
            this.value = DebuggerConstants.NULL_VALUE;
        }
        this.enabled = bl2;
    }

    public Watch(INumericVar iNumericVar, String string, Condition condition, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.handleVar = iNumericVar;
        this.propName = string3;
        this.value = string4;
        this.fullName = string;
        this.className = string2;
        this.cond = condition;
        this.activated = true;
        this.hexadecimal = bl;
        this.enabled = bl2;
    }

    public Watch(String string, String string2, Condition condition, boolean bl) {
        this.envProperty = string;
        this.cond = condition;
        this.value = string2;
        this.activated = true;
        this.enabled = bl;
    }

    public void setActive(boolean bl) {
        if (this.envProperty != null) {
            bl = true;
        }
        this.activated = bl;
    }

    @Override
    public boolean isActive() {
        return this.activated;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHexadecimal() {
        return this.hexadecimal;
    }

    @Override
    public String getEnvProperty() {
        return this.envProperty;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public Debugger.IscobolField getField() {
        return this.isField;
    }

    public boolean shouldNotifyChange(Debugger debugger) {
        boolean bl;
        if (!this.enabled || !this.activated) {
            return false;
        }
        Debugger.IscobolField iscobolField = this.isField;
        if (iscobolField != null) {
            bl = this.refresh(debugger, iscobolField, false);
        } else {
            if (this.varname != null) {
                try {
                    iscobolField = debugger.findVar(this.varname, false);
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
            bl = this.refresh(debugger, iscobolField, true);
        }
        if (bl && this.cond != null) {
            bl = iscobolField != null ? (bl &= this.cond.evaluate(iscobolField.getVar())) : (bl &= this.cond.evaluate(debugger.getHelper().getStrLiteral(this.value)));
        }
        return bl;
    }

    protected boolean refresh(Debugger debugger, Debugger.IscobolField iscobolField, boolean bl) {
        String string;
        boolean bl2;
        if (!this.activated) {
            return false;
        }
        if (iscobolField instanceof Debugger.IscobolProp) {
            bl = true;
        }
        if (iscobolField != null && iscobolField.getType() == Level88.class) {
            Object object = bl ? iscobolField.refresh(debugger) : iscobolField.getVar();
            boolean bl3 = ((Level88)object).getValue();
            bl2 = bl3 != this._88val;
            this._88val = bl3;
            string = iscobolField.toString();
        } else {
            if (this.handleVar != null) {
                string = DebugUtilities.inquireProp(this.handleVar, this.propName, debugger.getCurrClass(), false);
            } else if (this.envProperty != null) {
                string = debugger.getHelper().acceptFromEnv(this.envProperty);
            } else if (iscobolField != null) {
                Object object;
                Object object2 = object = bl ? iscobolField.refresh(debugger) : iscobolField.getVar();
                string = object != null ? (this.hexadecimal && ICobolVar.class.isAssignableFrom(iscobolField.getType()) ? DebugUtilities.toHexString((ICobolVar)object) : DebugUtilities.toString(object)) : Debugger.NULL_OBJECT.toString();
            } else {
                string = DebuggerConstants.NULL_VALUE;
            }
            boolean bl4 = bl2 = !string.equals(this.value);
        }
        if (bl2) {
            this.value = string;
        }
        return bl2;
    }

    @Override
    public String getPropName() {
        return this.propName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    @Override
    public Condition getCondition() {
        return this.cond;
    }

    @Override
    public String getDebugCommand() {
        StringBuffer stringBuffer = new StringBuffer("monitor");
        if (this.enabled) {
            stringBuffer.append(" -e ");
        } else {
            stringBuffer.append(" -d ");
        }
        if (this.envProperty != null) {
            stringBuffer.append(" -env " + this.envProperty);
        } else {
            stringBuffer.append(" -c " + this.className);
            if (this.hexadecimal) {
                stringBuffer.append(" -x ");
            }
            stringBuffer.append(" " + this.fullName);
            if (this.propName != null) {
                stringBuffer.append(" property " + this.propName);
            }
        }
        if (this.cond != null) {
            stringBuffer.append(" when " + this.cond.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDebugDelCommand() {
        StringBuffer stringBuffer = new StringBuffer("unmonitor");
        if (this.envProperty != null) {
            stringBuffer.append(" -env " + this.envProperty);
        } else {
            stringBuffer.append(" -c " + this.className);
            stringBuffer.append(" " + this.fullName);
            if (this.propName != null) {
                stringBuffer.append(" property " + this.propName);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.envProperty != null) {
            stringBuffer.append("iscobol." + this.envProperty);
        } else {
            stringBuffer.append(this.fullName);
            if (this.className != null) {
                stringBuffer.append(" [");
                stringBuffer.append(this.className);
                stringBuffer.append("]");
            }
            if (this.propName != null) {
                stringBuffer.append("::" + this.propName);
            }
        }
        stringBuffer.append(" = ");
        if (this.activated) {
            stringBuffer.append(this.value);
        } else {
            stringBuffer.append(DebuggerConstants.NULL_VALUE);
        }
        return stringBuffer.toString();
    }

    private int compare(String string, String string2, int n2) {
        if (string != null) {
            if (string2 != null) {
                return string.compareTo(string2);
            }
            return n2;
        }
        if (string2 != null) {
            return -n2;
        }
        return 0;
    }

    public int compareTo(Object object) throws ClassCastException {
        Watch watch = (Watch)object;
        int n2 = this.compare(this.envProperty, watch.envProperty, -1);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.compare(this.fullName, watch.fullName, 1);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.compare(this.className, watch.className, 1);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.compare(this.propName, watch.propName, 1);
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.fullName, dataOutput);
        RtsUtil.writeUTFOptmz(this.className, dataOutput);
        RtsUtil.writeUTFOptmz(this.propName, dataOutput);
        RtsUtil.writeUTFOptmz(this.envProperty, dataOutput);
        RtsUtil.writeUTF(this.value, dataOutput);
        dataOutput.writeBoolean(this.enabled);
        dataOutput.writeBoolean(this.activated);
        dataOutput.writeBoolean(this.hexadecimal);
        dataOutput.writeBoolean(this._88val);
        dataOutput.writeBoolean(this.cond != null);
        if (this.cond != null) {
            this.cond.writeExternal(dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.fullName = RtsUtil.readUTFOptmz(dataInput);
        this.className = RtsUtil.readUTFOptmz(dataInput);
        this.propName = RtsUtil.readUTFOptmz(dataInput);
        this.envProperty = RtsUtil.readUTFOptmz(dataInput);
        this.value = RtsUtil.readUTF(dataInput);
        this.enabled = dataInput.readBoolean();
        this.activated = dataInput.readBoolean();
        this.hexadecimal = dataInput.readBoolean();
        this._88val = dataInput.readBoolean();
        if (dataInput.readBoolean()) {
            this.cond = new Condition();
            this.cond.readExternal(dataInput);
        }
    }
}

