/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commandline;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.commandline.VIStyleConsole;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.rts.Config;
import com.iscobol.rts.OSValidator;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class CommandLineDebugger {
    private static final int ATTEMPT_NUMBER = 10;
    private static ResourceBundle rb = ResourceBundle.getBundle("com.iscobol.debugger.commandline.resources");
    public static final String eol = System.getProperty("line.separator", "\n");
    private CommandProcessor processor;
    private AutostepThread autostepThread = new AutostepThread();
    private int port;
    private boolean suspended = true;
    private boolean running;
    private String hostname = "localhost";
    private String lastCommand;
    private String lastProgram;
    private int lastCommandId;
    private DebugTM tm;
    private AbstractConsole console;
    protected DebuggerInvoker invoker;

    public CommandLineDebugger(DebuggerInvoker debuggerInvoker) {
        this.invoker = debuggerInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] stringArray) throws Exception {
        block22: {
            this.setPrefix();
            String string = MessageFormat.format(rb.getString("message.usage"), this.getName(), this.getRemoteOptionName());
            boolean bl = false;
            boolean bl2 = false;
            PrintStream printStream = System.out;
            PrintStream printStream2 = System.err;
            try {
                AbstractConsole abstractConsole;
                Object object;
                if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-vi")) {
                    bl2 = true;
                    object = stringArray;
                    stringArray = new String[stringArray.length - 1];
                    System.arraycopy(object, 1, stringArray, 0, stringArray.length);
                }
                if (OSValidator.isWindows()) {
                    abstractConsole = this.isSystemConsoleAvailable() ? new SystemConsole() : new SysInConsole();
                } else if (OSValidator.isUnix() && bl2) {
                    bl = true;
                    System.setOut(new CRPrintStream(new FileOutputStream(FileDescriptor.out)));
                    System.setErr(new CRPrintStream(new FileOutputStream(FileDescriptor.err)));
                    abstractConsole = new VIConsole(System.out);
                } else {
                    abstractConsole = new SysInConsole();
                }
                if (stringArray.length == 0) {
                    System.err.println(string);
                    System.exit(-1);
                }
                if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("-v")) {
                    this.version(System.out, rb);
                    System.exit(0);
                }
                this.console = abstractConsole;
                if (stringArray[0].equalsIgnoreCase(this.getRemoteOptionName())) {
                    object = null;
                    if (stringArray.length > 1) {
                        object = stringArray[1];
                    }
                    int n2 = 0;
                    if (stringArray.length > 2) {
                        try {
                            n2 = Integer.parseInt(stringArray[2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    try {
                        int n3 = this.start((String)object, n2);
                        System.exit(n3);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        System.exit(-1);
                    }
                    break block22;
                }
                int n4 = CommandLineDebugger.getClassNameIndex(stringArray);
                String string2 = null;
                if (n4 >= stringArray.length) {
                    System.err.println(string);
                    System.exit(-1);
                } else {
                    string2 = stringArray[n4];
                }
                try {
                    int n5 = this.start(string2, stringArray);
                    System.exit(n5);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.exit(-1);
                }
            }
            finally {
                if (bl) {
                    System.setOut(printStream);
                    System.setErr(printStream2);
                }
            }
        }
    }

    void processCommand(int n2) {
        this.suspended = false;
        this.processor.processCommand(n2, true);
    }

    private int start(String string, String[] stringArray) throws IOException {
        try {
            if (!this.isCobolProgram(string, stringArray)) {
                System.err.println(rb.getString("message.invalid.class") + " ' " + string + "'");
                return -1;
            }
            this.port = this.launchCobolProgram(stringArray);
            if (!this.isDebuggable(string)) {
                System.out.println(rb.getString("message.debugger.info.not.found"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(rb.getString("message.cannot.load.class") + " '" + string + "'");
            return -1;
        }
        if (this.port <= 0) {
            System.err.println(rb.getString("message.cannot.load.class") + " '" + string + "'");
            return -1;
        }
        int n2 = this.doRemoteDebugging("localhost", this.port, false);
        if (n2 != 0 && n2 != 203) {
            System.err.println(MessageFormat.format(rb.getString("message.debugger.not.respond"), this.getName()));
            return -1;
        }
        this.runDebugShell(false);
        this.invoker.exitDebug();
        return 0;
    }

    private int start(String string, int n2) throws IOException {
        int n3;
        if (string == null || string.length() == 0) {
            string = Config.a(".hostname", "localhost");
        }
        if (n2 <= 0) {
            n2 = Config.a(".debug.port", 9999);
        }
        if ((n3 = this.doRemoteDebugging(string, n2, true)) != 0) {
            System.err.println(MessageFormat.format(rb.getString("message.debugger.not.respond"), this.getName()));
            return -1;
        }
        this.runDebugShell(true);
        this.invoker.exitDebug();
        return 0;
    }

    private int doRemoteDebugging(String string, int n2, boolean bl) throws IOException {
        this.hostname = string;
        this.port = n2;
        DebugResponse debugResponse = this.invoker.invokeRemote(string, n2, 10, false);
        int n3 = debugResponse.getReturnCode();
        switch (n3) {
            case 103: {
                this.exit(MessageFormat.format(rb.getString("message.program.finished"), this.getName()), 0);
                break;
            }
            case 106: {
                this.exit(rb.getString("message.connection.refused"), 0);
                break;
            }
        }
        return n3;
    }

    private static int getClassNameIndex(String[] stringArray) {
        int n2;
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
        }
        return n2;
    }

    private void handleResponse(DebugResponse debugResponse) {
        String string = debugResponse.getLastProgram();
        if (string != null && string.length() > 0) {
            if (this.lastProgram == null || !string.equals(this.lastProgram)) {
                this.invoker.setInfo(this.invoker.getInfo(string, false, false));
            }
            this.lastProgram = string;
        }
    }

    private boolean checkSuspend() {
        if (!this.suspended) {
            System.out.println(rb.getString("message.debugger.not.suspended"));
            return false;
        }
        return true;
    }

    private boolean checkNotSuspend() {
        if (this.suspended) {
            System.out.println(rb.getString("message.debugger.already.suspended"));
            return false;
        }
        return true;
    }

    protected void printMessage(String string) {
        this.printMessage(string, true, true);
    }

    protected void printMessage(String string, boolean bl) {
        this.printMessage(string, bl, true);
    }

    protected void printMessage(String string, boolean bl, boolean bl2) {
        System.out.println();
        System.out.print(string);
        if (bl) {
            System.out.println();
        }
        if (bl2) {
            System.out.print(this.getPrompt());
        }
    }

    protected void runDebugShell(boolean bl) throws IOException {
        this.processor = new CommandProcessor(this.invoker, bl);
        this.processor.start();
        this.processor.processCommand(30, false);
        block19: while (true) {
            System.out.print(this.getPrompt());
            String string = this.console.readLine();
            string = string.trim();
            this.autostepThread.goOn = false;
            this.autostepThread.interrupt();
            if (string.length() == 0) {
                if (this.lastCommand == null) continue;
                string = this.lastCommand;
            }
            if (string.startsWith(">>") && this.running && !this.suspended) {
                this.invoker.putInput(string.substring(2));
                continue;
            }
            int n2 = this.lastCommandId;
            if (string.length() > 0) {
                this.lastCommand = string;
                this.tm = new DebugTM(this.lastCommand, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                try {
                    n2 = this.tm.getCommand(this.tm.getToken());
                }
                catch (DebuggerException debuggerException) {
                    System.out.println(debuggerException.getMessage());
                    continue;
                }
            }
            switch (n2) {
                case -1: {
                    System.out.println(rb.getString("message.internal.error"));
                    break;
                }
                case 21: 
                case 27: {
                    System.err.println(MessageFormat.format(rb.getString("message.debugger.exit"), this.getName()));
                    return;
                }
                case 39: {
                    DataExternalizable dataExternalizable;
                    if (this.running) {
                        if (!this.checkSuspend()) break;
                        try {
                            dataExternalizable = (AutoOnCommand)this.invoker.parseCommand(n2, this.tm);
                            if (((AutoOnCommand)dataExternalizable).isGet()) {
                                System.out.println(rb.getString("message.autostep.delay") + ": " + this.autostepThread.delay);
                                break;
                            }
                            if (((AutoOnCommand)dataExternalizable).isSet()) {
                                this.autostepThread.delay = ((AutoOnCommand)dataExternalizable).getDelay();
                                System.out.println(rb.getString("message.autostep.delay") + ": " + this.autostepThread.delay);
                                break;
                            }
                            this.autostepThread.goOn = true;
                            this.autostepThread.start();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            System.out.println(illegalArgumentException.getMessage());
                        }
                        catch (DebuggerException debuggerException) {
                            System.out.println(debuggerException.getMessage());
                        }
                        continue block19;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 40: {
                    this.autostepThread.goOn = false;
                    System.out.println(rb.getString("message.autostep.stop"));
                    break;
                }
                case 2: {
                    if (this.running) {
                        System.out.println(rb.getString("message.debugger.already.running"));
                        break;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 29: 
                case 44: 
                case 45: 
                case 52: 
                case 56: {
                    if (this.running) {
                        if (!this.checkSuspend()) break;
                        this.processCommand(n2);
                        break;
                    }
                    System.out.println(rb.getString("message.debugger.waiting.for.thread"));
                    break;
                }
                case 28: {
                    if (!this.checkNotSuspend()) break;
                    this.invoker.suspend();
                    break;
                }
                case 7: 
                case 8: 
                case 20: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 46: {
                    DataExternalizable dataExternalizable;
                    try {
                        dataExternalizable = this.invoker.processCommand(n2, this.tm);
                        this.handleResponse((DebugResponse)dataExternalizable);
                        System.out.print(((DebugResponse)dataExternalizable).getMessage());
                        if (n2 != 20 || string.indexOf(32) >= 0) continue block19;
                        System.out.println(rb.getString("message.pushdata.help"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println(illegalArgumentException.getMessage());
                    }
                    catch (DebuggerException debuggerException) {
                        System.out.println(debuggerException.getMessage());
                    }
                    continue block19;
                }
                case 22: 
                case 23: {
                    System.out.println(rb.getString("message.feature.not.supported"));
                }
            }
        }
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    private void exit(String string, int n2) {
        System.out.println(string);
        System.exit(n2);
    }

    public abstract void version(PrintStream var1, ResourceBundle var2);

    public abstract String getPrompt();

    public abstract boolean isCobolProgram(String var1, String[] var2) throws ClassNotFoundException;

    public abstract int launchCobolProgram(String[] var1);

    public abstract void setPrefix();

    public abstract boolean isDebuggable(String var1) throws ClassNotFoundException;

    public abstract int processGetInfo(boolean var1);

    public abstract String getName();

    public abstract String getRemoteOptionName();

    private boolean isSystemConsoleAvailable() {
        try {
            Method method = System.class.getMethod("console", new Class[0]);
            return method.invoke(null, new Object[0]) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Reader getSystemConsoleReader() {
        try {
            Method method = System.class.getMethod("console", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return (Reader)object.getClass().getMethod("reader", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DebuggerInvoker getInvoker() {
        return this.invoker;
    }

    private class AutostepThread
    implements Runnable {
        double delay = 1.0;
        volatile boolean goOn;
        Thread th;

        private AutostepThread() {
        }

        void start() {
            this.th = new Thread(this);
            this.th.start();
        }

        void interrupt() {
            if (this.th != null) {
                this.th.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.goOn) {
                try {
                    Thread.sleep((int)(this.delay * 1000.0));
                    CommandLineDebugger.this.suspended = false;
                    CommandLineDebugger.this.processor.processCommand(3, false);
                }
                catch (InterruptedException interruptedException) {
                    this.goOn = false;
                }
            }
        }
    }

    private class CommandProcessor
    extends Thread {
        boolean prompt;
        int cmdId = -1;
        boolean remote;
        DebuggerInvoker invoker;

        CommandProcessor(DebuggerInvoker debuggerInvoker, boolean bl) {
            this.setDaemon(true);
            this.remote = bl;
            this.invoker = debuggerInvoker;
        }

        synchronized void processCommand(int n2, boolean bl) {
            this.cmdId = n2;
            this.prompt = bl;
            this.notify();
        }

        synchronized void waitForCommand() {
            while (this.cmdId < 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public void run() {
            while (true) {
                this.waitForCommand();
                try {
                    if (this.cmdId == 30) {
                        int n2 = CommandLineDebugger.this.processGetInfo(this.remote);
                        if (n2 == 103) {
                            CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.program.finished"), CommandLineDebugger.this.getName()), 0);
                        } else {
                            CommandLineDebugger.this.running = true;
                        }
                    } else {
                        DebugResponse debugResponse = this.invoker.processCommand(this.cmdId, CommandLineDebugger.this.tm);
                        if (debugResponse != null) {
                            CommandLineDebugger.this.handleResponse(debugResponse);
                            if (debugResponse.getReturnCode() == 103) {
                                CommandLineDebugger.this.printMessage(debugResponse.getMessage(), false, this.prompt);
                                CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.program.finished"), CommandLineDebugger.this.getName()), 0);
                            } else if (debugResponse.getLastCmd() == 5 && debugResponse.getTree() != null) {
                                CommandLineDebugger.this.printMessage(debugResponse.getMessage(), false, false);
                                Tree tree = debugResponse.getTree();
                                for (TreeNode treeNode : tree.getRoot().getChildren()) {
                                    this.displayTreeNode(treeNode, "");
                                }
                                System.out.print(CommandLineDebugger.this.getPrompt());
                            } else {
                                CommandLineDebugger.this.printMessage(debugResponse.getMessage(), false, this.prompt);
                            }
                        } else {
                            CommandLineDebugger.this.exit(MessageFormat.format(rb.getString("message.debugger.not.respond"), CommandLineDebugger.this.getName()), 1);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CommandLineDebugger.this.printMessage(illegalArgumentException.getMessage(), true);
                }
                catch (DebuggerException debuggerException) {
                    CommandLineDebugger.this.printMessage(debuggerException.getMessage(), true);
                }
                CommandLineDebugger.this.suspended = true;
                this.cmdId = -1;
            }
        }

        private void displayTreeNode(TreeNode treeNode, String string) {
            String string2 = treeNode.getVarValue();
            System.out.println(string + "+ " + treeNode.getVarName() + (string2 != null ? " = " + string2 : ""));
            String string3 = string + "   ";
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.displayTreeNode(treeNode2, string3);
            }
        }
    }

    private static class CRPrintStream
    extends PrintStream {
        CRPrintStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public synchronized void print(String string) {
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                super.print(cArray[i2]);
                if (cArray[i2] != '\n') continue;
                super.print('\r');
            }
        }

        @Override
        public synchronized void println() {
            super.print("\n\r");
        }

        @Override
        public synchronized void println(String string) {
            this.print(string);
            super.print("\n\r");
        }
    }

    private class VIConsole
    extends AbstractConsole {
        VIStyleConsole vsc;

        VIConsole(PrintStream printStream) {
            this.vsc = new VIStyleConsole(CommandLineDebugger.this.getPrompt(), printStream, System.in);
        }

        @Override
        String readLine() throws IOException {
            return this.vsc.readLine();
        }
    }

    private class SysInConsole
    extends AbstractConsole {
        BufferedReader in;

        SysInConsole() {
            this.in = new BufferedReader(new InputStreamReader(System.in));
        }

        @Override
        String readLine() throws IOException {
            return this.in.readLine();
        }
    }

    private class SystemConsole
    extends AbstractConsole {
        BufferedReader in;

        SystemConsole() {
            this.in = new BufferedReader(CommandLineDebugger.this.getSystemConsoleReader());
        }

        @Override
        String readLine() throws IOException {
            return this.in.readLine();
        }
    }

    private static abstract class AbstractConsole {
        private AbstractConsole() {
        }

        abstract String readLine() throws IOException;
    }
}

