/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commandline;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;

public class VIStyleConsole {
    private static final int COMMAND_HOME = 1;
    private static final int COMMAND_END = 2;
    private static final int COMMAND_CHANGE_FROM_CURSOR = 3;
    private static final int COMMAND_DELETE_FROM_CURSOR = 4;
    private static final int COMMAND_APPEND_AFTER_CURSOR = 5;
    private static final int COMMAND_APPEND_TO_END = 6;
    private static final int COMMAND_PREVIOUS_WORD = 7;
    private static final int COMMAND_NEXT_WORD = 8;
    private static final int COMMAND_INSERT = 9;
    private static final int COMMAND_UP = 10;
    private static final int COMMAND_DOWN = 11;
    private static final int COMMAND_LEFT = 12;
    private static final int COMMAND_RIGHT = 13;
    private static final int COMMAND_DELETE_AT_CURSOR = 14;
    private static final int COMMAND_DELETE_BEFORE_CURSOR = 15;
    private static final int COMMAND_OVERWRITE = 16;
    private static final int COMMAND_OVERWRITE_1CHAR = 17;
    private static final int COMMAND_CHANGE_WORD = 18;
    private static final int COMMAND_DELETE_WORD = 19;
    private static final int COMMAND_CHANGE_LINE = 20;
    private static final int COMMAND_DELETE_LINE = 21;
    private static final int COMMAND_INSERT_AT_HOME = 22;
    private static final int COMMAND_UNDO = 23;
    private static final Hashtable commandTable = new Hashtable();
    private static final int COMMAND_MODE = 0;
    private static final int INSERTION_MODE = 1;
    private static final int OVERWRITE_MODE = 2;
    private static final int OVERWRITE_1CHAR_MODE = 3;
    private static final int ENTER_CODE = 13;
    private static final int ESCAPE_CODE = 27;
    private static final int FIRST_PRINTABLE_CHAR_CODE = 32;
    private static final int LAST_PRINTABLE_CHAR_CODE = 126;
    private static final int BACKSPACE_CODE = 127;
    private Stack undoStack = new Stack();
    private StringBuffer commandLine = new StringBuffer();
    private int cursorPosition = 0;
    private ArrayList history = new ArrayList();
    private int historyIndex = -1;
    private BufferedInputStream input;
    private String prompt;
    private PrintStream sysOut;
    private byte[] buffer = new byte[16];
    private StringBuffer commandBuffer = new StringBuffer();

    public VIStyleConsole(String string) {
        this(string, System.out, System.in);
    }

    public VIStyleConsole(String string, PrintStream printStream, InputStream inputStream) {
        this.sysOut = printStream;
        this.input = new BufferedInputStream(inputStream);
        this.prompt = string;
        if (this.prompt == null) {
            this.prompt = "";
        }
    }

    private static boolean isWordCharacter(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_';
    }

    private int getCommand(int n2) {
        this.commandBuffer.append((char)n2);
        String string = this.commandBuffer.toString();
        while (string.length() > 0) {
            Integer n3 = (Integer)commandTable.get(string);
            if (n3 != null) {
                this.commandBuffer.delete(0, this.commandBuffer.length());
                return n3;
            }
            string = string.substring(1);
        }
        return 0;
    }

    private void saveUndo() {
        if (this.undoStack.isEmpty() || !((Undo)this.undoStack.peek()).commandLine.equals(this.commandLine.toString())) {
            this.undoStack.push(new Undo(this.commandLine.toString(), this.cursorPosition));
        }
    }

    private void undo() {
        while (!this.undoStack.isEmpty()) {
            Undo undo = (Undo)this.undoStack.pop();
            if (undo.commandLine.equals(this.commandLine.toString())) continue;
            this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
            this.sysOut.print("\r" + this.prompt + undo.commandLine);
            this.commandLine.delete(0, this.commandLine.length());
            this.commandLine.append(undo.commandLine);
            this.setCursorPosition(undo.cursorPosition);
            break;
        }
    }

    public String readLine() {
        int n2 = 1;
        while (true) {
            int n3;
            try {
                n3 = this.input.read(this.buffer);
            }
            catch (IOException iOException) {
                break;
            }
            if (n3 != 1) continue;
            byte by = this.buffer[0];
            if (by == 127) {
                if (n2 == 0) {
                    this.saveUndo();
                }
                this.deleteBeforeCursor();
                continue;
            }
            if (by == 13) {
                this.undoStack.clear();
                return this.addCommand();
            }
            if (by == 27 && n2 != 0) {
                n2 = 0;
                this.left();
                continue;
            }
            if (n2 == 1) {
                if (by < 32 || by > 126) continue;
                if (this.cursorPosition < this.commandLine.length()) {
                    this.commandLine.insert(this.cursorPosition, (char)by);
                    this.sysOut.print("\r" + this.prompt + this.commandLine);
                    this.setCursorPosition(this.cursorPosition + 1);
                    continue;
                }
                this.commandLine.append((char)by);
                this.sysOut.print((char)by);
                ++this.cursorPosition;
                continue;
            }
            if (n2 == 2 || n2 == 3) {
                if (by < 32 || by > 126) continue;
                if (this.cursorPosition < this.commandLine.length()) {
                    this.commandLine.setCharAt(this.cursorPosition, (char)by);
                    this.sysOut.print("\r" + this.prompt + this.commandLine);
                    this.setCursorPosition(n2 == 2 ? this.cursorPosition + 1 : this.cursorPosition);
                }
                if (n2 != 3) continue;
                n2 = 0;
                continue;
            }
            switch (this.getCommand(by)) {
                case 1: {
                    this.home();
                    break;
                }
                case 2: {
                    this.end();
                    break;
                }
                case 3: {
                    this.saveUndo();
                    this.deleteFromCursor();
                    n2 = 1;
                    break;
                }
                case 4: {
                    this.saveUndo();
                    this.deleteFromCursor();
                    break;
                }
                case 5: {
                    this.saveUndo();
                    this.right();
                    n2 = 1;
                    break;
                }
                case 6: {
                    this.saveUndo();
                    this.setCursorPosition(this.commandLine.length());
                    n2 = 1;
                    break;
                }
                case 7: {
                    this.prevWord();
                    break;
                }
                case 8: {
                    this.nextWord();
                    break;
                }
                case 9: {
                    this.saveUndo();
                    n2 = 1;
                    break;
                }
                case 11: {
                    this.clearUndoStack();
                    this.down();
                    break;
                }
                case 10: {
                    this.clearUndoStack();
                    this.up();
                    break;
                }
                case 12: {
                    this.left();
                    break;
                }
                case 13: {
                    this.right();
                    break;
                }
                case 14: {
                    this.saveUndo();
                    this.deleteAtCursor();
                    break;
                }
                case 15: {
                    this.saveUndo();
                    this.deleteBeforeCursor();
                    break;
                }
                case 17: {
                    this.saveUndo();
                    n2 = 3;
                    break;
                }
                case 16: {
                    this.saveUndo();
                    n2 = 2;
                    break;
                }
                case 18: {
                    this.saveUndo();
                    this.deleteToNextWord();
                    n2 = 1;
                    break;
                }
                case 19: {
                    this.saveUndo();
                    this.deleteToNextWord();
                    break;
                }
                case 20: {
                    this.saveUndo();
                    this.deleteLine();
                    n2 = 1;
                    break;
                }
                case 21: {
                    this.saveUndo();
                    this.deleteLine();
                    break;
                }
                case 22: {
                    this.saveUndo();
                    this.home();
                    n2 = 1;
                    break;
                }
                case 23: {
                    this.undo();
                    break;
                }
            }
        }
        return null;
    }

    private void clearUndoStack() {
        this.undoStack.clear();
    }

    private void deleteToNextWord() {
        int n2;
        int n3 = this.getNextWordIndex();
        if (n3 == -1 && this.cursorPosition < this.commandLine.length()) {
            n3 = this.commandLine.length();
        }
        if ((n2 = n3 - this.cursorPosition) > 0) {
            this.commandLine.delete(this.cursorPosition, n3);
            this.sysOut.print("\r" + this.prompt + this.commandLine + VIStyleConsole.spaces(n2));
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteFromCursor() {
        int n2 = this.commandLine.length() - this.cursorPosition;
        if (n2 > 0) {
            this.commandLine.delete(this.cursorPosition, this.commandLine.length());
            this.sysOut.print("\r" + this.prompt + this.commandLine + VIStyleConsole.spaces(n2));
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteLine() {
        this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
        this.sysOut.print("\r" + this.prompt);
        this.commandLine.delete(0, this.commandLine.length());
        this.cursorPosition = 0;
    }

    private void deleteAtCursor() {
        if (this.cursorPosition < this.commandLine.length()) {
            this.commandLine.deleteCharAt(this.cursorPosition);
            this.sysOut.print("\r" + this.prompt + this.commandLine + " ");
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void deleteBeforeCursor() {
        if (this.cursorPosition > 0) {
            this.commandLine.deleteCharAt(this.cursorPosition - 1);
            this.sysOut.print("\r" + this.prompt + this.commandLine + " ");
            this.setCursorPosition(this.cursorPosition - 1);
        }
    }

    private void home() {
        if (this.commandLine.length() > 0) {
            this.setCursorPosition(0);
        }
    }

    private int getNextWordIndex() {
        int n2 = -1;
        if (this.cursorPosition < this.commandLine.length()) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i2 = this.cursorPosition + 1; i2 < this.commandLine.length() && n2 == -1; ++i2) {
                char c2 = this.commandLine.charAt(i2);
                if (bl3) {
                    if (c2 == ' ') continue;
                    n2 = i2;
                    continue;
                }
                if (bl) {
                    if (c2 == ' ') {
                        bl3 = true;
                        continue;
                    }
                    if (VIStyleConsole.isWordCharacter(c2)) continue;
                    n2 = i2;
                    continue;
                }
                if (bl2) {
                    if (c2 == ' ') {
                        bl3 = true;
                        continue;
                    }
                    if (!VIStyleConsole.isWordCharacter(c2)) continue;
                    n2 = i2;
                    continue;
                }
                if (VIStyleConsole.isWordCharacter(c2)) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                if (c2 == ' ') {
                    bl3 = true;
                    continue;
                }
                bl = false;
                bl2 = true;
                bl3 = false;
            }
        }
        return n2;
    }

    private void nextWord() {
        int n2 = this.getNextWordIndex();
        if (n2 == -1 && this.cursorPosition < this.commandLine.length()) {
            n2 = this.commandLine.length() - 1;
        }
        if (n2 >= 0) {
            this.setCursorPosition(n2);
        }
    }

    private int getPrevWordIndex() {
        int n2 = -1;
        if (this.cursorPosition > 0) {
            boolean bl = false;
            boolean bl2 = false;
            n2 = 0;
            for (int i2 = this.cursorPosition - 1; i2 >= 0 && n2 == 0; --i2) {
                char c2 = this.commandLine.charAt(i2);
                if (bl) {
                    if (VIStyleConsole.isWordCharacter(c2)) continue;
                    n2 = i2 + 1;
                    continue;
                }
                if (bl2) {
                    if (!VIStyleConsole.isWordCharacter(c2) && c2 != ' ') continue;
                    n2 = i2 + 1;
                    continue;
                }
                if (VIStyleConsole.isWordCharacter(c2)) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (c2 == ' ') continue;
                bl = false;
                bl2 = true;
            }
        }
        return n2;
    }

    private void prevWord() {
        int n2 = this.getPrevWordIndex();
        if (n2 >= 0) {
            this.setCursorPosition(n2);
        }
    }

    private void end() {
        if (this.commandLine.length() > 0) {
            this.setCursorPosition(this.commandLine.length() - 1);
        }
    }

    private void left() {
        if (this.cursorPosition > 0) {
            this.setCursorPosition(this.cursorPosition - 1);
        }
    }

    private void right() {
        if (this.cursorPosition < this.commandLine.length()) {
            this.setCursorPosition(this.cursorPosition + 1);
        }
    }

    private void down() {
        if (this.historyIndex >= 0 && this.historyIndex < this.history.size() - 1) {
            this.setHistoryIndex(this.historyIndex + 1);
        } else {
            this.deleteLine();
            this.historyIndex = -1;
        }
    }

    private void up() {
        if (this.historyIndex > 0) {
            this.setHistoryIndex(this.historyIndex - 1);
        } else if (this.historyIndex < 0 && this.history.size() > 0) {
            this.setHistoryIndex(this.history.size() - 1);
        }
    }

    private void setHistoryIndex(int n2) {
        this.historyIndex = n2;
        this.sysOut.print("\r" + VIStyleConsole.spaces(this.prompt.length() + this.commandLine.length()));
        this.sysOut.print("\r" + this.prompt + this.history.get(this.historyIndex));
        this.commandLine.delete(0, this.commandLine.length());
        this.commandLine.append(this.history.get(this.historyIndex).toString());
        this.cursorPosition = this.commandLine.length();
    }

    private void setCursorPosition(int n2) {
        this.cursorPosition = n2;
        this.sysOut.print("\r" + this.prompt + this.commandLine.substring(0, this.cursorPosition));
    }

    private String addCommand() {
        String string = this.commandLine.toString();
        if (string.length() > 0) {
            if (this.history.size() == 0 || !this.history.get(this.history.size() - 1).equals(string)) {
                this.history.add(string);
            }
            this.commandLine.delete(0, this.commandLine.length());
            this.cursorPosition = 0;
            this.historyIndex = -1;
        }
        this.sysOut.print("\n\r");
        return string;
    }

    private static String spaces(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static {
        commandTable.put("$", new Integer(2));
        commandTable.put("0", new Integer(1));
        commandTable.put("A", new Integer(6));
        commandTable.put("a", new Integer(5));
        commandTable.put("b", new Integer(7));
        commandTable.put("C", new Integer(3));
        commandTable.put("cc", new Integer(20));
        commandTable.put("cw", new Integer(18));
        commandTable.put("D", new Integer(4));
        commandTable.put("dd", new Integer(21));
        commandTable.put("dw", new Integer(19));
        commandTable.put("h", new Integer(12));
        commandTable.put("I", new Integer(22));
        commandTable.put("i", new Integer(9));
        commandTable.put("j", new Integer(10));
        commandTable.put("k", new Integer(11));
        commandTable.put("l", new Integer(13));
        commandTable.put("R", new Integer(16));
        commandTable.put("r", new Integer(17));
        commandTable.put("u", new Integer(23));
        commandTable.put("w", new Integer(8));
        commandTable.put("X", new Integer(15));
        commandTable.put("x", new Integer(14));
    }

    private static class Undo {
        private String commandLine;
        private int cursorPosition;

        public Undo(String string, int n2) {
            this.commandLine = string;
            this.cursorPosition = n2;
        }
    }
}

