/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BreakpointCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    int lineNo;
    int fileIndex;
    String paragraph;
    String filename;
    String progName;
    private String absolutePath;

    public BreakpointCommand() {
    }

    public BreakpointCommand(int n2, String string, int n3, String string2, String string3) {
        this.lineNo = n2;
        this.filename = string;
        this.progName = string2;
        this.absolutePath = string3;
        this.fileIndex = n3;
    }

    public BreakpointCommand(String string, String string2, int n2, String string3, String string4) {
        this.paragraph = string;
        this.filename = string2;
        this.progName = string3;
        this.absolutePath = string4;
        this.fileIndex = n2;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getProgName() {
        return this.progName;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getPath() {
        return this.absolutePath;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.lineNo);
        dataOutput.writeInt(this.fileIndex);
        RtsUtil.writeUTFOptmz(this.paragraph, dataOutput);
        RtsUtil.writeUTFOptmz(this.filename, dataOutput);
        RtsUtil.writeUTFOptmz(this.progName, dataOutput);
        RtsUtil.writeUTFOptmz(this.absolutePath, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.lineNo = dataInput.readInt();
        this.fileIndex = dataInput.readInt();
        this.paragraph = RtsUtil.readUTFOptmz(dataInput);
        this.filename = RtsUtil.readUTFOptmz(dataInput);
        this.progName = RtsUtil.readUTFOptmz(dataInput);
        this.absolutePath = RtsUtil.readUTFOptmz(dataInput);
    }
}

