/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClearMonitorCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 14;
    public static final String SHORT_DESCRIPTION = " : clear the monitor on a specified variable";
    public static final String STRING_ID = "unmonitor";
    public static final String HELP_PAGE = "unmonitor.html";
    public static final String USAGE = " usage:" + eol + "   unmonitor [-c class-name[:>method-name]] variable-name" + eol + "or unmonitor [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name" + eol + "or unmonitor " + "-env" + " env-name" + eol + "or unmonitor " + "-a" + " (to clear all monitors)" + eol;
    private VarName varname;
    private String propertyName;
    private String className;
    private String envName;
    private boolean clearAll;

    public ClearMonitorCommand() {
    }

    public ClearMonitorCommand(VarName varName, String string, String string2) {
        this.varname = varName;
        this.className = string;
        this.propertyName = string2;
    }

    public ClearMonitorCommand(String string) {
        this.envName = string;
    }

    public ClearMonitorCommand(boolean bl) {
        this.clearAll = bl;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getEnvName() {
        return this.envName;
    }

    public boolean isClearAll() {
        return this.clearAll;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.clearAll);
        if (!this.clearAll) {
            dataOutput.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(dataOutput);
            }
            RtsUtil.writeUTFOptmz(this.className, dataOutput);
            RtsUtil.writeUTFOptmz(this.propertyName, dataOutput);
            RtsUtil.writeUTFOptmz(this.envName, dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.clearAll = dataInput.readBoolean();
        if (!this.clearAll) {
            if (dataInput.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(dataInput);
            } else {
                this.varname = null;
            }
            this.className = RtsUtil.readUTFOptmz(dataInput);
            this.propertyName = RtsUtil.readUTFOptmz(dataInput);
            this.envName = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

