/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.commands.DebugCommand;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class CompositeCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    private Vector<DebugCommand> commandList;

    public CompositeCommand() {
    }

    public CompositeCommand(Vector<DebugCommand> vector) {
        this.commandList = vector;
    }

    public Vector<DebugCommand> getCommandList() {
        return this.commandList;
    }

    @Override
    public String getStringId() {
        return "???";
    }

    @Override
    public String getShortDescription() {
        return "???";
    }

    @Override
    public String getUsage() {
        return "???";
    }

    @Override
    public String getHelpPage() {
        return "???";
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public int getId() {
        return 1000;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.commandList.size());
        for (DebugCommand debugCommand : this.commandList) {
            dataOutput.writeInt(debugCommand.getId());
            debugCommand.writeExternal(dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.commandList = new Vector();
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = dataInput.readInt();
            try {
                DebugCommand debugCommand = DebuggerConstants.commandClasses.get(n3).newInstance();
                debugCommand.readExternal(dataInput);
                this.commandList.addElement(debugCommand);
                continue;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }
}

