/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DisplayCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 5;
    public static final String SHORT_DESCRIPTION = " : display value of variable (-x display in base 16)";
    public static final String STRING_ID = "display";
    public static final String HELP_PAGE = "display.html";
    public static final String USAGE = "usage:" + eol + "   display [" + "-tree" + "] [" + "-x" + "] [-c class-name[:>method-name]] variable-name" + eol + "or display [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name" + eol + "or display " + "-env" + " env-name" + eol + "or display " + "-classinfo";
    public static final short SHOW_CHILDREN_DISABLED = 0;
    public static final short SHOW_CHILDREN_1_LEVEL = 1;
    public static final short SHOW_CHILDREN_ALL = 2;
    private VarName varname;
    private String propertyName;
    private boolean showHex;
    private boolean showText;
    private short showChildren = (short)2;
    private boolean tree;
    private boolean deferredIfNotRunning;
    private boolean displayClassInfo;
    private String envName;
    private String className;

    public DisplayCommand() {
    }

    public DisplayCommand(boolean bl) {
        this.displayClassInfo = bl;
    }

    public DisplayCommand(VarName varName, String string, boolean bl, boolean bl2) {
        this(varName, string, bl, bl2, 2);
    }

    public DisplayCommand(VarName varName, String string, boolean bl, boolean bl2, short s2) {
        this(varName, string, bl);
        this.tree = bl2;
        this.showChildren = s2;
    }

    public DisplayCommand(VarName varName, String string, String string2) {
        this.varname = varName;
        this.propertyName = string2;
        this.className = string;
    }

    public DisplayCommand(VarName varName, String string, boolean bl) {
        this.varname = varName;
        this.showHex = bl;
        this.className = string;
    }

    public DisplayCommand(String string) {
        this.envName = string;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getEnvName() {
        return this.envName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean displayAsHex() {
        return this.showHex;
    }

    public void setDisplayAsText(boolean bl) {
        this.showText = bl;
    }

    public boolean displayAsText() {
        return this.showText;
    }

    public short getShowChildren() {
        return this.showChildren;
    }

    public void setShowChildren(short s2) {
        this.showChildren = s2;
    }

    public void setDisplayAsHex(boolean bl) {
        this.showHex = bl;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean displayAsTree() {
        return this.tree;
    }

    public boolean displayClassInfo() {
        return this.displayClassInfo;
    }

    public boolean isDeferredIfNotRunning() {
        return this.deferredIfNotRunning;
    }

    public void setDeferredIfNotRunning(boolean bl) {
        this.deferredIfNotRunning = bl;
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.displayClassInfo);
        if (!this.displayClassInfo) {
            dataOutput.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(dataOutput);
            }
            RtsUtil.writeUTFOptmz(this.propertyName, dataOutput);
            RtsUtil.writeUTFOptmz(this.envName, dataOutput);
            dataOutput.writeBoolean(this.showHex);
            dataOutput.writeBoolean(this.showText);
            dataOutput.writeBoolean(this.tree);
            dataOutput.writeBoolean(this.deferredIfNotRunning);
            dataOutput.writeShort(this.showChildren);
            RtsUtil.writeUTFOptmz(this.className, dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.displayClassInfo = dataInput.readBoolean();
        if (!this.displayClassInfo) {
            if (dataInput.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(dataInput);
            } else {
                this.varname = null;
            }
            this.propertyName = RtsUtil.readUTFOptmz(dataInput);
            this.envName = RtsUtil.readUTFOptmz(dataInput);
            this.showHex = dataInput.readBoolean();
            this.showText = dataInput.readBoolean();
            this.tree = dataInput.readBoolean();
            this.deferredIfNotRunning = dataInput.readBoolean();
            this.showChildren = dataInput.readShort();
            this.className = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

