/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GetVariablesCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 43;
    public static final int MAX_HEX_DUMP_LENGTH_VALUE = 1024;
    public static final int MAX_TEXT_LENGTH_VALUE = 2048;
    public static final int MAX_ARRAY_LENGTH_VALUE = 100;
    private VarName[] variablesNames;
    private boolean getChildren;
    private int maxHexDumpLength;
    private int startHexDumpOffset;
    private int maxArrayLength;
    private int startArrayOffset;
    private int maxTextLength;
    private String[] classNames;

    public GetVariablesCommand() {
        this.maxHexDumpLength = 256;
        this.startHexDumpOffset = 1;
        this.maxArrayLength = 25;
        this.startArrayOffset = 1;
        this.maxTextLength = 512;
    }

    public GetVariablesCommand(VarName[] varNameArray) {
        this(varNameArray, false, 256, 1, 25, 1, 512);
    }

    public GetVariablesCommand(VarName[] varNameArray, int n2, int n3, int n4, int n5, int n6) {
        this(varNameArray, false, n2, n3, n4, n5, n6);
    }

    public GetVariablesCommand(VarName varName) {
        VarName[] varNameArray;
        if (varName != null) {
            VarName[] varNameArray2 = new VarName[1];
            varNameArray = varNameArray2;
            varNameArray2[0] = varName;
        } else {
            varNameArray = null;
        }
        this(varNameArray, true, 256, 1, 25, 1, 512);
    }

    public GetVariablesCommand(VarName varName, int n2, int n3, int n4, int n5, int n6) {
        VarName[] varNameArray;
        if (varName != null) {
            VarName[] varNameArray2 = new VarName[1];
            varNameArray = varNameArray2;
            varNameArray2[0] = varName;
        } else {
            varNameArray = null;
        }
        this(varNameArray, true, n2, n3, n4, n5, n6);
    }

    private GetVariablesCommand(VarName[] varNameArray, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.maxHexDumpLength = 256;
        this.startHexDumpOffset = 1;
        this.maxArrayLength = 25;
        this.startArrayOffset = 1;
        this.maxTextLength = 512;
        if (varNameArray == null || varNameArray.length == 0) {
            throw new IllegalArgumentException("variablesNames cannot be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxHexDumpLength must be > 0");
        }
        if (n2 > 1024) {
            throw new IllegalArgumentException("maxHexDumpLength must be <= 1024");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("startHexDumpOffset must be > 0");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("maxArrayLength must be > 0");
        }
        if (n4 > 100) {
            throw new IllegalArgumentException("maxArrayLength must be <= 100");
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("startArrayOffset must be > 0");
        }
        if (n6 <= 0) {
            throw new IllegalArgumentException("maxTextLength must be > 0");
        }
        if (n6 > 2048) {
            throw new IllegalArgumentException("maxTextLength must be <= 2048");
        }
        this.variablesNames = varNameArray;
        this.getChildren = bl;
    }

    public VarName[] getVariablesNames() {
        return this.variablesNames;
    }

    public boolean getGetChildren() {
        return this.getChildren;
    }

    @Override
    public int getId() {
        return 43;
    }

    @Override
    public String getStringId() {
        return "???";
    }

    @Override
    public String getShortDescription() {
        return "???";
    }

    @Override
    public String getUsage() {
        return "???";
    }

    @Override
    public String getHelpPage() {
        return "???";
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    public int getMaxHexDumpLength() {
        return this.maxHexDumpLength;
    }

    public int getStartHexDumpOffset() {
        return this.startHexDumpOffset;
    }

    public int getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public int getStartArrayOffset() {
        return this.startArrayOffset;
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void setClassNames(String[] stringArray) {
        this.classNames = stringArray;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        if (this.variablesNames != null) {
            dataOutput.writeInt(this.variablesNames.length);
            for (VarName object : this.variablesNames) {
                object.writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        dataOutput.writeBoolean(this.getChildren);
        dataOutput.writeInt(this.maxHexDumpLength);
        dataOutput.writeInt(this.startHexDumpOffset);
        dataOutput.writeInt(this.maxArrayLength);
        dataOutput.writeInt(this.startArrayOffset);
        dataOutput.writeInt(this.maxTextLength);
        if (this.classNames != null) {
            dataOutput.writeInt(this.classNames.length);
            for (String string : this.classNames) {
                RtsUtil.writeUTFOptmz(string, dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        int n2;
        this.variablesNames = new VarName[dataInput.readInt()];
        for (n2 = 0; n2 < this.variablesNames.length; ++n2) {
            this.variablesNames[n2] = new VarName();
            this.variablesNames[n2].readExternal(dataInput);
        }
        this.getChildren = dataInput.readBoolean();
        this.maxHexDumpLength = dataInput.readInt();
        this.startHexDumpOffset = dataInput.readInt();
        this.maxArrayLength = dataInput.readInt();
        this.startArrayOffset = dataInput.readInt();
        this.maxTextLength = dataInput.readInt();
        this.classNames = new String[dataInput.readInt()];
        for (n2 = 0; n2 < this.classNames.length; ++n2) {
            this.classNames[n2] = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

