/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JumpCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 29;
    public static final String SHORT_DESCRIPTION = " : jump to the selected line or paragraph";
    public static final String STRING_ID = "jump";
    public static final String HELP_PAGE = "jump.html";
    public static final String USAGE = "usage:" + eol + "   jump line-number|paragraph-name" + eol + "   jump " + "-outpar" + eol + "   jump " + "-outprog" + eol + "   jump " + "-next" + eol;
    public static final byte TYPE_OUTPAR = 1;
    public static final byte TYPE_OUTPROG = 2;
    public static final byte TYPE_NEXT = 3;
    private int lineNo;
    private int fileIndex;
    private String fileName;
    private String paragraphName;
    private byte type;

    public JumpCommand() {
    }

    public JumpCommand(int n2, String string, int n3) {
        this.lineNo = n2;
        this.fileName = string;
        this.fileIndex = n3;
    }

    public static JumpCommand getJumpOutParagraphInstance() {
        JumpCommand jumpCommand = new JumpCommand();
        jumpCommand.type = 1;
        return jumpCommand;
    }

    public static JumpCommand getJumpOutProgramInstance() {
        JumpCommand jumpCommand = new JumpCommand();
        jumpCommand.type = (byte)2;
        return jumpCommand;
    }

    public static JumpCommand getJumpNextInstance() {
        JumpCommand jumpCommand = new JumpCommand();
        jumpCommand.type = (byte)3;
        return jumpCommand;
    }

    public JumpCommand(String string) {
        this.paragraphName = string;
    }

    public boolean isJumpOutParagraph() {
        return this.type == 1;
    }

    public boolean isJumpOutProgram() {
        return this.type == 2;
    }

    public boolean isJumpNext() {
        return this.type == 3;
    }

    public byte getType() {
        return this.type;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getParagraphName() {
        return this.paragraphName;
    }

    @Override
    public int getId() {
        return 29;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.type);
        if (this.type == 0) {
            dataOutput.writeInt(this.lineNo);
            dataOutput.writeInt(this.fileIndex);
            RtsUtil.writeUTFOptmz(this.paragraphName, dataOutput);
            RtsUtil.writeUTFOptmz(this.fileName, dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.type = dataInput.readByte();
        if (this.type == 0) {
            this.lineNo = dataInput.readInt();
            this.fileIndex = dataInput.readInt();
            this.paragraphName = RtsUtil.readUTFOptmz(dataInput);
            this.fileName = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

