/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LetCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 6;
    public static final String SHORT_DESCRIPTION = " : assign new value to variable";
    public static final String STRING_ID = "let";
    public static final String HELP_PAGE = "let.html";
    public static final String USAGE = " usage:" + eol + "   let [" + "-x" + "] [-c class-name[:>method-name]] variable-name = value" + eol + "or let [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name = property-value" + eol + "or let " + "-env" + " env-name = value";
    private VarName varname;
    private String propertyName;
    private String envName;
    private boolean hexadecimal;
    private String value;
    private String className;

    public LetCommand() {
    }

    public LetCommand(VarName varName, String string, boolean bl, String string2) {
        this.varname = varName;
        this.hexadecimal = bl;
        this.value = string2;
        this.className = string;
    }

    public LetCommand(VarName varName, String string, String string2, String string3) {
        this.varname = varName;
        this.propertyName = string2;
        this.value = string3;
        this.className = string;
    }

    public LetCommand(String string, String string2) {
        this.envName = string;
        this.value = string2;
    }

    public String getEnvName() {
        return this.envName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean acceptAsHex() {
        return this.hexadecimal;
    }

    public String getNewValue() {
        return this.value;
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.varname != null);
        if (this.varname != null) {
            this.varname.writeExternal(dataOutput);
        }
        RtsUtil.writeUTFOptmz(this.propertyName, dataOutput);
        RtsUtil.writeUTFOptmz(this.envName, dataOutput);
        dataOutput.writeBoolean(this.hexadecimal);
        RtsUtil.writeUTF(this.value, dataOutput);
        RtsUtil.writeUTFOptmz(this.className, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        if (dataInput.readBoolean()) {
            this.varname = new VarName();
            this.varname.readExternal(dataInput);
        } else {
            this.varname = new VarName();
        }
        this.propertyName = RtsUtil.readUTFOptmz(dataInput);
        this.envName = RtsUtil.readUTFOptmz(dataInput);
        this.hexadecimal = dataInput.readBoolean();
        this.value = RtsUtil.readUTF(dataInput);
        this.className = RtsUtil.readUTFOptmz(dataInput);
    }
}

