/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ListCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 8;
    public static final String SHORT_DESCRIPTION = " : display source code";
    public static final String STRING_ID = "list";
    public static final String HELP_PAGE = "list.html";
    public static final String USAGE = "usage:" + eol + "   list [fromLine[,toLine]]" + eol + "or list -f" + eol + "or list -get" + eol + "or list -set listsize" + eol + "or list +" + eol + "or list -";
    private int fromLine = -1;
    private int toLine = -1;
    private boolean set;
    private boolean get;
    private boolean fileList;
    private int listSize;
    private String fileName;

    public ListCommand() {
    }

    public ListCommand(int n2) {
        this.fromLine = n2;
    }

    public ListCommand(int n2, int n3) {
        this.fromLine = n2;
        this.toLine = n3;
    }

    public ListCommand(int n2, int n3, String string) {
        this.fromLine = n2;
        this.toLine = n3;
        this.fileName = string;
    }

    public static ListCommand Get() {
        ListCommand listCommand = new ListCommand();
        listCommand.get = true;
        return listCommand;
    }

    public static ListCommand FileList() {
        ListCommand listCommand = new ListCommand();
        listCommand.fileList = true;
        return listCommand;
    }

    public static ListCommand Set(int n2) {
        ListCommand listCommand = new ListCommand();
        listCommand.set = true;
        listCommand.listSize = n2;
        return listCommand;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getToLine() {
        return this.toLine;
    }

    public int getListSize() {
        return this.listSize;
    }

    public boolean isGet() {
        return this.get;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isFileList() {
        return this.fileList;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.fromLine);
        dataOutput.writeInt(this.toLine);
        dataOutput.writeBoolean(this.set);
        dataOutput.writeBoolean(this.get);
        dataOutput.writeBoolean(this.fileList);
        dataOutput.writeInt(this.listSize);
        RtsUtil.writeUTFOptmz(this.fileName, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.fromLine = dataInput.readInt();
        this.toLine = dataInput.readInt();
        this.set = dataInput.readBoolean();
        this.get = dataInput.readBoolean();
        this.fileList = dataInput.readBoolean();
        this.listSize = dataInput.readInt();
        this.fileName = RtsUtil.readUTFOptmz(dataInput);
    }
}

