/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodBreakpointCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 52;
    public static final String SHORT_DESCRIPTION = " : set a breakpoint at the start of 'classname.methodname'";
    public static final String STRING_ID = "m0";
    public static final String HELP_PAGE = "m0.html";
    public static final String USAGE = "usage:" + eol + "   m0 [" + "-d" + "] [classname.]methodname[(signature)] [when variable-name [=|!=|<|>|<=|>=] const]" + eol;
    private String methodName;
    private boolean enabled;
    private Expression condition;

    public MethodBreakpointCommand() {
    }

    public MethodBreakpointCommand(String string, boolean bl, Expression expression) {
        this.methodName = string;
        this.enabled = bl;
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getId() {
        return 52;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.methodName, dataOutput);
        dataOutput.writeBoolean(this.enabled);
        if (this.condition != null) {
            dataOutput.writeByte(1);
            this.condition.writeExternal(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.methodName = RtsUtil.readUTFOptmz(dataInput);
        this.enabled = dataInput.readBoolean();
        switch (dataInput.readByte()) {
            default: {
                break;
            }
            case 1: {
                this.condition = new Expression();
                this.condition.readExternal(dataInput);
                break;
            }
            case 2: {
                try {
                    this.condition = new Expression(new DebugTM(RtsUtil.readUTFOptmz(dataInput)), true, false, false);
                    break;
                }
                catch (DebuggerException debuggerException) {
                    throw new IOException(debuggerException);
                }
            }
        }
    }
}

