/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProgramBreakpointCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 19;
    public static final String SHORT_DESCRIPTION = " : set a breakpoint at the start of 'classname'";
    public static final String STRING_ID = "b0";
    public static final String HELP_PAGE = "b0.html";
    public static final String USAGE = "usage:" + eol + "   b0 [" + "-d" + "] progname [when variable-name [=|!=|<|>|<=|>=] const]" + eol;
    private String progName;
    private boolean enabled;
    private Expression condition;

    public ProgramBreakpointCommand() {
    }

    public ProgramBreakpointCommand(String string, boolean bl, Expression expression) {
        this.progName = string;
        this.enabled = bl;
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public String getProgName() {
        return this.progName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.progName, dataOutput);
        dataOutput.writeBoolean(this.enabled);
        if (this.condition != null) {
            dataOutput.writeByte(1);
            this.condition.writeExternal(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.progName = RtsUtil.readUTFOptmz(dataInput);
        this.enabled = dataInput.readBoolean();
        switch (dataInput.readByte()) {
            default: {
                break;
            }
            case 1: {
                this.condition = new Expression();
                this.condition.readExternal(dataInput);
                break;
            }
            case 2: {
                try {
                    this.condition = new Expression(new DebugTM(RtsUtil.readUTFOptmz(dataInput)), true, false, false);
                    break;
                }
                catch (DebuggerException debuggerException) {
                    throw new IOException(debuggerException);
                }
            }
        }
    }
}

