/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RunCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 2;
    public static final String SHORT_DESCRIPTION = " : start execution";
    public static final String STRING_ID = "run";
    public static final String HELP_PAGE = "run.html";
    public static final String USAGE = "usage: run [arg1 ... argN]" + eol;
    private String[] args;

    public RunCommand() {
    }

    public RunCommand(String[] stringArray) {
        this.args = stringArray;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        if (this.args != null) {
            dataOutput.writeInt(this.args.length);
            for (String string : this.args) {
                RtsUtil.writeUTFOptmz(string, dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.args = new String[dataInput.readInt()];
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            this.args[i2] = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

