/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.commands.BreakpointCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetBreakpointCommand
extends BreakpointCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 0;
    public static final String STRING_ID = "break";
    public static final String SHORT_DESCRIPTION = " : set a breakpoint at a line or in a method";
    public static final String USAGE = " usage:" + eol + "   break [" + "-d" + "] line-number|paragraph [cobolfile] [when variable-name [=|!=|<|>|<=|>=] const]" + eol + "or break " + "-l" + " (to list breakpoints)" + eol;
    public static final String HELP_PAGE = "break.html";
    private boolean listing;
    private boolean enabled;
    private Expression condition;

    public SetBreakpointCommand() {
    }

    public SetBreakpointCommand(int n2, String string, int n3, String string2, boolean bl, String string3) {
        super(n2, string, n3, string2, string3);
        this.enabled = bl;
    }

    public SetBreakpointCommand(int n2, String string, int n3, String string2, boolean bl, String string3, Expression expression) {
        super(n2, string, n3, string2, string3);
        this.enabled = bl;
        this.condition = expression;
    }

    public SetBreakpointCommand(String string, String string2, int n2, String string3, boolean bl, String string4, Expression expression) {
        super(string, string2, n2, string3, string4);
        this.enabled = bl;
        this.condition = expression;
    }

    public SetBreakpointCommand(String string, String string2, int n2, String string3, boolean bl, String string4) {
        super(string, string2, n2, string3, string4);
        this.enabled = bl;
    }

    public SetBreakpointCommand(boolean bl) {
        super(0, null, -1, null, null);
        this.listing = bl;
    }

    public boolean isListing() {
        return this.listing;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.listing);
        if (!this.listing) {
            super.writeExternal(dataOutput);
            dataOutput.writeBoolean(this.enabled);
            if (this.condition != null) {
                dataOutput.writeByte(1);
                this.condition.writeExternal(dataOutput);
            } else {
                dataOutput.writeByte(0);
            }
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.listing = dataInput.readBoolean();
        if (!this.listing) {
            super.readExternal(dataInput);
            this.enabled = dataInput.readBoolean();
            switch (dataInput.readByte()) {
                default: {
                    break;
                }
                case 1: {
                    this.condition = new Expression();
                    this.condition.readExternal(dataInput);
                    break;
                }
                case 2: {
                    try {
                        this.condition = new Expression(new DebugTM(RtsUtil.readUTFOptmz(dataInput)), true, false, false);
                        break;
                    }
                    catch (DebuggerException debuggerException) {
                        throw new IOException(debuggerException);
                    }
                }
            }
        }
    }
}

