/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetMonitorCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 13;
    public static final String SHORT_DESCRIPTION = " : set a monitor on a specified variable (-l print list of monitors)";
    public static final String STRING_ID = "monitor";
    public static final String HELP_PAGE = "monitor.html";
    public static final String USAGE = " usage:" + eol + "   monitor [" + "-d" + "] [" + "-x" + "] [-c class-name[:>method-name]] variable-name [when [=|!=|<|>|<=|>= const]|always|never]" + eol + "or monitor [" + "-d" + "] [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name [when [=|!=|<|>|<=|>= const]|always|never]" + eol + "or monitor [" + "-d" + "] " + "-env" + " env-name" + eol + "or monitor " + "-l" + " (to list monitors)" + eol;
    private VarName varname;
    private String propertyName;
    private String className;
    private boolean hexadecimal;
    private String envName;
    private Condition condition;
    private boolean listing;
    private boolean enabled;

    public SetMonitorCommand() {
    }

    public SetMonitorCommand(VarName varName, String string, boolean bl, Condition condition, boolean bl2) {
        this.varname = varName;
        this.className = string;
        this.hexadecimal = bl;
        this.condition = condition;
        this.enabled = bl2;
    }

    public SetMonitorCommand(VarName varName, String string, String string2, Condition condition, boolean bl) {
        this.varname = varName;
        this.className = string;
        this.propertyName = string2;
        this.condition = condition;
        this.enabled = bl;
    }

    public SetMonitorCommand(String string, Condition condition, boolean bl) {
        this.condition = condition;
        this.envName = string;
        this.enabled = bl;
    }

    public SetMonitorCommand(boolean bl) {
        this.listing = bl;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHexadecimal() {
        return this.hexadecimal;
    }

    public String getEnvName() {
        return this.envName;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean isListing() {
        return this.listing;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.listing);
        if (!this.listing) {
            dataOutput.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(dataOutput);
            }
            RtsUtil.writeUTFOptmz(this.className, dataOutput);
            RtsUtil.writeUTFOptmz(this.propertyName, dataOutput);
            dataOutput.writeBoolean(this.hexadecimal);
            dataOutput.writeBoolean(this.enabled);
            RtsUtil.writeUTFOptmz(this.envName, dataOutput);
            if (this.condition != null) {
                dataOutput.writeByte(1);
                this.condition.writeExternal(dataOutput);
            } else {
                dataOutput.writeByte(0);
            }
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.listing = dataInput.readBoolean();
        if (!this.listing) {
            if (dataInput.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(dataInput);
            } else {
                this.varname = new VarName();
            }
            this.className = RtsUtil.readUTFOptmz(dataInput);
            this.propertyName = RtsUtil.readUTFOptmz(dataInput);
            this.hexadecimal = dataInput.readBoolean();
            this.enabled = dataInput.readBoolean();
            this.envName = RtsUtil.readUTFOptmz(dataInput);
            switch (dataInput.readByte()) {
                default: {
                    break;
                }
                case 1: {
                    this.condition = new Condition();
                    this.condition.readExternal(dataInput);
                    break;
                }
                case 2: {
                    try {
                        this.condition = new Condition(new DebugTM(RtsUtil.readUTFOptmz(dataInput)), this.hexadecimal);
                        break;
                    }
                    catch (DebuggerException debuggerException) {
                        throw new IOException(debuggerException);
                    }
                }
            }
        }
    }
}

