/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ThreadCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 16;
    public static final String SHORT_DESCRIPTION = " : choose thread to debug";
    public static final String STRING_ID = "thread";
    public static final String HELP_PAGE = "thread.html";
    public static final String USAGE = "usage:" + eol + "   thread threadname" + eol + "or thread " + "-l" + " (to list threads)" + eol;
    private String threadName;
    private boolean listing;

    public ThreadCommand() {
    }

    public ThreadCommand(String string) {
        this.threadName = string;
    }

    public ThreadCommand(boolean bl) {
        this.listing = bl;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public boolean isListing() {
        return this.listing;
    }

    @Override
    public int getId() {
        return 16;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.listing);
        if (!this.listing) {
            RtsUtil.writeUTFOptmz(this.threadName, dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.listing = dataInput.readBoolean();
        if (!this.listing) {
            this.threadName = RtsUtil.readUTFOptmz(dataInput);
        }
    }
}

