/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TraceOnCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 17;
    public static final String SHORT_DESCRIPTION = " : start tracing program execution";
    public static final String STRING_ID = "tron";
    public static final String HELP_PAGE = "tron.html";
    public static final String USAGE = "usage: tron tracelevel [logfile]" + eol;
    private String logfile;
    private int traceLevel;

    public TraceOnCommand() {
    }

    public TraceOnCommand(int n2, String string) {
        this.traceLevel = n2;
        this.logfile = string;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public String getLogfileName() {
        return this.logfile;
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.traceLevel);
        RtsUtil.writeUTFOptmz(this.logfile, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.traceLevel = dataInput.readInt();
        this.logfile = RtsUtil.readUTFOptmz(dataInput);
    }
}

