/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class AbstractSettingsDialog
extends DebugDialog {
    private static final long serialVersionUID = 1L;
    private JButton applyBtn;
    private JButton cancelBtn;
    private JButton okBtn;
    private boolean dirty;

    public AbstractSettingsDialog(JFrame jFrame, String string, boolean bl) {
        super(jFrame, string, bl);
        this.configureDialog();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.createContents(jPanel);
        this.getContentPane().add((Component)jPanel, "Center");
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        JPanel jPanel2 = new JPanel(lMResize);
        this.okBtn = this.createOkButton();
        this.cancelBtn = this.createCancelButton();
        this.applyBtn = this.createApplyButton();
        this.applyBtn.setEnabled(false);
        int n2 = jPanel.getLayout().preferredLayoutSize((Container)jPanel).width;
        Dimension dimension = lMResize.getPreferredSize(this.cancelBtn);
        n2 = Math.max(n2, dimension.width * 3 + 40);
        this.applyBtn.setBounds(n2 - 10 - dimension.width, 10, dimension.width, dimension.height);
        jPanel2.add((Component)this.applyBtn, new LMResizeData(10));
        this.cancelBtn.setBounds(LMResize.getLeft(this.applyBtn) - 10 - dimension.width, LMResize.getTop(this.applyBtn), dimension.width, dimension.height);
        jPanel2.add((Component)this.cancelBtn, new LMResizeData(10));
        this.okBtn.setBounds(LMResize.getLeft(this.cancelBtn) - 10 - dimension.width, LMResize.getTop(this.applyBtn), dimension.width, dimension.height);
        jPanel2.add((Component)this.okBtn, new LMResizeData(10));
        this.getContentPane().add((Component)jPanel2, "South");
        this.setDefaultButton(this.okBtn);
        this.pack();
    }

    protected abstract void createContents(JPanel var1);

    protected void configureDialog() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.applyBtn.setEnabled(bl);
    }

    private JButton createApplyButton() {
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(actionEvent -> {
            String string = this.validateInput();
            if (string != null) {
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
            } else {
                this.performApply();
            }
        });
        jButton.setMnemonic(97);
        return jButton;
    }

    private JButton createOkButton() {
        JButton jButton = new JButton("Ok");
        jButton.setMnemonic(111);
        jButton.addActionListener(actionEvent -> {
            String string = this.validateInput();
            if (string != null) {
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
            } else {
                this.performOK();
            }
        });
        return jButton;
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(actionEvent -> this.performCancel());
        jButton.setMnemonic(99);
        return jButton;
    }

    protected void performApply() {
        Settings.saveSettings();
        this.setDirty(false);
    }

    protected void performCancel() {
        this.closeDialog();
    }

    protected void performOK() {
        this.performApply();
        this.closeDialog();
    }

    protected String validateInput() {
        return null;
    }
}

