/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AcceptVariableDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField variableTxt;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JTextField valueTxt;
    private JCheckBox hexChk;
    private JButton ok;
    private JButton close;

    public AcceptVariableDialog(JFrame jFrame, String string, String string2, String string3, String string4, String string5, boolean bl) {
        super(jFrame, string, true);
        JTextField jTextField;
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setMnemonic('h');
        Dimension dimension = lMResize.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(this.hexChk);
        JLabel jLabel = new JLabel("Variable name:");
        dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(LMResize.getLeft(this.hexChk), LMResize.getBottom(this.hexChk) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.variableTxt = new JTextField();
        this.variableTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.variableTxt));
        JLabel jLabel2 = new JLabel("Method/Program:");
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel2);
        this.moduleTxt = new JTextField();
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getRight(jLabel2) + 5, LMResize.getTop(jLabel2), 200, this.moduleTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleTxt, new LMResizeData(1));
        this.variableTxt.setBounds(LMResize.getRight(jLabel2) + 5, LMResize.getTop(jLabel), 200, this.variableTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableTxt, new LMResizeData(1));
        JLabel jLabel3 = new JLabel("Property name:");
        dimension = lMResize.getPreferredSize(jLabel3);
        jLabel3.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel2) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel3);
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel3), 200, this.propertyTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyTxt, new LMResizeData(1));
        JLabel jLabel4 = new JLabel("Value:");
        dimension = lMResize.getPreferredSize(jLabel4);
        jLabel4.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel3) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel4);
        this.valueTxt = new JTextField();
        this.valueTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.valueTxt));
        this.valueTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel4), 200, this.valueTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.valueTxt, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(actionEvent -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(actionEvent -> this.closeDialog());
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.valueTxt) - dimension.width + 5, LMResize.getBottom(this.valueTxt) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
        this.hexChk.setSelected(bl);
        if (string2 != null) {
            this.variableTxt.setText(string2);
        }
        if (string3 != null) {
            this.moduleTxt.setText(string3);
        }
        if (string5 != null && string5.length() > 0) {
            this.propertyTxt.setText(string5);
        }
        if (string4 != null) {
            this.valueTxt.setText(string4);
            this.valueTxt.select(0, string4.length());
        }
        if (string4 != null && string4.length() > 0) {
            jTextField = this.valueTxt;
            this.valueTxt.selectAll();
        } else {
            jTextField = this.variableTxt;
        }
        AcceptVariableDialog.setFirstFocusedComponent(jTextField);
    }

    private void makeString() {
        String string = this.variableTxt.getText();
        if (string.length() > 0) {
            String string2;
            this.commandString = "let";
            if (this.hexChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-x";
            }
            if (this.moduleTxt.getText().length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-c";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + this.moduleTxt.getText();
            }
            this.commandString = this.commandString + " ";
            this.commandString = this.commandString + string;
            if (this.propertyTxt != null && (string2 = this.propertyTxt.getText()).length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "property";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + string2;
            }
            this.commandString = this.commandString + " =" + this.valueTxt.getText();
        } else {
            this.commandString = null;
        }
    }
}

