/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BreakpointsSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox breakpointEnabledCmb;

    public BreakpointsSettingsDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
    }

    @Override
    protected void createContents(JPanel jPanel) {
        boolean bl = Settings.getDefaultBreakpointEnabledState();
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        jPanel.setLayout(lMResize);
        JLabel jLabel = new JLabel("Breakpoint default state:");
        this.breakpointEnabledCmb = new JComboBox<String>(new String[]{"Enabled", "Disabled"});
        this.breakpointEnabledCmb.setSelectedIndex(bl ? 0 : 1);
        Dimension dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        jPanel.add(jLabel);
        dimension = lMResize.getPreferredSize(this.breakpointEnabledCmb);
        this.breakpointEnabledCmb.setBounds(LMResize.getRight(jLabel) + 5, LMResize.getTop(jLabel), 100, dimension.height);
        jPanel.add(this.breakpointEnabledCmb);
        ActionListener actionListener = actionEvent -> this.setDirty(true);
        this.breakpointEnabledCmb.addActionListener(actionListener);
    }

    @Override
    protected void performApply() {
        Settings.setDefaultBreakpointEnabledState(this.breakpointEnabledCmb.getSelectedIndex() == 0);
        DebuggerInvoker.setDefaultBreakpointEnabledState(this.breakpointEnabledCmb.getSelectedIndex() == 0);
        super.performApply();
    }

    @Override
    protected String validateInput() {
        return null;
    }
}

