/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConnectDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField hostField;
    private JTextField portField;
    private String hostname;
    private int port;
    private boolean isOk;
    private JButton ok;
    private JButton close;

    public ConnectDialog(JFrame jFrame, String string, String string2, String string3) {
        super(jFrame, string, true);
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        JLabel jLabel = new JLabel("Host name:");
        Dimension dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.hostField = new JTextField();
        this.hostField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.hostField));
        if (string2 != null) {
            this.hostField.setText(string2);
        }
        JLabel jLabel2 = new JLabel("Port number:");
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel2);
        this.hostField.setBounds(LMResize.getRight(jLabel2) + 5, LMResize.getTop(jLabel), 200, this.hostField.getPreferredSize().height);
        this.getContentPane().add((Component)this.hostField, new LMResizeData(1));
        this.portField = new JTextField();
        this.portField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.portField));
        this.portField.setBounds(LMResize.getLeft(this.hostField), LMResize.getTop(jLabel2), 200, this.portField.getPreferredSize().height);
        this.getContentPane().add((Component)this.portField, new LMResizeData(1));
        if (string3 != null) {
            this.portField.setText(string3);
        }
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(actionEvent -> {
            try {
                this.port = Integer.parseInt(this.portField.getText().trim());
                this.hostname = this.hostField.getText().trim();
                this.isOk = true;
                this.closeDialog();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Incorrect port number!", this.getTitle(), 0);
            }
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(actionEvent -> this.closeDialog());
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.portField) - dimension.width + 5, LMResize.getBottom(this.portField) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }
}

