/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class CustomizeShortcutsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private static final String[][] shortcutNames = new String[][]{{"Accept Variable", "graphdebugger.shortcut.let"}, {"Back", "graphdebugger.shortcut.gotoback"}, {"Clear Output", "graphdebugger.shortcut.clearout"}, {"Continue", "graphdebugger.shortcut.continue"}, {"Current Line", "graphdebugger.shortcut.curr_line"}, {"Decrement Font Size", "graphdebugger.shortcut.decfont"}, {"Display Variable", "graphdebugger.shortcut.display"}, {"Display Variables On Selected Line", "graphdebugger.shortcut.displayonselline"}, {"Exit", "graphdebugger.shortcut.exit"}, {"Find", "graphdebugger.shortcut.find"}, {"Find Backwards", "graphdebugger.shortcut.fb"}, {"Find Forwards", "graphdebugger.shortcut.ff"}, {"Find From Top", "graphdebugger.shortcut.ft"}, {"Finish Session", "graphdebugger.shortcut.quit"}, {"First Executable Line", "graphdebugger.shortcut.first_exec_line"}, {"First Line", "graphdebugger.shortcut.first_line"}, {"Forward", "graphdebugger.shortcut.gotoforw"}, {"Go To", "graphdebugger.shortcut.goto"}, {"Go To Declaration", "graphdebugger.shortcut.gotodecl"}, {"Help", "graphdebugger.shortcut.help"}, {"Increment Font Size", "graphdebugger.shortcut.incfont"}, {"Jump", "graphdebugger.shortcut.jump"}, {"Jump Out Paragraph", "graphdebugger.shortcut.jumpoutpar"}, {"Jump Out Program", "graphdebugger.shortcut.jumpoutprog"}, {"Jump Over", "graphdebugger.shortcut.jumpnext"}, {"Jump To Selected Line", "graphdebugger.shortcut.jumptoline"}, {"Last Line", "graphdebugger.shortcut.last_line"}, {"Load File", "graphdebugger.shortcut.loadfile"}, {"Quick Watch", "graphdebugger.shortcut.quickwatch"}, {"Refresh Variables Area", "graphdebugger.shortcut.refreshvararea"}, {"Repeat Find", "graphdebugger.shortcut.repfind"}, {"Run To Line Number", "graphdebugger.shortcut.to"}, {"Run To Next Program", "graphdebugger.shortcut.prog"}, {"Run To Selected Line", "graphdebugger.shortcut.toline"}, {"Set Breakpoint", "graphdebugger.shortcut.break"}, {"Set Monitor", "graphdebugger.shortcut.monitor"}, {"Show Last Command", "graphdebugger.shortcut.lastcmd"}, {"Show Next Command", "graphdebugger.shortcut.nextcmd"}, {"Show Previous Command", "graphdebugger.shortcut.prevcmd"}, {"Start Autostep", "graphdebugger.shortcut.ston"}, {"Start Session", "graphdebugger.shortcut.run"}, {"Start Tracing", "graphdebugger.shortcut.tron"}, {"Step Into", "graphdebugger.shortcut.step"}, {"Step Out Paragraph", "graphdebugger.shortcut.outpar"}, {"Step Out Program", "graphdebugger.shortcut.outprog"}, {"Step Over", "graphdebugger.shortcut.next"}, {"Stop Autostep", "graphdebugger.shortcut.stoff"}, {"Stop Tracing", "graphdebugger.shortcut.troff"}, {"Toggle Breakpoint", "graphdebugger.shortcut.togglebreak"}, {"Unload File", "graphdebugger.shortcut.unloadfile"}};
    private JTable shortcutTable;
    private DefaultTableModel shortcutTableModel;
    private String[] shortcuts;
    private GraphDebugger gd;

    public CustomizeShortcutsDialog(JFrame jFrame, String string, GraphDebugger graphDebugger) {
        super(jFrame, string, true);
        this.gd = graphDebugger;
    }

    @Override
    protected void createContents(JPanel jPanel) {
        this.shortcutTableModel = new DefaultTableModel();
        this.shortcutTableModel.addColumn("Action");
        this.shortcutTableModel.addColumn("Shortcut");
        this.shortcuts = new String[shortcutNames.length];
        for (int i2 = 0; i2 < shortcutNames.length; ++i2) {
            this.shortcuts[i2] = Settings.getShortcut(shortcutNames[i2][1]);
            int[] nArray = Settings.getShortcutParams(this.shortcuts[i2]);
            int n2 = nArray[0];
            int n3 = nArray[1];
            String string = "";
            if ((n2 & 2) == 2) {
                string = string + "Ctrl ";
            }
            if ((n2 & 8) == 8) {
                string = string + "Alt ";
            }
            if ((n2 & 1) == 1) {
                string = string + "Shift ";
            }
            string = string + KeyEvent.getKeyText(n3);
            this.shortcutTableModel.addRow(new Object[]{shortcutNames[i2][0], string});
        }
        this.shortcutTable = new JTable(this.shortcutTableModel){
            MyTableEditor editor;
            {
                this.editor = new MyTableEditor();
            }

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return n3 == 1;
            }

            @Override
            public TableCellEditor getCellEditor(int n2, int n3) {
                if (n3 == 1) {
                    return this.editor;
                }
                return null;
            }
        };
        this.shortcutTable.setFont(this.getFont().deriveFont(13.0f));
        this.shortcutTable.setShowGrid(true);
        this.shortcutTable.setRowSelectionAllowed(true);
        this.shortcutTable.setSurrendersFocusOnKeystroke(true);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.shortcutTable), "Center");
    }

    @Override
    protected void performApply() {
        for (int i2 = 0; i2 < this.shortcutTable.getRowCount(); ++i2) {
            Settings.setShortcut(shortcutNames[i2][1], this.shortcuts[i2]);
        }
        this.gd.setAccelerators();
        super.performApply();
    }

    private class MyTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField tf = new JTextField();
        KeyListener kl;

        MyTableEditor() {
            this.tf.setBorder(null);
            this.tf.setToolTipText("Press a key");
            this.tf.setEditable(false);
        }

        @Override
        public Object getCellEditorValue() {
            return this.tf != null ? this.tf.getText() : null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n2, int n3) {
            if (object != null) {
                this.tf.setText(object.toString());
            }
            if (this.kl != null) {
                this.tf.removeKeyListener(this.kl);
            }
            this.kl = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n22 = keyEvent.getKeyCode();
                    switch (n22) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 65406: {
                            break;
                        }
                        default: {
                            int n3 = 0;
                            String string = "";
                            if (keyEvent.isControlDown()) {
                                n3 |= 2;
                                string = string + "Ctrl ";
                            }
                            if (keyEvent.isAltDown()) {
                                n3 |= 8;
                                string = string + "Alt ";
                            }
                            if (keyEvent.isShiftDown()) {
                                n3 |= 1;
                                string = string + "Shift ";
                            }
                            String string2 = "";
                            if (n3 > 0) {
                                string2 = string2 + n3 + " ";
                            }
                            string2 = string2 + n22;
                            string = string + KeyEvent.getKeyText(n22);
                            MyTableEditor.this.tf.setText(string);
                            for (int i2 = 0; i2 < CustomizeShortcutsDialog.this.shortcuts.length; ++i2) {
                                if (i2 == n2 || !CustomizeShortcutsDialog.this.shortcuts[i2].equals(string2)) continue;
                                ((CustomizeShortcutsDialog)CustomizeShortcutsDialog.this).shortcuts[i2] = CustomizeShortcutsDialog.this.shortcuts[n2];
                                CustomizeShortcutsDialog.this.shortcutTable.setValueAt(CustomizeShortcutsDialog.this.shortcutTable.getValueAt(n2, 1), i2, 1);
                                break;
                            }
                            ((CustomizeShortcutsDialog)CustomizeShortcutsDialog.this).shortcuts[n2] = string2;
                            MyTableEditor.this.fireEditingStopped();
                            keyEvent.consume();
                            CustomizeShortcutsDialog.this.setDirty(true);
                        }
                    }
                }
            };
            this.tf.addKeyListener(this.kl);
            return this.tf;
        }
    }
}

