/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox displayHexCmb;
    private JComboBox monitorEnabledCmb;
    private JSpinner variableHintDelaySpn;
    private JCheckBox variableHintEnabledChk;
    private JSpinner variableHandMouseDelaySpn;
    private JCheckBox variableHandMouseEnabledChk;
    private JTextField maxHexDumpLenTxt;
    private JTextField hexDumpStartTxt;
    private JTextField maxArrayLenTxt;
    private JTextField arrayStartTxt;
    private JTextField maxTextLenTxt;
    private JTextField maxTextLenOutTxt;
    private DebugPanel panel;

    public DataSettingsDialog(JFrame jFrame, String string, DebugPanel debugPanel) {
        super(jFrame, string, true);
        this.panel = debugPanel;
    }

    @Override
    protected void createContents(JPanel jPanel) {
        int n2 = Settings.getVariableHintDelay();
        boolean bl = Settings.isVariableHintEnabled();
        int n3 = Settings.getVariableHandMouseDelay();
        boolean bl2 = Settings.isVariableHandMouseEnabled();
        boolean bl3 = Settings.getDefaultMonitorEnabledState();
        boolean bl4 = Settings.getHexOption();
        LMResize lMResize = new LMResize(10, 10, 7, 0);
        jPanel.setLayout(lMResize);
        JLabel jLabel = new JLabel("'Hexadecimal' option default state:");
        this.displayHexCmb = new JComboBox<String>(new String[]{"Checked", "Unchecked"});
        this.displayHexCmb.setSelectedIndex(bl4 ? 0 : 1);
        Dimension dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Monitor default state:");
        this.monitorEnabledCmb = new JComboBox<String>(new String[]{"Enabled", "Disabled"});
        this.monitorEnabledCmb.setSelectedIndex(bl3 ? 0 : 1);
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        jPanel.add(jLabel2);
        this.variableHintEnabledChk = new JCheckBox("Enable variable hint");
        this.variableHintEnabledChk.setSelected(bl);
        dimension = lMResize.getPreferredSize(this.variableHintEnabledChk);
        this.variableHintEnabledChk.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel2) + 15, dimension.width, dimension.height);
        jPanel.add(this.variableHintEnabledChk);
        JLabel jLabel3 = new JLabel("Delay:");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(n2), new Integer(200), new Integer(10000), new Integer(10));
        this.variableHintDelaySpn = new JSpinner(spinnerNumberModel);
        JLabel jLabel4 = new JLabel("milliseconds");
        jLabel3.setEnabled(bl);
        this.variableHintDelaySpn.setEnabled(bl);
        jLabel4.setEnabled(bl);
        int n4 = 100;
        this.variableHandMouseEnabledChk = new JCheckBox("Enable hyperlink declaration");
        this.variableHandMouseEnabledChk.setSelected(bl2);
        dimension = lMResize.getPreferredSize(this.variableHandMouseEnabledChk);
        this.variableHandMouseEnabledChk.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(this.variableHintEnabledChk) + 15, dimension.width, dimension.height);
        jPanel.add(this.variableHandMouseEnabledChk);
        dimension = lMResize.getPreferredSize(jLabel3);
        jLabel3.setBounds(LMResize.getRight(this.variableHandMouseEnabledChk) + 10, LMResize.getTop(this.variableHintEnabledChk), dimension.width, dimension.height);
        jPanel.add(jLabel3);
        dimension = lMResize.getPreferredSize(this.variableHintDelaySpn);
        this.variableHintDelaySpn.setBounds(LMResize.getRight(jLabel3) + 5, LMResize.getTop(this.variableHintEnabledChk), 100, dimension.height);
        jPanel.add(this.variableHintDelaySpn);
        dimension = lMResize.getPreferredSize(jLabel4);
        jLabel4.setBounds(LMResize.getRight(this.variableHintDelaySpn) + 5, LMResize.getTop(this.variableHintEnabledChk), dimension.width, dimension.height);
        jPanel.add(jLabel4);
        JLabel jLabel5 = new JLabel("Delay:");
        spinnerNumberModel = new SpinnerNumberModel(new Integer(n3), new Integer(200), new Integer(10000), new Integer(10));
        this.variableHandMouseDelaySpn = new JSpinner(spinnerNumberModel);
        JLabel jLabel6 = new JLabel("milliseconds");
        jLabel5.setEnabled(bl2);
        this.variableHandMouseDelaySpn.setEnabled(bl2);
        jLabel6.setEnabled(bl2);
        dimension = lMResize.getPreferredSize(jLabel5);
        jLabel5.setBounds(LMResize.getRight(this.variableHandMouseEnabledChk) + 10, LMResize.getTop(this.variableHandMouseEnabledChk), dimension.width, dimension.height);
        jPanel.add(jLabel5);
        dimension = lMResize.getPreferredSize(this.variableHandMouseDelaySpn);
        this.variableHandMouseDelaySpn.setBounds(LMResize.getRight(jLabel5) + 5, LMResize.getTop(this.variableHandMouseEnabledChk), 100, dimension.height);
        jPanel.add(this.variableHandMouseDelaySpn);
        dimension = lMResize.getPreferredSize(jLabel6);
        jLabel6.setBounds(LMResize.getRight(this.variableHandMouseDelaySpn) + 5, LMResize.getTop(this.variableHandMouseEnabledChk), dimension.width, dimension.height);
        jPanel.add(jLabel6);
        dimension = lMResize.getPreferredSize(this.displayHexCmb);
        this.displayHexCmb.setBounds(LMResize.getLeft(this.variableHandMouseDelaySpn), LMResize.getTop(jLabel), 100, dimension.height);
        jPanel.add(this.displayHexCmb);
        dimension = lMResize.getPreferredSize(this.monitorEnabledCmb);
        this.monitorEnabledCmb.setBounds(LMResize.getLeft(this.variableHandMouseDelaySpn), LMResize.getTop(jLabel2), 100, dimension.height);
        jPanel.add(this.monitorEnabledCmb);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Variables view"));
        LMResize lMResize2 = new LMResize(10, 10, 7, 0);
        jPanel2.setLayout(lMResize2);
        JLabel jLabel7 = new JLabel("Max hex dump length:");
        this.maxHexDumpLenTxt = new JTextField(5);
        this.maxHexDumpLenTxt.setHorizontalAlignment(4);
        this.maxHexDumpLenTxt.setText(Integer.toString(Settings.getMaxHexDumpLength()));
        JLabel jLabel8 = new JLabel("Starting offset into hex dump when max length is exceeded:");
        this.hexDumpStartTxt = new JTextField(5);
        this.hexDumpStartTxt.setHorizontalAlignment(4);
        this.hexDumpStartTxt.setText(Integer.toString(Settings.getHexDumpStartOffset()));
        JLabel jLabel9 = new JLabel("Max array length:");
        this.maxArrayLenTxt = new JTextField(5);
        this.maxArrayLenTxt.setHorizontalAlignment(4);
        this.maxArrayLenTxt.setText(Integer.toString(Settings.getMaxArrayLength()));
        JLabel jLabel10 = new JLabel("Starting index into array when max length is exceeded:");
        this.arrayStartTxt = new JTextField(5);
        this.arrayStartTxt.setHorizontalAlignment(4);
        this.arrayStartTxt.setText(Integer.toString(Settings.getArrayStartOffset()));
        JLabel jLabel11 = new JLabel("Max text value length:");
        this.maxTextLenTxt = new JTextField(5);
        this.maxTextLenTxt.setHorizontalAlignment(4);
        this.maxTextLenTxt.setText(Integer.toString(Settings.getMaxTextValueLength()));
        dimension = lMResize2.getPreferredSize(jLabel7);
        jLabel7.setBounds(10, 20, dimension.width, dimension.height);
        jPanel2.add(jLabel7);
        dimension = lMResize2.getPreferredSize(jLabel8);
        jLabel8.setBounds(LMResize.getLeft(jLabel7), LMResize.getBottom(jLabel7) + 15, dimension.width, dimension.height);
        jPanel2.add(jLabel8);
        dimension = lMResize2.getPreferredSize(jLabel9);
        jLabel9.setBounds(LMResize.getLeft(jLabel7), LMResize.getBottom(jLabel8) + 15, dimension.width, dimension.height);
        jPanel2.add(jLabel9);
        dimension = lMResize2.getPreferredSize(jLabel10);
        jLabel10.setBounds(LMResize.getLeft(jLabel7), LMResize.getBottom(jLabel9) + 15, dimension.width, dimension.height);
        jPanel2.add(jLabel10);
        dimension = lMResize2.getPreferredSize(jLabel11);
        jLabel11.setBounds(LMResize.getLeft(jLabel7), LMResize.getBottom(jLabel10) + 15, dimension.width, dimension.height);
        jPanel2.add(jLabel11);
        dimension = lMResize2.getPreferredSize(this.hexDumpStartTxt);
        this.hexDumpStartTxt.setBounds(LMResize.getRight(jLabel8) + 5, LMResize.getTop(jLabel8), 100, dimension.height);
        jPanel2.add((Component)this.hexDumpStartTxt, new LMResizeData(1));
        dimension = lMResize2.getPreferredSize(this.maxHexDumpLenTxt);
        this.maxHexDumpLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(jLabel7), 100, dimension.height);
        jPanel2.add((Component)this.maxHexDumpLenTxt, new LMResizeData(1));
        dimension = lMResize2.getPreferredSize(this.maxArrayLenTxt);
        this.maxArrayLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(jLabel9), 100, dimension.height);
        jPanel2.add((Component)this.maxArrayLenTxt, new LMResizeData(1));
        dimension = lMResize2.getPreferredSize(this.arrayStartTxt);
        this.arrayStartTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(jLabel10), 100, dimension.height);
        jPanel2.add((Component)this.arrayStartTxt, new LMResizeData(1));
        dimension = lMResize2.getPreferredSize(this.maxTextLenTxt);
        this.maxTextLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(jLabel11), 100, dimension.height);
        jPanel2.add((Component)this.maxTextLenTxt, new LMResizeData(1));
        dimension = lMResize2.preferredLayoutSize(jPanel2);
        jPanel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(this.variableHandMouseEnabledChk) + 15, dimension.width, dimension.height);
        jPanel.add((Component)jPanel2, new LMResizeData(1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Output view"));
        LMResize lMResize3 = new LMResize(10, 10, 5, 0);
        jPanel3.setLayout(lMResize3);
        JLabel jLabel12 = new JLabel("Max text value length (output):");
        this.maxTextLenOutTxt = new JTextField(5);
        this.maxTextLenOutTxt.setHorizontalAlignment(4);
        this.maxTextLenOutTxt.setText(Integer.toString(Settings.getMaxTextValueLengthOutput()));
        dimension = lMResize3.getPreferredSize(jLabel12);
        jLabel12.setBounds(10, 20, dimension.width, dimension.height);
        jPanel3.add(jLabel12);
        dimension = lMResize3.getPreferredSize(this.maxTextLenOutTxt);
        this.maxTextLenOutTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(jLabel12), 100, dimension.height);
        jPanel3.add((Component)this.maxTextLenOutTxt, new LMResizeData(1));
        dimension = lMResize3.preferredLayoutSize(jPanel3);
        jPanel3.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jPanel2) + 15, dimension.width, dimension.height);
        jPanel.add((Component)jPanel3, new LMResizeData(1));
        ActionListener actionListener = actionEvent -> this.setDirty(true);
        this.displayHexCmb.addActionListener(actionListener);
        this.monitorEnabledCmb.addActionListener(actionListener);
        ChangeListener changeListener = changeEvent -> this.setDirty(true);
        this.variableHandMouseEnabledChk.addActionListener(actionEvent -> {
            boolean bl = this.variableHandMouseEnabledChk.isSelected();
            jLabel5.setEnabled(bl);
            this.variableHandMouseDelaySpn.setEnabled(bl);
            jLabel6.setEnabled(bl);
        });
        this.variableHintEnabledChk.addActionListener(actionEvent -> {
            boolean bl = this.variableHintEnabledChk.isSelected();
            jLabel3.setEnabled(bl);
            this.variableHintDelaySpn.setEnabled(bl);
            jLabel4.setEnabled(bl);
        });
        this.variableHintDelaySpn.addChangeListener(changeListener);
        this.variableHandMouseDelaySpn.addChangeListener(changeListener);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DataSettingsDialog.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DataSettingsDialog.this.setDirty(true);
            }
        };
        this.maxHexDumpLenTxt.getDocument().addDocumentListener(documentListener);
        this.hexDumpStartTxt.getDocument().addDocumentListener(documentListener);
        this.maxArrayLenTxt.getDocument().addDocumentListener(documentListener);
        this.arrayStartTxt.getDocument().addDocumentListener(documentListener);
        this.maxTextLenTxt.getDocument().addDocumentListener(documentListener);
        this.maxTextLenOutTxt.getDocument().addDocumentListener(documentListener);
    }

    @Override
    protected void performApply() {
        Settings.setHexOption(this.displayHexCmb.getSelectedIndex() == 0);
        Settings.setDefaultMonitorEnabledState(this.monitorEnabledCmb.getSelectedIndex() == 0);
        Settings.setMaxHexDumpLength(Integer.parseInt(this.maxHexDumpLenTxt.getText()));
        Settings.setHexDumpStartOffset(Integer.parseInt(this.hexDumpStartTxt.getText()));
        Settings.setMaxArrayLength(Integer.parseInt(this.maxArrayLenTxt.getText()));
        Settings.setArrayStartOffset(Integer.parseInt(this.arrayStartTxt.getText()));
        Settings.setMaxTextValueLength(Integer.parseInt(this.maxTextLenTxt.getText()));
        Settings.setMaxTextValueLengthOutput(Integer.parseInt(this.maxTextLenOutTxt.getText()));
        int n2 = (Integer)this.variableHintDelaySpn.getValue();
        Settings.setVariableHintDelay(n2);
        Settings.setVariableHintEnabled(this.variableHintEnabledChk.isSelected());
        this.panel.setVariableHintDelay(this.variableHintEnabledChk.isSelected() ? n2 : 0);
        n2 = (Integer)this.variableHandMouseDelaySpn.getValue();
        Settings.setVariableHandMouseDelay(n2);
        Settings.setVariableHandMouseEnabled(this.variableHandMouseEnabledChk.isSelected());
        this.panel.setVariableHandMouseDelay(this.variableHandMouseEnabledChk.isSelected() ? n2 : 0);
        DebuggerInvoker.setDefaultMonitorEnabledState(this.monitorEnabledCmb.getSelectedIndex() == 0);
        super.performApply();
    }

    @Override
    protected String validateInput() {
        int n2;
        try {
            n2 = Integer.parseInt(this.maxHexDumpLenTxt.getText());
            if (n2 <= 0) {
                return "Max hex dump length must be > 0";
            }
            if (n2 > 1024) {
                return "Max hex dump length must be <= 1024";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max hex dump length";
        }
        try {
            n2 = Integer.parseInt(this.hexDumpStartTxt.getText());
            if (n2 <= 0) {
                return "Start hex dump offset must be > 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid start hex dump offset";
        }
        try {
            n2 = Integer.parseInt(this.maxArrayLenTxt.getText());
            if (n2 <= 0) {
                return "Max array length must be > 0";
            }
            if (n2 > 100) {
                return "Max array length must be <= 100";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max array length";
        }
        try {
            n2 = Integer.parseInt(this.arrayStartTxt.getText());
            if (n2 <= 0) {
                return "Start array index must be > 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid start array length";
        }
        try {
            n2 = Integer.parseInt(this.maxTextLenTxt.getText());
            if (n2 <= 0) {
                return "Max text length must be > 0";
            }
            if (n2 > 2048) {
                return "Max text length must be <= 2048";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max text length";
        }
        try {
            n2 = Integer.parseInt(this.maxTextLenOutTxt.getText());
            if (n2 <= 0) {
                return "Max text length (output) must be > 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max text length (output)";
        }
        return null;
    }
}

