/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DisplayVariableDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField variableTxt;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JCheckBox treeChk;
    private JCheckBox hexChk;
    private JButton ok;
    private JButton close;

    public DisplayVariableDialog(JFrame jFrame, String string, String string2, String string3, boolean bl) {
        super(jFrame, string, true);
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.treeChk = new JCheckBox("Show in Watched Variables");
        this.treeChk.setMnemonic('v');
        if (bl) {
            this.treeChk.setSelected(true);
            this.treeChk.setEnabled(false);
        }
        Dimension dimension = lMResize.getPreferredSize(this.treeChk);
        this.treeChk.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(this.treeChk);
        LMResize lMResize2 = new LMResize(5, 5, 5, 0);
        JPanel jPanel = new JPanel(lMResize2);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setSelected(Settings.getHexOption());
        this.hexChk.setMnemonic('h');
        dimension = lMResize2.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(10, 10, dimension.width, dimension.height);
        jPanel.add(this.hexChk);
        JLabel jLabel = new JLabel("Variable name:");
        dimension = lMResize2.getPreferredSize(jLabel);
        jLabel.setBounds(LMResize.getLeft(this.hexChk), LMResize.getBottom(this.hexChk) + 15, dimension.width, dimension.height);
        jPanel.add(jLabel);
        this.variableTxt = new JTextField(30);
        this.variableTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.variableTxt));
        JLabel jLabel2 = new JLabel("Method/Program name:");
        dimension = lMResize2.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        jPanel.add(jLabel2);
        this.moduleTxt = new JTextField(30);
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getRight(jLabel2) + 5, LMResize.getTop(jLabel2), 200, this.moduleTxt.getPreferredSize().height);
        jPanel.add((Component)this.moduleTxt, new LMResizeData(1));
        this.variableTxt.setBounds(LMResize.getLeft(this.moduleTxt), LMResize.getTop(jLabel), 200, this.variableTxt.getPreferredSize().height);
        jPanel.add((Component)this.variableTxt, new LMResizeData(1));
        if (string2 != null) {
            this.variableTxt.setText(string2);
            this.variableTxt.select(0, string2.length());
        }
        if (string3 != null) {
            this.moduleTxt.setText(string3);
        }
        JLabel jLabel3 = new JLabel("Property name:");
        dimension = lMResize2.getPreferredSize(jLabel3);
        jLabel3.setBounds(LMResize.getLeft(jLabel2), LMResize.getBottom(jLabel2) + 15, dimension.width, dimension.height);
        jPanel.add(jLabel3);
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.moduleTxt), LMResize.getTop(jLabel3), 200, this.propertyTxt.getPreferredSize().height);
        jPanel.add((Component)this.propertyTxt, new LMResizeData(1));
        dimension = lMResize2.preferredLayoutSize(jPanel);
        jPanel.setBounds(LMResize.getLeft(this.treeChk), LMResize.getBottom(this.treeChk) + 15, dimension.width, dimension.height);
        this.getContentPane().add((Component)jPanel, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(actionEvent -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.treeChk.setHorizontalTextPosition(4);
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(jPanel) - dimension.width + 5, LMResize.getBottom(jPanel) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        DisplayVariableDialog.setFirstFocusedComponent(this.variableTxt);
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String string = this.variableTxt.getText();
        if (string.length() > 0) {
            String string2;
            this.commandString = "display";
            if (this.treeChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-tree";
            }
            if (this.hexChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-x";
            }
            if (this.moduleTxt.getText().length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-c";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + this.moduleTxt.getText();
            }
            this.commandString = this.commandString + " ";
            this.commandString = this.commandString + string;
            if (this.propertyTxt != null && (string2 = this.propertyTxt.getText()).length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "property";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + string2;
            }
        } else {
            this.commandString = null;
        }
    }
}

