/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class FindDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JComboBox toSearch;
    private JTextComponent toSearchEditor;
    private JCheckBox matchCase;
    private JCheckBox wholeWords;
    private JCheckBox backSearch;
    private JCheckBox wrapSearch;
    private JCheckBox searchFromTop;
    private JCheckBox matchMinusUnderscore;
    private JButton find;
    private JButton close;
    private FindParam param;
    private DebugPanel preview;

    public FindDialog(JFrame jFrame, String string, boolean bl, DebugPanel debugPanel) {
        super(jFrame, string, bl);
        this.preview = debugPanel;
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FindDialog findDialog = FindDialog.this;
                synchronized (findDialog) {
                    FindDialog.this.notify();
                }
            }
        });
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.matchCase = new JCheckBox("Match Case");
        this.wholeWords = new JCheckBox("Match Whole Words Only");
        this.backSearch = new JCheckBox("Backward Search");
        this.wrapSearch = new JCheckBox("Wrap Search");
        this.searchFromTop = new JCheckBox("From Top");
        this.matchMinusUnderscore = new JCheckBox("Match -/_");
        this.find = new JButton("Find");
        this.find.addActionListener(actionEvent -> this.responseOnAction());
        this.close = new JButton("Close");
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.find.setMnemonic('f');
        this.close.setMnemonic('c');
        JLabel jLabel = new JLabel("Find:");
        this.toSearch = new JComboBox();
        Component component = this.toSearch.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            this.toSearchEditor = (JTextComponent)component;
            component.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.toSearchEditor));
        }
        this.toSearch.setEditable(true);
        Dimension dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        dimension = lMResize.getPreferredSize(this.matchCase);
        this.matchCase.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 20, dimension.width, dimension.height);
        this.getContentPane().add(this.matchCase);
        dimension = lMResize.getPreferredSize(this.backSearch);
        this.backSearch.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(this.matchCase) + 10, dimension.width, dimension.height);
        this.getContentPane().add(this.backSearch);
        dimension = lMResize.getPreferredSize(this.searchFromTop);
        this.searchFromTop.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(this.backSearch) + 10, dimension.width, dimension.height);
        this.getContentPane().add(this.searchFromTop);
        dimension = lMResize.getPreferredSize(this.wholeWords);
        this.wholeWords.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.matchCase), dimension.width, dimension.height);
        this.getContentPane().add(this.wholeWords);
        int n2 = LMResize.getRight(jLabel) + 5;
        this.toSearch.setBounds(n2, LMResize.getTop(jLabel), LMResize.getRight(this.wholeWords) - n2, this.toSearch.getPreferredSize().height);
        this.getContentPane().add((Component)this.toSearch, new LMResizeData(1));
        dimension = lMResize.getPreferredSize(this.wrapSearch);
        this.wrapSearch.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.backSearch), dimension.width, dimension.height);
        this.getContentPane().add(this.wrapSearch);
        dimension = lMResize.getPreferredSize(this.matchMinusUnderscore);
        this.matchMinusUnderscore.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.searchFromTop), dimension.width, dimension.height);
        this.getContentPane().add(this.matchMinusUnderscore);
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.toSearch) - dimension.width + 5, LMResize.getBottom(this.searchFromTop) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.find.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.find, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.find);
    }

    public void setMatchCaseSelected(boolean bl) {
        this.matchCase.setSelected(bl);
    }

    public void setWholeWordsSelected(boolean bl) {
        this.wholeWords.setSelected(bl);
    }

    public void setBackwardSearchSelected(boolean bl) {
        this.backSearch.setSelected(bl);
    }

    public void setWrapSearchSelected(boolean bl) {
        this.wrapSearch.setSelected(bl);
    }

    public void setSearchFromTopSelected(boolean bl) {
        this.searchFromTop.setSelected(bl);
    }

    public void setMatchMinusUnderscoreSelected(boolean bl) {
        this.matchMinusUnderscore.setSelected(bl);
    }

    public boolean isMatchCaseSelected() {
        return this.matchCase.isSelected();
    }

    public boolean isWholeWordsSelected() {
        return this.wholeWords.isSelected();
    }

    public boolean isBackwardSearchSelected() {
        return this.backSearch.isSelected();
    }

    public boolean isWrapSearchSelected() {
        return this.wrapSearch.isSelected();
    }

    public boolean isSearchFromTopSelected() {
        return this.searchFromTop.isSelected();
    }

    public boolean isMatchMinusUnderscoreSelected() {
        return this.matchMinusUnderscore.isSelected();
    }

    public void setVisible(String string) {
        super.openDialog(this.getLastBounds());
        this.param = null;
        if (string != null && this.toSearchEditor != null) {
            this.toSearchEditor.setText(string);
        } else if (this.toSearch.getItemCount() > 0) {
            this.toSearch.setSelectedIndex(0);
        }
        if (this.toSearchEditor != null) {
            this.toSearchEditor.selectAll();
        }
    }

    public void addItemToSearchList(String string) {
        this.removeItem(string);
        this.toSearch.insertItemAt(string, 0);
        this.toSearch.setSelectedIndex(0);
    }

    private void responseOnAction() {
        String string;
        Object object = this.toSearch.getEditor().getItem();
        String string2 = string = object != null ? object.toString() : null;
        if (string != null && string.length() > 0) {
            this.param = new FindParam();
            this.param.toSearch = string.toString();
            this.param.matchCase = this.matchCase.isSelected();
            this.param.wholeWords = this.wholeWords.isSelected();
            this.param.backSearch = this.backSearch.isSelected();
            this.param.wrapSearch = this.wrapSearch.isSelected();
            this.param.searchFromTop = this.searchFromTop.isSelected();
            this.param.matchMinusUnderscore = this.matchMinusUnderscore.isSelected();
            this.searchFromTop.setSelected(false);
            this.preview.find(this.param);
        }
    }

    private void removeItem(String string) {
        int n2 = this.toSearch.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.toSearch.getItemAt(i2).toString().equals(string)) continue;
            this.toSearch.removeItemAt(i2);
            return;
        }
    }

    public static class FindParam {
        public String toSearch;
        public boolean matchCase;
        public boolean wholeWords;
        public boolean backSearch;
        public boolean wrapSearch;
        public boolean searchFromTop;
        public boolean matchMinusUnderscore;

        public FindParam() {
        }

        public FindParam(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            this.toSearch = string;
            this.matchCase = bl;
            this.wholeWords = bl2;
            this.backSearch = bl3;
            this.wrapSearch = bl4;
            this.searchFromTop = bl5;
            this.matchMinusUnderscore = bl6;
        }
    }
}

