/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GotoDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JRadioButton lineRb;
    private JRadioButton parRb;
    private JTextField lineTf;
    private JComboBox<DebugParagraph> parCmb;
    private JComboBox<Filename> fileCmb;
    private JButton goTo;
    private JButton close;
    private DebugPanel preview;
    private ActionListener aListener = actionEvent -> {
        if (this.lineRb.isSelected()) {
            try {
                int n2 = Integer.parseInt(this.lineTf.getText());
                this.preview.goTo(n2, null, this.fileCmb.getSelectedIndex());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        } else {
            DebugParagraph debugParagraph = (DebugParagraph)this.parCmb.getSelectedItem();
            if (debugParagraph != null) {
                this.preview.goTo(debugParagraph.getLineNumber(), debugParagraph.getParagraphName(), debugParagraph.getFileIndex());
            }
        }
    };

    public GotoDialog(JFrame jFrame, String string, boolean bl, DebugPanel debugPanel) {
        super(jFrame, string, bl);
        this.preview = debugPanel;
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent windowEvent) {
                GotoDialog gotoDialog = GotoDialog.this;
                synchronized (gotoDialog) {
                    GotoDialog.this.notify();
                }
            }
        });
        this.lineRb = new JRadioButton("Go to Line");
        Dimension dimension = lMResize.getPreferredSize(this.lineRb);
        this.lineRb.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(this.lineRb);
        this.lineRb.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.lineTf.setEnabled(true);
                this.parCmb.setEnabled(false);
                this.fileCmb.setEnabled(true);
                this.lineTf.requestFocus();
            }
        });
        this.parRb = new JRadioButton("Go to Paragraph");
        dimension = lMResize.getPreferredSize(this.parRb);
        this.parRb.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.lineRb) + 20, dimension.width, dimension.height);
        this.getContentPane().add(this.parRb);
        this.parRb.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.parCmb.setEnabled(true);
                this.lineTf.setEnabled(false);
                this.fileCmb.setEnabled(false);
                this.parCmb.requestFocus();
            }
        });
        this.lineTf = new JTextField();
        this.lineTf.setBounds(LMResize.getRight(this.parRb) + 5, LMResize.getTop(this.lineRb) + 2, 70, this.lineTf.getPreferredSize().height);
        this.getContentPane().add((Component)this.lineTf, new LMResizeData(1));
        this.lineTf.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineTf));
        this.lineTf.setHorizontalAlignment(4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lineRb);
        buttonGroup.add(this.parRb);
        this.parCmb = new JComboBox();
        this.parCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(this.parRb) + 2, 200, this.parCmb.getPreferredSize().height);
        this.getContentPane().add(this.parCmb, new LMResizeData(1));
        JLabel jLabel = new JLabel("Filename:");
        dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.parRb) + 20, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.fileCmb = new JComboBox();
        this.fileCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(jLabel), 200, this.fileCmb.getPreferredSize().height);
        this.getContentPane().add(this.fileCmb, new LMResizeData(1));
        this.goTo = new JButton("Go To");
        this.goTo.setMnemonic('g');
        this.goTo.addActionListener(this.aListener);
        this.close = new JButton("Close");
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.close.setMnemonic('c');
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.fileCmb) - dimension.width + 5, LMResize.getBottom(this.fileCmb) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.goTo.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.goTo, new LMResizeData(10));
        this.lineRb.setSelected(true);
        GotoDialog.setFirstFocusedComponent(this.lineTf);
        this.pack();
        this.setDefaultButton(this.goTo);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.fileCmb.removeAllItems();
            this.parCmb.removeAllItems();
            Filename[] filenameArray = this.preview.getFile().getFilenames();
            for (int i2 = 0; i2 < filenameArray.length; ++i2) {
                this.fileCmb.addItem(filenameArray[i2]);
            }
            this.parCmb.addItem(new DebugParagraph("", 0, 0));
            Object[] objectArray = this.preview.getFile().getDebugParagraphs();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    this.parCmb.addItem((DebugParagraph)objectArray[i3]);
                }
            }
        }
        super.setVisible(bl);
    }
}

