/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class HelpDialog
extends DebugFrame {
    private static final long serialVersionUID = 123L;
    private static Command[] commands = new Command[]{new Command("b0", "b0.html"), new Command("break", "break.html"), new Command("clear", "clear.html"), new Command("continue", "continue.html"), new Command("directory", "directory.html"), new Command("display", "display.html"), new Command("down", "down.html"), new Command("env", "env.html"), new Command("exit", "exit.html"), new Command("f", "f.html"), new Command("fb", "fb.html"), new Command("ff", "ff.html"), new Command("ft", "ft.html"), new Command("gc", "gc.html"), new Command("help", "help.html"), new Command("infostack", "infostack.html"), new Command("jump", "jump.html"), new Command("length", "length.html"), new Command("let", "let.html"), new Command("line", "line.html"), new Command("list", "list.html"), new Command("m0", "m0.html"), new Command("memory", "memory.html"), new Command("monitor", "monitor.html"), new Command("next", "next.html"), new Command("offset", "offset.html"), new Command("outpar", "outpar.html"), new Command("outprog", "outprog.html"), new Command("pause", "suspend.html"), new Command("prog", "prog.html"), new Command("quit", "quit.html"), new Command("readsession", "readsession.html"), new Command("run", "run.html"), new Command("step", "step.html"), new Command("stoff", "stoff.html"), new Command("ston", "ston.html"), new Command("thread", "thread.html"), new Command("to", "to.html"), new Command("troff", "troff.html"), new Command("tron", "tron.html"), new Command("unmonitor", "unmonitor.html"), new Command("up", "up.html"), new Command("w0", "w0.html"), new Command("w@", "w@.html"), new Command("wb", "wb.html"), new Command("writesession", "writesession.html"), new Command("wt", "wt.html")};
    private JEditorPane textArea;
    private JTree helpTree;
    private JButton close;
    private DefaultMutableTreeNode b0;
    private DefaultMutableTreeNode m0;

    public HelpDialog(JFrame jFrame, String string) {
        super(jFrame, string);
        Serializable serializable;
        this.setSize(800, 700);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.helpTree = new JTree(defaultTreeModel);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setFont(new Font("sansserif", 1, 12));
        this.helpTree.setCellRenderer(defaultTreeCellRenderer);
        this.helpTree.setRootVisible(false);
        this.helpTree.setShowsRootHandles(true);
        this.helpTree.setScrollsOnExpand(true);
        this.helpTree.setExpandsSelectedPaths(true);
        for (int i2 = 0; i2 < commands.length; ++i2) {
            serializable = new DefaultMutableTreeNode(commands[i2]);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            if (commands[i2].name.equals("b0")) {
                this.b0 = serializable;
                continue;
            }
            if (!commands[i2].name.equals("m0")) continue;
            this.m0 = serializable;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        serializable = new JLabel("Debug commands");
        ((JComponent)serializable).setOpaque(true);
        ((JComponent)serializable).setBackground(Color.white);
        ((JComponent)serializable).setPreferredSize(new Dimension(0, 30));
        ((JLabel)serializable).setHorizontalAlignment(0);
        jPanel.add((Component)serializable, "North");
        JScrollPane jScrollPane = new JScrollPane(this.helpTree);
        jPanel.add((Component)jScrollPane, "Center");
        jSplitPane.setLeftComponent(jPanel);
        this.textArea = new JEditorPane();
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.textArea));
        this.textArea.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getURL().toString();
                if (string.endsWith("m0")) {
                    this.helpTree.setSelectionPath(new TreePath(this.m0.getPath()));
                } else if (string.endsWith("b0")) {
                    this.helpTree.setSelectionPath(new TreePath(this.b0.getPath()));
                }
            }
        });
        this.textArea.setContentType("text/html");
        this.helpTree.addTreeSelectionListener(treeSelectionEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            this.helpTree.scrollPathToVisible(treeSelectionEvent.getPath());
            Object object = defaultMutableTreeNode.getUserObject();
            try {
                if (object instanceof Command) {
                    Command command = (Command)object;
                    String string = command.helpPage;
                    this.textArea.setPage(HelpDialog.class.getResource(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        jScrollPane = new JScrollPane(this.textArea);
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setDividerSize(5);
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(actionEvent -> this.closeFrame());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        jPanel2.add(jSplitPane);
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel3 = new JPanel(springLayout);
        jPanel3.add(this.close);
        springLayout.putConstraint("East", (Component)this.close, -10, "East", (Component)jPanel3);
        springLayout.putConstraint("North", (Component)this.close, 10, "North", (Component)jPanel3);
        springLayout.putConstraint("South", (Component)jPanel3, 10, "South", (Component)this.close);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        defaultTreeModel.reload();
        this.setDefaultButton(this.close);
    }

    public void selectCommand(String string) {
        for (int i2 = 0; i2 < commands.length; ++i2) {
            if (!commands[i2].name.equalsIgnoreCase(string)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.helpTree.getModel().getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i2);
            this.helpTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
            break;
        }
    }

    private static class Command
    implements Comparable {
        private String name;
        private String helpPage;

        Command(String string, String string2) {
            this.name = string;
            this.helpPage = string2;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object object) {
            if (object instanceof Command) {
                return this.name.compareToIgnoreCase(((Command)object).name);
            }
            throw new ClassCastException();
        }
    }
}

