/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JumpToDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JRadioButton lineRb;
    private JRadioButton parRb;
    private JTextField lineTf;
    private JComboBox parCmb;
    private JComboBox fileCmb;
    private JButton jumpTo;
    private JButton close;
    private DebugPanel preview;
    private int selectedLine;
    private String selectedParagraph;
    private String selectedFileName;

    public JumpToDialog(JFrame jFrame, String string, DebugPanel debugPanel) {
        super(jFrame, string, true);
        this.preview = debugPanel;
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent windowEvent) {
                JumpToDialog jumpToDialog = JumpToDialog.this;
                synchronized (jumpToDialog) {
                    JumpToDialog.this.notify();
                }
            }
        });
        this.lineRb = new JRadioButton("Jump to Line");
        this.lineRb.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.lineTf.setEnabled(true);
                this.parCmb.setEnabled(false);
                this.fileCmb.setEnabled(true);
                this.lineTf.requestFocus();
            }
        });
        Dimension dimension = lMResize.getPreferredSize(this.lineRb);
        this.lineRb.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(this.lineRb);
        this.lineTf = new JTextField();
        this.lineTf.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineTf));
        this.lineTf.setHorizontalAlignment(4);
        this.parRb = new JRadioButton("Jump to Paragraph");
        this.parRb.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.parCmb.setEnabled(true);
                this.lineTf.setEnabled(false);
                this.fileCmb.setEnabled(false);
                this.parCmb.requestFocus();
            }
        });
        dimension = lMResize.getPreferredSize(this.parRb);
        this.parRb.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.lineRb) + 20, dimension.width, dimension.height);
        this.getContentPane().add(this.parRb);
        this.lineTf.setBounds(LMResize.getRight(this.parRb) + 5, LMResize.getTop(this.lineRb) + 2, 70, this.lineTf.getPreferredSize().height);
        this.getContentPane().add((Component)this.lineTf, new LMResizeData(1));
        this.parCmb = new JComboBox();
        this.parCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(this.parRb) + 2, 200, this.parCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.parCmb, new LMResizeData(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lineRb);
        buttonGroup.add(this.parRb);
        JLabel jLabel = new JLabel("Filename:");
        dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.parRb) + 20, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.fileCmb = new JComboBox();
        this.fileCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(jLabel), 200, this.fileCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.fileCmb, new LMResizeData(1));
        this.jumpTo = new JButton("Jump To");
        this.jumpTo.setMnemonic('j');
        this.jumpTo.addActionListener(actionEvent -> {
            if (this.lineRb.isSelected()) {
                try {
                    this.selectedLine = Integer.parseInt(this.lineTf.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.fileCmb.getSelectedIndex() >= 0) {
                    this.selectedFileName = this.fileCmb.getSelectedItem().toString();
                }
            } else if (this.parCmb.getSelectedIndex() >= 0) {
                this.selectedParagraph = this.parCmb.getSelectedItem().toString();
            }
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.close.setMnemonic('c');
        this.lineRb.setSelected(true);
        dimension = lMResize.getPreferredSize(this.jumpTo);
        this.close.setBounds(LMResize.getRight(this.fileCmb) - dimension.width + 5, LMResize.getBottom(this.fileCmb) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.jumpTo.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.jumpTo, new LMResizeData(10));
        JumpToDialog.setFirstFocusedComponent(this.lineTf);
        this.pack();
        this.setDefaultButton(this.jumpTo);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.fileCmb.removeAllItems();
            this.parCmb.removeAllItems();
            Filename[] filenameArray = this.preview.getFile().getFilenames();
            for (int i2 = 0; i2 < filenameArray.length; ++i2) {
                this.fileCmb.addItem(filenameArray[i2]);
            }
            this.parCmb.addItem("");
            Object[] objectArray = this.preview.getFile().getParagraphs();
            if (objectArray != null) {
                Arrays.sort(objectArray);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    this.parCmb.addItem(objectArray[i3]);
                }
            }
        }
        super.setVisible(bl);
    }

    public int getSelectedLineNumber() {
        return this.selectedLine;
    }

    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    public String getSelectedParagraphName() {
        return this.selectedParagraph;
    }
}

