/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.concurrent.ConcurrentHashMap;

public class LMResize
implements LayoutManager2 {
    private Dimension origContainerSize;
    private ConcurrentHashMap<Component, LMResizeData> constraintsTable = new ConcurrentHashMap();
    private int currContainerWidth;
    private int currContainerHeight;
    private int hMargin;
    private int vMargin;
    private int hPad;
    private int vPad;
    private boolean noMinX = true;
    private boolean noMinY = true;

    public LMResize() {
    }

    public LMResize(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, true, true);
    }

    public LMResize(int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this.hMargin = n2;
        this.vMargin = n3;
        this.hPad = n4;
        this.vPad = n5;
        this.noMinX = bl;
        this.noMinY = bl2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraintsTable.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Rectangle rectangle = componentArray[i2].getBounds();
            n2 = Math.max(n2, rectangle.x + rectangle.width);
            n3 = Math.max(n3, rectangle.y + rectangle.height);
        }
        Dimension dimension = new Dimension(n2 + this.hMargin, n3 + this.vMargin);
        return dimension;
    }

    private int getNewWidth(Rectangle rectangle) {
        return rectangle.width + this.currContainerWidth - this.origContainerSize.width;
    }

    private int getNewHeight(Rectangle rectangle) {
        return rectangle.height + this.currContainerHeight - this.origContainerSize.height;
    }

    private int getNewX(Rectangle rectangle) {
        return rectangle.x + this.currContainerWidth - this.origContainerSize.width;
    }

    private int getNewY(Rectangle rectangle) {
        return rectangle.y + this.currContainerHeight - this.origContainerSize.height;
    }

    private void setOriginalContainerSize(Dimension dimension) {
        if (dimension != null && dimension.width > 0 && dimension.height > 0) {
            this.origContainerSize = dimension;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.origContainerSize == null) {
            this.setOriginalContainerSize(container.getSize());
            return;
        }
        Dimension dimension = container.getSize();
        this.currContainerWidth = dimension.width;
        this.currContainerHeight = dimension.height;
        for (Component component : this.constraintsTable.keySet()) {
            LMResizeData lMResizeData = this.constraintsTable.get(component);
            Rectangle rectangle = component.getBounds();
            int n2 = (lMResizeData.action & 1) == 1 ? (this.noMinX ? this.getNewWidth(lMResizeData.origBounds) : Math.max(lMResizeData.origBounds.width, this.getNewWidth(lMResizeData.origBounds))) : rectangle.width;
            int n3 = (lMResizeData.action & 4) == 4 ? (this.noMinY ? this.getNewHeight(lMResizeData.origBounds) : Math.max(lMResizeData.origBounds.height, this.getNewHeight(lMResizeData.origBounds))) : rectangle.height;
            int n4 = (lMResizeData.action & 2) == 2 ? (this.noMinX ? this.getNewX(lMResizeData.origBounds) : Math.max(lMResizeData.origBounds.x, this.getNewX(lMResizeData.origBounds))) : rectangle.x;
            int n5 = (lMResizeData.action & 8) == 8 ? (this.noMinY ? this.getNewY(lMResizeData.origBounds) : Math.max(lMResizeData.origBounds.y, this.getNewY(lMResizeData.origBounds))) : rectangle.y;
            if (n2 == rectangle.width && n3 == rectangle.height && n4 == rectangle.x && n5 == rectangle.y) continue;
            component.setBounds(n4, n5, n2, n3);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = new LMResizeData(0);
        }
        if (!(object instanceof LMResizeData)) {
            throw new IllegalArgumentException("LMResizeData object required.");
        }
        ((LMResizeData)object).origBounds = component.getBounds();
        this.constraintsTable.put(component, (LMResizeData)object);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    static int getRight(Component component) {
        Rectangle rectangle = component.getBounds();
        return rectangle.x + rectangle.width;
    }

    static int getBottom(Component component) {
        Rectangle rectangle = component.getBounds();
        return rectangle.y + rectangle.height;
    }

    static int getTop(Component component) {
        return component.getLocation().y;
    }

    static int getLeft(Component component) {
        return component.getLocation().x;
    }

    Dimension getPreferredSize(Component component) {
        Dimension dimension = component.getPreferredSize();
        dimension.width += this.hPad;
        dimension.height += this.vPad;
        return dimension;
    }
}

