/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MonitorDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField variableTxt;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JComboBox conditionCmb;
    private JTextField valueTxt;
    private JCheckBox envChk;
    private JCheckBox hexChk;
    private JCheckBox enableChk;
    private JButton ok;
    private JButton close;

    public MonitorDialog(JFrame jFrame, String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        this(jFrame, string, bl, bl2, bl3, false);
        if (string2 != null) {
            this.variableTxt.setText(string2);
            this.variableTxt.select(0, string2.length());
        }
        if (string3 != null) {
            this.moduleTxt.setText(string3);
        }
        if (this.propertyTxt != null && string4 != null) {
            this.propertyTxt.setText(string4);
        }
    }

    public MonitorDialog(JFrame jFrame, String string, Watch watch, boolean bl, boolean bl2, boolean bl3) {
        this(jFrame, string, bl, bl2, bl3, watch != null);
        if (watch != null) {
            Condition condition;
            String string2 = watch.getEnvProperty();
            String string3 = string2 != null ? string2 : watch.getFullName();
            this.variableTxt.setText(string3);
            this.variableTxt.setEnabled(false);
            this.enableChk.setSelected(watch.isEnabled());
            this.envChk.setEnabled(false);
            if (string2 != null) {
                this.envChk.setSelected(true);
                this.hexChk.setSelected(false);
                this.hexChk.setEnabled(false);
            } else if (watch.isHexadecimal()) {
                this.envChk.setSelected(false);
                this.hexChk.setSelected(true);
            }
            if (watch != null && watch.getClassname() != null && watch.getClassname().length() > 0) {
                this.moduleTxt.setText(watch.getClassname());
            }
            if (this.propertyTxt != null) {
                if (watch.getPropName() != null) {
                    this.propertyTxt.setText(watch.getPropName());
                }
                this.propertyTxt.setEnabled(false);
            }
            if ((condition = watch.getCondition()) != null) {
                this.conditionCmb.setSelectedItem(condition.getTypeStr());
                if (!(condition.getValue() == null || condition.getTypeStr() != null && condition.getTypeStr().equals("always"))) {
                    this.valueTxt.setText(condition.getValueStr());
                    this.valueTxt.setEnabled(true);
                }
            }
        }
    }

    private MonitorDialog(JFrame jFrame, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(jFrame, string, true);
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.enableChk = new JCheckBox("Enabled");
        this.enableChk.setSelected(bl3);
        Dimension dimension = lMResize.getPreferredSize(this.enableChk);
        this.enableChk.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(this.enableChk);
        this.envChk = new JCheckBox("Environment name");
        dimension = lMResize.getPreferredSize(this.envChk);
        this.envChk.setBounds(LMResize.getLeft(this.enableChk), LMResize.getBottom(this.enableChk) + 15, dimension.width, dimension.height);
        this.getContentPane().add(this.envChk);
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setSelected(bl2);
        dimension = lMResize.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(LMResize.getRight(this.envChk) + 15, LMResize.getTop(this.envChk), dimension.width, dimension.height);
        this.getContentPane().add(this.hexChk);
        if (!bl4) {
            this.envChk.addActionListener(actionEvent -> {
                if (this.propertyTxt != null) {
                    this.propertyTxt.setEnabled(!this.envChk.isSelected());
                }
                this.hexChk.setEnabled(!this.envChk.isSelected());
                if (this.envChk.isSelected()) {
                    this.hexChk.setSelected(false);
                }
            });
            this.hexChk.addActionListener(actionEvent -> {
                if (this.propertyTxt != null) {
                    this.propertyTxt.setEnabled(!this.hexChk.isSelected());
                }
                this.envChk.setEnabled(!this.hexChk.isSelected());
                if (this.hexChk.isSelected()) {
                    this.envChk.setSelected(false);
                }
            });
        }
        JLabel jLabel = new JLabel("Variable name:");
        dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(this.envChk) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        JLabel jLabel2 = new JLabel("Method/Program:");
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel2);
        JLabel jLabel3 = new JLabel("Property name:");
        dimension = lMResize.getPreferredSize(jLabel3);
        jLabel3.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(jLabel2) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel3);
        JLabel jLabel4 = new JLabel("Notify change when");
        dimension = lMResize.getPreferredSize(jLabel4);
        jLabel4.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(jLabel3) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel4);
        JLabel jLabel5 = new JLabel("Value:");
        dimension = lMResize.getPreferredSize(jLabel5);
        jLabel5.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(jLabel4) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel5);
        this.variableTxt = new JTextField(20);
        this.variableTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.variableTxt));
        this.variableTxt.setBounds(LMResize.getRight(jLabel4) + 5, LMResize.getTop(jLabel), 200, this.variableTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableTxt, new LMResizeData(1));
        this.moduleTxt = new JTextField();
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel2), 200, this.moduleTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleTxt, new LMResizeData(1));
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel3), 200, this.propertyTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyTxt, new LMResizeData(1));
        this.conditionCmb = new JComboBox<String>(Condition.conditionStrings);
        this.conditionCmb.addItemListener(itemEvent -> {
            if (this.conditionCmb.getSelectedIndex() == 0) {
                this.valueTxt.setText("");
                this.valueTxt.setEnabled(false);
            } else {
                this.valueTxt.setEnabled(true);
            }
        });
        this.conditionCmb.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel4), 200, this.conditionCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.conditionCmb, new LMResizeData(1));
        this.valueTxt = new JTextField();
        this.valueTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.valueTxt));
        this.valueTxt.setEnabled(false);
        this.valueTxt.setBounds(LMResize.getLeft(this.variableTxt), LMResize.getTop(jLabel5), 200, this.valueTxt.getPreferredSize().height);
        this.getContentPane().add((Component)this.valueTxt, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(actionEvent -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.close.setMnemonic('c');
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.valueTxt) - dimension.width + 5, LMResize.getBottom(this.valueTxt) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        MonitorDialog.setFirstFocusedComponent(this.variableTxt);
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String string = this.variableTxt.getText();
        if (string.length() > 0) {
            this.commandString = "monitor";
            this.commandString = this.enableChk.isSelected() ? this.commandString + " -e" : this.commandString + " -d";
            if (this.envChk.isSelected()) {
                this.commandString = this.commandString + " -env " + string;
            } else {
                String string2;
                if (this.moduleTxt.getText().length() > 0) {
                    this.commandString = this.commandString + " -c " + this.moduleTxt.getText();
                }
                if (this.hexChk.isSelected()) {
                    this.commandString = this.commandString + " -x";
                }
                this.commandString = this.commandString + " " + string;
                if (this.propertyTxt != null && (string2 = this.propertyTxt.getText()).length() > 0) {
                    this.commandString = this.commandString + " property " + string2;
                }
            }
            this.commandString = this.commandString + " when " + this.conditionCmb.getSelectedItem() + " " + this.valueTxt.getText();
        } else {
            this.commandString = null;
        }
    }
}

