/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import com.iscobol.debugger.dialogs.treetable.model.VariableModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;

public class QuickWatchDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private GraphDebugger graphDebug;
    private JButton refresh;
    private JButton addWatch;
    private JButton modifyValue;
    private JButton displayTree;
    private JButton close;
    private JComboBox variableName;
    private JTextField propertyName;
    private JTextField moduleName;
    private JTreeTable variableTree;
    private JScrollPane variableScrollPane;
    private JCheckBox asHex;
    private VariableModel variableModel;
    private int lastCommand;
    private String currVarname;
    private boolean executingDisplayCommand;
    private boolean active;

    public QuickWatchDialog(GraphDebugger graphDebugger, JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.graphDebug = graphDebugger;
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        this.refresh = new JButton("Refresh");
        this.refresh.setMnemonic(82);
        this.refresh.addActionListener(actionEvent -> this.refresh());
        this.displayTree = new JButton("Show in Watched Variables");
        this.displayTree.setMnemonic(86);
        this.displayTree.addActionListener(actionEvent -> this.displayTree());
        this.modifyValue = new JButton("Modify value");
        this.modifyValue.setMnemonic(77);
        this.modifyValue.addActionListener(actionEvent -> this.modifyValue());
        this.addWatch = new JButton("Add monitor");
        this.addWatch.setMnemonic(65);
        this.addWatch.addActionListener(actionEvent -> this.addMonitor());
        this.close = new JButton("Close");
        this.close.addActionListener(actionEvent -> this.closeDialog());
        this.close.setMnemonic(67);
        Dimension dimension = lMResize.getPreferredSize(this.displayTree);
        this.refresh.setBounds(870 - dimension.width, 10, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.refresh, new LMResizeData(2));
        this.displayTree.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.refresh) + 10, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.displayTree, new LMResizeData(2));
        this.modifyValue.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.displayTree) + 10, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.modifyValue, new LMResizeData(2));
        this.addWatch.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.modifyValue) + 10, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.addWatch, new LMResizeData(2));
        this.close.setBounds(LMResize.getLeft(this.refresh), LMResize.getBottom(this.addWatch) + 10, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(2));
        JLabel jLabel = new JLabel("Variable: ");
        dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.variableName = new JComboBox();
        Component component = this.variableName.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            component.addMouseListener(new GraphUtilities.TextFieldDefaultPopup((JTextComponent)component));
        }
        this.variableName.setEditable(true);
        JLabel jLabel2 = new JLabel("Method/Program: ");
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 20, dimension.width, dimension.height);
        this.getContentPane().add(jLabel2);
        this.moduleName = new JTextField();
        this.moduleName.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleName));
        int n2 = LMResize.getRight(jLabel2) + 5;
        this.moduleName.setBounds(n2, LMResize.getTop(jLabel2), LMResize.getLeft(this.refresh) - 10 - n2, this.moduleName.getPreferredSize().height);
        this.getContentPane().add((Component)this.moduleName, new LMResizeData(1));
        this.variableName.setBounds(LMResize.getLeft(this.moduleName), LMResize.getTop(jLabel), this.moduleName.getSize().width, this.variableName.getPreferredSize().height);
        this.getContentPane().add((Component)this.variableName, new LMResizeData(1));
        JLabel jLabel3 = new JLabel("Property: ");
        dimension = lMResize.getPreferredSize(jLabel3);
        jLabel3.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel2) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel3);
        this.propertyName = new JTextField();
        this.propertyName.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyName));
        this.propertyName.setBounds(LMResize.getLeft(this.moduleName), LMResize.getTop(jLabel3), this.moduleName.getSize().width, this.propertyName.getPreferredSize().height);
        this.getContentPane().add((Component)this.propertyName, new LMResizeData(1));
        this.asHex = new JCheckBox("Show Hex Values");
        this.asHex.setMnemonic(88);
        this.asHex.addActionListener(actionEvent -> {
            this.variableModel.setShowHexValues(this.asHex.isSelected());
            this.refreshCurrent();
        });
        dimension = lMResize.getPreferredSize(this.asHex);
        this.asHex.setBounds(LMResize.getLeft(jLabel) + 5, LMResize.getBottom(jLabel3) + 15, dimension.width, dimension.height);
        this.getContentPane().add(this.asHex);
        VariableNode variableNode = new VariableNode("", null, "", null);
        this.variableTree = this.createVariableTree(variableNode, false);
        this.variableScrollPane = new JScrollPane(this.variableTree);
        n2 = LMResize.getLeft(jLabel);
        this.variableScrollPane.setBounds(n2, LMResize.getBottom(this.asHex) + 10, LMResize.getLeft(this.refresh) - 10 - n2, 400);
        this.getContentPane().add((Component)this.variableScrollPane, new LMResizeData(5));
        this.pack();
        this.setDefaultButton(this.refresh);
    }

    private boolean getHexFlag() {
        return this.propertyName.getText().length() == 0 && Settings.getHexOption();
    }

    public boolean isExecutingDisplayCommand() {
        return this.executingDisplayCommand;
    }

    private JTreeTable createVariableTree(VariableNode variableNode, boolean bl) {
        this.variableModel = new VariableModelExt(variableNode, this.asHex.isSelected(), bl);
        this.variableTree = new JTreeTable(this.variableModel);
        this.variableTree.setRootVisible(bl);
        this.variableTree.getTreeTableCellRenderer().setShowsRootHandles(true);
        this.variableTree.setSelectionMode(0);
        this.variableTree.setRowSelectionAllowed(true);
        this.variableTree.setFillsViewportHeight(true);
        this.variableTree.setColumnSelectionAllowed(false);
        this.variableTree.getTableHeader().setReorderingAllowed(false);
        this.variableTree.setDefaultEditor(String.class, GraphUtilities.getValueEditor(this.variableTree));
        this.variableTree.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.variableTree.getColumnModel().getColumn(1).setMaxWidth(80);
        this.variableTree.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.variableTree.getColumnModel().getColumn(2).setMaxWidth(80);
        JTree jTree = this.variableTree.getTreeTableCellRenderer();
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
                this.setIcon(null);
                this.doLayout();
                return this;
            }
        });
        this.variableTree.getTreeTableCellRenderer().addTreeSelectionListener(treeSelectionEvent -> {
            VariableNode variableNode = (VariableNode)jTree.getLastSelectedPathComponent();
            if (variableNode != null) {
                String string = GraphUtilities.nodeToVarname(variableNode);
                int n2 = string.indexOf("::");
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                }
                this.variableName.getEditor().setItem(string);
            }
        });
        return this.variableTree;
    }

    private void addMonitor() {
        Object object = this.variableName.getEditor().getItem();
        String string = null;
        if (object != null && (string = object.toString()).length() > 0) {
            String string2;
            String string3 = this.propertyName.getText();
            DebugResponse debugResponse = this.executeDisplayCommand(string, string3);
            boolean bl = this.getHexFlag();
            if (debugResponse != null && debugResponse.getReturnCode() == 0 && debugResponse.getVarType() == 12) {
                bl = false;
            }
            String string4 = null;
            if (this.moduleName.getText().length() > 0) {
                string4 = this.moduleName.getText();
            }
            if ((string2 = this.graphDebug.showMonitorDialog(string, string4, string3, true, bl)) != null) {
                this.lastCommand = 13;
            }
            this.removeAndInsert(string);
        }
    }

    private void displayTree() {
        this.executingDisplayCommand = true;
        this.refresh();
    }

    public void setVariableName(String string) {
        if (string != null && string.length() > 0) {
            this.variableName.getEditor().setItem(string.trim());
        }
    }

    public void setModuleName(String string) {
        if (string != null && string.length() > 0) {
            this.moduleName.setText(string);
        }
    }

    public boolean commandExecuted(DebugResponse debugResponse) {
        if (debugResponse.getReturnCode() == 0) {
            switch (this.lastCommand) {
                case 5: {
                    this.updateTree(debugResponse);
                    return true;
                }
                case 6: {
                    this.refreshCurrent();
                    break;
                }
            }
        }
        return false;
    }

    private void refreshCurrent() {
        if (this.currVarname != null) {
            String string = this.getDisplayCommand(this.currVarname);
            DebugResponse debugResponse = this.graphDebug.getInvoker().processCommand(string);
            if (debugResponse != null && debugResponse.getReturnCode() == 0) {
                this.updateTree(debugResponse);
            }
        }
    }

    private void updateTree(DebugResponse debugResponse) {
        boolean bl;
        VariableNode variableNode;
        this.executingDisplayCommand = false;
        Tree tree = debugResponse.getTree();
        if (tree != null) {
            variableNode = GraphUtilities.buildVariableNode(tree);
            TreeNode treeNode = tree.getRoot();
            int n2 = treeNode.getChildCount();
            bl = n2 > 1 || n2 == 1 && !treeNode.getVarName().equals(treeNode.getChildren()[0].getVarName());
        } else {
            variableNode = new VariableNode(debugResponse.getVarName(), null, "", null);
            VariableNode variableNode2 = new VariableNode(debugResponse.getVarName(), null, "", variableNode);
            variableNode2.setTextValue(debugResponse.getVarValue());
            bl = false;
        }
        this.variableTree = this.createVariableTree(variableNode, bl);
        this.variableScrollPane.getViewport().setView(this.variableTree);
        new IsguiWorker(false, () -> {
            this.variableScrollPane.doLayout();
            GraphUtilities.expandNode(this.variableTree.getTreeTableCellRenderer(), this.variableModel.getRootNode());
        }).start();
    }

    private DebugResponse executeDisplayCommand(String string, String string2) {
        String string3 = "display";
        if (this.getHexFlag()) {
            string3 = string3 + " -x";
        }
        string3 = string3 + " " + string;
        if (string2.length() > 0) {
            string3 = string3 + " property " + string2;
        }
        return this.graphDebug.getInvoker().processCommand(string3);
    }

    private void modifyValue() {
        Object object = this.variableName.getEditor().getItem();
        String string = null;
        if (object != null && (string = object.toString()).length() > 0) {
            String string2;
            String string3;
            String string4 = this.propertyName.getText();
            String string5 = null;
            boolean bl = this.getHexFlag();
            DebugResponse debugResponse = this.executeDisplayCommand(string, string4);
            if (debugResponse != null && debugResponse.getReturnCode() == 0) {
                if (debugResponse.getVarType() == 12) {
                    string5 = debugResponse.getVarValue().trim();
                    string5 = string5.substring(0, string5.indexOf(32));
                    bl = false;
                } else {
                    string5 = debugResponse.getVarValue().replaceAll("\\s+$", "");
                }
            }
            if ((string3 = this.graphDebug.showAcceptVariableDialog(string, string2 = this.moduleName.getText().length() > 0 ? this.moduleName.getText() : null, string5, string4, bl)) != null) {
                this.lastCommand = 6;
                this.graphDebug.setTextCommand(string3);
            }
            this.removeAndInsert(string);
        }
    }

    private String getDisplayCommand(String string) {
        String string2 = this.propertyName.getText();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("display");
        if (string2.length() == 0) {
            stringBuffer.append(" ");
            stringBuffer.append("-tree");
        }
        if (this.moduleName.getText().length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append("-c");
            stringBuffer.append(" ");
            stringBuffer.append(this.moduleName.getText());
        }
        stringBuffer.append(" ");
        stringBuffer.append(string);
        if (string2.length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append("property");
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void refresh() {
        Object object = this.variableName.getEditor().getItem();
        String string = null;
        if (object != null && (string = object.toString()).length() > 0) {
            String string2 = this.getDisplayCommand(string);
            this.lastCommand = 5;
            this.graphDebug.setTextCommand(string2);
            this.currVarname = string;
            this.removeAndInsert(string);
        }
    }

    private void removeAndInsert(String string) {
        Object object = this.variableName.getEditor().getItem();
        int n2 = this.variableName.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.variableName.getItemAt(i2).toString().equalsIgnoreCase(string)) continue;
            this.variableName.removeItemAt(i2);
            break;
        }
        this.variableName.insertItemAt(string, 0);
        this.variableName.setSelectedItem(object);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void closeDialog() {
        this.active = false;
        super.closeDialog();
    }

    @Override
    public void setVisible(boolean bl) {
        this.active = bl;
        if (bl) {
            this.propertyName.setText("");
            this.variableTree.clearSelection();
            this.variableTree = this.createVariableTree(new VariableNode("", null, "", null), false);
            this.variableScrollPane.getViewport().setView(this.variableTree);
            this.variableScrollPane.doLayout();
            this.refresh();
        }
        super.setVisible(bl);
    }

    private static class VariableModelExt
    extends VariableModel {
        private final boolean showRootNode;

        public VariableModelExt(VariableNode variableNode, boolean bl, boolean bl2) {
            super(variableNode, bl);
            this.showRootNode = bl2;
        }

        @Override
        protected Class[] getColumnTypes() {
            return new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
        }

        @Override
        protected String[] getColumnNames() {
            return new String[]{"Name", "Offset", "Length", "Value", "Hex"};
        }

        @Override
        public Object getValueAt(Object object, int n2) {
            if (object == null || object == this.root && !this.showRootNode) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return ((VariableNode)object).getName();
                }
                case 1: {
                    return String.valueOf(((VariableNode)object).getOffset());
                }
                case 2: {
                    return String.valueOf(((VariableNode)object).getLength());
                }
                case 3: {
                    return ((VariableNode)object).getTextValue();
                }
                case 4: {
                    return this.showHexValues ? ((VariableNode)object).getHexDump() : "";
                }
            }
            return null;
        }
    }
}

