/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SessionSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoSaveChk;
    private JCheckBox confirmExitChk;
    private JCheckBox confirmQuitChk;
    private JCheckBox autoConnectChk;
    private JCheckBox forceStopRunChk;
    private JCheckBox exitAfterTermChk;
    private JSpinner autoConnectSpn;
    private JLabel autoConnectDelayLbl;
    private JLabel autoConnectSecLbl;
    private JTextField customFileNameTxt;
    private JRadioButton defFileNameRb;
    private JRadioButton customFileNameRb;

    public SessionSettingsDialog(JFrame jFrame, String string, boolean bl) {
        super(jFrame, string, bl);
    }

    @Override
    protected void createContents(JPanel jPanel) {
        boolean bl = Settings.getAutosave();
        boolean bl2 = Settings.getAskConfirmWhenExit();
        boolean bl3 = Settings.getAskConfirmWhenQuit();
        boolean bl4 = Settings.getExitAfterTermination();
        boolean bl5 = Settings.getAutoConnect();
        int n2 = Settings.getAutoConnectDelay();
        boolean bl6 = Settings.getForceStopRun();
        String string = Settings.getSessionOutputFileName();
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        jPanel.setLayout(lMResize);
        this.autoSaveChk = new JCheckBox("Save session automatically");
        this.autoSaveChk.setSelected(bl);
        Dimension dimension = lMResize.getPreferredSize(this.autoSaveChk);
        this.autoSaveChk.setBounds(10, 10, dimension.width, dimension.height);
        jPanel.add(this.autoSaveChk);
        this.exitAfterTermChk = new JCheckBox("Exit after program termination");
        this.exitAfterTermChk.setSelected(bl4);
        this.confirmQuitChk = new JCheckBox("Ask confirm when finish session");
        this.confirmQuitChk.setSelected(bl3);
        this.confirmExitChk = new JCheckBox("Ask confirm when exit");
        this.confirmExitChk.setSelected(bl2);
        JPanel jPanel2 = new JPanel();
        LMResize lMResize2 = new LMResize(10, 10, 5, 0);
        jPanel2.setLayout(lMResize2);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Session output file name"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.defFileNameRb = new JRadioButton("Automatic: <PROGRAMNAME>.isd");
        buttonGroup.add(this.defFileNameRb);
        this.defFileNameRb.setSelected(string.length() == 0);
        dimension = lMResize2.getPreferredSize(this.defFileNameRb);
        this.defFileNameRb.setBounds(10, 20, dimension.width, dimension.height);
        jPanel2.add(this.defFileNameRb);
        this.customFileNameRb = new JRadioButton("Custom:");
        buttonGroup.add(this.customFileNameRb);
        this.customFileNameRb.setSelected(string.length() > 0);
        dimension = lMResize2.getPreferredSize(this.customFileNameRb);
        this.customFileNameRb.setBounds(LMResize.getLeft(this.defFileNameRb), LMResize.getBottom(this.defFileNameRb) + 10, dimension.width, dimension.height);
        jPanel2.add(this.customFileNameRb);
        this.customFileNameTxt = new JTextField();
        this.customFileNameTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.customFileNameTxt));
        this.customFileNameTxt.setText(string);
        this.customFileNameTxt.setEnabled(string.length() > 0);
        dimension = lMResize2.getPreferredSize(this.customFileNameTxt);
        this.customFileNameTxt.setBounds(LMResize.getRight(this.customFileNameRb) + 5, LMResize.getTop(this.customFileNameRb), 200, dimension.height);
        jPanel2.add((Component)this.customFileNameTxt, new LMResizeData(1));
        dimension = lMResize2.preferredLayoutSize(jPanel2);
        jPanel2.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.autoSaveChk) + 10, dimension.width, dimension.height);
        jPanel.add((Component)jPanel2, new LMResizeData(1));
        JPanel jPanel3 = new JPanel();
        LMResize lMResize3 = new LMResize(10, 10, 5, 0);
        jPanel3.setLayout(lMResize3);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Remote session"));
        this.autoConnectChk = new JCheckBox("Auto Connect");
        this.autoConnectChk.setSelected(bl5);
        dimension = lMResize3.getPreferredSize(this.autoConnectChk);
        this.autoConnectChk.setBounds(10, 20, dimension.width, dimension.height);
        jPanel3.add(this.autoConnectChk);
        this.autoConnectDelayLbl = new JLabel("Delay:");
        dimension = lMResize3.getPreferredSize(this.autoConnectDelayLbl);
        this.autoConnectDelayLbl.setBounds(LMResize.getRight(this.autoConnectChk) + 10, LMResize.getTop(this.autoConnectChk) + 4, dimension.width, dimension.height);
        jPanel3.add(this.autoConnectDelayLbl);
        this.autoConnectSpn = new JSpinner(new SpinnerNumberModel(n2, 1, 10, 1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.autoConnectSpn);
        this.autoConnectSpn.setEditor(numberEditor);
        numberEditor.getTextField().setEditable(false);
        dimension = lMResize3.getPreferredSize(this.autoConnectSpn);
        this.autoConnectSpn.setBounds(LMResize.getRight(this.autoConnectDelayLbl) + 5, LMResize.getTop(this.autoConnectDelayLbl), 70, dimension.height);
        jPanel3.add(this.autoConnectSpn);
        this.autoConnectSecLbl = new JLabel("seconds");
        dimension = lMResize3.getPreferredSize(this.autoConnectSecLbl);
        this.autoConnectSecLbl.setBounds(LMResize.getRight(this.autoConnectSpn) + 5, LMResize.getTop(this.autoConnectDelayLbl), dimension.width, dimension.height);
        jPanel3.add(this.autoConnectSecLbl);
        this.forceStopRunChk = new JCheckBox("Force STOP RUN after disconnect");
        this.forceStopRunChk.setSelected(bl6);
        dimension = lMResize3.getPreferredSize(this.forceStopRunChk);
        this.forceStopRunChk.setBounds(LMResize.getLeft(this.autoConnectChk), LMResize.getBottom(this.autoConnectChk) + 10, dimension.width, dimension.height);
        jPanel3.add(this.forceStopRunChk);
        dimension = lMResize3.preferredLayoutSize(jPanel3);
        jPanel3.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(jPanel2) + 10, jPanel2.getSize().width, dimension.height);
        jPanel.add((Component)jPanel3, new LMResizeData(1));
        dimension = lMResize.getPreferredSize(this.exitAfterTermChk);
        this.exitAfterTermChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(jPanel3) + 10, dimension.width, dimension.height);
        jPanel.add(this.exitAfterTermChk);
        dimension = lMResize.getPreferredSize(this.confirmQuitChk);
        this.confirmQuitChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.exitAfterTermChk) + 10, dimension.width, dimension.height);
        jPanel.add(this.confirmQuitChk);
        dimension = lMResize.getPreferredSize(this.confirmExitChk);
        this.confirmExitChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.confirmQuitChk) + 10, dimension.width, dimension.height);
        jPanel.add(this.confirmExitChk);
        ActionListener actionListener = actionEvent -> this.setDirty(true);
        this.autoSaveChk.addActionListener(actionListener);
        this.autoConnectChk.addActionListener(actionListener);
        this.exitAfterTermChk.addActionListener(actionListener);
        this.confirmQuitChk.addActionListener(actionListener);
        this.confirmExitChk.addActionListener(actionListener);
        this.forceStopRunChk.addActionListener(actionListener);
        this.defFileNameRb.addActionListener(actionEvent -> {
            this.customFileNameTxt.setEnabled(false);
            this.setDirty(true);
        });
        this.customFileNameRb.addActionListener(actionEvent -> {
            this.customFileNameTxt.setEnabled(true);
            this.setDirty(true);
        });
        this.customFileNameTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SessionSettingsDialog.this.setDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SessionSettingsDialog.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.autoConnectSpn.addChangeListener(changeEvent -> this.setDirty(true));
    }

    @Override
    protected void performApply() {
        Settings.setAutosave(this.autoSaveChk.isSelected());
        String string = "";
        if (this.customFileNameRb.isSelected()) {
            string = this.customFileNameTxt.getText().trim();
        }
        if (string.length() > 0 && string.lastIndexOf(46) < 0) {
            string = string + ".isd";
        }
        Settings.setSessionOutputFileName(string);
        Settings.setAutoConnect(this.autoConnectChk.isSelected());
        Settings.setAutoConnectDelay((Integer)this.autoConnectSpn.getValue());
        Settings.setExitAfterTermination(this.exitAfterTermChk.isSelected());
        Settings.setAskConfirmWhenQuit(this.confirmQuitChk.isSelected());
        Settings.setAskConfirmWhenExit(this.confirmExitChk.isSelected());
        Settings.setForceStopRun(this.forceStopRunChk.isSelected());
        super.performApply();
    }
}

