/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class SettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private DefaultListModel namesModel;
    private JList namesList;
    private JList stylesList;
    private JList sizesList;
    private JTextField nameField;
    private JTextField styleField;
    private JTextField sizeField;
    private JLabel previewLabel;
    private JCheckBox lafChk;
    private JLabel backLbl;
    private JLabel foreLbl;
    private JButton backBtn;
    private JButton foreBtn;
    private JTree settingsTree;
    private DebugPanel debugPanel;
    private Settings.FontAndColors copySource;
    private Settings.FontAndColors[] settings;
    private HashMap<Settings.FontAndColors, Settings.FontAndColors> cloneTable;

    public SettingsDialog(JFrame jFrame, String string, boolean bl, DebugPanel debugPanel) {
        super(jFrame, string, bl);
        this.debugPanel = debugPanel;
    }

    @Override
    protected void createContents(JPanel jPanel) {
        Object object;
        Serializable serializable;
        this.cloneTable = new HashMap();
        Settings.FontAndColors[] fontAndColorsArray = Settings.getSettings();
        this.settings = new Settings.FontAndColors[fontAndColorsArray.length];
        for (int i2 = 0; i2 < fontAndColorsArray.length; ++i2) {
            this.settings[i2] = this.cloneFontAndColors(fontAndColorsArray[i2]);
        }
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        JLabel jLabel = new JLabel("Name");
        jPanel.add(jLabel);
        this.nameField = new JTextField(19);
        this.nameField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.nameField));
        this.nameField.setEditable(false);
        this.nameField.setBackground(Color.white);
        jPanel.add(this.nameField);
        this.namesModel = new DefaultListModel();
        for (int i3 = 0; i3 < Settings.getFonts().length; ++i3) {
            this.namesModel.addElement(Settings.getFonts()[i3]);
        }
        this.namesList = new JList(this.namesModel);
        this.namesList.addListSelectionListener(listSelectionEvent -> {
            this.nameField.setText(this.namesList.getSelectedValue().toString());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode != null) {
                Font font = this.getSelectedFont();
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                fontAndColors.setFont(font);
                fontAndColors.setModified(true);
                this.updatePreview(font);
                this.setDirty(true);
            }
        });
        this.namesList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.namesList);
        jPanel.add(jScrollPane);
        JLabel jLabel2 = new JLabel("Style");
        jPanel.add(jLabel2);
        this.styleField = new JTextField(8);
        this.styleField.setEditable(false);
        this.styleField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.styleField));
        this.styleField.setBackground(Color.white);
        jPanel.add(this.styleField);
        this.stylesList = new JList<String>(Settings.getStylesNames());
        this.stylesList.addListSelectionListener(listSelectionEvent -> {
            this.styleField.setText(this.stylesList.getSelectedValue().toString());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode != null) {
                Font font = this.getSelectedFont();
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                fontAndColors.setFont(font);
                fontAndColors.setModified(true);
                this.updatePreview(font);
                this.setDirty(true);
            }
        });
        this.stylesList.setSelectionMode(0);
        JScrollPane jScrollPane2 = new JScrollPane(this.stylesList);
        jPanel.add(jScrollPane2);
        JLabel jLabel3 = new JLabel("Size");
        jPanel.add(jLabel3);
        this.sizeField = new JTextField(6);
        this.sizeField.setEditable(false);
        this.sizeField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.sizeField));
        this.sizeField.setBackground(Color.white);
        jPanel.add(this.sizeField);
        Integer[] integerArray = new Integer[12];
        int n2 = 9;
        int n3 = 0;
        while (n2 <= 20) {
            integerArray[n3] = new Integer(n2);
            ++n2;
            ++n3;
        }
        this.sizesList = new JList<Integer>(integerArray);
        this.sizesList.addListSelectionListener(listSelectionEvent -> {
            this.sizeField.setText(this.sizesList.getSelectedValue().toString());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode != null) {
                Font font = this.getSelectedFont();
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                fontAndColors.setFont(font);
                fontAndColors.setModified(true);
                this.updatePreview(font);
                this.setDirty(true);
            }
        });
        this.sizesList.setSelectionMode(0);
        JScrollPane jScrollPane3 = new JScrollPane(this.sizesList);
        jPanel.add(jScrollPane3);
        this.lafChk = new JCheckBox("default LAF colors");
        jPanel.add(this.lafChk);
        this.lafChk.addActionListener(actionEvent -> this.lafChkStateChanged());
        this.backLbl = new JLabel("Background");
        jPanel.add(this.backLbl);
        this.backBtn = new JButton("...");
        this.backBtn.setPreferredSize(new Dimension(30, this.backBtn.getPreferredSize().height));
        jPanel.add(this.backBtn);
        this.backBtn.addActionListener(actionEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Color color = JColorChooser.showDialog(this, "Choose background", this.backBtn.getBackground());
            if (color != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent()) != null) {
                boolean bl = true;
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                if (fontAndColors.getName().startsWith("Level ")) {
                    int n2 = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
                    Settings.FontAndColors[] fontAndColorsArray = this.copySource.getChildren();
                    for (int i2 = 0; i2 < fontAndColorsArray.length && bl; ++i2) {
                        bl = i2 == n2 || !color.equals(fontAndColorsArray[i2].getBackground());
                    }
                }
                if (bl) {
                    fontAndColors.setBackground(color);
                    fontAndColors.setModified(true);
                    this.updateBackground(color);
                    this.setDirty(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Duplicate Color!", "ERROR", 0);
                }
            }
        });
        this.foreLbl = new JLabel("Foreground");
        jPanel.add(this.foreLbl);
        this.foreBtn = new JButton("...");
        this.foreBtn.setPreferredSize(new Dimension(30, this.foreBtn.getPreferredSize().height));
        jPanel.add(this.foreBtn);
        this.foreBtn.addActionListener(actionEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Color color = JColorChooser.showDialog(this, "Choose foreground", this.foreBtn.getBackground());
            if (color != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent()) != null) {
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                fontAndColors.setForeground(color);
                fontAndColors.setModified(true);
                this.updateForeground(color);
                this.setDirty(true);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        this.previewLabel = new JLabel("isCOBOL Debugger");
        this.previewLabel.setOpaque(true);
        this.previewLabel.setHorizontalAlignment(0);
        jPanel2.add(this.previewLabel);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), "Preview", 0, 1, this.foreBtn.getFont()));
        jPanel.add(jPanel2);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.settingsTree = new JTree(defaultTreeModel);
        this.settingsTree.setRootVisible(false);
        this.settingsTree.setShowsRootHandles(true);
        this.settingsTree.addTreeSelectionListener(treeSelectionEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode != null) {
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                if (fontAndColors.getName().equals("Copy source")) {
                    fontAndColors = this.copySource.getChildren()[0];
                }
                boolean bl = this.isDirty();
                this.lafChk.setSelected(fontAndColors.isInheritFromLaf());
                this.lafChkStateChanged();
                this.updateFont(fontAndColors.getFont(), !fontAndColors.isFontInherited());
                this.updateBackground(fontAndColors.getBackground(), !fontAndColors.isBackgroundInherited());
                this.updateForeground(fontAndColors.getForeground(), !fontAndColors.isForegroundInherited());
                this.setDirty(bl);
            }
        });
        for (Settings.FontAndColors object22 : this.settings) {
            serializable = new DefaultMutableTreeNode(object22);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            if (!object22.getName().equals("Copy source")) continue;
            this.copySource = object22;
            object = object22.getChildren();
            for (int jScrollPane4 = 0; jScrollPane4 < ((Settings.FontAndColors[])object).length; ++jScrollPane4) {
                ((DefaultMutableTreeNode)serializable).add(new DefaultMutableTreeNode(object[jScrollPane4]));
            }
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add");
        ActionListener actionListener = actionEvent -> {
            Color color = JColorChooser.showDialog(this, "Choose background", this.backBtn.getBackground());
            if (color != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
                Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                if (!fontAndColors.getName().equals("Copy source")) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                }
                boolean bl = true;
                Settings.FontAndColors[] fontAndColorsArray = this.copySource.getChildren();
                for (int i2 = 0; i2 < fontAndColorsArray.length && bl; ++i2) {
                    bl = !color.equals(fontAndColorsArray[i2].getBackground());
                }
                if (bl) {
                    Settings.FontAndColors[] fontAndColorsArray2 = new Settings.FontAndColors[fontAndColorsArray.length + 1];
                    System.arraycopy(fontAndColorsArray, 0, fontAndColorsArray2, 0, fontAndColorsArray.length);
                    fontAndColorsArray2[fontAndColorsArray.length] = new Settings.FontAndColors(fontAndColors, "Level " + fontAndColorsArray2.length, null, color, null);
                    this.copySource.setChildren(fontAndColorsArray2);
                    this.copySource.setModified(true);
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(fontAndColorsArray2[fontAndColorsArray2.length - 1]));
                    defaultTreeModel.reload();
                    this.settingsTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                    this.setDirty(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Duplicate Color!", "ERROR", 0);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        final JPopupMenu jPopupMenu2 = new JPopupMenu();
        serializable = new JMenuItem("Add");
        ((AbstractButton)serializable).addActionListener(actionListener);
        jPopupMenu2.add((JMenuItem)serializable);
        object = new JMenuItem("Remove");
        ((AbstractButton)object).addActionListener(actionEvent -> {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2.getChildCount() > 1) {
                Settings.FontAndColors[] fontAndColorsArray = this.copySource.getChildren();
                Settings.FontAndColors[] fontAndColorsArray2 = new Settings.FontAndColors[fontAndColorsArray.length - 1];
                int n2 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                int n3 = 0;
                for (int i2 = 0; i2 < fontAndColorsArray.length; ++i2) {
                    if (i2 == n2) continue;
                    fontAndColorsArray2[n3] = fontAndColorsArray[i2];
                    fontAndColorsArray2[n3].setName("Level " + (n3 + 1));
                    ++n3;
                }
                defaultMutableTreeNode2.remove(n2);
                this.copySource.setChildren(fontAndColorsArray2);
                this.copySource.setModified(true);
                defaultTreeModel.reload();
                this.settingsTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                this.setDirty(true);
            } else {
                JOptionPane.showMessageDialog(this, "There must be at least one color pattern", "ERROR", 0);
            }
        });
        jPopupMenu2.add((JMenuItem)object);
        this.settingsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (mouseEvent.isPopupTrigger() && (defaultMutableTreeNode = (DefaultMutableTreeNode)SettingsDialog.this.settingsTree.getLastSelectedPathComponent()) != null) {
                    Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
                    if (fontAndColors.getName().equals("Copy source")) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (fontAndColors.getName().startsWith("Level ")) {
                        jPopupMenu2.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        JScrollPane jScrollPane4 = new JScrollPane(this.settingsTree);
        jScrollPane4.setPreferredSize(new Dimension(270, 540));
        this.settingsTree.setRowHeight(this.settingsTree.getFontMetrics(this.settingsTree.getFont()).getHeight() + 2);
        jPanel.add(jScrollPane4);
        springLayout.putConstraint("North", (Component)jScrollPane4, 10, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jScrollPane4, 10, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jPanel, 5, "South", (Component)jScrollPane4);
        springLayout.putConstraint("West", (Component)jLabel, 30, "East", (Component)jScrollPane4);
        springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.nameField, 0, "West", (Component)jLabel);
        springLayout.putConstraint("North", (Component)this.nameField, 3, "South", (Component)jLabel);
        springLayout.putConstraint("West", (Component)jScrollPane, 0, "West", (Component)this.nameField);
        springLayout.putConstraint("East", (Component)jScrollPane, 0, "East", (Component)this.nameField);
        springLayout.putConstraint("North", (Component)jScrollPane, 1, "South", (Component)this.nameField);
        springLayout.putConstraint("South", (Component)jScrollPane, 310, "North", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)jLabel2, 30, "East", (Component)this.nameField);
        springLayout.putConstraint("North", (Component)jLabel2, 0, "North", (Component)jLabel);
        springLayout.putConstraint("West", (Component)this.styleField, 0, "West", (Component)jLabel2);
        springLayout.putConstraint("North", (Component)this.styleField, 3, "South", (Component)jLabel2);
        springLayout.putConstraint("West", (Component)jScrollPane2, 0, "West", (Component)this.styleField);
        springLayout.putConstraint("East", (Component)jScrollPane2, 0, "East", (Component)this.styleField);
        springLayout.putConstraint("North", (Component)jScrollPane2, 1, "South", (Component)this.styleField);
        springLayout.putConstraint("South", (Component)jScrollPane2, 0, "South", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)jLabel3, 30, "East", (Component)this.styleField);
        springLayout.putConstraint("North", (Component)jLabel3, 0, "North", (Component)jLabel2);
        springLayout.putConstraint("West", (Component)this.sizeField, 0, "West", (Component)jLabel3);
        springLayout.putConstraint("North", (Component)this.sizeField, 3, "South", (Component)jLabel3);
        springLayout.putConstraint("East", (Component)jPanel, 10, "East", (Component)this.sizeField);
        springLayout.putConstraint("West", (Component)jScrollPane3, 0, "West", (Component)this.sizeField);
        springLayout.putConstraint("East", (Component)jScrollPane3, 0, "East", (Component)this.sizeField);
        springLayout.putConstraint("North", (Component)jScrollPane3, 1, "South", (Component)this.sizeField);
        springLayout.putConstraint("South", (Component)jScrollPane3, 0, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.lafChk, 27, "South", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)this.lafChk, 0, "West", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.backLbl, 30, "South", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)this.backLbl, 20, "East", (Component)this.lafChk);
        springLayout.putConstraint("North", (Component)this.backBtn, -3, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.backBtn, 10, "East", (Component)this.backLbl);
        springLayout.putConstraint("North", (Component)this.foreLbl, 0, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.foreLbl, 10, "East", (Component)this.backBtn);
        springLayout.putConstraint("North", (Component)this.foreBtn, -3, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.foreBtn, 10, "East", (Component)this.foreLbl);
        springLayout.putConstraint("North", (Component)jPanel2, 30, "South", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)jPanel2, 0, "West", (Component)jScrollPane);
        springLayout.putConstraint("South", (Component)jPanel2, 0, "South", (Component)jScrollPane4);
        springLayout.putConstraint("East", (Component)jPanel2, 0, "East", (Component)this.sizeField);
        defaultTreeModel.reload();
    }

    @Override
    public Rectangle openDialog(Rectangle rectangle) {
        this.settingsTree.setSelectionRow(0);
        return super.openDialog(rectangle);
    }

    private void selectFontName(String string) {
        int n2 = this.namesModel.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase(this.namesModel.elementAt(i2).toString())) continue;
            this.namesList.setSelectedIndex(i2);
            this.namesList.ensureIndexIsVisible(i2);
            break;
        }
    }

    private Font getSelectedFont() {
        String string = this.nameField.getText();
        String string2 = this.styleField.getText();
        String string3 = this.sizeField.getText();
        int n2 = 0;
        if (string2.equalsIgnoreCase("Italic")) {
            n2 = 2;
        } else if (string2.equalsIgnoreCase("Bold")) {
            n2 = 1;
        } else if (string2.equalsIgnoreCase("Bold Italic")) {
            n2 = 3;
        }
        int n3 = 12;
        try {
            n3 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font(string, n2, n3);
    }

    private void updatePreview(Font font) {
        this.previewLabel.setFont(font);
    }

    private void updateBackground(Color color) {
        this.updateBackground(color, true);
    }

    private void updateBackground(Color color, boolean bl) {
        this.backBtn.setBackground(color);
        this.previewLabel.setBackground(color);
        this.backLbl.setEnabled(bl && !this.lafChk.isSelected());
        this.backBtn.setEnabled(bl && !this.lafChk.isSelected());
    }

    private void updateForeground(Color color) {
        this.updateForeground(color, true);
    }

    private void updateForeground(Color color, boolean bl) {
        this.foreBtn.setBackground(color);
        this.previewLabel.setForeground(color);
        this.foreLbl.setEnabled(bl && !this.lafChk.isSelected());
        this.foreBtn.setEnabled(bl && !this.lafChk.isSelected());
    }

    private void updateFont(Font font, boolean bl) {
        this.selectFontName(font.getName());
        if (font.isPlain()) {
            this.stylesList.setSelectedIndex(0);
        } else if (font.isBold() && font.isItalic()) {
            this.stylesList.setSelectedIndex(3);
        } else if (font.isBold()) {
            this.stylesList.setSelectedIndex(2);
        } else {
            this.stylesList.setSelectedIndex(1);
        }
        int n2 = font.getSize() - 9;
        this.sizesList.setSelectedIndex(n2);
        this.sizesList.ensureIndexIsVisible(n2);
        this.nameField.setEnabled(bl);
        this.namesList.setEnabled(bl);
        this.styleField.setEnabled(bl);
        this.stylesList.setEnabled(bl);
        this.sizeField.setEnabled(bl);
        this.sizesList.setEnabled(bl);
    }

    private Settings.FontAndColors cloneFontAndColors(Settings.FontAndColors fontAndColors) {
        Settings.FontAndColors[] fontAndColorsArray;
        Settings.FontAndColors fontAndColors2 = this.cloneTable.get(fontAndColors);
        if (fontAndColors2 == null) {
            fontAndColors2 = fontAndColors.Clone();
            this.cloneTable.put(fontAndColors, fontAndColors2);
        }
        if (fontAndColors.getSuper() != null) {
            fontAndColorsArray = this.cloneTable.get(fontAndColors.getSuper());
            if (fontAndColorsArray == null) {
                fontAndColorsArray = fontAndColors.getSuper().Clone();
                this.cloneTable.put(fontAndColors.getSuper(), (Settings.FontAndColors)fontAndColorsArray);
            }
            fontAndColors2.setSuper((Settings.FontAndColors)fontAndColorsArray);
        }
        if (fontAndColors.getChildren() != null) {
            fontAndColorsArray = new Settings.FontAndColors[fontAndColors.getChildren().length];
            for (int i2 = 0; i2 < fontAndColors.getChildren().length; ++i2) {
                fontAndColorsArray[i2] = this.cloneFontAndColors(fontAndColors.getChildren()[i2]);
            }
            fontAndColors2.setChildren(fontAndColorsArray);
        }
        return fontAndColors2;
    }

    private void lafChkStateChanged() {
        boolean bl = this.lafChk.isSelected();
        this.backLbl.setEnabled(!bl);
        this.backBtn.setEnabled(!bl);
        this.foreLbl.setEnabled(!bl);
        this.foreBtn.setEnabled(!bl);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            Settings.FontAndColors fontAndColors = (Settings.FontAndColors)defaultMutableTreeNode.getUserObject();
            if (!bl) {
                fontAndColors.setBackground(fontAndColors.getBackground());
                fontAndColors.setForeground(fontAndColors.getForeground());
            }
            fontAndColors.setInheritFromLaf(bl);
            this.updateBackground(fontAndColors.getBackground());
            this.updateForeground(fontAndColors.getForeground());
            fontAndColors.setModified(true);
            this.setDirty(true);
        }
    }

    @Override
    protected void performApply() {
        Settings.setSettings(this.settings);
        for (int i2 = 0; i2 < this.settings.length; ++i2) {
            Settings.FontAndColors fontAndColors = this.settings[i2];
            String string = fontAndColors.getName();
            if (string.equals("Copy source")) {
                Settings.FontAndColors[] fontAndColorsArray = fontAndColors.getChildren();
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = fontAndColors.isModified();
                for (int i3 = 0; i3 < fontAndColorsArray.length; ++i3) {
                    stringBuffer.append(fontAndColorsArray[i3].getBackground().getRGB());
                    if (i3 < fontAndColorsArray.length - 1) {
                        stringBuffer.append(";");
                    }
                    bl |= fontAndColorsArray[i3].isModified();
                    fontAndColorsArray[i3].setModified(false);
                }
                Settings.setCopySourcePattern(stringBuffer.toString());
                if (bl && this.debugPanel != null) {
                    this.debugPanel.setCopySourcePattern(stringBuffer.toString());
                }
            } else if (fontAndColors.isModified() && this.debugPanel != null) {
                if (string.equals("Source code")) {
                    this.debugPanel.setSourceFont(fontAndColors.getFont());
                    this.debugPanel.setSourceBackground(fontAndColors.getBackground());
                    this.debugPanel.setSourceForeground(fontAndColors.getForeground());
                } else if (string.equals("Highlighted by search")) {
                    this.debugPanel.setHighBackground(fontAndColors.getBackground());
                    this.debugPanel.setHighForeground(fontAndColors.getForeground());
                } else if (string.equals("Source code (selected)")) {
                    this.debugPanel.setSelectedBackground(fontAndColors.getBackground());
                } else if (string.equals("Comments")) {
                    this.debugPanel.setCommentForeground(fontAndColors.getForeground());
                } else if (string.equals("Keywords")) {
                    this.debugPanel.setKeywordForeground(fontAndColors.getForeground());
                } else if (string.equals("String literals")) {
                    this.debugPanel.setStringForeground(fontAndColors.getForeground());
                } else if (string.equals("Numeric literals")) {
                    this.debugPanel.setNumberForeground(fontAndColors.getForeground());
                } else if (string.equals("Statements")) {
                    this.debugPanel.setStatementForeground(fontAndColors.getForeground());
                } else if (string.equals("Level numbers")) {
                    this.debugPanel.setLevelNumberForeground(fontAndColors.getForeground());
                } else if (string.equals("Figurative constants")) {
                    this.debugPanel.setFigurativeConstantForeground(fontAndColors.getForeground());
                } else if (string.equals("Line number column")) {
                    this.debugPanel.setLNBackground(fontAndColors.getBackground());
                    this.debugPanel.setLNForeground(fontAndColors.getForeground());
                } else if (string.equals("Current line")) {
                    this.debugPanel.setCurrLineBackground(fontAndColors.getBackground());
                } else if (string.equals("Breakpoint column")) {
                    this.debugPanel.setBPColBackground(fontAndColors.getBackground());
                } else if (string.equals("Variable hint")) {
                    this.debugPanel.setTipFont(fontAndColors.getFont());
                    this.debugPanel.setTipBackground(fontAndColors.getBackground());
                    this.debugPanel.setTipForeground(fontAndColors.getForeground());
                } else if (string.equals("Perform stack")) {
                    this.debugPanel.setPSFont(fontAndColors.getFont());
                    this.debugPanel.setPSBackground(fontAndColors.getBackground());
                    this.debugPanel.setPSForeground(fontAndColors.getForeground());
                } else if (string.equals("Perform stack (selected)")) {
                    this.debugPanel.setPSSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setPSSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Breakpoint list")) {
                    this.debugPanel.setBPLFont(fontAndColors.getFont());
                    this.debugPanel.setBPLBackground(fontAndColors.getBackground());
                    this.debugPanel.setBPLForeground(fontAndColors.getForeground());
                } else if (string.equals("Breakpoint list (selected)")) {
                    this.debugPanel.setBPLSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setBPLSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Monitor list")) {
                    this.debugPanel.setMLFont(fontAndColors.getFont());
                    this.debugPanel.setMLBackground(fontAndColors.getBackground());
                    this.debugPanel.setMLForeground(fontAndColors.getForeground());
                } else if (string.equals("Monitor list (selected)")) {
                    this.debugPanel.setMLSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setMLSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Command history")) {
                    this.debugPanel.setCHFont(fontAndColors.getFont());
                    this.debugPanel.setCHBackground(fontAndColors.getBackground());
                    this.debugPanel.setCHForeground(fontAndColors.getForeground());
                } else if (string.equals("Command history (selected)")) {
                    this.debugPanel.setCHSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setCHSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Thread list")) {
                    this.debugPanel.setTLFont(fontAndColors.getFont());
                    this.debugPanel.setTLBackground(fontAndColors.getBackground());
                    this.debugPanel.setTLForeground(fontAndColors.getForeground());
                } else if (string.equals("Display tree area")) {
                    this.debugPanel.setDTFont(fontAndColors.getFont());
                    this.debugPanel.setDTBackground(fontAndColors.getBackground());
                    this.debugPanel.setDTForeground(fontAndColors.getForeground());
                } else if (string.equals("Display tree area (selected)")) {
                    this.debugPanel.setDTSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setDTSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Output area")) {
                    this.debugPanel.setOutputFont(fontAndColors.getFont());
                    this.debugPanel.setOutputBackground(fontAndColors.getBackground());
                    this.debugPanel.setOutputForeground(fontAndColors.getForeground());
                } else if (string.equals("Console")) {
                    this.debugPanel.setConsoleFont(fontAndColors.getFont());
                    this.debugPanel.setConsoleBackground(fontAndColors.getBackground());
                    this.debugPanel.setConsoleForeground(fontAndColors.getForeground());
                } else if (string.equals("Output area (selected)")) {
                    this.debugPanel.setOutputSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setOutputSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Console (selected)")) {
                    this.debugPanel.setConsoleSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setConsoleSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Console StdErr")) {
                    this.debugPanel.setConsoleStdErrForeground(fontAndColors.getForeground());
                } else if (string.equals("Line command")) {
                    this.debugPanel.setInputFont(fontAndColors.getFont());
                    this.debugPanel.setInputBackground(fontAndColors.getBackground());
                    this.debugPanel.setInputForeground(fontAndColors.getForeground());
                } else if (string.equals("Line command (selected)")) {
                    this.debugPanel.setInputSelBackground(fontAndColors.getBackground());
                    this.debugPanel.setInputSelForeground(fontAndColors.getForeground());
                } else if (string.equals("Breakpoint line")) {
                    this.debugPanel.setBreakpointBackground(fontAndColors.getBackground());
                }
            }
            fontAndColors.setModified(false);
        }
        super.performApply();
    }
}

