/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TraceDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField levelField;
    private JTextField logfileField;
    private JButton ok;
    private JButton close;

    public TraceDialog(JFrame jFrame, String string, boolean bl) {
        super(jFrame, string, bl);
        LMResize lMResize = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(lMResize);
        JLabel jLabel = new JLabel("Trace level:");
        Dimension dimension = lMResize.getPreferredSize(jLabel);
        jLabel.setBounds(10, 10, dimension.width, dimension.height);
        this.getContentPane().add(jLabel);
        this.levelField = new JTextField(5);
        this.levelField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.levelField));
        this.levelField.setBounds(LMResize.getRight(jLabel) + 5, LMResize.getTop(jLabel), 50, this.levelField.getPreferredSize().height);
        this.getContentPane().add(this.levelField);
        JLabel jLabel2 = new JLabel("Log file:");
        dimension = lMResize.getPreferredSize(jLabel2);
        jLabel2.setBounds(LMResize.getLeft(jLabel), LMResize.getBottom(jLabel) + 15, dimension.width, dimension.height);
        this.getContentPane().add(jLabel2);
        this.logfileField = new JTextField();
        this.logfileField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.logfileField));
        this.logfileField.setBounds(LMResize.getLeft(this.levelField), LMResize.getTop(jLabel2), 150, this.logfileField.getPreferredSize().height);
        this.getContentPane().add((Component)this.logfileField, new LMResizeData(1));
        JButton jButton = new JButton("...");
        jButton.setBounds(LMResize.getRight(this.logfileField) + 5, LMResize.getTop(this.logfileField), 20, this.logfileField.getSize().height);
        jButton.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("user.home", ".")));
            jFileChooser.showDialog(this, "OK");
            File file = jFileChooser.getSelectedFile();
            if (file != null) {
                this.logfileField.setText(file.getPath());
            }
        });
        this.getContentPane().add((Component)jButton, new LMResizeData(2));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(actionEvent -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(actionEvent -> this.closeDialog());
        dimension = lMResize.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(jButton) - dimension.width + 5, LMResize.getBottom(jButton) + 20, dimension.width, dimension.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - dimension.width, LMResize.getTop(this.close), dimension.width, dimension.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String string = this.levelField.getText();
        if (string.length() > 0) {
            this.commandString = "tron " + string;
            string = this.logfileField.getText();
            if (string.length() > 0) {
                this.commandString = this.commandString + " \"" + string + "\"";
            }
        } else {
            this.commandString = null;
        }
    }
}

