/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.dialogs.treetable.model.VectorModel;

public class CallStackModel
extends VectorModel {
    public CallStackModel(GraphDebugger graphDebugger) {
        super(new Class[]{String.class, String.class, String.class}, new String[]{"Paragraph", "Program", "Location"}, graphDebugger);
    }

    @Override
    public boolean isCellEditable(Object object, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(Object object, int n2) {
        if (object == this.vector) {
            return null;
        }
        ParagraphObject paragraphObject = (ParagraphObject)object;
        switch (n2) {
            case 0: {
                String string = paragraphObject.getName();
                if (paragraphObject.getParentSection() != null) {
                    string = string + " of " + paragraphObject.getParentSection();
                }
                return string;
            }
            case 1: {
                String string = paragraphObject.getProgName();
                if (paragraphObject.getEntryPointName() != null) {
                    string = paragraphObject.getEntryPointName() + " of " + string;
                } else if (paragraphObject.getMethodName() != null) {
                    string = paragraphObject.getMethodName() + " of " + string;
                }
                return string;
            }
            case 2: {
                String string = paragraphObject.getFile();
                if (string != null) {
                    return string + ":" + paragraphObject.getLine();
                }
                return String.valueOf(paragraphObject.getLine());
            }
        }
        return null;
    }
}

