/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.dialogs.treetable.model.VectorModel;

public class ThreadModel
extends VectorModel {
    protected String currThread = "";

    public ThreadModel(GraphDebugger graphDebugger) {
        super(new Class[]{Boolean.class, String.class, String.class, String.class}, new String[]{"", "Name", "Paragraph", "Program"}, 0, graphDebugger);
    }

    @Override
    public void setValueAt(Object object, Object object2, int n2) {
        if (object2 == this.vector || n2 != 0 || !(object instanceof Boolean) || this.graphDebug.isProcessing()) {
            return;
        }
        ThreadObject threadObject = (ThreadObject)object2;
        if (!threadObject.getName().equals(this.currThread)) {
            this.graphDebug.setTextCommand("thread " + threadObject.getName());
        }
    }

    public String getCurrThread() {
        return this.currThread;
    }

    public void setCurrThread(String string) {
        this.currThread = string;
    }

    @Override
    public Object getValueAt(Object object, int n2) {
        if (object == this.vector) {
            return null;
        }
        ThreadObject threadObject = (ThreadObject)object;
        switch (n2) {
            case 0: {
                return new Boolean(threadObject.getName().equals(this.currThread));
            }
            case 1: {
                return threadObject.getName();
            }
            case 2: {
                ParagraphObject[] paragraphObjectArray = threadObject.getParStack();
                if (paragraphObjectArray != null && paragraphObjectArray.length > 0) {
                    return paragraphObjectArray[paragraphObjectArray.length - 1].getName();
                }
                return null;
            }
            case 3: {
                ParagraphObject[] paragraphObjectArray = threadObject.getParStack();
                if (paragraphObjectArray != null && paragraphObjectArray.length > 0) {
                    return paragraphObjectArray[paragraphObjectArray.length - 1].getProgName();
                }
                return null;
            }
        }
        return null;
    }
}

