/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.gui.client.swing.treetable.AbstractTreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import java.util.HashMap;
import java.util.Map;

public class VariableModel
extends AbstractTreeTableModel {
    protected VariableNode rootNode;
    private Map cache = new HashMap();
    private Class[] columnTypes;
    private String[] columnNames;
    protected boolean showHexValues;

    public VariableModel(VariableNode variableNode, boolean bl) {
        super(variableNode);
        this.rootNode = (VariableNode)this.getRoot();
        this.columnNames = this.getColumnNames();
        this.columnTypes = this.getColumnTypes();
        this.showHexValues = bl;
    }

    protected Class[] getColumnTypes() {
        return new Class[]{TreeTableModel.class, String.class, String.class};
    }

    @Override
    public boolean isCellEditable(Object object, int n2) {
        return n2 == 0;
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Value", "Hex"};
    }

    public VariableNode getRootNode() {
        return this.rootNode;
    }

    public void updateRoot(VariableNode variableNode) {
        this.updateNode(this.rootNode, variableNode);
    }

    public void updateNode(VariableNode variableNode, VariableNode variableNode2) {
        int n2;
        variableNode.setName(variableNode2.getName());
        variableNode.setHexDump(variableNode2.getHexDump());
        variableNode.setTextValue(variableNode2.getTextValue());
        variableNode.setHasChildren(variableNode2.hasChildren());
        int n3 = variableNode.getChildCount();
        int n4 = variableNode2.getChildCount();
        int n5 = Math.min(n4, n3);
        for (n2 = 0; n2 < n5; ++n2) {
            this.updateNode((VariableNode)variableNode.getChildAt(n2), (VariableNode)variableNode2.getChildAt(n2));
        }
        this.cache.remove(variableNode);
        n2 = variableNode2.getChildCount() - variableNode.getChildCount();
        if (n2 != 0) {
            if (n2 > 0) {
                for (int i2 = n5; i2 < n4; ++i2) {
                    VariableNode variableNode3 = (VariableNode)variableNode2.getChildAt(i2);
                    variableNode.addChild(variableNode3);
                }
            } else {
                for (int i3 = n5; i3 < n3; ++i3) {
                    VariableNode variableNode4 = (VariableNode)variableNode.getChildAt(n5);
                    variableNode.removeChildAt(n5);
                    this.cache.remove(variableNode4);
                }
            }
            this.cache.put(variableNode, variableNode.getChildren().toArray());
        }
    }

    @Override
    public Class getColumnClass(int n2) {
        if (n2 >= 0 && n2 < this.columnTypes.length) {
            return this.columnTypes[n2];
        }
        return Object.class;
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildren(object).length;
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = (Object[])this.cache.get(object);
        if (objectArray == null) {
            objectArray = ((VariableNode)object).getChildren().toArray();
            this.cache.put(object, objectArray);
        }
        return objectArray;
    }

    @Override
    public Object getChild(Object object, int n2) {
        return this.getChildren(object)[n2];
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 >= 0 && n2 < this.columnNames.length) {
            return this.columnNames[n2];
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(Object object, int n2) {
        if (object == null || object == this.rootNode) {
            return null;
        }
        switch (n2) {
            case 0: {
                return ((VariableNode)object).getName();
            }
            case 1: {
                return ((VariableNode)object).getTextValue();
            }
            case 2: {
                return this.showHexValues ? ((VariableNode)object).getHexDump() : "";
            }
        }
        return null;
    }

    public boolean isShowHexValues() {
        return this.showHexValues;
    }

    public void setShowHexValues(boolean bl) {
        this.showHexValues = bl;
    }
}

